/*
 * Decompiled with CFR 0.152.
 */
package com.samaxes.maven.minify.common;

import org.apache.maven.plugin.logging.Log;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;

public class JavaScriptErrorReporter
implements ErrorReporter {
    private Log log;
    private String filename;

    public JavaScriptErrorReporter(Log log, String filename) {
        this.log = log;
        this.filename = filename;
    }

    public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
        if (line < 0) {
            this.log.warn((CharSequence)message);
        } else {
            this.log.warn((CharSequence)("[" + this.filename + ":" + line + "] " + message));
        }
    }

    public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
        if (line < 0) {
            this.log.error((CharSequence)message);
        } else {
            this.log.error((CharSequence)("[" + this.filename + ":" + line + "] " + message));
        }
    }

    public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
        this.error(message, sourceName, line, lineSource, lineOffset);
        return new EvaluatorException(message);
    }
}

