/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa.support;

import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Template;
import com.querydsl.jpa.hibernate.HibernateUtil;
import com.querydsl.sql.SQLTemplates;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.type.Type;

final class DialectSupport {
    private DialectSupport() {
    }

    public static Map<String, SQLFunction> createFunctions(SQLTemplates templates) {
        HashMap<String, SQLFunction> functions = new HashMap<String, SQLFunction>();
        functions.put("second", DialectSupport.createFunction(templates, (Operator)Ops.DateTimeOps.SECOND));
        functions.put("minute", DialectSupport.createFunction(templates, (Operator)Ops.DateTimeOps.MINUTE));
        functions.put("hour", DialectSupport.createFunction(templates, (Operator)Ops.DateTimeOps.HOUR));
        functions.put("day", DialectSupport.createFunction(templates, (Operator)Ops.DateTimeOps.DAY_OF_MONTH));
        functions.put("week", DialectSupport.createFunction(templates, (Operator)Ops.DateTimeOps.WEEK));
        functions.put("month", DialectSupport.createFunction(templates, (Operator)Ops.DateTimeOps.MONTH));
        functions.put("year", DialectSupport.createFunction(templates, (Operator)Ops.DateTimeOps.YEAR));
        return functions;
    }

    public static SQLFunction createFunction(SQLTemplates templates, Operator operator) {
        Template template = templates.getTemplate(operator);
        Type type = HibernateUtil.getType(operator.getType());
        return new SQLFunctionTemplate(type, DialectSupport.convert(template));
    }

    public static String convert(Template template) {
        StringBuilder builder = new StringBuilder();
        for (Template.Element element : template.getElements()) {
            if (element instanceof Template.AsString) {
                builder.append("?").append(((Template.AsString)element).getIndex() + 1);
                continue;
            }
            if (element instanceof Template.ByIndex) {
                builder.append("?").append(((Template.ByIndex)element).getIndex() + 1);
                continue;
            }
            if (element instanceof Template.Transformed) {
                builder.append("?").append(((Template.Transformed)element).getIndex() + 1);
                continue;
            }
            if (element instanceof Template.StaticText) {
                builder.append(((Template.StaticText)element).getText());
                continue;
            }
            throw new IllegalStateException("Unsupported element " + element);
        }
        return builder.toString();
    }
}

