/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.OPartitionedDatabasePool;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionNoTx;
import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientConfigurableGraph;
import org.apache.commons.configuration.Configuration;

public abstract class OrientTransactionalGraph
extends OrientBaseGraph
implements TransactionalGraph {
    protected OrientTransactionalGraph(ODatabaseDocumentTx iDatabase) {
        this(iDatabase, true, null, null);
    }

    protected OrientTransactionalGraph(ODatabaseDocumentTx iDatabase, String iUserName, String iUserPasswd, OrientConfigurableGraph.Settings iConfiguration) {
        super(iDatabase, iUserName, iUserPasswd, iConfiguration);
        this.setCurrentGraphInThreadLocal();
        this.setAutoStartTx(this.isAutoStartTx());
        if (this.isAutoStartTx()) {
            this.ensureTransaction();
        }
    }

    protected OrientTransactionalGraph(ODatabaseDocumentTx iDatabase, boolean iAutoStartTx, String iUserName, String iUserPasswd) {
        super(iDatabase, iUserName, iUserPasswd, null);
        this.setCurrentGraphInThreadLocal();
        this.setAutoStartTx(iAutoStartTx);
        if (iAutoStartTx) {
            this.ensureTransaction();
        }
    }

    protected OrientTransactionalGraph(OPartitionedDatabasePool pool) {
        super(pool);
        this.setCurrentGraphInThreadLocal();
        this.ensureTransaction();
    }

    protected OrientTransactionalGraph(OPartitionedDatabasePool pool, OrientConfigurableGraph.Settings configuration) {
        super(pool, configuration);
        this.setCurrentGraphInThreadLocal();
        if (configuration.isAutoStartTx()) {
            this.ensureTransaction();
        }
    }

    protected OrientTransactionalGraph(String url) {
        this(url, true);
    }

    protected OrientTransactionalGraph(String url, boolean iAutoStartTx) {
        super(url, "admin", "admin");
        this.setCurrentGraphInThreadLocal();
        this.setAutoStartTx(iAutoStartTx);
        if (iAutoStartTx) {
            this.ensureTransaction();
        }
    }

    protected OrientTransactionalGraph(String url, String username, String password) {
        this(url, username, password, true);
    }

    protected OrientTransactionalGraph(String url, String username, String password, boolean iAutoStartTx) {
        super(url, username, password);
        this.setCurrentGraphInThreadLocal();
        this.setAutoStartTx(iAutoStartTx);
        if (iAutoStartTx) {
            this.ensureTransaction();
        }
    }

    protected OrientTransactionalGraph(Configuration configuration) {
        super(configuration);
        Boolean autoStartTx = configuration.getBoolean("blueprints.orientdb.autoStartTx", null);
        if (autoStartTx != null) {
            this.setAutoStartTx(autoStartTx);
        }
    }

    public boolean isUseLog() {
        this.makeActive();
        return this.settings.isUseLog();
    }

    @Override
    public OrientTransactionalGraph setUseLog(boolean useLog) {
        this.makeActive();
        this.settings.setUseLog(useLog);
        return this;
    }

    @Override
    public void setAutoStartTx(boolean autoStartTx) {
        this.makeActive();
        boolean showWarning = !autoStartTx && this.isAutoStartTx() && this.getDatabase() != null && this.getDatabase().getTransaction().isActive();
        super.setAutoStartTx(autoStartTx);
        if (showWarning) {
            OLogManager.instance().warn((Object)this, "Auto transaction starting is turned off for the graph, but already started transaction is left open.Commit it manually or consider disabling auto transactions while creating the graph or its factory.", new Object[0]);
        }
    }

    public void stopTransaction(TransactionalGraph.Conclusion conclusion) {
        this.makeActive();
        if (this.getDatabase().isClosed() || this.getDatabase().getTransaction() instanceof OTransactionNoTx || this.getDatabase().getTransaction().getStatus() != OTransaction.TXSTATUS.BEGUN) {
            return;
        }
        if (TransactionalGraph.Conclusion.SUCCESS == conclusion) {
            this.commit();
        } else {
            this.rollback();
        }
    }

    @Override
    public void commit() {
        this.makeActive();
        if (this.getDatabase() == null) {
            return;
        }
        this.getDatabase().commit();
        if (this.isAutoStartTx()) {
            this.ensureTransaction();
        }
    }

    @Override
    public void rollback() {
        this.makeActive();
        if (this.getDatabase() == null) {
            return;
        }
        this.getDatabase().rollback();
        if (this.isAutoStartTx()) {
            this.ensureTransaction();
        }
    }

    @Override
    public void begin() {
        this.makeActive();
        if (this.isAutoStartTx() && this.getDatabase().getTransaction().isActive()) {
            throw new OTransactionException("A mixture of auto started and manually started transactions is not allowed. Disable auto transactions for the graph before starting a manual transaction.");
        }
        this.getDatabase().begin();
        this.getDatabase().getTransaction().setUsingLog(this.settings.isUseLog());
    }

    @Override
    protected void autoStartTransaction() {
        boolean txBegun = this.getDatabase().getTransaction().isActive();
        if (!this.isAutoStartTx()) {
            if (this.isRequireTransaction() && !txBegun) {
                throw new OTransactionException("Transaction required to change the Graph");
            }
            return;
        }
        if (!txBegun) {
            this.getDatabase().begin();
            this.getDatabase().getTransaction().setUsingLog(this.settings.isUseLog());
        }
    }

    private void ensureTransaction() {
        boolean txBegun = this.getDatabase().getTransaction().isActive();
        if (!txBegun) {
            this.getDatabase().begin();
            this.getDatabase().getTransaction().setUsingLog(this.settings.isUseLog());
        }
    }
}

