/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.client.remote.OStorageRemoteThreadLocal;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.conflict.ORecordConflictStrategy;
import com.orientechnologies.orient.core.db.record.OCurrentStorageComponentsFactory;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OSBTreeCollectionManager;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.ORecordMetadata;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import com.orientechnologies.orient.core.storage.OStorageProxy;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.core.version.OVersionFactory;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryAsynchClient;
import com.orientechnologies.orient.enterprise.channel.binary.ORemoteServerEventListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;

public class OStorageRemoteThread
implements OStorageProxy {
    private static AtomicInteger sessionSerialId = new AtomicInteger(-1);
    private final OStorageRemote delegate;
    private String serverURL;
    private int sessionId;
    private byte[] token;
    private String connectionUserName;
    private String connectionUserPassword;

    public OStorageRemoteThread(OStorageRemote iSharedStorage) {
        this.delegate = iSharedStorage;
        this.serverURL = null;
        this.sessionId = sessionSerialId.decrementAndGet();
    }

    public OStorageRemoteThread(OStorageRemote iSharedStorage, int iSessionId) {
        this.delegate = iSharedStorage;
        this.serverURL = null;
        this.sessionId = iSessionId;
    }

    public static int getNextConnectionId() {
        return sessionSerialId.decrementAndGet();
    }

    public void open(String iUserName, String iUserPassword, Map<String, Object> iOptions) {
        this.pushSession();
        try {
            this.connectionUserName = iUserName;
            this.connectionUserPassword = iUserPassword;
            this.delegate.open(iUserName, iUserPassword, iOptions);
        }
        catch (RuntimeException e) {
            Orient.instance().unregisterStorage((OStorage)this);
            throw e;
        }
        finally {
            this.popSession();
        }
    }

    public boolean isDistributed() {
        return this.delegate.isDistributed();
    }

    public Class<? extends OSBTreeCollectionManager> getCollectionManagerClass() {
        return this.delegate.getCollectionManagerClass();
    }

    public void create(Map<String, Object> iOptions) {
        this.pushSession();
        try {
            this.delegate.create(iOptions);
        }
        finally {
            this.popSession();
        }
    }

    public void close(boolean iForce, boolean onDelete) {
        this.pushSession();
        try {
            this.delegate.close(iForce, false);
            Orient.instance().unregisterStorage((OStorage)this);
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dropCluster(String iClusterName, boolean iTruncate) {
        this.pushSession();
        try {
            boolean bl = this.delegate.dropCluster(iClusterName, iTruncate);
            return bl;
        }
        finally {
            this.popSession();
        }
    }

    public int getUsers() {
        this.pushSession();
        try {
            int n = this.delegate.getUsers();
            return n;
        }
        finally {
            this.popSession();
        }
    }

    public int addUser() {
        this.pushSession();
        try {
            int n = this.delegate.addUser();
            return n;
        }
        finally {
            this.popSession();
        }
    }

    public void setSessionId(String iServerURL, int iSessionId, byte[] iToken) {
        this.serverURL = iServerURL;
        this.sessionId = iSessionId;
        this.token = iToken;
        this.delegate.setSessionId(this.serverURL, iSessionId, iToken);
    }

    public void reload() {
        this.pushSession();
        try {
            this.delegate.reload();
        }
        finally {
            this.popSession();
        }
    }

    public boolean exists() {
        this.pushSession();
        try {
            boolean bl = this.delegate.exists();
            return bl;
        }
        finally {
            this.popSession();
        }
    }

    public int removeUser() {
        this.pushSession();
        try {
            int n = this.delegate.removeUser();
            return n;
        }
        finally {
            this.popSession();
        }
    }

    public void close() {
        this.pushSession();
        try {
            this.delegate.close();
            Orient.instance().unregisterStorage((OStorage)this);
        }
        finally {
            this.popSession();
        }
    }

    public void delete() {
        this.pushSession();
        try {
            this.delegate.delete();
            Orient.instance().unregisterStorage((OStorage)this);
        }
        finally {
            this.popSession();
        }
    }

    public OStorage getUnderlying() {
        return this.delegate;
    }

    public boolean isRemote() {
        return true;
    }

    public Set<String> getClusterNames() {
        this.pushSession();
        try {
            Set<String> set = this.delegate.getClusterNames();
            return set;
        }
        finally {
            this.popSession();
        }
    }

    public List<String> backup(OutputStream out, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener, int compressionLevel, int bufferSize) throws IOException {
        throw new UnsupportedOperationException("backup");
    }

    public void restore(InputStream in, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener) throws IOException {
        throw new UnsupportedOperationException("restore");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OStorageOperationResult<OPhysicalPosition> createRecord(ORecordId iRid, byte[] iContent, ORecordVersion iRecordVersion, byte iRecordType, int iMode, ORecordCallback<Long> iCallback) {
        this.pushSession();
        try {
            OStorageOperationResult<OPhysicalPosition> oStorageOperationResult = this.delegate.createRecord(iRid, iContent, OVersionFactory.instance().createVersion(), iRecordType, iMode, iCallback);
            return oStorageOperationResult;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OStorageOperationResult<ORawBuffer> readRecord(ORecordId iRid, String iFetchPlan, boolean iIgnoreCache, ORecordCallback<ORawBuffer> iCallback) {
        this.pushSession();
        try {
            OStorageOperationResult<ORawBuffer> oStorageOperationResult = this.delegate.readRecord(iRid, iFetchPlan, iIgnoreCache, null);
            return oStorageOperationResult;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OStorageOperationResult<ORawBuffer> readRecordIfVersionIsNotLatest(ORecordId rid, String fetchPlan, boolean ignoreCache, ORecordVersion recordVersion) throws ORecordNotFoundException {
        this.pushSession();
        try {
            OStorageOperationResult<ORawBuffer> oStorageOperationResult = this.delegate.readRecordIfVersionIsNotLatest(rid, fetchPlan, ignoreCache, recordVersion);
            return oStorageOperationResult;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OStorageOperationResult<ORecordVersion> updateRecord(ORecordId iRid, boolean updateContent, byte[] iContent, ORecordVersion iVersion, byte iRecordType, int iMode, ORecordCallback<ORecordVersion> iCallback) {
        this.pushSession();
        try {
            OStorageOperationResult<ORecordVersion> oStorageOperationResult = this.delegate.updateRecord(iRid, updateContent, iContent, iVersion, iRecordType, iMode, iCallback);
            return oStorageOperationResult;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OStorageOperationResult<Boolean> deleteRecord(ORecordId iRid, ORecordVersion iVersion, int iMode, ORecordCallback<Boolean> iCallback) {
        this.pushSession();
        try {
            OStorageOperationResult<Boolean> oStorageOperationResult = this.delegate.deleteRecord(iRid, iVersion, iMode, iCallback);
            return oStorageOperationResult;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OStorageOperationResult<Boolean> hideRecord(ORecordId recordId, int mode, ORecordCallback<Boolean> callback) {
        this.pushSession();
        try {
            OStorageOperationResult<Boolean> oStorageOperationResult = this.delegate.hideRecord(recordId, mode, callback);
            return oStorageOperationResult;
        }
        finally {
            this.popSession();
        }
    }

    public OCluster getClusterByName(String clusterName) {
        return this.delegate.getClusterByName(clusterName);
    }

    public ORecordConflictStrategy getConflictStrategy() {
        throw new UnsupportedOperationException("getConflictStrategy");
    }

    public void setConflictStrategy(ORecordConflictStrategy iResolver) {
        throw new UnsupportedOperationException("setConflictStrategy");
    }

    public ORecordMetadata getRecordMetadata(ORID rid) {
        this.pushSession();
        try {
            ORecordMetadata oRecordMetadata = this.delegate.getRecordMetadata(rid);
            return oRecordMetadata;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cleanOutRecord(ORecordId recordId, ORecordVersion recordVersion, int iMode, ORecordCallback<Boolean> callback) {
        this.pushSession();
        try {
            boolean bl = this.delegate.cleanOutRecord(recordId, recordVersion, iMode, callback);
            return bl;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count(int iClusterId) {
        this.pushSession();
        try {
            long l = this.delegate.count(iClusterId);
            return l;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count(int iClusterId, boolean countTombstones) {
        this.pushSession();
        try {
            long l = this.delegate.count(iClusterId, countTombstones);
            return l;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count(int[] iClusterIds, boolean countTombstones) {
        this.pushSession();
        try {
            long l = this.delegate.count(iClusterIds, countTombstones);
            return l;
        }
        finally {
            this.popSession();
        }
    }

    public String toString() {
        return this.delegate.toString();
    }

    public long[] getClusterDataRange(int iClusterId) {
        this.pushSession();
        try {
            long[] lArray = this.delegate.getClusterDataRange(iClusterId);
            return lArray;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OPhysicalPosition[] higherPhysicalPositions(int currentClusterId, OPhysicalPosition physicalPosition) {
        this.pushSession();
        try {
            OPhysicalPosition[] oPhysicalPositionArray = this.delegate.higherPhysicalPositions(currentClusterId, physicalPosition);
            return oPhysicalPositionArray;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OPhysicalPosition[] lowerPhysicalPositions(int currentClusterId, OPhysicalPosition physicalPosition) {
        this.pushSession();
        try {
            OPhysicalPosition[] oPhysicalPositionArray = this.delegate.lowerPhysicalPositions(currentClusterId, physicalPosition);
            return oPhysicalPositionArray;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OPhysicalPosition[] ceilingPhysicalPositions(int clusterId, OPhysicalPosition physicalPosition) {
        this.pushSession();
        try {
            OPhysicalPosition[] oPhysicalPositionArray = this.delegate.ceilingPhysicalPositions(clusterId, physicalPosition);
            return oPhysicalPositionArray;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OPhysicalPosition[] floorPhysicalPositions(int clusterId, OPhysicalPosition physicalPosition) {
        this.pushSession();
        try {
            OPhysicalPosition[] oPhysicalPositionArray = this.delegate.floorPhysicalPositions(clusterId, physicalPosition);
            return oPhysicalPositionArray;
        }
        finally {
            this.popSession();
        }
    }

    public long getSize() {
        this.pushSession();
        try {
            long l = this.delegate.getSize();
            return l;
        }
        finally {
            this.popSession();
        }
    }

    public long countRecords() {
        this.pushSession();
        try {
            long l = this.delegate.countRecords();
            return l;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count(int[] iClusterIds) {
        this.pushSession();
        try {
            long l = this.delegate.count(iClusterIds);
            return l;
        }
        finally {
            this.popSession();
        }
    }

    public Object command(OCommandRequestText iCommand) {
        this.pushSession();
        try {
            Object object = this.delegate.command(iCommand);
            return object;
        }
        finally {
            this.popSession();
        }
    }

    public void commit(OTransaction iTx, Runnable callback) {
        this.pushSession();
        try {
            this.delegate.commit(iTx, null);
        }
        finally {
            this.popSession();
        }
    }

    public void rollback(OTransaction iTx) {
        this.pushSession();
        try {
            this.delegate.rollback(iTx);
        }
        finally {
            this.popSession();
        }
    }

    public int getClusterIdByName(String iClusterName) {
        this.pushSession();
        try {
            int n = this.delegate.getClusterIdByName(iClusterName);
            return n;
        }
        finally {
            this.popSession();
        }
    }

    public int getDefaultClusterId() {
        this.pushSession();
        try {
            int n = this.delegate.getDefaultClusterId();
            return n;
        }
        finally {
            this.popSession();
        }
    }

    public void setDefaultClusterId(int defaultClusterId) {
        this.pushSession();
        try {
            this.delegate.setDefaultClusterId(defaultClusterId);
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addCluster(String iClusterName, boolean forceListBased, Object ... iArguments) {
        this.pushSession();
        try {
            int n = this.delegate.addCluster(iClusterName, false, iArguments);
            return n;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addCluster(String iClusterName, int iRequestedId, boolean forceListBased, Object ... iParameters) {
        this.pushSession();
        try {
            int n = this.delegate.addCluster(iClusterName, iRequestedId, forceListBased, iParameters);
            return n;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dropCluster(int iClusterId, boolean iTruncate) {
        this.pushSession();
        try {
            boolean bl = this.delegate.dropCluster(iClusterId, iTruncate);
            return bl;
        }
        finally {
            this.popSession();
        }
    }

    public void synch() {
        this.pushSession();
        try {
            this.delegate.synch();
        }
        finally {
            this.popSession();
        }
    }

    public String getPhysicalClusterNameById(int iClusterId) {
        this.pushSession();
        try {
            String string = this.delegate.getPhysicalClusterNameById(iClusterId);
            return string;
        }
        finally {
            this.popSession();
        }
    }

    public int getClusters() {
        this.pushSession();
        try {
            int n = this.delegate.getClusterMap();
            return n;
        }
        finally {
            this.popSession();
        }
    }

    public Collection<OCluster> getClusterInstances() {
        this.pushSession();
        try {
            Collection<OCluster> collection = this.delegate.getClusterInstances();
            return collection;
        }
        finally {
            this.popSession();
        }
    }

    public OCluster getClusterById(int iId) {
        this.pushSession();
        try {
            OCluster oCluster = this.delegate.getClusterById(iId);
            return oCluster;
        }
        finally {
            this.popSession();
        }
    }

    public long getVersion() {
        this.pushSession();
        try {
            long l = this.delegate.getVersion();
            return l;
        }
        finally {
            this.popSession();
        }
    }

    public boolean isPermanentRequester() {
        this.pushSession();
        try {
            boolean bl = this.delegate.isPermanentRequester();
            return bl;
        }
        finally {
            this.popSession();
        }
    }

    public void updateClusterConfiguration(String iCurrentURL, byte[] iContent) {
        this.pushSession();
        try {
            this.delegate.updateClusterConfiguration(iCurrentURL, iContent);
        }
        finally {
            this.popSession();
        }
    }

    public OStorageConfiguration getConfiguration() {
        this.pushSession();
        try {
            OStorageConfiguration oStorageConfiguration = this.delegate.getConfiguration();
            return oStorageConfiguration;
        }
        finally {
            this.popSession();
        }
    }

    public boolean isClosed() {
        return this.sessionId < 0 && this.token == null || this.delegate.isClosed();
    }

    public boolean checkForRecordValidity(OPhysicalPosition ppos) {
        this.pushSession();
        try {
            boolean bl = this.delegate.checkForRecordValidity(ppos);
            return bl;
        }
        finally {
            this.popSession();
        }
    }

    public boolean isAssigningClusterIds() {
        return false;
    }

    public String getName() {
        this.pushSession();
        try {
            String string = this.delegate.getName();
            return string;
        }
        finally {
            this.popSession();
        }
    }

    public String getURL() {
        return this.delegate.getURL();
    }

    public void beginResponse(OChannelBinaryAsynchClient iNetwork) throws IOException {
        this.pushSession();
        try {
            this.delegate.beginResponse(iNetwork);
        }
        finally {
            this.popSession();
        }
    }

    public OCurrentStorageComponentsFactory getComponentsFactory() {
        return this.delegate.getComponentsFactory();
    }

    public long getLastOperationId() {
        return 0L;
    }

    public boolean existsResource(String iName) {
        return this.delegate.existsResource(iName);
    }

    public synchronized <T> T getResource(String iName, Callable<T> iCallback) {
        return (T)this.delegate.getResource(iName, iCallback);
    }

    public <T> T removeResource(String iName) {
        return (T)this.delegate.removeResource(iName);
    }

    public ODocument getClusterConfiguration() {
        return this.delegate.getClusterConfiguration();
    }

    public <V> V callInLock(Callable<V> iCallable, boolean iExclusiveLock) {
        return (V)this.delegate.callInLock(iCallable, iExclusiveLock);
    }

    public ORemoteServerEventListener getRemoteServerEventListener() {
        return this.delegate.getAsynchEventListener();
    }

    public void setRemoteServerEventListener(ORemoteServerEventListener iListener) {
        this.delegate.setAsynchEventListener(iListener);
    }

    public void removeRemoteServerEventListener() {
        this.delegate.removeRemoteServerEventListener();
    }

    public void checkForClusterPermissions(String iClusterName) {
        this.delegate.checkForClusterPermissions(iClusterName);
    }

    public OStorage.STATUS getStatus() {
        return this.delegate.getStatus();
    }

    public String getUserName() {
        return this.delegate.getUserName();
    }

    public Object indexGet(String iIndexName, Object iKey, String iFetchPlan) {
        return this.delegate.indexGet(iIndexName, iKey, iFetchPlan);
    }

    public void indexPut(String iIndexName, Object iKey, OIdentifiable iValue) {
        this.delegate.indexPut(iIndexName, iKey, iValue);
    }

    public boolean indexRemove(String iIndexName, Object iKey) {
        return this.delegate.indexRemove(iIndexName, iKey);
    }

    public String getType() {
        return this.delegate.getType();
    }

    public boolean equals(Object iOther) {
        if (iOther instanceof OStorageRemoteThread) {
            return iOther == this;
        }
        if (iOther instanceof OStorageRemote) {
            return iOther == this.delegate;
        }
        return false;
    }

    protected void handleException(OChannelBinaryAsynchClient iNetwork, String iMessage, Exception iException) {
        this.delegate.handleException(iNetwork, iMessage, iException);
    }

    protected void pushSession() {
        OStorageRemoteThreadLocal instance = OStorageRemoteThreadLocal.INSTANCE;
        if (instance != null) {
            OStorageRemoteThreadLocal.OStorageRemoteSession tl = (OStorageRemoteThreadLocal.OStorageRemoteSession)instance.get();
            tl.serverURL = this.serverURL;
            tl.sessionId = this.sessionId;
            tl.token = this.token;
            tl.connectionUserName = this.connectionUserName;
            tl.connectionUserPassword = this.connectionUserPassword;
        }
    }

    protected void popSession() {
        this.serverURL = this.delegate.getServerURL();
        this.sessionId = this.delegate.getSessionId();
        this.token = this.delegate.getSessionToken();
        this.connectionUserName = this.delegate.getUserName();
        this.connectionUserPassword = this.delegate.getUserPassword();
    }
}

