/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.resources;

import com.netflix.appinfo.AmazonInfo;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.EurekaAccept;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.appinfo.UniqueIdentifier;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.Version;
import com.netflix.eureka.registry.Key;
import com.netflix.eureka.registry.PeerAwareInstanceRegistry;
import com.netflix.eureka.registry.ResponseCache;
import com.netflix.eureka.resources.CurrentRequestVersion;
import com.netflix.eureka.resources.InstanceResource;
import com.netflix.eureka.util.EurekaMonitors;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Produces(value={"application/xml", "application/json"})
public class ApplicationResource {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationResource.class);
    private final String appName;
    private final EurekaServerConfig serverConfig;
    private final PeerAwareInstanceRegistry registry;
    private final ResponseCache responseCache;

    ApplicationResource(String appName, EurekaServerConfig serverConfig, PeerAwareInstanceRegistry registry) {
        this.appName = appName.toUpperCase();
        this.serverConfig = serverConfig;
        this.registry = registry;
        this.responseCache = registry.getResponseCache();
    }

    public String getAppName() {
        return this.appName;
    }

    @GET
    public Response getApplication(@PathParam(value="version") String version, @HeaderParam(value="Accept") String acceptHeader, @HeaderParam(value="X-Eureka-Accept") String eurekaAccept) {
        if (!this.registry.shouldAllowAccess(false)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        EurekaMonitors.GET_APPLICATION.increment();
        CurrentRequestVersion.set(Version.toEnum(version));
        Key.KeyType keyType = Key.KeyType.JSON;
        if (acceptHeader == null || !acceptHeader.contains("json")) {
            keyType = Key.KeyType.XML;
        }
        Key cacheKey = new Key(Key.EntityType.Application, this.appName, keyType, CurrentRequestVersion.get(), EurekaAccept.fromString((String)eurekaAccept));
        String payLoad = this.responseCache.get(cacheKey);
        CurrentRequestVersion.remove();
        if (payLoad != null) {
            logger.debug("Found: {}", (Object)this.appName);
            return Response.ok((Object)payLoad).build();
        }
        logger.debug("Not Found: {}", (Object)this.appName);
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @Path(value="{id}")
    public InstanceResource getInstanceInfo(@PathParam(value="id") String id) {
        return new InstanceResource(this, id, this.serverConfig, this.registry);
    }

    @POST
    @Consumes(value={"application/json", "application/xml"})
    public Response addInstance(InstanceInfo info, @HeaderParam(value="x-netflix-discovery-replication") String isReplication) {
        String dataCenterInfoId;
        logger.debug("Registering instance {} (replication={})", (Object)info.getId(), (Object)isReplication);
        if (this.isBlank(info.getId())) {
            return Response.status((int)400).entity((Object)"Missing instanceId").build();
        }
        if (this.isBlank(info.getHostName())) {
            return Response.status((int)400).entity((Object)"Missing hostname").build();
        }
        if (this.isBlank(info.getIPAddr())) {
            return Response.status((int)400).entity((Object)"Missing ip address").build();
        }
        if (this.isBlank(info.getAppName())) {
            return Response.status((int)400).entity((Object)"Missing appName").build();
        }
        if (!this.appName.equals(info.getAppName())) {
            return Response.status((int)400).entity((Object)("Mismatched appName, expecting " + this.appName + " but was " + info.getAppName())).build();
        }
        if (info.getDataCenterInfo() == null) {
            return Response.status((int)400).entity((Object)"Missing dataCenterInfo").build();
        }
        if (info.getDataCenterInfo().getName() == null) {
            return Response.status((int)400).entity((Object)"Missing dataCenterInfo Name").build();
        }
        DataCenterInfo dataCenterInfo = info.getDataCenterInfo();
        if (dataCenterInfo instanceof UniqueIdentifier && this.isBlank(dataCenterInfoId = ((UniqueIdentifier)dataCenterInfo).getId())) {
            boolean experimental = "true".equalsIgnoreCase(this.serverConfig.getExperimental("registration.validation.dataCenterInfoId"));
            if (experimental) {
                String entity = "DataCenterInfo of type " + dataCenterInfo.getClass() + " must contain a valid id";
                return Response.status((int)400).entity((Object)entity).build();
            }
            if (dataCenterInfo instanceof AmazonInfo) {
                AmazonInfo amazonInfo = (AmazonInfo)dataCenterInfo;
                String effectiveId = amazonInfo.get(AmazonInfo.MetaDataKey.instanceId);
                if (effectiveId == null) {
                    amazonInfo.getMetadata().put(AmazonInfo.MetaDataKey.instanceId.getName(), info.getId());
                }
            } else {
                logger.warn("Registering DataCenterInfo of type {} without an appropriate id", dataCenterInfo.getClass());
            }
        }
        this.registry.register(info, "true".equals(isReplication));
        return Response.status((int)204).build();
    }

    String getName() {
        return this.appName;
    }

    private boolean isBlank(String str) {
        return str == null || str.isEmpty();
    }
}

