/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.recipes.storage;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.astyanax.connectionpool.exceptions.NotFoundException;
import com.netflix.astyanax.recipes.storage.ChunkedStorageProvider;
import com.netflix.astyanax.recipes.storage.NoOpObjectReadCallback;
import com.netflix.astyanax.recipes.storage.ObjectMetadata;
import com.netflix.astyanax.recipes.storage.ObjectReadCallback;
import com.netflix.astyanax.retry.RetryPolicy;
import com.netflix.astyanax.retry.RunOnce;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectReader
implements Callable<ObjectMetadata> {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectReader.class);
    private static final int DEFAULT_CONCURRENCY_LEVEL = 4;
    private static final int MAX_WAIT_TIME_TO_FINISH = 60;
    private static final int DEFAULT_BATCH_SIZE = 11;
    private final ChunkedStorageProvider provider;
    private final String objectName;
    private final OutputStream os;
    private int concurrencyLevel = 4;
    private int maxWaitTimeInSeconds = 60;
    private int batchSize = 11;
    private RetryPolicy retryPolicy;
    private ObjectReadCallback callback = new NoOpObjectReadCallback();

    public ObjectReader(ChunkedStorageProvider provider, String objectName, OutputStream os) {
        this.provider = provider;
        this.objectName = objectName;
        this.os = os;
        this.retryPolicy = new RunOnce();
    }

    public ObjectReader withBatchSize(int size) {
        this.batchSize = size;
        return this;
    }

    public ObjectReader withConcurrencyLevel(int level) {
        this.concurrencyLevel = level;
        return this;
    }

    public ObjectReader withRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public ObjectReader withMaxWaitTime(int maxWaitTimeInSeconds) {
        this.maxWaitTimeInSeconds = maxWaitTimeInSeconds;
        return this;
    }

    public ObjectReader withCallback(ObjectReadCallback callback) {
        this.callback = callback;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectMetadata call() throws Exception {
        LOG.info("Reading: " + this.objectName);
        Preconditions.checkNotNull((Object)this.objectName);
        Preconditions.checkNotNull((Object)this.os);
        try {
            ObjectMetadata attributes;
            RetryPolicy retry = this.retryPolicy.duplicate();
            while (true) {
                try {
                    while (!(attributes = this.provider.readMetadata(this.objectName)).isValidForRead()) {
                        if (retry.allowRetry()) continue;
                        throw new NotFoundException("File doesn't exists or isn't ready to be read: " + this.objectName);
                    }
                }
                catch (Exception e) {
                    LOG.warn(e.getMessage());
                    if (retry.allowRetry()) continue;
                    throw e;
                }
                break;
            }
            final AtomicReference exception = new AtomicReference();
            final AtomicLong totalBytesRead = new AtomicLong();
            ArrayList idsToRead = Lists.newArrayList();
            for (int block = 0; block < attributes.getChunkCount(); ++block) {
                idsToRead.add(block);
                if (idsToRead.size() != this.batchSize && block != attributes.getChunkCount() - 1) continue;
                final int firstBlockId = (Integer)idsToRead.get(0);
                Collections.shuffle(idsToRead);
                final AtomicReferenceArray chunks = new AtomicReferenceArray(idsToRead.size());
                ExecutorService executor = Executors.newFixedThreadPool(this.concurrencyLevel, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ChunkReader-" + this.objectName + "-%d").build());
                try {
                    Iterator i$ = idsToRead.iterator();
                    while (i$.hasNext()) {
                        final int chunkId = (Integer)i$.next();
                        executor.submit(new Runnable(){

                            @Override
                            public void run() {
                                RetryPolicy retry = ObjectReader.this.retryPolicy.duplicate();
                                while (exception.get() == null) {
                                    try {
                                        ByteBuffer chunk = ObjectReader.this.provider.readChunk(ObjectReader.this.objectName, chunkId);
                                        totalBytesRead.addAndGet(chunk.limit());
                                        chunks.set(chunkId - firstBlockId, chunk);
                                        ObjectReader.this.callback.onChunk(chunkId, chunk);
                                        break;
                                    }
                                    catch (Exception e) {
                                        ObjectReader.this.callback.onChunkException(chunkId, e);
                                        if (retry.allowRetry()) continue;
                                        exception.compareAndSet(null, e);
                                    }
                                }
                            }
                        });
                    }
                }
                finally {
                    executor.shutdown();
                    if (!executor.awaitTermination(this.maxWaitTimeInSeconds, TimeUnit.SECONDS)) {
                        throw new Exception("Took too long to fetch object: " + this.objectName);
                    }
                }
                if (exception.get() != null) {
                    throw (Exception)exception.get();
                }
                for (int i = 0; i < chunks.length(); ++i) {
                    this.os.write(((ByteBuffer)chunks.get(i)).array());
                    this.os.flush();
                }
                idsToRead.clear();
            }
            if (totalBytesRead.get() != attributes.getObjectSize().longValue()) {
                throw new Exception("Bytes read (" + totalBytesRead.get() + ") does not match object size (" + attributes.getObjectSize() + ") for object " + this.objectName);
            }
            this.callback.onSuccess();
            return attributes;
        }
        catch (Exception e) {
            this.callback.onFailure(e);
            throw e;
        }
    }
}

