/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.http;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequestBuilder;
import com.microsoft.graph.http.BaseFunctionCollectionRequest;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.http.ICollectionResponse;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class BaseDeltaCollectionRequest<T, T2 extends ICollectionResponse<T>, T3 extends BaseCollectionPage<T, ? extends BaseRequestBuilder<T>>>
extends BaseFunctionCollectionRequest<T, T2, T3> {
    private static Pattern pattern = Pattern.compile("(?>[$]?delta)?token=['\"]?([\\w\\-\\.]+)", 2);

    public BaseDeltaCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> options, @Nonnull Class<T2> responseCollectionClass, @Nonnull Class<T3> collectionPageClass, @Nonnull Class<? extends BaseCollectionRequestBuilder<T, ? extends BaseRequestBuilder<T>, T2, T3, ? extends BaseCollectionRequest<T, T2, T3>>> collectionRequestBuilderClass) {
        super(requestUrl, client, options, responseCollectionClass, collectionPageClass, collectionRequestBuilderClass);
    }

    protected void addDeltaTokenOption(@Nonnull String value, @Nonnull String optionKey) {
        Objects.requireNonNull(value, "parameter value cannot be null");
        Objects.requireNonNull(optionKey, "parameter optionKey cannot be null");
        this.addQueryOption(new QueryOption(optionKey, value));
    }

    @Nonnull
    protected String getDeltaTokenFromLink(@Nonnull String deltaLink) {
        Objects.requireNonNull(deltaLink, "parameter deltaLink cannot be null");
        Matcher matcher = pattern.matcher(deltaLink);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }
}

