/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.web.dependencies.http.impl.nio.client;

import com.microsoft.applicationinsights.web.dependencies.http.impl.nio.client.CloseableHttpAsyncClient;
import com.microsoft.applicationinsights.web.dependencies.http.impl.nio.client.CloseableHttpPipeliningClient;
import com.microsoft.applicationinsights.web.dependencies.http.impl.nio.client.HttpAsyncClientBuilder;
import com.microsoft.applicationinsights.web.dependencies.http.impl.nio.client.MinimalHttpAsyncClientBuilder;
import com.microsoft.applicationinsights.web.dependencies.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import com.microsoft.applicationinsights.web.dependencies.http.nio.conn.NHttpClientConnectionManager;
import com.microsoft.applicationinsights.web.dependencies.http.nio.reactor.ConnectingIOReactor;
import com.microsoft.applicationinsights.web.dependencies.http.util.Args;

public class HttpAsyncClients {
    private HttpAsyncClients() {
    }

    public static HttpAsyncClientBuilder custom() {
        return HttpAsyncClientBuilder.create();
    }

    public static CloseableHttpAsyncClient createDefault() {
        return HttpAsyncClientBuilder.create().build();
    }

    public static CloseableHttpAsyncClient createSystem() {
        return HttpAsyncClientBuilder.create().useSystemProperties().build();
    }

    public static CloseableHttpAsyncClient createMinimal() {
        return MinimalHttpAsyncClientBuilder.create().disableCookieManagement().build();
    }

    public static CloseableHttpAsyncClient createMinimal(ConnectingIOReactor ioreactor) {
        Args.notNull(ioreactor, "I/O reactor");
        return HttpAsyncClients.createMinimal(new PoolingNHttpClientConnectionManager(ioreactor), false);
    }

    public static CloseableHttpAsyncClient createMinimal(NHttpClientConnectionManager connManager) {
        return HttpAsyncClients.createMinimal(connManager, false);
    }

    public static CloseableHttpAsyncClient createMinimal(NHttpClientConnectionManager connManager, boolean shared) {
        Args.notNull(connManager, "Connection manager");
        return MinimalHttpAsyncClientBuilder.create().setConnectionManager(connManager).setConnectionManagerShared(shared).disableCookieManagement().build();
    }

    public static CloseableHttpPipeliningClient createPipelining() {
        return MinimalHttpAsyncClientBuilder.create().build();
    }

    public static CloseableHttpPipeliningClient createPipelining(ConnectingIOReactor ioreactor) {
        return HttpAsyncClients.createPipelining(new PoolingNHttpClientConnectionManager(ioreactor), false);
    }

    public static CloseableHttpPipeliningClient createPipelining(NHttpClientConnectionManager connManager) {
        return HttpAsyncClients.createPipelining(connManager, false);
    }

    public static CloseableHttpPipeliningClient createPipelining(NHttpClientConnectionManager connManager, boolean shared) {
        Args.notNull(connManager, "Connection manager");
        return MinimalHttpAsyncClientBuilder.create().setConnectionManager(connManager).setConnectionManagerShared(shared).build();
    }
}

