/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0;

import com.mchange.v2.c3p0.ConnectionCustomizer;
import com.mchange.v2.c3p0.ConnectionTester;
import com.mchange.v2.c3p0.PooledDataSource;
import com.mchange.v2.c3p0.TaskRunnerFactory;
import com.mchange.v2.c3p0.cfg.C3P0ConfigUtils;
import com.mchange.v2.c3p0.impl.C3P0Defaults;
import com.mchange.v2.c3p0.impl.DefaultTaskRunnerFactory;
import com.mchange.v2.c3p0.impl.IdentityTokenized;
import com.mchange.v2.c3p0.impl.IdentityTokenizedCoalesceChecker;
import com.mchange.v2.c3p0.management.ManagementCoordinator;
import com.mchange.v2.c3p0.management.NullManagementCoordinator;
import com.mchange.v2.coalesce.CoalesceChecker;
import com.mchange.v2.coalesce.Coalescer;
import com.mchange.v2.coalesce.CoalescerFactory;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.sql.SqlUtils;
import com.mchange.v2.util.DoubleWeakHashMap;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class C3P0Registry {
    private static final String MC_PARAM = "com.mchange.v2.c3p0.management.ManagementCoordinator";
    private static final String OLD_SCHOOL_DEFAULT_CONNECTION_TESTER_CLASS_NAME = "com.mchange.v2.c3p0.impl.DefaultConnectionTester";
    static final MLogger logger = MLog.getLogger(C3P0Registry.class);
    static boolean banner_printed = false;
    static boolean registry_mbean_registered = false;
    private static CoalesceChecker CC = IdentityTokenizedCoalesceChecker.INSTANCE;
    private static Coalescer idtCoalescer = CoalescerFactory.createCoalescer((CoalesceChecker)CC, (boolean)true, (boolean)false);
    private static Map tokensToTokenized = new DoubleWeakHashMap();
    private static HashSet unclosedPooledDataSources = new HashSet();
    private static final Map classNamesToConnectionTesters = new HashMap();
    private static final Map classNamesToTaskRunnerFactories = new HashMap();
    private static final Map classNamesToConnectionCustomizers = new HashMap();
    private static ManagementCoordinator mc;
    private static final TaskRunnerFactory DEFAULT_TASK_RUNNER_FACTORY;

    public static void markConfigRefreshed() {
        C3P0Registry.resetConnectionTesterCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectionTester getConnectionTester(String string) {
        if (string == null) {
            return null;
        }
        try {
            Map map = classNamesToConnectionTesters;
            synchronized (map) {
                ConnectionTester connectionTester = (ConnectionTester)classNamesToConnectionTesters.get(string);
                if (connectionTester == null) {
                    connectionTester = (ConnectionTester)Class.forName(string).newInstance();
                    classNamesToConnectionTesters.put(string, connectionTester);
                }
                return connectionTester;
            }
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "Could not create for find ConnectionTester with class name '" + string + "'. Skipping custom ConnectionTester, reverting to null ConnectionTester for IsValidSimplifiedConnectionTestPath.", (Throwable)exception);
            }
            return null;
        }
    }

    private static ConnectionTester recreateOldSchoolDefaultConnectionTester() {
        try {
            return (ConnectionTester)Class.forName(OLD_SCHOOL_DEFAULT_CONNECTION_TESTER_CLASS_NAME).newInstance();
        }
        catch (Exception exception) {
            throw new Error("Huh? We cannot instantiate the hard-coded, default ConnectionTester? We are very broken.", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void resetConnectionTesterCache() {
        Map map = classNamesToConnectionTesters;
        synchronized (map) {
            classNamesToConnectionTesters.clear();
            classNamesToConnectionTesters.put(OLD_SCHOOL_DEFAULT_CONNECTION_TESTER_CLASS_NAME, C3P0Registry.recreateOldSchoolDefaultConnectionTester());
        }
    }

    public static TaskRunnerFactory getDefaultTaskRunnerFactory() {
        return C3P0Registry.getTaskRunnerFactory(C3P0Defaults.taskRunnerFactoryClassName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TaskRunnerFactory getTaskRunnerFactory(String string) {
        try {
            Map map = classNamesToTaskRunnerFactories;
            synchronized (map) {
                TaskRunnerFactory taskRunnerFactory = (TaskRunnerFactory)classNamesToTaskRunnerFactories.get(string);
                if (taskRunnerFactory == null) {
                    taskRunnerFactory = (TaskRunnerFactory)Class.forName(string).newInstance();
                    classNamesToTaskRunnerFactories.put(string, taskRunnerFactory);
                }
                return taskRunnerFactory;
            }
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "Could not create for find TaskRunnerFactory with class name '" + string + "'. Using default.", (Throwable)exception);
            }
            return DEFAULT_TASK_RUNNER_FACTORY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectionCustomizer getConnectionCustomizer(String string) throws SQLException {
        if (string == null || string.trim().equals("")) {
            return null;
        }
        try {
            Map map = classNamesToConnectionCustomizers;
            synchronized (map) {
                ConnectionCustomizer connectionCustomizer = (ConnectionCustomizer)classNamesToConnectionCustomizers.get(string);
                if (connectionCustomizer == null) {
                    connectionCustomizer = (ConnectionCustomizer)Class.forName(string).newInstance();
                    classNamesToConnectionCustomizers.put(string, connectionCustomizer);
                }
                return connectionCustomizer;
            }
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "Could not create for find ConnectionCustomizer with class name '" + string + "'.", (Throwable)exception);
            }
            throw SqlUtils.toSQLException((Throwable)exception);
        }
    }

    private static void banner() {
        if (!banner_printed) {
            if (logger.isLoggable(MLevel.INFO)) {
                logger.info("Initializing c3p0-0.12.0 [built 2026-02-22T16:57:43.223248Z; debug? true; trace: 10]");
            }
            banner_printed = true;
        }
    }

    private static void attemptRegisterRegistryMBean() {
        if (!registry_mbean_registered) {
            mc.attemptManageC3P0Registry();
            registry_mbean_registered = true;
        }
    }

    private static boolean isIncorporated(IdentityTokenized identityTokenized) {
        return tokensToTokenized.keySet().contains(identityTokenized.getIdentityToken());
    }

    private static void incorporate(IdentityTokenized identityTokenized) {
        tokensToTokenized.put(identityTokenized.getIdentityToken(), identityTokenized);
        if (identityTokenized instanceof PooledDataSource) {
            unclosedPooledDataSources.add(identityTokenized);
            mc.attemptManagePooledDataSource((PooledDataSource)((Object)identityTokenized));
        }
    }

    private static synchronized Object findTokenized(String string) {
        return tokensToTokenized.get(string);
    }

    public static Map extensionsForToken(String string) throws NoSuchElementException, IllegalArgumentException {
        Object object = C3P0Registry.findTokenized(string);
        if (object == null) {
            throw new NoSuchElementException("No object is known to be identified by token '" + string + "'. Either it is a bad token, or the object was no longer in use and has been garbage collected.");
        }
        if (!(object instanceof PooledDataSource)) {
            throw new IllegalArgumentException("The object '" + object + "', identified by token '" + string + "', is not a PooledDataSource and therefore cannot have extensions.");
        }
        return ((PooledDataSource)object).getExtensions();
    }

    public static synchronized IdentityTokenized reregister(IdentityTokenized identityTokenized) {
        if (identityTokenized instanceof PooledDataSource) {
            C3P0Registry.banner();
            C3P0Registry.attemptRegisterRegistryMBean();
        }
        if (identityTokenized.getIdentityToken() == null) {
            throw new RuntimeException("[c3p0 issue] The identityToken of a registered object should be set prior to registration.");
        }
        IdentityTokenized identityTokenized2 = (IdentityTokenized)idtCoalescer.coalesce((Object)identityTokenized);
        if (!C3P0Registry.isIncorporated(identityTokenized2)) {
            C3P0Registry.incorporate(identityTokenized2);
        }
        return identityTokenized2;
    }

    public static synchronized void markClosed(PooledDataSource pooledDataSource) {
        unclosedPooledDataSources.remove(pooledDataSource);
        mc.attemptUnmanagePooledDataSource(pooledDataSource);
        if (unclosedPooledDataSources.isEmpty()) {
            mc.attemptUnmanageC3P0Registry();
            registry_mbean_registered = false;
        }
    }

    public static synchronized Set getPooledDataSources() {
        return (Set)unclosedPooledDataSources.clone();
    }

    public static synchronized Set pooledDataSourcesByName(String string) {
        HashSet<PooledDataSource> hashSet = new HashSet<PooledDataSource>();
        for (PooledDataSource pooledDataSource : unclosedPooledDataSources) {
            if (!pooledDataSource.getDataSourceName().equals(string)) continue;
            hashSet.add(pooledDataSource);
        }
        return hashSet;
    }

    public static synchronized PooledDataSource pooledDataSourceByName(String string) {
        for (PooledDataSource pooledDataSource : unclosedPooledDataSources) {
            if (!pooledDataSource.getDataSourceName().equals(string)) continue;
            return pooledDataSource;
        }
        return null;
    }

    public static synchronized Set allIdentityTokens() {
        Set set = Collections.unmodifiableSet(tokensToTokenized.keySet());
        return set;
    }

    public static synchronized Set allIdentityTokenized() {
        HashSet hashSet = new HashSet();
        hashSet.addAll(tokensToTokenized.values());
        return Collections.unmodifiableSet(hashSet);
    }

    public static synchronized Set allPooledDataSources() {
        Set set = Collections.unmodifiableSet(unclosedPooledDataSources);
        return set;
    }

    public static synchronized int getNumPooledDataSources() {
        return unclosedPooledDataSources.size();
    }

    public static synchronized int getNumPoolsAllDataSources() throws SQLException {
        int n = 0;
        for (PooledDataSource pooledDataSource : unclosedPooledDataSources) {
            n += pooledDataSource.getNumUserPools();
        }
        return n;
    }

    public synchronized int getNumThreadsAllThreadPools() throws SQLException {
        int n = 0;
        for (PooledDataSource pooledDataSource : unclosedPooledDataSources) {
            n += pooledDataSource.getNumHelperThreads();
        }
        return n;
    }

    public static synchronized Map getConfigExtensionsForPooledDataSource(String string) throws SQLException {
        try {
            PooledDataSource pooledDataSource = (PooledDataSource)tokensToTokenized.get(string);
            if (pooledDataSource == null) {
                throw new SQLException("No DataSource or registered IdentityTokenized has identityToken '" + string + "'.");
            }
            return pooledDataSource.getExtensions();
        }
        catch (ClassCastException classCastException) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "Tried to get config extensions for an entity that is not a PooledDataSource. (Extensions are available only on PooledDataSources.) Thowing SQLException.", (Throwable)classCastException);
            }
            throw SqlUtils.toSQLException((String)"Tried to get config extensions for an entity that is not a PooledDataSource. (Extensions are available only on PooledDataSources.)", (Throwable)classCastException);
        }
    }

    static {
        C3P0Registry.resetConnectionTesterCache();
        String string = C3P0ConfigUtils.getPropsFileConfigProperty(MC_PARAM);
        if (string != null) {
            try {
                mc = (ManagementCoordinator)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                if (logger.isLoggable(MLevel.WARNING)) {
                    logger.log(MLevel.WARNING, "Could not instantiate user-specified ManagementCoordinator " + string + ". Using NullManagementCoordinator (c3p0 JMX management disabled!)", (Throwable)exception);
                }
                mc = new NullManagementCoordinator();
            }
        } else {
            try {
                Class.forName("java.lang.management.ManagementFactory");
                mc = (ManagementCoordinator)Class.forName("com.mchange.v2.c3p0.management.ActiveManagementCoordinator").newInstance();
            }
            catch (Exception exception) {
                if (logger.isLoggable(MLevel.INFO)) {
                    logger.log(MLevel.INFO, "jdk1.5 management interfaces unavailable... JMX support disabled.", (Throwable)exception);
                }
                mc = new NullManagementCoordinator();
            }
        }
        DEFAULT_TASK_RUNNER_FACTORY = new DefaultTaskRunnerFactory();
    }
}

