/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: EmbeddedFileHandler.java 1870 2010-12-27 12:35:52Z sletellier $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.5.2/vradi-swing/src/main/java/com/jurismarches/vradi/ui/offer/widgets/EmbeddedFileHandler.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.offer.widgets;

import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.offer.OfferEditHandler;
import com.jurismarches.vradi.ui.widgets.MultipleSelectionFileHandler;
import com.jurismarches.vradi.ui.widgets.MultipleSelectionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.File;
import java.util.List;
import java.util.Set;

import static org.nuiton.i18n.I18n.n_;

/**
 * @author sletellier
 */
public class EmbeddedFileHandler extends MultipleSelectionFileHandler<Form, OfferEditHandler> {

    /** log. */
    private static final Log log = LogFactory.getLog(AttachmentFileHandler.class);

    public EmbeddedFileHandler(MultipleSelectionPane ui) {
        super(ui, OfferEditHandler.class, n_("vradi.offerEdit.embeddedfile"));
    }

    @Override
    public File downloadFile(String selected, String wikittyId) throws VradiException {
        return VradiService.getFileService().downloadFormEmbeddedFile(selected, getBean().getWikittyId());
    }

    @Override
    public List<String> removeFiles(Form bean, List<String> selectedInList) {
        return getHandler().removeEmbeddedFile(getBean(), getSelectedInList());
    }

    @Override
    public Set<String> getFiles() {
        return getBean().getFiles();
    }

    @Override
    public File addFiles(MultipleSelectionPane ui, Form bean) {
        return getHandler().addEmbeddedFile(ui, getBean());
    }
}
