/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.email;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.email.*;
import com.jurismarches.vradi.ui.email.models.EmailEntityModel;
import com.jurismarches.vradi.ui.email.renderers.EmailFormsListCellRenderer;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.renderers.EntityRenderer;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import org.nuiton.wikitty.entities.BusinessEntity;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class QueryMakerViewUI<E extends BusinessEntity> extends javax.swing.JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_CLAZZ = "clazz";
    public static final String PROPERTY_FORM = "form";
    public static final String PROPERTY_FORMS_IDS = "formsIds";
    public static final String PROPERTY_SESSION = "session";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_QUERY_MAKER_FORM_ENABLED = "queryMakerForm.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUu24TQRS9Nn4HTCAiSkSQDEQKoljTOwpBQVaMHBBYQRFuGHuHeMLuzmRmNl6nQHwCnwA9DRIdFaKgpqBB/AJCFLSIO+PHJmGjRMLF7nrnnjPnnjl33/6ArJJwdYdEkSPDQDOfOvfubG096OzQrr5LVVcyobmE4S+VhnQbptzJe6Xhertp4NURvLrGfcEDGhxA15pQUnrgUdWjVGu4chjRVaramizXIhHKMetEVBLr618/06/cl2/SAJFAdTlspXISKu4k04Q0czVcxJ32SNUjwTbKkCzYRr3nzLs1jyh1n/h0F15Avgk5QSSSabh2+pYth8VHQsP0bkjlYIM8p/Ixo/3NhoZbXe47O6Fkyiey26PK2ZPEZU7IHOoT5jkPj0CEsHw5DXlFlWI80LB0DAlqYprh39awMsZmux7Z39dw3jTqmOYdKzWuyDzj0teweBJ1HctiVMGgVMPFZJQtdaixhyZTOq4pxy7U7R6HA6j6eAYW0qIexpDLzYZBFgUe8OVDpRgdJ45OfLapNmRliK81zLX/TdsjXBrmbO5IzgyhXf0zO/P1w/f39XG4Mrj3pcTSA7OBhy4kF1QaY9DbYbKMA9UNImptKKpRR7i6kCBs3DCKw/0uxAauE9VDimz+28dPs0+/nIF0HUoeJ26dmPoGFHVPogvccyNxe9UqOtsv4HXaaNOQ88iAh5jd8rJLNKl0WOCizSsRmrCQYMJESaf4+fdM693q2IgUCps/tjw2I/sEcizwWEDtnI1GKHGupoSiocvjUUkanpS5l8QoRRV7XUzqNE8D0vGo3XEpCs3thtVtnm5amvlT0BRw1F0qqfxPniIeSn+duVzip2Z56EiFaPzQdEJNV44n/gvUUIVjnQUAAA==";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.email.QueryMakerViewUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.lang.Class< E > clazz;
    protected com.jurismarches.vradi.entities.Form form;
    protected java.util.List< String > formsIds;
    protected jaxx.runtime.swing.ListSelectorUI< E > queryMakerForm;
    protected QueryMakerViewUI queryMakerViewUI = this;
    protected com.jurismarches.vradi.entities.Session session;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected EmailFormsListCellRenderer emailFormsCellRenderer;
    
    
    public void init(java.util.List<E> toCombo, java.util.List<E> toList) {
        init(false, null, null, toCombo, toList);
    }
    
    public void init(boolean isEmailUI, Form form, EmailFormsListCellRenderer emailFormsCellRenderer, java.util.List<E> toCombo, java.util.List<E> toList) {
    
        this.form = form;
        this.emailFormsCellRenderer = emailFormsCellRenderer;
    
        // Add completion
        AutoCompleteDecorator.decorate(queryMakerForm.getCombo(), EntityRenderer.getInstance());
    
        JButton addButton = queryMakerForm.getAdd();
    
        JButton removeButton = queryMakerForm.getRemove();
    
        if (!isEmailUI) {
    
            queryMakerForm.init(toCombo, toList);
    
            log.info("is not email ui");
            return;
        }
    
        // Add own
        addButton.addActionListener(new ActionListener(){
    
            @Override
            public void actionPerformed(ActionEvent e) {
                addSending();
            }
        });
    
        // Add own
        removeButton.addActionListener(new ActionListener(){
    
            @Override
            public void actionPerformed(ActionEvent e) {
                removeSending();
            }
        });
    
        // Remove default listener
        addButton.removeActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", queryMakerForm, "doActionPerformed__on__add"));
    
        // Remove default listener
        removeButton.removeActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", queryMakerForm, "doActionPerformed__on__remove"));
    
        queryMakerForm.init(toCombo, toList);
    
        queryMakerForm.getList().setCellRenderer(emailFormsCellRenderer);
    
        queryMakerForm.getList().addMouseListener(new MouseAdapter() {
            @Override
            public void mouseClicked(MouseEvent e) {
    
                JList list = (JList)e.getSource();
    
                if (e.getButton() == MouseEvent.BUTTON3) {
                    Object[] objects = list.getSelectedValues();
                    showPopupMenu(e, objects);
                }
            }
        });
    }
    
    protected void showPopupMenu(MouseEvent e, Object[] objects) {
        if (emailFormsCellRenderer.areDeleted(objects) && VradiConstants.SessionStatus.isToSend(session)) {
    
            // Display popup menu
            final JPopupMenu menu = new JPopupMenu();
            final JMenuItem revertDeletion = new JMenuItem(_("vradi.email.forms.revertDeletion"));
            revertDeletion.addActionListener(new ActionListener() {
    
                @Override
                public void actionPerformed(ActionEvent e) {
                    revertDeletion();
                }
            });
    
            menu.add(revertDeletion);
            menu.show(e.getComponent(), e.getX(), e.getY());
        }
    
    }
    
    protected void revertDeletion() {
        Form form = getForm();
        if (form != null) {
            if (clazz == User.class) {
                getHandler().revertUserDeletion(this, session, form.getWikittyId(), queryMakerForm.getList().getSelectedValues());
            } else {
                getHandler().revertGroupDeletion(this, session, form.getWikittyId(), queryMakerForm.getList().getSelectedValues());
            }
        }
    }
    
    protected void addSending() {
        Form form = getForm();
        if (form != null) {
            if (clazz == User.class) {
                getHandler().addUserSending(QueryMakerViewUI.this, session, form.getWikittyId(), queryMakerForm.getCombo().getSelectedItem());
            } else {
                getHandler().addGroupSending(QueryMakerViewUI.this, session, form.getWikittyId(), queryMakerForm.getCombo().getSelectedItem());
            }
        } else {
            if (clazz == User.class) {
                getHandler().addUserSending(QueryMakerViewUI.this, session, getFormsIds(), queryMakerForm.getCombo().getSelectedItem());
            } else {
                getHandler().addGroupSending(QueryMakerViewUI.this, session, getFormsIds(), queryMakerForm.getCombo().getSelectedItem());
            }
        }
    }
    
    protected void removeSending() {
        Form form = getForm();
        if (form != null) {
            if (clazz == User.class) {
                getHandler().removeUserSending(QueryMakerViewUI.this, session, form.getWikittyId(), queryMakerForm.getList().getSelectedValues());
            } else {
                getHandler().removeGroupSending(QueryMakerViewUI.this, session, form.getWikittyId(), queryMakerForm.getList().getSelectedValues());
            }
        } else {
            if (clazz == User.class) {
                getHandler().removeUserSending(QueryMakerViewUI.this, session, getFormsIds(), queryMakerForm.getList().getSelectedValues());
            } else {
                getHandler().removeGroupSending(QueryMakerViewUI.this, session, getFormsIds(), queryMakerForm.getList().getSelectedValues());
            }
        }
    }
    
    protected void updateSession(Session sessionRestored) {
        getParentContainer(FormViewUI.class).updateSession(sessionRestored);
    }
    
    public EmailHandler getHandler() {
        return UIHelper.getHandler(this, EmailHandler.class);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public QueryMakerViewUI() {
        $initialize();
    }

    public QueryMakerViewUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public java.lang.Class< E > getClazz() {
        return clazz;
    }

    public com.jurismarches.vradi.entities.Form getForm() {
        return form;
    }

    public java.util.List< String > getFormsIds() {
        return formsIds;
    }

    public jaxx.runtime.swing.ListSelectorUI< E > getQueryMakerForm() {
        return queryMakerForm;
    }

    public com.jurismarches.vradi.entities.Session getSession() {
        return session;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setClazz(java.lang.Class< E > newValue) {
        java.lang.Class< E > oldValue = this.clazz;
        this.clazz = newValue;
        firePropertyChange(PROPERTY_CLAZZ, oldValue, newValue);
    }

    public void setForm(com.jurismarches.vradi.entities.Form newValue) {
        com.jurismarches.vradi.entities.Form oldValue = this.form;
        this.form = newValue;
        firePropertyChange(PROPERTY_FORM, oldValue, newValue);
    }

    public void setFormsIds(java.util.List< String > newValue) {
        java.util.List< String > oldValue = this.formsIds;
        this.formsIds = newValue;
        firePropertyChange(PROPERTY_FORMS_IDS, oldValue, newValue);
    }

    public void setSession(com.jurismarches.vradi.entities.Session newValue) {
        com.jurismarches.vradi.entities.Session oldValue = this.session;
        this.session = newValue;
        firePropertyChange(PROPERTY_SESSION, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToQueryMakerViewUI() {
        if (!allComponentsCreated) {
            return;
        }
        add(queryMakerForm, BorderLayout.CENTER);
    }

    protected void createClazz() {
        $objectMap.put("clazz", clazz = null);
    }

    protected void createForm() {
        $objectMap.put("form", form = null);
    }

    protected void createFormsIds() {
        $objectMap.put("formsIds", formsIds = null);
    }

    protected void createQueryMakerForm() {
        $objectMap.put("queryMakerForm", queryMakerForm = new jaxx.runtime.swing.ListSelectorUI< E >());
        
        queryMakerForm.setName("queryMakerForm");
        queryMakerForm.setShowHidor(false);
    }

    protected void createSession() {
        $objectMap.put("session", session = null);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToQueryMakerViewUI();
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 2 property setters
        queryMakerForm.setRenderer(new EntityRenderer());
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("queryMakerViewUI", this);
        createSession();
        createClazz();
        createForm();
        createFormsIds();
        createQueryMakerForm();
        // inline creation of queryMakerViewUI
        setName("queryMakerViewUI");
        setLayout(new BorderLayout());
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_QUERY_MAKER_FORM_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                queryMakerForm.setEnabled(isEnabled());
            }
        });
    }

}