/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: JListCellRenderer.java 1873 2010-12-30 12:56:40Z sletellier $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.5.2/vradi-swing/src/main/java/com/jurismarches/vradi/ui/admin/renderers/JListCellRenderer.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.renderers;

import java.awt.Component;

import javax.swing.*;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.jurismarches.vradi.ui.helpers.UIHelper;

/**
 * Un renderer d'une cellule d'un tableau qui contient une liste de valeurs sélectionnables.
 * <p/>
 * User: chemit
 * Date: 15 nov. 2009
 * Time: 21:36:08
 */
public class JListCellRenderer implements TableCellRenderer {

    /**
     * Logger
     */
    static private final Log log = LogFactory.getLog(JListCellRenderer.class);

    /**
     * le composant pour le rendu
     */
    protected JList list;
    /**
     * le composant de délégation pour obtenir le rendu visuel (commun à tout le tableau)
     */
    protected TableCellRenderer delegateRenderer;

    public JListCellRenderer() {
        this(null, new DefaultTableCellRenderer());
    }

    public JListCellRenderer(ListCellRenderer listRenderer) {
        this(listRenderer, new DefaultTableCellRenderer());
    }

    public JListCellRenderer(TableCellRenderer delegateRenderer) {
        this(null, delegateRenderer);
    }

    public JListCellRenderer(ListCellRenderer listRenderer, TableCellRenderer delegateRenderer) {
        this.delegateRenderer = delegateRenderer;
        this.list = new JList(new DefaultListModel());
        if (listRenderer != null) {
            list.setCellRenderer(listRenderer);
        }
    }

    /**
     * Pour mettre à jour la liste des valeurs sélectionnables.
     *
     * @param values les valeurs sélectionnables (à placer dans le modèle de la liste)
     */
    public void updateUniverse(java.util.List<String> values) {
        UIHelper.fillList(list, values, null);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (log.isInfoEnabled()) {
            log.info("renderer value " + value);
        }
        UIHelper.updateListSelection(list, value);

        renderFromDelegate(table, value, isSelected, hasFocus, row, column);

        return list;
    }

    /**
     * Effectuer le rendu visual à partir du renderer delegate.
     *
     * @param table      la table a afficher
     * @param value      la valeur à afficher
     * @param isSelected {@code true} si la cellule est sélectionnée
     * @param hasFocus   {@code true} si la cellule a le focus
     * @param row        la ligne sélectionnée
     * @param column     la colonne sélectionnée
     */
    protected void renderFromDelegate(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        // obtain visual render from delegate
        JComponent rendererComponent = (JComponent) delegateRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        list.setBackground(rendererComponent.getBackground());
        list.setFont(rendererComponent.getFont());
        list.setBorder(rendererComponent.getBorder());
    }
}
