/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.beans.QueryBean;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class RequestListUI extends javax.swing.JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";
    private static final String BINDING_$JBUTTON1_ENABLED = "$JButton1.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.content.RequestListUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected com.jurismarches.vradi.entities.Group bean;
    protected javax.swing.JPanel content;
    protected javax.swing.JScrollPane contentScroll;
    protected jaxx.runtime.swing.Table header;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private RequestListUI $JPanel0 = this;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JButton $JButton1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init() {
        content.setVisible(false);
        content.removeAll();
        content.setAlignmentY(TOP_ALIGNMENT);
        
        if (bean != null && bean.getQueries() != null) {
            for (String query : bean.getQueries()) {
                createRequest(query);
            }
        }
        content.setVisible(true);    
    }
    
    protected void createRequest(final String query) {
        RequestSelectUI requestUI = new RequestSelectUI(RequestListUI.this);
        requestUI.setAlignmentY(TOP_ALIGNMENT);
    
        if (log.isDebugEnabled()){
            log.debug("Open query " + query);
        }
        
        try {
            requestUI.setBean(new QueryBean(query));
        } catch (IOException e) {
            log.error(e.getMessage(), e);
            return;
        }
        
        requestUI.addPropertyChangeListener(PROPERTY_BEAN, new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                RequestSelectUI query = (RequestSelectUI) evt.getSource();
    
                QueryBean oldValue = (QueryBean) evt.getOldValue();
                QueryBean newValue = (QueryBean) evt.getNewValue();
    
                if (log.isDebugEnabled()
                    && oldValue != null
                    && newValue != null) {
                    log.debug("Update query from '" + oldValue.getQueryLine() + "' to '" + newValue.getQueryLine() + "'");
                }
    
                bean.removeQueries(oldValue.getQueryLine());
    
                if (newValue == null) {
                    // this means remove
                    content.setVisible(false);
                    content.remove(query);
                    content.setVisible(true);
                } else {
                    // this means update
                    bean.addQueries(newValue.getQueryLine());
                }
            }
        });
        requestUI.setAlignmentY(Component.TOP_ALIGNMENT);
        content.add(requestUI);
        validate();
    }
    
    protected void showHistory() {
        AdminHandler handler = getContextValue(AdminHandler.class);
        handler.showHistory(bean.getWikittyId());
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public RequestListUI() {
        $initialize();
    }

    public RequestListUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        showHistory();
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        createRequest("");
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public com.jurismarches.vradi.entities.Group getBean() {
        return bean;
    }

    public javax.swing.JPanel getContent() {
        return content;
    }

    public javax.swing.JScrollPane getContentScroll() {
        return contentScroll;
    }

    public jaxx.runtime.swing.Table getHeader() {
        return header;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(com.jurismarches.vradi.entities.Group newValue) {
        com.jurismarches.vradi.entities.Group oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToContentScroll() {
        if (!allComponentsCreated) {
            return;
        }
        contentScroll.getViewport().add(content);
    }

    protected void addChildrenToHeader() {
        if (!allComponentsCreated) {
            return;
        }
        header.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        header.add($JButton0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        header.add($JButton1, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createContent() {
        $objectMap.put("content", content = new javax.swing.JPanel());
        
        content.setName("content");
        content.setLayout(new BoxLayout(content, BoxLayout.Y_AXIS));
    }

    protected void createContentScroll() {
        $objectMap.put("contentScroll", contentScroll = new javax.swing.JScrollPane());
        
        contentScroll.setName("contentScroll");
    }

    protected void createHeader() {
        $objectMap.put("header", header = new jaxx.runtime.swing.Table());
        
        header.setName("header");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $JPanel0
        add(header);
        add(contentScroll, BorderLayout.CENTER);
        addChildrenToHeader();
        addChildrenToContentScroll();
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 4 property setters
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("history"));
        contentScroll.setColumnHeaderView(header);
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$JPanel0", this);
        createBean();
        createHeader();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminRequest.title"));
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.adminRequest.history.show"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("vradi.adminRequest.new"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        createContentScroll();
        createContent();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new GridLayout(0,1));
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON1_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                $JButton1.setEnabled(isEnabled());
            }
        });
    }

}