/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.email.widgets;

import com.jurismarches.vradi.entities.Session;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.email.EmailHandler;
import com.jurismarches.vradi.ui.widgets.MultipleSelectionFileHandler;
import com.jurismarches.vradi.ui.widgets.MultipleSelectionPane;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class AttachmentSessionFileHandler
extends MultipleSelectionFileHandler<Session, EmailHandler> {
    private static final Log log = LogFactory.getLog(AttachmentSessionFileHandler.class);

    public AttachmentSessionFileHandler(MultipleSelectionPane ui) {
        super(ui, EmailHandler.class, I18n.n_("vradi.email.sessionAttachedfile"));
    }

    @Override
    public File downloadFile(String selected, String wikittyId) throws VradiException {
        return VradiService.getFileService().downloadSessionAttachment(selected, ((Session)this.getBean()).getWikittyId());
    }

    @Override
    public List<String> removeFiles(Session bean, List<String> selectedInList) {
        List<String> result = ((EmailHandler)this.getHandler()).removeAttachmentFile((Session)this.getBean(), this.getSelectedInList());
        this.updateSession();
        return result;
    }

    @Override
    public Set<String> getFiles() {
        return ((Session)this.getBean()).getFiles();
    }

    @Override
    public File addFiles(MultipleSelectionPane ui, Session bean) {
        File result = ((EmailHandler)this.getHandler()).addAttachmentFile(ui, (Session)this.getBean());
        this.updateSession();
        return result;
    }

    protected void updateSession() {
        Session session = (Session)VradiService.getWikittyProxy().restore(Session.class, ((Session)this.getBean()).getWikittyId());
        this.setBean(session);
    }
}

