/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.email.models;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiEntitiesListener;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.Session;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.email.renderers.EmailFormsListCellRenderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.entities.BusinessEntity;

public abstract class EmailEntityModel<E extends BusinessEntity>
extends DefaultListModel
implements VradiEntitiesListener<Sending> {
    private static final Log log = LogFactory.getLog(EmailEntityModel.class);
    protected EmailFormsListCellRenderer renderer;
    protected Map<String, E> datas;
    protected Session session;
    protected Form form;

    public EmailEntityModel(EmailFormsListCellRenderer renderer, Session session, Form form) {
        this.renderer = renderer;
        this.datas = new HashMap<String, E>();
        this.session = session;
        this.form = form;
        this.updateModel(session, form);
        VradiContext.get().getVradiNotifier().addVradiListener(Sending.class, this);
    }

    @Override
    public int getSize() {
        return this.datas.size();
    }

    public abstract void updateModel(Session var1, Form var2);

    @Override
    public Object getElementAt(int index) {
        ArrayList<String> keys = new ArrayList<String>(this.datas.keySet());
        return this.datas.get(keys.get(index));
    }

    protected void updateDatas(List<E> datas) {
        if (datas == null) {
            return;
        }
        for (BusinessEntity data : datas) {
            if (data == null) continue;
            this.datas.put(data.getWikittyId(), data);
        }
        this.fireContentsChanged(this, 0, this.getSize());
    }

    protected void refresh() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Refresh datas");
        }
        this.session = (Session)VradiService.getWikittyProxy().restore(Session.class, this.session.getWikittyId());
        this.renderer.updateDatas(this.session, this.form.getWikittyId());
        this.updateModel(this.session, this.form);
    }

    @Override
    public void entitiesAdded(Set<Sending> added) {
        this.refreshIfNeeded(VradiHelper.extractIds(added));
    }

    @Override
    public void entitiesRemoved(Set<String> removed) {
        this.refreshIfNeeded(removed);
    }

    protected void refreshIfNeeded(Collection<String> sendingsIds) {
        boolean mustBeRefresh = false;
        for (String sendingId : sendingsIds) {
            Session restoredSession = VradiService.getVradiDataService().getSessionBySending(sendingId);
            if (!this.session.equals(restoredSession)) continue;
            mustBeRefresh = true;
            break;
        }
        if (mustBeRefresh) {
            this.refresh();
        }
    }
}

