/*
 * Decompiled with CFR 0.152.
 */
package ognl;

import java.beans.IntrospectionException;
import java.util.Map;
import ognl.NoSuchPropertyException;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlRuntime;
import ognl.PropertyAccessor;

public class ObjectPropertyAccessor
implements PropertyAccessor {
    public Object getPossibleProperty(Map context, Object target, String name) throws OgnlException {
        Object result;
        OgnlContext ognlContext = (OgnlContext)context;
        try {
            result = OgnlRuntime.getMethodValue(ognlContext, target, name, true);
            if (result == OgnlRuntime.NotFound) {
                result = OgnlRuntime.getFieldValue(ognlContext, target, name, true);
            }
        }
        catch (IntrospectionException ex) {
            throw new OgnlException(name, ex);
        }
        catch (OgnlException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OgnlException(name, ex);
        }
        return result;
    }

    public Object setPossibleProperty(Map context, Object target, String name, Object value) throws OgnlException {
        Object result = null;
        OgnlContext ognlContext = (OgnlContext)context;
        try {
            if (!OgnlRuntime.setMethodValue(ognlContext, target, name, value, true)) {
                result = OgnlRuntime.setFieldValue(ognlContext, target, name, value) ? null : OgnlRuntime.NotFound;
            }
        }
        catch (IntrospectionException ex) {
            throw new OgnlException(name, ex);
        }
        catch (OgnlException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OgnlException(name, ex);
        }
        return result;
    }

    public boolean hasGetProperty(OgnlContext context, Object target, Object oname) throws OgnlException {
        try {
            return OgnlRuntime.hasGetProperty(context, target, oname);
        }
        catch (IntrospectionException ex) {
            throw new OgnlException("checking if " + target + " has gettable property " + oname, ex);
        }
    }

    public boolean hasGetProperty(Map context, Object target, Object oname) throws OgnlException {
        return this.hasGetProperty((OgnlContext)context, target, oname);
    }

    public boolean hasSetProperty(OgnlContext context, Object target, Object oname) throws OgnlException {
        try {
            return OgnlRuntime.hasSetProperty(context, target, oname);
        }
        catch (IntrospectionException ex) {
            throw new OgnlException("checking if " + target + " has settable property " + oname, ex);
        }
    }

    public boolean hasSetProperty(Map context, Object target, Object oname) throws OgnlException {
        return this.hasSetProperty((OgnlContext)context, target, oname);
    }

    public Object getProperty(Map context, Object target, Object oname) throws OgnlException {
        Object result = null;
        String name = oname.toString();
        result = this.getPossibleProperty(context, target, name);
        if (result == OgnlRuntime.NotFound) {
            throw new NoSuchPropertyException(target, name);
        }
        return result;
    }

    public void setProperty(Map context, Object target, Object oname, Object value) throws OgnlException {
        String name = oname.toString();
        if (this.setPossibleProperty(context, target, name, value) == OgnlRuntime.NotFound) {
            throw new NoSuchPropertyException(target, name);
        }
    }
}

