/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util.beans;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderBuilder;

@Deprecated
public class BinderProvider {
    private static final Log log = LogFactory.getLog(BinderProvider.class);
    protected static Map<BinderEntry, Binder<?, ?>> binders;

    public static <S> Binder<S, S> getBinder(Class<S> sourceType) {
        return BinderProvider.getBinder(sourceType, sourceType, null);
    }

    public static <S> Binder<S, S> getBinder(Class<S> sourceType, String name) {
        return BinderProvider.getBinder(sourceType, sourceType, name);
    }

    public static <S, T> Binder<S, T> getBinder(Class<S> sourceType, Class<T> targetType) {
        return BinderProvider.getBinder(sourceType, targetType, null);
    }

    public static <S, T> Binder<S, T> getBinder(Class<S> sourceType, Class<T> targetType, String name) {
        Binder<?, ?> result;
        BinderEntry entry = new BinderEntry(sourceType, targetType, name);
        if (log.isDebugEnabled()) {
            log.debug((Object)("for entry " + entry));
        }
        if ((result = BinderProvider.getBinders().get(entry)) == null && log.isWarnEnabled()) {
            log.warn((Object)("Could not find binder " + entry));
        }
        return result;
    }

    public static void registerBinder(Binder<?, ?> binder) {
        BinderProvider.registerBinder(binder, null);
    }

    public static void registerBinder(BinderBuilder builder) {
        BinderProvider.registerBinder(builder, Binder.class);
    }

    public static <B extends Binder<?, ?>> void registerBinder(BinderBuilder builder, Class<B> binderType) {
        BinderProvider.registerBinder(builder, binderType, null);
    }

    public static void registerBinder(BinderBuilder builder, String name) {
        BinderProvider.registerBinder(builder, Binder.class, name);
    }

    public static <B extends Binder<?, ?>> void registerBinder(BinderBuilder builder, Class<B> binderType, String name) {
        B binder = builder.createBinder(binderType);
        BinderProvider.registerBinder(binder, name);
    }

    public static void registerBinder(Binder<?, ?> binder, String name) {
        Binder<?, ?> oldBinder;
        Binder.BinderModel<?, ?> model = binder.getModel();
        BinderEntry entry = new BinderEntry(model.getSourceType(), model.getTargetType(), name);
        if (log.isDebugEnabled()) {
            log.debug((Object)("binder to seek : " + entry));
        }
        if ((oldBinder = BinderProvider.getBinders().get(entry)) != null && log.isWarnEnabled()) {
            log.warn((Object)("Binder already registred for " + entry + " : " + oldBinder));
            log.warn((Object)("Will be replace by the new binder " + binder));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("entry : " + entry + " : " + binder));
        }
        BinderProvider.getBinders().put(entry, binder);
    }

    protected static Map<BinderEntry, Binder<?, ?>> getBinders() {
        if (binders == null) {
            binders = new HashMap();
        }
        return binders;
    }

    public static void clear() {
        if (binders != null) {
            binders.clear();
            binders = null;
        }
    }

    public static class BinderEntry {
        protected final Class<?> sourceType;
        protected final Class<?> targetType;
        protected final String name;

        public BinderEntry(Class<?> sourceType, Class<?> targetType, String name) {
            this.sourceType = sourceType;
            this.targetType = targetType;
            this.name = name;
        }

        public Class<?> getSourceType() {
            return this.sourceType;
        }

        public Class<?> getTargetType() {
            return this.targetType;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BinderEntry that = (BinderEntry)o;
            return (this.name == null ? that.name == null : this.name.equals(that.name)) && this.sourceType.equals(that.sourceType) && this.targetType.equals(that.targetType);
        }

        public int hashCode() {
            int result = this.sourceType.hashCode();
            result = 31 * result + this.targetType.hashCode();
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder("<");
            buffer.append(super.toString());
            buffer.append(", sourceType: ").append(this.getSourceType()).append(',');
            buffer.append(" targetType: ").append(this.getTargetType()).append(',');
            buffer.append(" name: ").append(this.getName()).append('>');
            return buffer.toString();
        }
    }
}

