/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.search;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.models.OfferListTableModel;
import com.jurismarches.vradi.ui.renderers.NumberListCellRenderer;
import com.jurismarches.vradi.ui.search.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.text.MaskFormatter;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.SwingUtil.getStringValue;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class PaginationUI extends javax.swing.JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_OFFER_LIST_TABLE_MODEL = "offerListTableModel";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_FORM_NB_LABEL_TEXT = "formNbLabel.text";
    public static final String BINDING_NEXT_PAGE_VISIBLE = "nextPage.visible";
    public static final String BINDING_PAGE_NUMBER_TEXT = "pageNumber.text";
    public static final String BINDING_PAGE_WANTED_TEXT = "pageWanted.text";
    public static final String BINDING_PREVIOUS_PAGE_VISIBLE = "previousPage.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVTW/TQBDdhqbfpU1DP4BCS6mEOOC0IIGgUCBFgVZpQbSIilxYx9tkK3vX7K6DywHxE/gJcOeCxI0T4sCZAxfEX0CIA1fErJM4NbipRXNw4pl5b97M7kzefEdpKdCpbez7hvCYog4xVm5ubt41t0lZ3SKyLKiruED1T0cKpUqo3wrtUqHTpaKG5xrw3BJ3XM4I24VeKKI+qXZsIquEKIVORBFlKXProXvBdz3RZA1FxbG++vkj9dJ68TqFkO+CukEoZXo/VKuSziJKUUuhEchUwzkbswrIEJRVQO+gti3ZWMo17JAn6DnqLqIuFwsgU2gmeckBR4D3XYV6ZlfuYUbsOYXOlbljbHuCSgeLcpVIoyawRQ2PGpJoi3EPVyjDinL2YNl1A5IuhbJ8a4uIIpVqA5s2WeUWsRW6sjdbEG84Ok4ad/8Ft6i7Zu/kuQ/axiNdlE+hJ4Z26bjeMLx/iwtnzSxiUysY0R3zG8ErgVHHDYXhUHtgndPvR6K+euZ5/ZaJJmmi5kPUeKsVWoDM70CjCJyByYFDodGIkKY9iqznOx+Tb8AVpEa5JzUppIiQ5T2lONORJ0NAnwuBDzFTBO7SVCS8APKwAscG8VWBEtuKga55jklEWF3L28MApVXo95mGT6DjkbOB2TFas9O63B0llBYemBWaKP07bvfBVR+0ib8GTRMG3t9j2S/vv70rNKcrA7lHY0N3LQe49a7gLhGK6tRD9dHyFLVzq9hdKKFeSWzYLMHmmIwRtt5wgzjIl9FwQ8ONO1hWgSLd/fXDx7HHnw+hVAH12RxbBazjl1GvqgroArct371+I1A08LQHnsNaGxy5jXc4nB86fNXCCk+blFlwSos+NGEypgmhErP306/s+tsbzUZ0gLCje4a3mpF+hLoosykjwaJp7JDYxdLvSuJZvLUr4rZHh/7ucxvjmgueF+IqzdR0/8vYvmnTCnNgL+nQi76nvy4FFehflwPC4QSEnQpuYhuO7L4c2pyHHXG13pBpmApBTU+RxXjGsQSqslUu6DPOVLJCJxKJvHZghrx+3I5nOJagrHSwqdvImExA0gP/UxYR9b3y3zz7NWQqyd2h5frG3IPjVAKO7hqVFP6uDkpT5rbnMNnmgGaTH/EeQg7OcCYRQ6UNw9lEDO3umGb4A6los+UdCgAA";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.search.PaginationUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel formNbLabel;
    protected javax.swing.JComboBox formsByPageComboBox;
    protected javax.swing.JButton nextPage;
    protected com.jurismarches.vradi.ui.offer.models.OfferListTableModel offerListTableModel;
    protected javax.swing.JLabel pageNumber;
    protected javax.swing.JFormattedTextField pageWanted;
    protected javax.swing.JButton previousPage;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private PaginationUI $JPanel0 = this;
    private jaxx.runtime.swing.HBox $HBox0;
    private javax.swing.JLabel $JLabel0;
    private jaxx.runtime.swing.HBox $HBox1;
    private javax.swing.JLabel $JLabel1;
    private jaxx.runtime.swing.HBox $HBox2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public SearchHandler getHandler() {
        return UIHelper.getHandler(this, SearchHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
        pageWanted.addKeyListener(new KeyAdapter(){
            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if(keyEvent.getKeyCode() == KeyEvent.VK_ENTER) {
                    offerListTableModel.setPageToShow((Integer) pageWanted.getValue());
                }
            }
        });
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public PaginationUI() {
        $initialize();
    }

    public PaginationUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__formsByPageComboBox(java.awt.event.ActionEvent event) {
        offerListTableModel.setNbFormsPerPage((Integer)formsByPageComboBox.getSelectedItem());
    }

    public void doActionPerformed__on__nextPage(java.awt.event.ActionEvent event) {
        offerListTableModel.setPageToShow(offerListTableModel.getPageToShow() + 1);
    }

    public void doActionPerformed__on__previousPage(java.awt.event.ActionEvent event) {
        offerListTableModel.setPageToShow(offerListTableModel.getPageToShow() - 1);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JLabel getFormNbLabel() {
        return formNbLabel;
    }

    public javax.swing.JComboBox getFormsByPageComboBox() {
        return formsByPageComboBox;
    }

    public javax.swing.JButton getNextPage() {
        return nextPage;
    }

    public com.jurismarches.vradi.ui.offer.models.OfferListTableModel getOfferListTableModel() {
        return offerListTableModel;
    }

    public javax.swing.JLabel getPageNumber() {
        return pageNumber;
    }

    public javax.swing.JFormattedTextField getPageWanted() {
        return pageWanted;
    }

    public javax.swing.JButton getPreviousPage() {
        return previousPage;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setOfferListTableModel(com.jurismarches.vradi.ui.offer.models.OfferListTableModel newValue) {
        com.jurismarches.vradi.ui.offer.models.OfferListTableModel oldValue = this.offerListTableModel;
        this.offerListTableModel = newValue;
        firePropertyChange(PROPERTY_OFFER_LIST_TABLE_MODEL, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.HBox get$HBox0() {
        return $HBox0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected jaxx.runtime.swing.HBox get$HBox1() {
        return $HBox1;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected jaxx.runtime.swing.HBox get$HBox2() {
        return $HBox2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createFormNbLabel() {
        $objectMap.put("formNbLabel", formNbLabel = new javax.swing.JLabel());
        
        formNbLabel.setName("formNbLabel");
    }

    protected void createFormsByPageComboBox() {
        $objectMap.put("formsByPageComboBox", formsByPageComboBox = new javax.swing.JComboBox());
        
        formsByPageComboBox.setName("formsByPageComboBox");
        formsByPageComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__formsByPageComboBox"));
    }

    protected void createNextPage() {
        $objectMap.put("nextPage", nextPage = new javax.swing.JButton());
        
        nextPage.setName("nextPage");
        nextPage.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__nextPage"));
    }

    protected void createOfferListTableModel() {
        $objectMap.put("offerListTableModel", offerListTableModel = getContextValue(OfferListTableModel.class));
    }

    protected void createPageNumber() {
        $objectMap.put("pageNumber", pageNumber = new javax.swing.JLabel());
        
        pageNumber.setName("pageNumber");
    }

    protected void createPageWanted() {
        $objectMap.put("pageWanted", pageWanted = new javax.swing.JFormattedTextField(new UIHelper.NumberFormatterFactory()));
        
        pageWanted.setName("pageWanted");
        pageWanted.setColumns(15);
        pageWanted.setColumns(3);
    }

    protected void createPreviousPage() {
        $objectMap.put("previousPage", previousPage = new javax.swing.JButton());
        
        previousPage.setName("previousPage");
        previousPage.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__previousPage"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $JPanel0
        add($HBox0, BorderLayout.WEST);
        add($HBox1, BorderLayout.CENTER);
        add($HBox2, BorderLayout.EAST);
        // inline complete setup of $HBox0
        $HBox0.add(formNbLabel);
        $HBox0.add($JLabel0);
        // inline complete setup of $HBox1
        $HBox1.add($JLabel1);
        $HBox1.add(formsByPageComboBox);
        // inline complete setup of $HBox2
        $HBox2.add(previousPage);
        $HBox2.add(pageWanted);
        $HBox2.add(pageNumber);
        $HBox2.add(nextPage);
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 9 property setters
        $HBox0.setVerticalAlignment(SwingConstants.CENTER);
        $HBox1.setHorizontalAlignment(SwingConstants.CENTER);
        $HBox1.setVerticalAlignment(SwingConstants.CENTER);
        formsByPageComboBox.setModel(new DefaultComboBoxModel(new Object[]{10,20,50,100,1000,-1}));
        formsByPageComboBox.setRenderer(getVradiContext().getContextValue(NumberListCellRenderer.class));
        $HBox2.setVerticalAlignment(SwingConstants.CENTER);
        previousPage.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("arrowLeft"));
        nextPage.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("arrowRight"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$JPanel0", this);
        createOfferListTableModel();
        // inline creation of $HBox0
        $objectMap.put("$HBox0", $HBox0 = new jaxx.runtime.swing.HBox());
        
        $HBox0.setName("$HBox0");
        createFormNbLabel();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.forms.returned"));
        // inline creation of $HBox1
        $objectMap.put("$HBox1", $HBox1 = new jaxx.runtime.swing.HBox());
        
        $HBox1.setName("$HBox1");
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.forms.shown"));
        createFormsByPageComboBox();
        // inline creation of $HBox2
        $objectMap.put("$HBox2", $HBox2 = new jaxx.runtime.swing.HBox());
        
        $HBox2.setName("$HBox2");
        createPreviousPage();
        createPageWanted();
        createPageNumber();
        createNextPage();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        // registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FORM_NB_LABEL_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (offerListTableModel != null) {
                    offerListTableModel.addPropertyChangeListener("totalFoundFormNb", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (offerListTableModel != null) {
                    formNbLabel.setText(_(getStringValue(offerListTableModel.getTotalFoundFormNb())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (offerListTableModel != null) {
                    offerListTableModel.removePropertyChangeListener("totalFoundFormNb", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PREVIOUS_PAGE_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (offerListTableModel != null) {
                    offerListTableModel.addPropertyChangeListener("pageToShow", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (offerListTableModel != null) {
                    previousPage.setVisible(offerListTableModel.getPageToShow() > 1);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (offerListTableModel != null) {
                    offerListTableModel.removePropertyChangeListener("pageToShow", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PAGE_WANTED_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (offerListTableModel != null) {
                    offerListTableModel.addPropertyChangeListener("pageToShow", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (offerListTableModel != null) {
                    jaxx.runtime.SwingUtil.setText(pageWanted, getStringValue(offerListTableModel.getPageToShow()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (offerListTableModel != null) {
                    offerListTableModel.removePropertyChangeListener("pageToShow", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PAGE_NUMBER_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (offerListTableModel != null) {
                    offerListTableModel.addPropertyChangeListener("nbPagesAsText", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (offerListTableModel != null) {
                    pageNumber.setText(_(getStringValue(offerListTableModel.getNbPagesAsText())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (offerListTableModel != null) {
                    offerListTableModel.removePropertyChangeListener("nbPagesAsText", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NEXT_PAGE_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (offerListTableModel != null) {
                    offerListTableModel.addPropertyChangeListener("lastPage", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (offerListTableModel != null) {
                    nextPage.setVisible(!offerListTableModel.isLastPage());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (offerListTableModel != null) {
                    offerListTableModel.removePropertyChangeListener("lastPage", this);
                }
            }
        });
    }

}