/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.offer.widgets;

import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.offer.widgets.AttachmentFileHandler;
import com.jurismarches.vradi.ui.offer.widgets.MultipleSelectionHandler;
import com.jurismarches.vradi.ui.offer.widgets.MultipleSelectionPane;
import java.awt.Desktop;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class EmbeddedFileHandler
extends MultipleSelectionHandler {
    private static final Log log = LogFactory.getLog(AttachmentFileHandler.class);

    public EmbeddedFileHandler(MultipleSelectionPane ui) {
        super(ui);
        ui.setLbl(I18n._("vradi.offerEdit.embeddedfile"));
    }

    @Override
    public void init() {
        Set<String> files = this.getBean().getFiles();
        this.fillList(files);
    }

    @Override
    public void add() {
        File file = this.getHandler().addEmbeddedFile(this.ui, this.getBean());
        if (file != null) {
            this.addToList(file, file.getName());
        }
    }

    @Override
    public void remove() {
        List<String> filesNames = this.getHandler().removeEmbeddedFile(this.getBean(), this.getSelectedInList());
        this.removeFromList(filesNames);
    }

    @Override
    public void openSelected(String selected) {
        try {
            File file = VradiService.getFileService().downloadFormEmbeddedFile(selected, this.getBean().getWikittyId());
            Desktop.getDesktop().open(file);
        }
        catch (Exception eee) {
            log.error((Object)("Error on download file : " + selected), (Throwable)eee);
            this.getHandler().fileNotFound(selected);
        }
    }
}

