/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.email;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.beans.FormPagedResult;
import com.jurismarches.vradi.beans.SendingHelper;
import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.Session;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.services.VradiDataService;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.ui.email.EmailContentUI;
import com.jurismarches.vradi.ui.email.EmailPopupUI;
import com.jurismarches.vradi.ui.email.QueryMakerViewUI;
import com.jurismarches.vradi.ui.email.SendingViewUI;
import com.jurismarches.vradi.ui.email.SessionViewUI;
import com.jurismarches.vradi.ui.email.helpers.EmailBeanConstant;
import com.jurismarches.vradi.ui.email.helpers.EmailDataHelper;
import com.jurismarches.vradi.ui.email.helpers.EmailNavigationTreeHelper;
import com.jurismarches.vradi.ui.email.helpers.SendingViewManager;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.OfferListHandler;
import com.jurismarches.vradi.ui.offer.models.OfferListTableModel;
import com.jurismarches.vradi.ui.task.AbstractProgressBarUI;
import com.jurismarches.vradi.ui.task.VradiTask;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.lang.reflect.Constructor;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.CardLayout2;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.nav.NavNode;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyProxy;

public class EmailHandler {
    private static final Log log = LogFactory.getLog(EmailHandler.class);

    public EmailPopupUI init(JAXXContext rootContext) {
        EmailPopupUI ui = (EmailPopupUI)VradiContext.EMAIL_UI_ENTRY_DEF.getContextValue(rootContext);
        if (ui == null) {
            JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext).add((Object)this);
            ui = new EmailPopupUI((JAXXContext)context);
            UIHelper.registerComponentToSaveDispositionConfig(ui);
            VradiContext.EMAIL_UI_ENTRY_DEF.setContextValue(rootContext, (Object)ui);
        }
        return ui;
    }

    public EmailPopupUI getUI(JAXXContext context) {
        if (context instanceof EmailPopupUI) {
            return (EmailPopupUI)context;
        }
        EmailPopupUI ui = (EmailPopupUI)VradiContext.EMAIL_UI_ENTRY_DEF.getContextValue(context);
        return ui;
    }

    public SessionViewUI getSessionsListUI(JAXXContext context) {
        if (context instanceof SessionViewUI) {
            return (SessionViewUI)context;
        }
        return (SessionViewUI)context.getContextValue(SessionViewUI.class);
    }

    public SendingViewUI getSessionViewUI(JAXXContext context) {
        if (context instanceof SendingViewUI) {
            return (SendingViewUI)context;
        }
        return (SendingViewUI)context.getContextValue(SendingViewUI.class);
    }

    public VradiStorageService getStorageService() {
        return VradiService.getVradiStorageService();
    }

    public VradiDataService getDataService() {
        return VradiService.getVradiDataService();
    }

    public WikittyProxy getProxy() {
        return VradiService.getWikittyProxy();
    }

    protected void close(JAXXContext context) {
        EmailPopupUI ui = this.getUI(context);
        UIHelper.saveComponentDispositionConfig();
        ui.setVisible(false);
        ui.dispose();
    }

    public List<Session> getSessions(Date date) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getSessions for date : " + date));
        }
        List sessions = null;
        try {
            sessions = this.getDataService().getSessions(date);
        }
        catch (VradiException eee) {
            log.error((Object)eee);
            ErrorDialogUI.showError((Exception)((Object)eee));
        }
        return sessions;
    }

    public void createNewSession(EmailPopupUI ui) {
        try {
            Session session = this.getStorageService().createNewSession();
            EmailNavigationTreeHelper helper = ui.getHelper();
            VradiTreeNode node = helper.createSessionNode(session);
            helper.selectNode((NavNode)node);
        }
        catch (VradiException ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't create new session", (Throwable)ex);
            }
            JOptionPane.showMessageDialog(ui, I18n._((String)"Can't create new session for reason : %s", (Object[])new Object[]{ex.getMessage()}), I18n._((String)"Can't create new session"), 0);
        }
    }

    public void bindEmailsWithForms(final EmailPopupUI ui) {
        VradiTask<Void> task = new VradiTask<Void>((JAXXContext)ui){

            @Override
            public Void doAction() throws Exception {
                try {
                    Session selectedSession = ui.getHelper().getSelectedActiveSession();
                    if (!VradiConstants.SessionStatus.isActive((Session)selectedSession)) {
                        JOptionPane.showMessageDialog(ui, I18n._((String)"vradi.error.session.bindNonActiveSession"), I18n._((String)"vradi.error.session.bindNonActiveSession.title"), 0);
                        return null;
                    }
                    EmailHandler.this.getStorageService().bindForms(selectedSession);
                }
                catch (WikittyException eee) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"An exception occured while binding form", (Throwable)eee);
                    }
                    JOptionPane.showMessageDialog(ui, I18n._((String)"vradi.binding.forms.concurrence.message"));
                }
                return null;
            }
        };
        task.execute();
    }

    protected void openUI(JAXXContext context, CardLayout2 contentLayout, JPanel content, VradiTreeNode node) {
        Class editType = node.getInternalClass();
        Class<? extends EmailContentUI> uiClass = EmailBeanConstant.getUIClass(editType);
        if (uiClass == null) {
            contentLayout.show((Container)content, "none");
            return;
        }
        EmailContentUI ui = UIHelper.getContentIfExist(contentLayout, content, uiClass);
        String contentName = editType.getName();
        if (ui == null) {
            try {
                Constructor<? extends EmailContentUI> constructor = uiClass.getConstructor(JAXXContext.class);
                ui = constructor.newInstance(context);
                ui.openUI(node);
            }
            catch (Exception eee) {
                log.error((Object)eee);
                ErrorDialogUI.showError((Exception)eee);
            }
            content.add((Component)ui, contentName);
        }
        contentLayout.show((Container)content, contentName);
    }

    public void displaySession(JAXXContext context, EmailNavigationTreeHelper helper, VradiTreeNode node) {
        SendingViewUI ui = this.getSessionViewUI(context);
        Sending sending = helper.getSendingToDisplay(node);
        Session session = helper.getSelectedActiveSession();
        SendingViewManager manager = SendingViewManager.getInstance();
        context.setContextValue((Object)manager);
        manager.openUI(ui, session, sending);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending displayed : " + sending));
        }
    }

    public boolean askToRemoveUserForm(JPanel ui, String userName, String formAsString) {
        int yes = JOptionPane.showConfirmDialog(ui, I18n._((String)"vradi.email.confirmRemoveUserForms", (Object[])new Object[]{formAsString, userName}), I18n._((String)"vradi.email.confirmRemoveUserFormsTitle"), 0);
        return yes == 0;
    }

    public boolean askToRemoveAllForm(JPanel ui, String formAsString) {
        int yes = JOptionPane.showConfirmDialog(ui, I18n._((String)"vradi.email.confirmRemoveForms", (Object[])new Object[]{formAsString}), I18n._((String)"vradi.email.confirmRemoveFormsTitle"), 0);
        return yes == 0;
    }

    public void revertDeletion(SendingViewUI ui, final Sending sending, final List<String> formsIdsToUpdate) {
        int yes = JOptionPane.showConfirmDialog(ui, I18n._((String)"vradi.email.confirmRevertFormDeletion", (Object[])new Object[]{EmailDataHelper.convertFormsIdsToString(formsIdsToUpdate)}), I18n._((String)"vradi.email.confirmRevertFormDeletionTitle"), 0);
        if (yes == 0) {
            VradiTask<Void> revertSendingTask = new VradiTask<Void>((JAXXContext)ui){

                @Override
                public Void doAction() throws Exception {
                    VradiService.getVradiStorageService().revertDeletion(sending.getWikittyId(), formsIdsToUpdate);
                    return null;
                }
            };
            revertSendingTask.execute();
        }
    }

    public void revertUserDeletion(QueryMakerViewUI<?> ui, Session session, String formId, Object[] selectedValues) {
        if (this.askUserRevert(ui, EmailDataHelper.convertFormToString(formId), EmailDataHelper.convertObjectBeanToString(Arrays.asList(selectedValues), User.class))) {
            for (Object o : selectedValues) {
                this.revertUserDeletion(ui, session, (User)o, formId, false);
            }
        }
    }

    public void revertUserDeletion(QueryMakerViewUI<?> ui, Session session, User user, String formToRevert) {
        this.revertUserDeletion(ui, session, user, formToRevert, true);
    }

    protected void revertUserDeletion(QueryMakerViewUI<?> ui, final Session session, final User user, final String formToRevert, boolean ask) {
        if (!ask || this.askUserRevert(ui, EmailDataHelper.convertFormToString(formToRevert), VradiHelper.getEntityName(user))) {
            VradiTask<Void> revertSendingTask = new VradiTask<Void>(ui){

                @Override
                public Void doAction() throws Exception {
                    VradiService.getVradiStorageService().revertUserDeletion(session.getWikittyId(), user.getWikittyId(), formToRevert);
                    return null;
                }
            };
            revertSendingTask.execute();
        }
    }

    public void revertGroupDeletion(QueryMakerViewUI<?> ui, Session session, String formId, Object[] selectedValues) {
        if (this.askGroupRevert(ui, EmailDataHelper.convertFormToString(formId), EmailDataHelper.convertObjectBeanToString(Arrays.asList(selectedValues), Group.class))) {
            for (Object o : selectedValues) {
                this.revertGroupDeletion(ui, session, (Group)o, formId, false);
            }
        }
    }

    public void revertGroupDeletion(QueryMakerViewUI<?> ui, Session session, Group group, String formToRevert) {
        this.revertGroupDeletion(ui, session, group, formToRevert, true);
    }

    protected void revertGroupDeletion(QueryMakerViewUI<?> ui, final Session session, final Group group, final String formToRevert, boolean ask) {
        if (!ask || this.askGroupRevert(ui, EmailDataHelper.convertFormToString(formToRevert), VradiHelper.getEntityName(group))) {
            VradiTask<Void> revertSendingTask = new VradiTask<Void>(ui){

                @Override
                public Void doAction() throws Exception {
                    VradiService.getVradiStorageService().revertGroupDeletion(session.getWikittyId(), group.getWikittyId(), formToRevert);
                    return null;
                }
            };
            revertSendingTask.execute();
        }
    }

    protected boolean askUserRevert(JPanel ui, String formAsString, String userAsString) {
        int yes = JOptionPane.showConfirmDialog(ui, I18n._((String)"vradi.email.confirmRevertUserFormDeletion", (Object[])new Object[]{formAsString, userAsString}), I18n._((String)"vradi.email.confirmRevertUserFormDeletionTitle"), 0);
        return yes == 0;
    }

    protected boolean askGroupRevert(JPanel ui, String formAsString, String userAsString) {
        int yes = JOptionPane.showConfirmDialog(ui, I18n._((String)"vradi.email.confirmRevertGroupFormDeletion", (Object[])new Object[]{formAsString, userAsString}), I18n._((String)"vradi.email.confirmRevertGroupFormDeletionTitle"), 0);
        return yes == 0;
    }

    public void selectOffer(JAXXContext context, JTable listTable) {
        OfferListTableModel tableModel = (OfferListTableModel)listTable.getModel();
        int selectedRow = listTable.getSelectedRow();
        if (selectedRow >= 0 && selectedRow < tableModel.getRowCount()) {
            selectedRow = listTable.convertRowIndexToModel(selectedRow);
            FormPagedResult formPageDTO = tableModel.getFormPagedResult();
            List formsToShow = formPageDTO.getFormsIdsToShow();
            String id = (String)formsToShow.get(selectedRow);
            if (id != null) {
                UIHelper.getHandler(context, OfferListHandler.class).addEditPane(context, id);
            }
        }
    }

    public void displayForm(JAXXContext context, VradiTreeNode node) {
        Session session = EmailNavigationTreeHelper.getParentSession(node);
        if (session != null) {
            context.setContextValue((Object)session);
        }
        String id = node.getId();
        Form form = (Form)this.getProxy().restore(Form.class, id);
        context.setContextValue((Object)form);
    }

    public void addAllUserSending(QueryMakerViewUI ui, Session session, String formId, List values) {
        if (this.askToAddUsers((JAXXContext)ui, EmailDataHelper.convertFormToString(formId), EmailDataHelper.convertObjectBeanToString(values, User.class))) {
            for (Object selected : values) {
                this.addUserSending((JAXXContext)ui, session, formId, selected, false);
            }
        }
    }

    public void addAllUserSending(QueryMakerViewUI ui, Session session, List<String> formsIds, List values) {
        if (this.askToAddUsers((JAXXContext)ui, EmailDataHelper.convertFormsIdsToString(formsIds), EmailDataHelper.convertObjectBeanToString(values, User.class))) {
            for (Object selected : values) {
                this.addUserSending((JAXXContext)ui, session, formsIds, selected, false);
            }
        }
    }

    public void addUserSending(JAXXContext context, Session session, List<String> formsId, Object selected) {
        this.addUserSending(context, session, formsId, selected, true);
    }

    protected void addUserSending(JAXXContext context, final Session session, final List<String> formsIds, final Object selected, boolean ask) {
        User user = (User)selected;
        if (!ask || this.askToAddUsers(context, EmailDataHelper.convertFormsIdsToString(formsIds), VradiHelper.getEntityName(user))) {
            VradiTask<Void> createSendingTask = new VradiTask<Void>(context){

                @Override
                public Void doAction() throws Exception {
                    EmailHandler.this.getStorageService().createSending(session.getWikittyId(), (User)selected, formsIds);
                    return null;
                }
            };
            createSendingTask.execute();
        }
    }

    public void addUserSending(JAXXContext context, Session session, String formId, Object selected) {
        this.addUserSending(context, session, formId, selected, true);
    }

    protected void addUserSending(JAXXContext context, Session session, String formId, Object selected, boolean ask) {
        User user = (User)selected;
        if (!ask || this.askToAddUsers(context, EmailDataHelper.convertFormToString(formId), VradiHelper.getEntityName(user))) {
            ArrayList<String> formsIds = new ArrayList<String>();
            formsIds.add(formId);
            this.addUserSending(context, session, formsIds, (Object)user, false);
        }
    }

    protected boolean askToAddUsers(JAXXContext context, String formAsString, String userAsString) {
        if (StringUtils.isEmpty((String)userAsString)) {
            return true;
        }
        int yes = JOptionPane.showConfirmDialog((Component)context, I18n._((String)"vradi.email.confirmAddUser", (Object[])new Object[]{formAsString, userAsString}), I18n._((String)"vradi.email.confirmAddTitle"), 0);
        return yes == 0;
    }

    public void removeUserSending(JAXXContext context, Session session, List<String> formsIds, Object[] selecteds) {
        this.removeUserSending(context, session, formsIds, selecteds, true);
    }

    public void removeUserSending(JAXXContext context, final Session session, final List<String> formsIds, final Object[] selecteds, boolean ask) {
        int yes = 0;
        if (ask) {
            yes = JOptionPane.showConfirmDialog((Component)context, I18n._((String)"vradi.email.confirmDelete", (Object[])new Object[]{EmailDataHelper.convertFormsIdsToString(formsIds)}), I18n._((String)"vradi.email.confirmDeleteTitle"), 0);
        }
        if (yes == 0) {
            VradiTask<Void> removeSendingTask = new VradiTask<Void>(context){

                @Override
                public Void doAction() throws Exception {
                    for (Object selected : selecteds) {
                        EmailHandler.this.getStorageService().removeSending(session.getWikittyId(), formsIds, (User)selected);
                    }
                    return null;
                }
            };
            removeSendingTask.execute();
        }
    }

    public void removeUserSending(JAXXContext context, Session session, String formId, Object[] selecteds) {
        this.removeUserSending(context, session, formId, selecteds, true);
    }

    protected void removeUserSending(JAXXContext context, Session session, String formId, Object[] selecteds, boolean ask) {
        ArrayList<String> formsIds = new ArrayList<String>();
        formsIds.add(formId);
        this.removeUserSending(context, session, formsIds, selecteds, ask);
    }

    public void addAllGroupSending(JAXXContext context, Session session, String formId, List values) {
        if (this.askToAddGroups(context, EmailDataHelper.convertFormToString(formId), EmailDataHelper.convertObjectBeanToString(values, Group.class))) {
            for (Object selected : values) {
                this.addGroupSending(context, session, formId, selected, false);
            }
        }
    }

    public void addAllGroupSending(JAXXContext context, Session session, List<String> beanList, List values) {
        if (this.askToAddGroups(context, EmailDataHelper.convertFormsIdsToString(beanList), EmailDataHelper.convertObjectBeanToString(values, Group.class))) {
            for (Object selected : values) {
                this.addGroupSending(context, session, beanList, selected, false);
            }
        }
    }

    protected void addGroupSending(JAXXContext context, Session session, List<String> formsIds, Object selected) {
        this.addGroupSending(context, session, formsIds, selected, true);
    }

    protected void addGroupSending(JAXXContext context, final Session session, final List<String> formsIds, Object selected, boolean ask) {
        final Group group = (Group)selected;
        if (!ask || this.askToAddGroups(context, EmailDataHelper.convertFormsIdsToString(formsIds), VradiHelper.getEntityName(group))) {
            VradiTask<Void> createSendingTask = new VradiTask<Void>(context){

                @Override
                public Void doAction() throws Exception {
                    EmailHandler.this.getStorageService().createAllSending(session.getWikittyId(), group, formsIds);
                    return null;
                }
            };
            createSendingTask.execute();
        }
    }

    public void addGroupSending(JAXXContext context, Session session, String formId, Object selected) {
        this.addGroupSending(context, session, formId, selected, true);
    }

    public void addGroupSending(JAXXContext context, Session session, String formId, Object selected, boolean ask) {
        ArrayList<String> formsIds = new ArrayList<String>();
        formsIds.add(formId);
        this.addGroupSending(context, session, formsIds, selected, ask);
    }

    protected boolean askToAddGroups(JAXXContext context, String formAsString, String groupAsString) {
        if (StringUtils.isEmpty((String)groupAsString)) {
            return true;
        }
        int yes = JOptionPane.showConfirmDialog((Component)context, I18n._((String)"vradi.email.confirmAddGroup", (Object[])new Object[]{formAsString, groupAsString}), I18n._((String)"vradi.email.confirmAddTitle"), 0);
        return yes == 0;
    }

    public void removeGroupSending(JAXXContext context, final Session session, final List<String> formsIds, final Object[] selecteds) {
        int yes = JOptionPane.showConfirmDialog((Component)context, I18n._((String)"vradi.email.confirmDelete", (Object[])new Object[]{EmailDataHelper.convertFormsIdsToString(formsIds)}), I18n._((String)"vradi.email.confirmDeleteTitle"), 0);
        if (yes == 0) {
            VradiTask<Void> removeAllSendingTask = new VradiTask<Void>(context){

                @Override
                public Void doAction() throws Exception {
                    for (Object selected : selecteds) {
                        EmailHandler.this.getStorageService().removeAllSending(session.getWikittyId(), formsIds, (Group)selected);
                    }
                    return null;
                }
            };
            removeAllSendingTask.execute();
        }
    }

    public void removeGroupSending(JAXXContext context, Session session, String formId, Object[] selecteds) {
        ArrayList<String> formsIds = new ArrayList<String>();
        formsIds.add(formId);
        this.removeGroupSending(context, session, formsIds, selecteds);
    }

    protected void reloadTree(EmailPopupUI ui) {
        EmailNavigationTreeHelper helper = ui.getHelper();
        TreePath[] selectionPaths = helper.getSelectionModel().getSelectionPaths();
        ui.updateTree();
        if (selectionPaths != null) {
            helper.getSelectionModel().setSelectionPaths(selectionPaths);
        }
    }

    public void sendSending(SendingViewUI ui, final Sending sending) {
        Object[] options = new Object[]{I18n._((String)"vradi.email.confirmSendSending.optionYes"), I18n._((String)"vradi.email.confirmSendSending.optionNo"), I18n._((String)"vradi.email.confirmSendSending.optionOtherMail")};
        int i = JOptionPane.showOptionDialog(ui, I18n._((String)"vradi.email.confirmSendSending", (Object[])new Object[]{this.getUserName(sending)}), I18n._((String)"vradi.email.confirmSendSendingTitle"), 1, 3, null, options, options[2]);
        String email = null;
        if (i == 2) {
            email = JOptionPane.showInputDialog(ui, I18n._((String)"vradi.email.confirmSendSending.askMail"), I18n._((String)"vradi.email.confirmSendSending.askMailTitle"), -1);
            i = 0;
        }
        if (i == 0) {
            Session session = this.getSessionBySending(sending.getWikittyId());
            final String sessionParagraph = session.getParagraph();
            final String finalEmail = email;
            final EmailPopupUI finalUI = ui.getParentContainer(EmailPopupUI.class);
            VradiTask<Void> sendSendingTask = new VradiTask<Void>((JAXXContext)ui, "vradi.email.sendSending"){

                @Override
                public Void doAction() throws VradiException {
                    try {
                        String sendingLogs = EmailHandler.this.getStorageService().sendMessage(sending.getWikittyId(), sessionParagraph, finalEmail);
                        if (sendingLogs != null && !sendingLogs.isEmpty()) {
                            JOptionPane.showMessageDialog(finalUI, I18n._((String)"vradi.error.sending.sendDialogError", (Object[])new Object[]{sendingLogs}), I18n._((String)"vradi.error.sending.sendDialogError.title"), 0);
                        }
                    }
                    catch (VradiException eee) {
                        JOptionPane.showMessageDialog(finalUI, I18n._((String)"vradi.email.sendSending.sendError", (Object[])new Object[]{eee.getMessage()}), I18n._((String)"vradi.email.sendSession.error"), 0);
                    }
                    return null;
                }

                @Override
                public void doWhenError(Exception eee) {
                }
            };
            sendSendingTask.execute();
        }
    }

    public boolean send(final EmailPopupUI ui) {
        final Session session = ui.getHelper().getSelectedActiveSession();
        int confirm = JOptionPane.showConfirmDialog(ui, I18n._((String)"vradi.email.confirmSendSession"), I18n._((String)"vradi.email.confirmSendSessionTitle"), 0, 3);
        if (confirm != 0) {
            return false;
        }
        if (!this.checkAllSending(ui, session)) {
            return false;
        }
        AbstractProgressBarUI pb = new AbstractProgressBarUI((JAXXContext)ui){
            private static final long serialVersionUID = 5926558779822425487L;

            @Override
            public void cancel() {
                try {
                    VradiService.getVradiStorageService().stopSentMail(session);
                    this.dispose();
                }
                catch (VradiException eee) {
                    log.info((Object)"Cant stop sending emails : ", (Throwable)eee);
                    ErrorDialogUI.showError((Exception)((Object)eee));
                }
                ui.setCursor(Cursor.getPredefinedCursor(0));
            }
        };
        if (log.isInfoEnabled()) {
            SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy");
            log.info((Object)("Sending session : " + session.getNum() + " - " + format.format(session.getSessionDate()) + " status : " + VradiConstants.SessionStatus.getStatus((int)session.getStatus()).getDescription()));
        }
        VradiTask<Boolean> pdfGenerationAndSendingTask = new VradiTask<Boolean>((JAXXContext)ui, pb, I18n.n_((String)"vradi.email.generation")){

            @Override
            public Boolean doAction() throws Exception {
                try {
                    VradiService.getVradiStorageService().generatePDFForSession(session.getWikittyId());
                }
                catch (Exception eee) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Error generating pdf : ", (Throwable)eee);
                    }
                    this.doWhenError(eee);
                    ErrorDialogUI.showError((Exception)eee);
                    return false;
                }
                return true;
            }

            @Override
            public void doWhenDone() throws Exception {
                Boolean result = (Boolean)this.get();
                if (result != null && result.booleanValue()) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Start sending mails");
                    }
                    VradiTask<Void> sentTask = new VradiTask<Void>((JAXXContext)ui, this.pb, I18n.n_((String)"vradi.email.sendSession")){

                        @Override
                        public Void doAction() throws Exception {
                            try {
                                String sessionLogs = VradiService.getVradiStorageService().sendMessages(session.getWikittyId());
                                if (!sessionLogs.isEmpty()) {
                                    JOptionPane.showMessageDialog(ui, I18n._((String)"vradi.error.session.sendDialogError", (Object[])new Object[]{sessionLogs}), I18n._((String)"vradi.error.session.sendDialogError.title"), 0);
                                }
                            }
                            catch (VradiException eee) {
                                log.error((Object)"Failed to send message : ", (Throwable)eee);
                                JOptionPane.showMessageDialog(ui, I18n._((String)"vradi.email.sendSending.sendError", (Object[])new Object[]{eee.getMessage()}), I18n._((String)"vradi.email.sendSession.error"), 0);
                            }
                            return null;
                        }

                        @Override
                        public void doWhenError(Exception eee) {
                        }
                    };
                    sentTask.execute();
                }
            }

            @Override
            public void doWhenError(Exception eee) {
            }
        };
        pdfGenerationAndSendingTask.execute();
        return true;
    }

    protected boolean checkAllSending(EmailPopupUI ui, Session session) {
        for (Sending sending : EmailDataHelper.getAllSending(session)) {
            Set formIds;
            boolean emailEmpty = VradiService.getVradiDataService().checkUserEmail(sending);
            if (emailEmpty) {
                User user = (User)VradiService.getWikittyProxy().restore(User.class, sending.getUser());
                Client client = (Client)VradiService.getWikittyProxy().restore(Client.class, user.getClient());
                boolean abord = this.askAbordSending(ui, I18n._((String)"vradi.email.askUserEmailEmpty", (Object[])new Object[]{user.getName(), client.getName()}));
                if (abord) {
                    this.updateSendingStatus(sending, VradiConstants.SendingStatus.ERROR);
                    return false;
                }
            }
            if ((formIds = SendingHelper.extractForms((WikittyProxy)VradiService.getWikittyProxy(), (Collection)sending.getGroupForms())) == null) {
                return true;
            }
            List forms = this.getProxy().restore(Form.class, new ArrayList(formIds));
            ArrayList<String> alreadyAskFormType = new ArrayList<String>();
            for (Form form : forms) {
                String extensionName = null;
                for (String ext : form.getExtensionNames()) {
                    if (ext.equals("Infogene") || ext.equals("Form")) continue;
                    extensionName = ext;
                    break;
                }
                boolean isTemplateExist = false;
                try {
                    isTemplateExist = VradiService.getVradiStorageService().checkTemplateExist(extensionName);
                }
                catch (VradiException eee) {
                    log.error((Object)"Cant check if template exist : ", (Throwable)eee);
                    ErrorDialogUI.showError((Exception)((Object)eee));
                }
                if (isTemplateExist || alreadyAskFormType.contains(extensionName)) continue;
                boolean abord = this.askAbordSending(ui, I18n._((String)"vradi.email.askModelEmpty", (Object[])new Object[]{extensionName}));
                if (abord) {
                    this.updateSendingStatus(sending, VradiConstants.SendingStatus.ERROR);
                    return false;
                }
                alreadyAskFormType.add(extensionName);
            }
        }
        return true;
    }

    protected boolean askAbordSending(EmailPopupUI ui, String msg) {
        int i = JOptionPane.showConfirmDialog(ui, msg, I18n._((String)"vradi.email.askAbordSendingTitle"), 0);
        return i != 0;
    }

    public Sending updateSendingStatus(Sending sending, VradiConstants.SendingStatus status) {
        if (sending == null) {
            return null;
        }
        Sending sendingRestored = (Sending)this.getProxy().restore(Sending.class, sending.getWikittyId());
        sendingRestored.setStatus(status.getValue());
        log.info((Object)("Saving sending " + sendingRestored.getWikittyId() + " with status " + status.getDescription()));
        return (Sending)this.getProxy().store((BusinessEntity)sendingRestored);
    }

    protected String getUserName(Sending sending) {
        try {
            String userId = sending.getUser();
            return ((User)this.getProxy().restore(User.class, userId)).getName();
        }
        catch (Exception eee) {
            log.error((Object)"Cant get sending user name : ", (Throwable)eee);
            ErrorDialogUI.showError((Exception)eee);
            return null;
        }
    }

    public void deleteSession(EmailPopupUI ui) {
        int i;
        Session session = ui.getHelper().getSessionSelected();
        if (session != null && (i = JOptionPane.showConfirmDialog(ui, I18n._((String)"vradi.email.confimCloseSession"), I18n._((String)"vradi.email.confimCloseSession.titles"), 0)) == 0) {
            try {
                VradiService.getVradiStorageService().deleteSession(session.getWikittyId());
            }
            catch (VradiException eee) {
                log.error((Object)"Cant delete session : ", (Throwable)eee);
                ErrorDialogUI.showError((Exception)((Object)eee));
            }
        }
    }

    public void updateReceptionProof(Sending sending, boolean isSelected) {
        sending.setReceptionProof(isSelected);
        this.getProxy().store((BusinessEntity)sending);
    }

    public void updateParagraph(Sending sending, String text) {
        sending.setParagraph(text);
        this.getProxy().store((BusinessEntity)sending);
    }

    protected Sending getSendingForUser(Session session, String userId) {
        List<Sending> sendings = EmailDataHelper.getAllSending(session);
        for (Sending sending : sendings) {
            if (sending == null || !sending.getUser().equals(userId)) continue;
            return sending;
        }
        return null;
    }

    protected Session getSessionBySending(String sendingId) {
        return VradiService.getVradiDataService().getSessionBySending(sendingId);
    }

    protected List<String> getStringAsList(String s) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(s);
        return result;
    }
}

