/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.popups;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.popups.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.renderers.ThesaurusHighlighter;
import com.jurismarches.vradi.ui.thesaurus.helpers.ThesaurusTreeTableHelper;
import com.jurismarches.vradi.ui.tree.VradiTreeTableNode;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.JAXXTree;
import jaxx.runtime.swing.JAXXTree.JAXXTreeModel;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.decorator.*;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class ThesaurusPathChooserUI extends javax.swing.JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_SAVED = "saved";
    public static final String PROPERTY_SELECTED = "selected";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_SELECT_ENABLED = "select.enabled";
    public static final String BINDING_THESAURUS_TREE_TABLE_MODEL = "thesaurus.treeTableModel";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.popups.ThesaurusPathChooserUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JButton cancel;
    protected java.lang.Boolean saved;
    protected javax.swing.JButton select;
    protected java.lang.Boolean selected;
    protected org.jdesktop.swingx.JXTreeTable thesaurus;
    protected ThesaurusPathChooserUI thesaurusPathChooserUI = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected ThesaurusTreeTableHelper helper;
    
    
    public  ThesaurusPathChooserUI(jaxx.runtime.JAXXContext parentContext, ThesaurusTreeTableHelper helper) {
        jaxx.runtime.SwingUtil.initContext(this, parentContext);
        this.helper = helper;
    $initialize();
    }
    
    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    protected ThesaurusTreeTableHelper getHelper() {
        return helper;
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
        thesaurus.putClientProperty("JTree.lineStyle", "Angled");
    
        TreeSelectionListener listener = new TreeSelectionListener(){
    
            @Override
            public void valueChanged(TreeSelectionEvent e) {
    
                // Get selcted node
                VradiTreeTableNode selectedNode = helper.getSelectedNode();
    
                // Set as selected
                setSelected(selectedNode != null);
            }
        };
    
        // Register tree table
        helper.setUI(thesaurus, true, false, listener);
        
        UIHelper.addThesaurusExpandOnClickListener(thesaurus);
    
        // Render
        thesaurus.setTreeCellRenderer(new ThesaurusHighlighter(ThesaurusHighlighter.HighlighterType.MOVE));
    
        this.pack();
    
        // Register for save disposition
        UIHelper.registerComponentToSaveDispositionConfig(this);
    }
        
    protected void close(){
        UIHelper.saveComponentDispositionConfig();
        setVisible(false);
        dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ThesaurusPathChooserUI() {
        $initialize();
    }

    public ThesaurusPathChooserUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(java.awt.event.ActionEvent event) {
        close();
    }

    public void doActionPerformed__on__select(java.awt.event.ActionEvent event) {
        setSaved(true);close();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JButton getCancel() {
        return cancel;
    }

    public java.lang.Boolean getSaved() {
        return saved;
    }

    public javax.swing.JButton getSelect() {
        return select;
    }

    public java.lang.Boolean getSelected() {
        return selected;
    }

    public org.jdesktop.swingx.JXTreeTable getThesaurus() {
        return thesaurus;
    }

    public java.lang.Boolean isSaved() {
        return saved !=null && saved;
    }

    public java.lang.Boolean isSelected() {
        return selected !=null && selected;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setSaved(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.saved;
        this.saved = newValue;
        firePropertyChange(PROPERTY_SAVED, oldValue, newValue);
    }

    public void setSelected(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.selected;
        this.selected = newValue;
        firePropertyChange(PROPERTY_SELECTED, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToThesaurusPathChooserUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0, BorderLayout.CENTER);
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new javax.swing.JButton());
        
        cancel.setName("cancel");
        cancel.setText(_("vradi.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createSaved() {
        $objectMap.put("saved", saved = false);
    }

    protected void createSelect() {
        $objectMap.put("select", select = new javax.swing.JButton());
        
        select.setName("select");
        select.setText(_("vradi.common.select"));
        select.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__select"));
    }

    protected void createSelected() {
        $objectMap.put("selected", selected = false);
    }

    protected void createThesaurus() {
        $objectMap.put("thesaurus", thesaurus = new org.jdesktop.swingx.JXTreeTable());
        
        thesaurus.setName("thesaurus");
        if (thesaurus.getFont() != null) {
            thesaurus.setFont(thesaurus.getFont().deriveFont((float) 11));
        }
        thesaurus.setRootVisible(false);
        thesaurus.setShowsRootHandles(true);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToThesaurusPathChooserUI();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.7, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(cancel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(select, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(thesaurus);
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 4 property setters
        thesaurus.setHighlighters(new ThesaurusHighlighter(ThesaurusHighlighter.HighlighterType.MOVE));
        cancel.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("cancel"));
        select.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("select"));
        // late initializer
        thesaurusPathChooserUI.pack();
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("thesaurusPathChooserUI", this);
        createSelected();
        createSaved();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminThesaurus.selectAsk"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createThesaurus();
        createCancel();
        createSelect();
        // inline creation of thesaurusPathChooserUI
        setName("thesaurusPathChooserUI");
        thesaurusPathChooserUI.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        setTitle(_("vradi.adminThesaurus.select"));
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_THESAURUS_TREE_TABLE_MODEL, true ,"helper") {
        
            @Override
            public void processDataBinding() {
                if (helper != null) {
                    thesaurus.setTreeTableModel(helper.createTreeModel());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SELECT_ENABLED, true ,"selected") {
        
            @Override
            public void processDataBinding() {
                select.setEnabled(isSelected());
            }
        });
    }

}