/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing;

import com.l2fprod.common.swing.BannerPanel;
import com.l2fprod.common.swing.LookAndFeelTweaks;
import com.l2fprod.common.swing.UIUtilities;
import com.l2fprod.common.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class BaseDialog
extends JDialog {
    public static final int OK_CANCEL_DIALOG = 0;
    public static final int CLOSE_DIALOG = 1;
    private BannerPanel banner;
    private JPanel contentPane;
    private JPanel buttonPane;
    private boolean cancelClicked;
    private JButton okButton;
    private JButton cancelOrCloseButton;
    private int mode;
    private Action okAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            BaseDialog.this.ok();
        }
    };
    private Action cancelOrCloseAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            BaseDialog.this.cancel();
        }
    };

    public BaseDialog() throws HeadlessException {
        this.buildUI();
    }

    public BaseDialog(Dialog owner) throws HeadlessException {
        super(owner);
        this.buildUI();
    }

    public BaseDialog(Dialog owner, boolean modal) throws HeadlessException {
        super(owner, modal);
        this.buildUI();
    }

    public BaseDialog(Frame owner) throws HeadlessException {
        super(owner);
        this.buildUI();
    }

    public BaseDialog(Frame owner, boolean modal) throws HeadlessException {
        super(owner, modal);
        this.buildUI();
    }

    public BaseDialog(Dialog owner, String title) throws HeadlessException {
        super(owner, title);
        this.buildUI();
    }

    public BaseDialog(Dialog owner, String title, boolean modal) throws HeadlessException {
        super(owner, title, modal);
        this.buildUI();
    }

    public BaseDialog(Frame owner, String title) throws HeadlessException {
        super(owner, title);
        this.buildUI();
    }

    public BaseDialog(Frame owner, String title, boolean modal) throws HeadlessException {
        super(owner, title, modal);
        this.buildUI();
    }

    public BaseDialog(Dialog owner, String title, boolean modal, GraphicsConfiguration gc) throws HeadlessException {
        super(owner, title, modal, gc);
        this.buildUI();
    }

    public BaseDialog(Frame owner, String title, boolean modal, GraphicsConfiguration gc) {
        super(owner, title, modal, gc);
        this.buildUI();
    }

    public final BannerPanel getBanner() {
        return this.banner;
    }

    public final Container getContentPane() {
        return this.contentPane;
    }

    public final Container getButtonPane() {
        return this.buttonPane;
    }

    public boolean ask() {
        this.setVisible(true);
        this.dispose();
        return !this.cancelClicked;
    }

    public void ok() {
        this.cancelClicked = false;
        this.setVisible(false);
    }

    public void cancel() {
        this.cancelClicked = true;
        this.setVisible(false);
    }

    public void setDialogMode(int mode) {
        if (mode != 0 && mode != 1) {
            throw new IllegalArgumentException("invalid dialog mode");
        }
        if (this.okButton != null) {
            this.buttonPane.remove(this.okButton);
            this.okButton = null;
        }
        if (this.cancelOrCloseButton != null) {
            this.buttonPane.remove(this.cancelOrCloseButton);
            this.cancelOrCloseButton = null;
        }
        switch (mode) {
            case 0: {
                this.okButton = new JButton(ResourceManager.all(BaseDialog.class).getString("ok"));
                this.okButton.addActionListener(this.okAction);
                this.buttonPane.add(this.okButton);
                this.cancelOrCloseButton = new JButton(ResourceManager.all(BaseDialog.class).getString("cancel"));
                this.cancelOrCloseButton.addActionListener(this.cancelOrCloseAction);
                this.buttonPane.add(this.cancelOrCloseButton);
                break;
            }
            case 1: {
                this.cancelOrCloseButton = new JButton(ResourceManager.all(BaseDialog.class).getString("close"));
                this.cancelOrCloseButton.addActionListener(this.cancelOrCloseAction);
                this.buttonPane.add(this.cancelOrCloseButton);
            }
        }
        this.mode = mode;
    }

    public int getDialogMode() {
        return this.mode;
    }

    public void centerOnScreen() {
        UIUtilities.centerOnScreen(this);
    }

    protected String paramString() {
        return super.paramString() + ",dialogMode=" + (this.mode == 0 ? "OK_CANCEL_DIALOG" : "CLOSE_DIALOG");
    }

    private void buildUI() {
        Container container = super.getContentPane();
        container.setLayout(new BorderLayout(0, 0));
        this.banner = new BannerPanel();
        container.add("North", this.banner);
        JPanel contentPaneAndButtons = new JPanel();
        contentPaneAndButtons.setLayout(LookAndFeelTweaks.createVerticalPercentLayout());
        contentPaneAndButtons.setBorder(LookAndFeelTweaks.WINDOW_BORDER);
        container.add("Center", contentPaneAndButtons);
        this.contentPane = new JPanel();
        LookAndFeelTweaks.setBorderLayout(this.contentPane);
        LookAndFeelTweaks.setBorder(this.contentPane);
        contentPaneAndButtons.add((Component)this.contentPane, "*");
        this.buttonPane = new JPanel();
        this.buttonPane.setLayout(LookAndFeelTweaks.createButtonAreaLayout());
        LookAndFeelTweaks.setBorder(this.buttonPane);
        contentPaneAndButtons.add(this.buttonPane);
        this.setDefaultCloseOperation(0);
        ((JComponent)container).registerKeyboardAction(this.cancelOrCloseAction, KeyStroke.getKeyStroke(27, 0), 2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                BaseDialog.this.cancel();
            }
        });
        this.setDialogMode(0);
    }
}

