/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import net.sf.saxon.Controller;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Bindery;
import net.sf.saxon.instruct.GlobalVariable;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;

public final class GlobalParam
extends GlobalVariable {
    public int getInstructionNameCode() {
        return 170;
    }

    public ValueRepresentation evaluateVariable(XPathContext xPathContext) throws XPathException {
        Controller controller = xPathContext.getController();
        Bindery bindery = controller.getBindery();
        boolean bl = bindery.useGlobalParameter(this.getVariableFingerprint(), this, xPathContext);
        ValueRepresentation valueRepresentation = bindery.getGlobalVariableValue(this);
        if (bl || valueRepresentation != null) {
            return valueRepresentation;
        }
        if (this.isRequiredParam()) {
            DynamicError dynamicError = new DynamicError("No value supplied for required parameter $" + xPathContext.getNamePool().getDisplayName(this.getVariableFingerprint()));
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setLocator(this.getSourceLocator());
            dynamicError.setErrorCode("XTDE0050");
            throw dynamicError;
        }
        try {
            bindery.setExecuting(this, true);
            ValueRepresentation valueRepresentation2 = this.getSelectValue(xPathContext);
            bindery.defineGlobalVariable(this, valueRepresentation2);
            bindery.setExecuting(this, false);
            return valueRepresentation2;
        }
        catch (XPathException xPathException) {
            bindery.setExecuting(this, false);
            if (xPathException instanceof XPathException.Circularity) {
                DynamicError dynamicError = new DynamicError("Circular definition of parameter " + this.getVariableName());
                dynamicError.setXPathContext(xPathContext);
                int n = this.getHostLanguage();
                dynamicError.setErrorCode(n == 51 ? "XQST0054" : "XTDE0640");
                this.select = new ErrorExpression(dynamicError);
                throw dynamicError;
            }
            throw xPathException;
        }
    }
}

