/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.widget.tooltip;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.MouseInputAdapter;
import org.nuiton.widget.tooltip.TipUtil;
import org.nuiton.widget.tooltip.TipWindow;

public class FocusableTip {
    protected JComponent attachedComponent;
    protected TipWindow tipWindow;
    protected URL imageBase;
    protected AttachedComponentListener attachedComponentListener;
    protected HyperlinkListener hyperlinkListener;
    protected String lastText;
    protected boolean showCopyContextMenu;
    protected int width = 320;
    protected int height = 250;
    protected Rectangle tipVisibleBounds;
    protected static final int MARGIN = 10;

    public FocusableTip(JComponent attachedComponent) {
        this(attachedComponent, null);
    }

    public FocusableTip(JComponent attachedComponent, HyperlinkListener listener) {
        this(attachedComponent, listener, false);
    }

    public FocusableTip(JComponent attachedComponent, boolean showCopyContextMenu) {
        this(attachedComponent, null, showCopyContextMenu);
    }

    public FocusableTip(JComponent attachedComponent, HyperlinkListener listener, boolean showCopyContextMenu) {
        this.setAttachedComponent(attachedComponent);
        this.hyperlinkListener = listener;
        this.attachedComponentListener = new AttachedComponentListener();
        this.tipVisibleBounds = new Rectangle();
        this.showCopyContextMenu = showCopyContextMenu;
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public TipWindow getTipWindows() {
        return this.tipWindow;
    }

    protected void computeTipVisibleBounds() {
        Rectangle r = this.tipWindow.getBounds();
        Point p = r.getLocation();
        SwingUtilities.convertPointFromScreen(p, this.attachedComponent);
        r.setLocation(p);
        this.tipVisibleBounds.setBounds(r.x, r.y - 15, r.width, r.height + 30);
    }

    protected void createAndShowTipWindow(final MouseEvent e, final String text) {
        Window owner = SwingUtilities.getWindowAncestor(this.attachedComponent);
        this.tipWindow = new TipWindow(owner, this, text);
        this.tipWindow.setHyperlinkListener(this.hyperlinkListener);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (FocusableTip.this.tipWindow == null) {
                    return;
                }
                if (FocusableTip.this.showCopyContextMenu) {
                    TipUtil.addCopyContextMenu(FocusableTip.this.tipWindow);
                }
                FocusableTip.this.tipWindow.fixSize(FocusableTip.this.width, FocusableTip.this.height);
                ComponentOrientation o = FocusableTip.this.attachedComponent.getComponentOrientation();
                Point p = e.getPoint();
                SwingUtilities.convertPointToScreen(p, FocusableTip.this.attachedComponent);
                int x = o.isLeftToRight() ? p.x - 10 : p.x - FocusableTip.this.tipWindow.getWidth() + 10;
                int y = p.y + 10;
                Dimension ss = FocusableTip.this.tipWindow.getToolkit().getScreenSize();
                x = Math.max(x, 0);
                if (x + FocusableTip.this.tipWindow.getWidth() >= ss.width) {
                    x = ss.width - FocusableTip.this.tipWindow.getWidth();
                }
                if (y + FocusableTip.this.tipWindow.getHeight() >= ss.height) {
                    y = p.y - FocusableTip.this.tipWindow.getHeight() - 10;
                }
                FocusableTip.this.tipWindow.setLocation(x, y);
                FocusableTip.this.tipWindow.setVisible(true);
                FocusableTip.this.tipWindow.toFront();
                FocusableTip.this.computeTipVisibleBounds();
                FocusableTip.this.attachedComponentListener.install(FocusableTip.this.attachedComponent);
                FocusableTip.this.lastText = text;
            }
        });
    }

    public URL getImageBase() {
        return this.imageBase;
    }

    public void possiblyDisposeOfTipWindow() {
        if (this.tipWindow != null) {
            this.tipWindow.dispose();
            this.tipWindow = null;
            this.attachedComponentListener.uninstall();
            this.tipVisibleBounds.setBounds(-1, -1, 0, 0);
            this.lastText = null;
            this.attachedComponent.requestFocus();
        }
    }

    void removeListeners() {
        this.attachedComponentListener.uninstall();
    }

    public void setImageBase(URL url) {
        this.imageBase = url;
    }

    protected void setAttachedComponent(JComponent attachedComponent) {
        this.attachedComponent = attachedComponent;
        ToolTipManager.sharedInstance().registerComponent(attachedComponent);
    }

    public void toolTipRequested(MouseEvent e, String text) {
        if (text == null || text.length() == 0) {
            this.possiblyDisposeOfTipWindow();
            this.lastText = text;
            return;
        }
        if (this.lastText == null || text.length() != this.lastText.length() || !text.equals(this.lastText)) {
            this.possiblyDisposeOfTipWindow();
            this.createAndShowTipWindow(e, text);
        }
    }

    protected class AttachedComponentListener
    extends MouseInputAdapter
    implements CaretListener,
    ComponentListener,
    FocusListener,
    KeyListener {
        protected AttachedComponentListener() {
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            Object source = e.getSource();
            if (source == FocusableTip.this.attachedComponent) {
                FocusableTip.this.possiblyDisposeOfTipWindow();
            }
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            this.handleComponentEvent(e);
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            this.handleComponentEvent(e);
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.handleComponentEvent(e);
        }

        @Override
        public void componentShown(ComponentEvent e) {
            this.handleComponentEvent(e);
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            boolean tipClicked;
            Component c = e.getOppositeComponent();
            boolean bl = tipClicked = c instanceof TipWindow || c != null && SwingUtilities.getWindowAncestor(c) instanceof TipWindow;
            if (!tipClicked) {
                FocusableTip.this.possiblyDisposeOfTipWindow();
            }
        }

        protected void handleComponentEvent(ComponentEvent e) {
            FocusableTip.this.possiblyDisposeOfTipWindow();
        }

        public void install(JComponent attachedComponent) {
            attachedComponent.addComponentListener(this);
            attachedComponent.addFocusListener(this);
            attachedComponent.addKeyListener(this);
            attachedComponent.addMouseListener(this);
            attachedComponent.addMouseMotionListener(this);
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                FocusableTip.this.possiblyDisposeOfTipWindow();
            } else if (e.getKeyCode() == 113 && FocusableTip.this.tipWindow != null && !FocusableTip.this.tipWindow.getFocusableWindowState()) {
                FocusableTip.this.tipWindow.actionPerformed(null);
                e.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (FocusableTip.this.tipVisibleBounds == null || !FocusableTip.this.tipVisibleBounds.contains(e.getPoint())) {
                FocusableTip.this.possiblyDisposeOfTipWindow();
            }
        }

        public void uninstall() {
            FocusableTip.this.attachedComponent.removeComponentListener(this);
            FocusableTip.this.attachedComponent.removeFocusListener(this);
            FocusableTip.this.attachedComponent.removeKeyListener(this);
            FocusableTip.this.attachedComponent.removeMouseListener(this);
            FocusableTip.this.attachedComponent.removeMouseMotionListener(this);
        }
    }
}

