/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.thesaurus;

import com.jurismarches.vradi.beans.FormPagedResult;
import com.jurismarches.vradi.beans.QueryParameters;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.RootThesaurus;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.services.search.UnsupportedQueryException;
import com.jurismarches.vradi.ui.helpers.ToolTipHelper;
import com.jurismarches.vradi.ui.helpers.VradiComparators;
import com.jurismarches.vradi.ui.thesaurus.helpers.ThesaurusDataHelper;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThesaurusDataProvider
extends VradiDataProvider {
    private static final Log log = LogFactory.getLog(ThesaurusDataProvider.class);
    protected QueryParameters queryParameters;
    protected Map<Thesaurus, Integer> cachedMap;
    private List<RootThesaurus> rootThesaurus;

    public ThesaurusDataProvider() {
    }

    public ThesaurusDataProvider(QueryParameters queryParameters) {
        this.cachedMap = new HashMap<Thesaurus, Integer>();
        this.queryParameters = queryParameters;
    }

    public boolean isCartography() {
        return this.queryParameters != null;
    }

    public Integer getNbFormsForThesaurus(Thesaurus thesaurus) {
        int result = 0;
        if (this.isCartography()) {
            Integer nb = this.cachedMap.get(thesaurus);
            if (nb != null) {
                result = nb;
            }
        } else {
            result = ThesaurusDataHelper.getNbFormsForThesaurus(thesaurus);
        }
        return result;
    }

    public List<RootThesaurus> getRootThesaurus() {
        return this.rootThesaurus;
    }

    public Collection<Thesaurus> getChildrenThesaurus(String thesaurusId) {
        if (this.isCartography()) {
            Set<Thesaurus> thesauruses = this.getChildrenCartography(thesaurusId).keySet();
            ArrayList<Thesaurus> sortedList = new ArrayList<Thesaurus>(thesauruses);
            Collections.sort(sortedList, VradiComparators.THESAURUS_COMPARATOR);
            return sortedList;
        }
        try {
            return VradiService.getVradiDataService().getChildrenThesaurus(thesaurusId);
        }
        catch (VradiException eee) {
            log.error((Object)("Cant get thesaurus children of node " + thesaurusId), (Throwable)eee);
            return null;
        }
    }

    protected Map<Thesaurus, Integer> getChildrenCartography(String thesaurusId) {
        Map map = null;
        try {
            map = VradiService.getVradiDataService().getChildrenCartography(thesaurusId, this.queryParameters);
        }
        catch (VradiException eee) {
            log.error((Object)("Exception occured on get children cartography of node " + thesaurusId), (Throwable)eee);
        }
        catch (UnsupportedQueryException eee) {
            log.error((Object)("Exception occured on get children cartography of node " + thesaurusId), (Throwable)eee);
        }
        if (map != null) {
            this.cachedMap.putAll(map);
        }
        return map;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public String getCartographyToolTip(Thesaurus thesaurus) {
        Integer formsForThesaurus = this.getNbFormsForThesaurus(thesaurus);
        if (formsForThesaurus == null || formsForThesaurus == 0) {
            return null;
        }
        FormPagedResult pagedResult = new FormPagedResult();
        List thesauruses = this.queryParameters.getThesaurus();
        this.queryParameters.clearThesaurus();
        this.queryParameters.addThesaurus(thesaurus);
        try {
            pagedResult = VradiService.getVradiDataService().findForms(this.queryParameters, pagedResult);
        }
        catch (VradiException eee) {
            log.error((Object)("Cant get tool tip for thesaurus " + thesaurus.getName()), (Throwable)eee);
        }
        catch (UnsupportedQueryException eee) {
            log.error((Object)("Cant get tool tip for thesaurus " + thesaurus.getName()), (Throwable)eee);
        }
        List formToShow = pagedResult.getFormsIdsToShow();
        List formList = VradiService.getWikittyProxy().restore(Form.class, formToShow);
        this.queryParameters.setThesaurus(thesauruses);
        return ToolTipHelper.getToolTip(formList);
    }
}

