/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: EmailFormsHighlighter.java 1715 2010-10-27 19:21:28Z tchemit $
 * $HeadURL: svn+ssh://tchemit@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.3/vradi-swing/src/main/java/com/jurismarches/vradi/ui/email/renderers/EmailFormsHighlighter.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.email.renderers;

import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.models.OfferListTableModel;
import javax.swing.ListModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;

import java.awt.Color;
import java.awt.Component;
import java.util.Collection;

/**
 * Highlighter to cross of deleted forms
 *
 * @author letellier
 */
public class EmailFormsHighlighter extends AbstractHighlighter {

    static private final Log log = LogFactory.getLog(EmailFormsHighlighter.class);

    protected OfferListTableModel listTableModel;
    protected ListModel listModel;
    protected Collection<String> formsDeleted;
    protected Collection<String> formsAdded;

    public EmailFormsHighlighter(OfferListTableModel listTableModel) {
        this.listTableModel = listTableModel;
    }

    public void setFormsAdded(Collection<String> formsAdded) {
        this.formsAdded = formsAdded;
    }

    public void setFormsDeleted(Collection<String> formsDeleted) {
        this.formsDeleted = formsDeleted;
    }

    public void notifyChange() {
        super.fireStateChanged();
    }

    @Override
    protected Component doHighlight(Component component, ComponentAdapter adapter) {
        String formId = listTableModel.getFormIdAt(adapter.row);
        if (formsDeleted != null && formsDeleted.contains(formId)) {
            component = UIHelper.crossOf(component);
        }
        if (formsAdded != null && formsAdded.contains(formId)) {
            component.setForeground(Color.BLUE);
        }
        return component;
    }
}
