/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import java.util.concurrent.Future;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.annotations.DeprecatedProperty;
import org.jgroups.annotations.Experimental;
import org.jgroups.annotations.Property;
import org.jgroups.annotations.Unsupported;
import org.jgroups.stack.Protocol;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

@Experimental
@Unsupported
@DeprecatedProperty(names={"use_separate_thread"})
public class MERGE3
extends Protocol {
    Address local_addr = null;
    View view;
    @Property
    long min_interval = 5000L;
    @Property
    long max_interval = 20000L;
    boolean is_coord = false;
    final Vector<Address> mbrs = new Vector();
    TimeScheduler timer = null;
    Future<?> announcer_task_future = null;

    @Override
    public void init() throws Exception {
        this.timer = this.getTransport().getTimer();
        if (this.min_interval <= 0L || this.max_interval <= 0L) {
            throw new Exception("min_interval and max_interval have to be > 0");
        }
        if (this.max_interval <= this.min_interval) {
            throw new Exception("max_interval has to be greater than min_interval");
        }
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                CoordAnnouncement hdr = (CoordAnnouncement)msg.getHeader(this.id);
                if (hdr != null) {
                    ViewId other;
                    if (this.is_coord && !Util.sameViewId(other = hdr.view.getViewId(), this.view.getViewId())) {
                        HashMap<Address, View> views = new HashMap<Address, View>();
                        views.put(this.local_addr, this.view);
                        views.put(msg.getSrc(), hdr.view);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("detected different views (" + Util.printViews(views.values()) + "), sending up MERGE event");
                        }
                        this.up_prot.up(new Event(14, views));
                    }
                    return null;
                }
                return this.up_prot.up(evt);
            }
        }
        return this.up_prot.up(evt);
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.down_prot.down(evt);
                this.view = (View)evt.getArg();
                Vector<Address> tmp = this.view.getMembers();
                this.mbrs.clear();
                this.mbrs.addAll(tmp);
                Address coord = this.mbrs.elementAt(0);
                if (coord.equals(this.local_addr)) {
                    if (this.is_coord) break;
                    this.is_coord = true;
                    this.startCoordAnnouncerTask();
                    break;
                }
                if (!this.is_coord) break;
                this.is_coord = false;
                this.stopCoordAnnouncerTask();
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        return this.down_prot.down(evt);
    }

    void startCoordAnnouncerTask() {
        if (this.announcer_task_future == null || this.announcer_task_future.isDone()) {
            this.announcer_task_future = this.timer.scheduleWithDynamicInterval(new CoordinatorAnnouncer());
        }
    }

    void stopCoordAnnouncerTask() {
        if (this.announcer_task_future != null) {
            this.announcer_task_future.cancel(false);
            this.announcer_task_future = null;
        }
    }

    long computeInterval() {
        return this.min_interval + Util.random(this.max_interval - this.min_interval);
    }

    void sendView() {
        Message view_announcement = new Message();
        CoordAnnouncement hdr = new CoordAnnouncement(this.view);
        view_announcement.putHeader(this.id, hdr);
        this.down_prot.down(new Event(1, view_announcement));
    }

    public static class CoordAnnouncement
    extends Header {
        private View view;

        public CoordAnnouncement() {
        }

        public CoordAnnouncement(View view) {
            this.view = view;
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
            Util.writeView(this.view, out);
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.view = Util.readView(in);
        }

        @Override
        public int size() {
            return Util.size(this.view);
        }
    }

    class CoordinatorAnnouncer
    implements TimeScheduler.Task {
        CoordinatorAnnouncer() {
        }

        @Override
        public long nextInterval() {
            return MERGE3.this.computeInterval();
        }

        @Override
        public void run() {
            if (MERGE3.this.is_coord) {
                MERGE3.this.sendView();
            }
        }
    }
}

