/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.util.*;
import java.util.regex.Matcher;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class XmlStreamConfigUI extends javax.swing.JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.content.XmlStreamConfigUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected com.jurismarches.vradi.entities.XmlStream bean;
    protected javax.swing.JComboBox hourDays;
    protected javax.swing.JComboBox minuteDays;
    protected XmlStreamConfigUI xmlStreamConfigUI = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected ComboBoxModel minutesModel;
    protected ComboBoxModel hoursModel;
    protected ComboBoxModel daysModel;
    
    
    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    void $afterCompleteSetup() {
        addPropertyChangeListener("bean", new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (getBean() != null) {
                
    
                    // Parse la valeur ImportTime du bean XmlStream courant et
                    // initialise correctement les differents panel.
                    //
                    // Dans le cas ou le pattern ne match pas, la valeur par defaut
                    // est celle des services (à savoir, tous les 1 jour, à minuit).
                    //
                    String xmlStringImportTime = bean.getImportTime();
    
                    if (xmlStringImportTime != null && !xmlStringImportTime.isEmpty()) {
                        Matcher matcher = VradiConstants.XML_STREAM_IMPORT_TIME.matcher(xmlStringImportTime);
            
                        if (matcher.find()) {
                            // selection des heures
                            hourDays.setSelectedItem(Integer.valueOf(matcher.group(1)));
                            // selection de la minutes
                            minuteDays.setSelectedItem(Integer.valueOf(matcher.group(2)));
                        }
                    }
                } else {
                    // clear UI
                    hourDays.setSelectedItem(0);
                    minuteDays.setSelectedItem(0);;
                }
            }
        });
    }
    
    /**
     * Set import time value into bean.
     */
    protected void setImportTimeValue() {
        if (bean != null) {
            String importTime = null;
            importTime = hourDays.getSelectedItem().toString() + ":" + minuteDays.getSelectedItem().toString();
            bean.setImportTime(importTime);
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public XmlStreamConfigUI() {
        $initialize();
    }

    public XmlStreamConfigUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__hourDays(java.awt.event.ActionEvent event) {
        setImportTimeValue();
    }

    public void doActionPerformed__on__minuteDays(java.awt.event.ActionEvent event) {
        setImportTimeValue();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public com.jurismarches.vradi.entities.XmlStream getBean() {
        return bean;
    }

    public javax.swing.JComboBox getHourDays() {
        return hourDays;
    }

    public javax.swing.JComboBox getMinuteDays() {
        return minuteDays;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(com.jurismarches.vradi.entities.XmlStream newValue) {
        com.jurismarches.vradi.entities.XmlStream oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToXmlStreamConfigUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($JLabel0);
        add(hourDays);
        add($JLabel1);
        add(minuteDays);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createHourDays() {
        $objectMap.put("hourDays", hourDays = new javax.swing.JComboBox());
        
        hourDays.setName("hourDays");
        hourDays.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__hourDays"));
    }

    protected void createMinuteDays() {
        $objectMap.put("minuteDays", minuteDays = new javax.swing.JComboBox());
        
        minuteDays.setName("minuteDays");
        minuteDays.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__minuteDays"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToXmlStreamConfigUI();
        
        // apply 6 property setters
        hourDays.setModel(UIHelper.getHourModel());
        hourDays.setRenderer(UIHelper.get2DigitsRenderer());
        hourDays.setSelectedItem(0);
        minuteDays.setModel(UIHelper.getMinuteModel());
        minuteDays.setRenderer(UIHelper.get2DigitsRenderer());
        minuteDays.setSelectedItem(0);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("xmlStreamConfigUI", this);
        createBean();
        minutesModel = new DefaultComboBoxModel(new Object[]{15, 30, 45});
        hoursModel = UIHelper.getNumberComboBoxModel(1, 24);
        daysModel = UIHelper.getNumberComboBoxModel(1, 31);
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminXmlStream.config.load"));
        createHourDays();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.common.timeseparator"));
        createMinuteDays();
        // inline creation of xmlStreamConfigUI
        setName("xmlStreamConfigUI");
        
        $completeSetup();
    }

}