/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.admin.loadors;

import com.jurismarches.vradi.entities.RootThesaurus;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.ui.helpers.ThesaurusDataHelper;
import com.jurismarches.vradi.ui.helpers.VradiComparators;
import com.jurismarches.vradi.ui.offer.thesaurus.loadors.ThesaurusNodeLoadors;
import com.jurismarches.vradi.ui.tree.VradiTreeTableNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jaxx.runtime.swing.nav.NavDataProvider;
import jaxx.runtime.swing.nav.NavHelper;
import jaxx.runtime.swing.nav.treetable.NavTreeTableNodeChildLoador;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.BusinessEntity;

public class ThesaurusTreeTableNodeLoadors
extends NavTreeTableNodeChildLoador<String, Thesaurus, VradiTreeTableNode> {
    private static final Log log = LogFactory.getLog(ThesaurusNodeLoadors.class);

    public ThesaurusTreeTableNodeLoadors() {
        super(Thesaurus.class);
    }

    public List<String> getData(Class<?> parentClass, String parentId, NavDataProvider dataProvider) throws Exception {
        if (RootThesaurus.class.equals(parentClass)) {
            List<Thesaurus> thesauruses = ThesaurusDataHelper.getChildrenOfRootThesaurus(parentId);
            if (log.isDebugEnabled()) {
                RootThesaurus root = ThesaurusDataHelper.restoreRootThesaurus(parentId);
                for (Thesaurus thesaurus : thesauruses) {
                    log.debug((Object)("Children of root thesaurus " + root.getName() + " find : " + thesaurus.getName()));
                }
            }
            Collections.sort(thesauruses, VradiComparators.THESAURUS_COMPARATOR);
            return this.extractIds(thesauruses);
        }
        List<Thesaurus> childrenOfThesaurus = ThesaurusDataHelper.getChildrenOfThesaurus(parentId);
        if (log.isDebugEnabled()) {
            for (Thesaurus thesaurus : childrenOfThesaurus) {
                Thesaurus parent = ThesaurusDataHelper.restoreThesaurus(parentId);
                log.debug((Object)("Children of thesaurus " + parent.getName() + " found : " + thesaurus.getName()));
            }
        }
        Collections.sort(childrenOfThesaurus, VradiComparators.THESAURUS_COMPARATOR);
        return this.extractIds(childrenOfThesaurus);
    }

    public VradiTreeTableNode createNode(String id, NavDataProvider dataProvider) {
        return new VradiTreeTableNode(this.getBeanType(), id, null, (NavTreeTableNodeChildLoador)NavHelper.getChildLoador(ThesaurusTreeTableNodeLoadors.class));
    }

    public List<String> extractIds(List<? extends BusinessEntity> entities) {
        ArrayList<String> ids = new ArrayList<String>();
        for (BusinessEntity businessEntity : entities) {
            if (businessEntity == null) continue;
            ids.add(businessEntity.getWikittyId());
        }
        return ids;
    }
}

