package com.jurismarches.vradi.ui.admin.renderers;

import java.awt.Component;

import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.ui.admin.helpers.AdminNavigationTreeHelper;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.decorator.DecoratorProvider;

import jaxx.runtime.swing.nav.tree.AbstractNavTreeCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.jurismarches.vradi.ui.admin.helpers.AdminBeanConstant;

/**
 * @author letellier
 * @see AbstractNavTreeCellRenderer
 */
public class AdminCellRenderer extends AbstractNavTreeCellRenderer<DefaultTreeModel, VradiTreeNode> {

    /** serialVersionUID. */
    private static final long serialVersionUID = 7917305304778635796L;

    /** Logger */
    protected static final Log log = LogFactory.getLog(AdminCellRenderer.class);

    protected DecoratorProvider decoratorProvider;

    /**
     * Init renderer.
     * 
     * @param decoratorProvider ???
     * @param dataProvider data provider
     */
    public AdminCellRenderer(DecoratorProvider decoratorProvider,
                             VradiDataProvider dataProvider) {

        setDataProvider(dataProvider);
        this.decoratorProvider = decoratorProvider;
    }

    @Override
    protected String computeNodeText(VradiTreeNode node) {

        // Get node type
        Class<?> editType = node.getInternalClass();
        String id = node.getId();

        // get decorator
        Decorator<?> decorator = decoratorProvider.getDecorator(editType);

        // for user
        if (editType.equals(User.class)) {

            // And if its client ui
            VradiTreeNode clientCategoryNode = AdminNavigationTreeHelper.getParentCategoryNode(node, AdminBeanConstant.CLIENT.getCategoryName());
            if (clientCategoryNode != null) {

                // Decorate with user name only
                decorator = decoratorProvider.getDecorator(User.class, VradiConstants.USER_ONLY_DECORATOR);
            }
        }

        Object toDecorate = AdminBeanConstant.getConstantByBeanClass(editType).
                getBean((VradiDataProvider)getDataProvider(), id);

        // Get decorated value
        String decorated = decorator.toString(toDecorate);

        if (log.isDebugEnabled()) {
            log.debug("Compute text for node " + node + " return " + decorated);
        }

        return decorated;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree,
                                                  Object value,
                                                  boolean sel,
                                                  boolean expanded,
                                                  boolean leaf, int row,
                                                  boolean hasFocus) {

        // get node
        VradiTreeNode node = (VradiTreeNode)value;

        // get text for node
        String text = getNodeText(node);

        // Render node
        return super.getTreeCellRendererComponent(tree, text, sel,
                                                  expanded, leaf,
                                                  row, hasFocus);
    }
}
