/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Message;

public class AckReceiverWindow {
    private long next_to_remove = 0L;
    private final Map<Long, Message> msgs = new HashMap<Long, Message>();
    private final AtomicBoolean processing = new AtomicBoolean(false);
    private final Lock lock = new ReentrantLock();

    public AckReceiverWindow(long initial_seqno) {
        this.next_to_remove = initial_seqno;
    }

    public AtomicBoolean getProcessing() {
        return this.processing;
    }

    public boolean add(long seqno, Message msg) {
        return this.add2(seqno, msg) == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte add2(long seqno, Message msg) {
        if (msg == null) {
            throw new IllegalArgumentException("msg must be non-null");
        }
        this.lock.lock();
        try {
            if (seqno < this.next_to_remove) {
                byte by = -1;
                return by;
            }
            if (!this.msgs.containsKey(seqno)) {
                this.msgs.put(seqno, msg);
                byte by = 1;
                return by;
            }
            byte by = 0;
            return by;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message remove() {
        this.lock.lock();
        try {
            Message retval = this.msgs.remove(this.next_to_remove);
            if (retval != null) {
                ++this.next_to_remove;
            }
            Message message = retval;
            return message;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> removeMany() {
        LinkedList<Message> retval = new LinkedList<Message>();
        this.lock.lock();
        try {
            Message msg;
            while ((msg = this.msgs.remove(this.next_to_remove)) != null) {
                ++this.next_to_remove;
                retval.add(msg);
            }
            LinkedList<Message> linkedList = retval;
            return linkedList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message removeOOBMessage() {
        this.lock.lock();
        try {
            Message retval = this.msgs.get(this.next_to_remove);
            if (retval != null) {
                if (!retval.isFlagSet((byte)1)) {
                    Message message = null;
                    return message;
                }
                retval = this.msgs.remove(this.next_to_remove);
                if (retval != null) {
                    ++this.next_to_remove;
                }
            }
            Message message = retval;
            return message;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long removeOOBMessages() {
        long highest = -1L;
        this.lock.lock();
        try {
            Message retval;
            while ((retval = this.msgs.get(this.next_to_remove)) != null && retval.isFlagSet((byte)1) && (retval = this.msgs.remove(this.next_to_remove)) != null) {
                highest = Math.max(highest, this.next_to_remove);
                ++this.next_to_remove;
            }
            long l = highest;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean hasMessagesToRemove() {
        return this.msgs.containsKey(this.next_to_remove);
    }

    public void reset() {
        this.msgs.clear();
    }

    public int size() {
        return this.msgs.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.msgs.size()).append(" msgs (").append("next=").append(this.next_to_remove).append(")");
        TreeSet<Long> s = new TreeSet<Long>(this.msgs.keySet());
        if (!s.isEmpty()) {
            sb.append(" [").append(s.first()).append(" - ").append(s.last()).append("]");
            sb.append(": ").append(s);
        }
        return sb.toString();
    }

    public String printDetails() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.msgs.size()).append(" msgs (").append("next=").append(this.next_to_remove).append(")").append(", msgs=").append(new TreeSet<Long>(this.msgs.keySet()));
        return sb.toString();
    }
}

