/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.helpers;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.ClientImpl;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.GroupImpl;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.StatusImpl;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.entities.UserImpl;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.entities.XmlStreamImpl;
import com.jurismarches.vradi.ui.VradiComparators;
import com.jurismarches.vradi.ui.admin.AdminContentUI;
import com.jurismarches.vradi.ui.admin.AdminNavUI;
import com.jurismarches.vradi.ui.admin.content.AdminClientUI;
import com.jurismarches.vradi.ui.admin.content.AdminFormTypeUI;
import com.jurismarches.vradi.ui.admin.content.AdminGroupUI;
import com.jurismarches.vradi.ui.admin.content.AdminStatusUI;
import com.jurismarches.vradi.ui.admin.content.AdminUserUI;
import com.jurismarches.vradi.ui.admin.content.AdminXmlStreamUI;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.swing.CardLayout2;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.navigation.AbstractNavigationHelper;
import jaxx.runtime.swing.navigation.NavigationModel;
import jaxx.runtime.swing.navigation.NavigationNode;
import jaxx.runtime.swing.navigation.handler.NavigationHandler;
import jaxx.runtime.swing.navigation.handler.NavigationTreeHandlerWithCardLayout;
import jaxx.runtime.swing.navigation.tree.NavigationTreeModel;
import jaxx.runtime.swing.navigation.tree.NavigationTreeModelBuilder;
import jaxx.runtime.swing.navigation.tree.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.sharengo.wikitty.WikittyExtension;

public abstract class AdminNavigationTreeHelper
extends AbstractNavigationHelper<NavigationTreeNode> {
    private static final Log log = LogFactory.getLog(AdminNavigationTreeHelper.class);
    protected static String NEW_CLIENT_NAME = I18n.n_((String)"vradi.adminClient.newClientName");
    protected static String NEW_GROUP_NAME = I18n.n_((String)"vradi.adminGroup.newGroupName");
    protected static String NEW_USER_NAME = I18n.n_((String)"vradi.adminUser.newUserName");
    protected static String NEW_STATUS_NAME = I18n.n_((String)"vradi.adminStatus.newStatusName");
    protected static String NEW_XMLSTREAM_NAME = I18n.n_((String)"vradi.adminXmlStream.newStreamName");
    protected final AdminTreeModelBuilder builder;

    public abstract NavigationModel<NavigationTreeNode> createTreeModel();

    public AdminNavigationTreeHelper(String prefix, JAXXContext context) {
        super(prefix);
        this.builder = new AdminTreeModelBuilder(context);
    }

    public JAXXContext getContext() {
        return this.builder.getModel().getContext();
    }

    public NavigationTreeNode addClientToSelected(JAXXContext context, Client client) {
        return this.builder.addClient(context, (NavigationTreeNode)this.getSelectedNode(context), client);
    }

    public NavigationTreeNode addFormTypeToSelected(JAXXContext context, WikittyExtension form) {
        return this.builder.addForm(context, (NavigationTreeNode)this.getSelectedNode(context), form);
    }

    public NavigationTreeNode addGroupToSelected(JAXXContext context, Group group) {
        return this.builder.addGroup(context, (NavigationTreeNode)this.getSelectedNode(context), group);
    }

    public NavigationTreeNode addStatusToSelected(JAXXContext context, Status status) {
        return this.builder.addStatus(context, (NavigationTreeNode)this.getSelectedNode(context), status);
    }

    public NavigationTreeNode addUserToSelected(JAXXContext context, User user) {
        return this.builder.addUser(context, (NavigationTreeNode)this.getSelectedNode(context), user);
    }

    public NavigationTreeNode addXmlStreamToSelected(JAXXContext context, XmlStream xml) {
        return this.builder.addXmlStream(context, (NavigationTreeNode)this.getSelectedNode(context), xml);
    }

    public NavigationTreeNode addClient(JAXXContext context, NavigationTreeNode selectedNode, Client client) {
        return this.builder.addClient(context, selectedNode, client);
    }

    public NavigationTreeNode addStatus(JAXXContext context, NavigationTreeNode selectedNode, Status status) {
        return this.builder.addStatus(context, selectedNode, status);
    }

    public NavigationTreeNode addFormType(JAXXContext context, NavigationTreeNode selectedNode, WikittyExtension form) {
        return this.builder.addForm(context, selectedNode, form);
    }

    public NavigationTreeNode addGroup(JAXXContext context, NavigationTreeNode selectedNode, Group group) {
        return this.builder.addGroup(context, selectedNode, group);
    }

    public NavigationTreeNode addUser(JAXXContext context, NavigationTreeNode selectedNode, User user) {
        return this.builder.addUser(context, selectedNode, user);
    }

    public NavigationTreeNode addXmlStream(JAXXContext context, NavigationTreeNode selectedNode, XmlStream xml) {
        return this.builder.addXmlStream(context, selectedNode, xml);
    }

    public NavigationTreeNode getParentClientNode(NavigationTreeNode current) {
        return this.builder.getParentClientNode(current);
    }

    public NavigationTreeNode getParentGroupNode(NavigationTreeNode current) {
        return this.builder.getParentGroupNode(current);
    }

    public NavigationTreeNode removeChildNode(NavigationTreeNode node) {
        return (NavigationTreeNode)this.builder.removeChildNode((NavigationNode)node);
    }

    public void reSelectNode(JAXXContext context, String fullPath) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("try to reselect " + fullPath));
        }
        NavigationModel model = this.getSafeModel(context);
        String[] paths = fullPath.split(model.getPathSeparator());
        Object node = (NavigationTreeNode)model.getRoot();
        int max = paths.length;
        for (int i = 1; i < max; ++i) {
            NavigationTreeNode node2;
            String p = paths[i];
            if (log.isDebugEnabled()) {
                log.debug((Object)("find child with path " + p));
            }
            if ((node2 = node.getChild(p)) == null) break;
            node = node2;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("reselect " + node.getFullPath()));
        }
        if (node == model.getRoot()) {
            node = node.getChildCount() > 0 ? node.getChildAt(0) : null;
        }
        this.selectNode(context, (NavigationNode)node);
    }

    public void sort(NavigationTreeNode node) {
        NavigationTreeNode statusCategory = this.builder.getStatusCategoryNode(node);
        if (statusCategory != null) {
            this.sortCategory(statusCategory);
            return;
        }
        NavigationTreeNode formCategory = this.builder.getFormCategoryNode(node);
        if (formCategory != null) {
            this.sortCategory(formCategory);
            return;
        }
        NavigationTreeNode xmlStreamCategory = this.builder.getXmlStreamCategoryNode(node);
        if (xmlStreamCategory != null) {
            this.sortCategory(xmlStreamCategory);
            return;
        }
        if (this.builder.isGroupNavigationTree(node)) {
            NavigationTreeNode clientCategory = this.builder.getParentCategoryNode(node, "clients");
            if (clientCategory != null) {
                this.sortCategory(clientCategory);
                return;
            }
            NavigationTreeNode userCategory = this.builder.getParentCategoryNode(node, "users");
            if (userCategory != null) {
                this.sortCategory(userCategory);
                return;
            }
            NavigationTreeNode groupCategory = this.builder.getGroupCategoryNode(node);
            this.sortCategory(groupCategory);
            return;
        }
        NavigationTreeNode userCategory = this.builder.getParentCategoryNode(node, "users");
        if (userCategory != null) {
            this.sortCategory(userCategory);
            return;
        }
        NavigationTreeNode clientCategory = this.builder.getParentCategoryNode(node, "clients");
        if (clientCategory != null) {
            this.sortCategory(clientCategory);
            return;
        }
    }

    protected void sortCategory(NavigationTreeNode categoryNode) {
        Enumeration childEnum = categoryNode.children();
        ArrayList<NavigationTreeNode> children = Collections.list(childEnum);
        Collections.sort(children, VradiComparators.RENDERER_COMPARATOR);
        for (NavigationTreeNode child : children) {
            int index = children.indexOf(child);
            categoryNode.remove(child);
            categoryNode.insert(child, index);
        }
        this.builder.getModel().nodeStructureChanged(categoryNode);
    }

    public void reloadGroup(JAXXContext context, NavigationTreeNode groupNode, Group group) {
        groupNode.removeAllChildren();
        this.sort(groupNode);
        this.builder.fillGroupNode(group, groupNode);
    }

    public final NavigationModel<NavigationTreeNode> createTreeModel(JAXXContext context) {
        NavigationModel<NavigationTreeNode> model = this.createTreeModel();
        return model;
    }

    public final NavigationHandler<NavigationTreeNode> createTreeHandler(JAXXObject context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"create handler");
        }
        NavigationTreeHandlerWithCardLayout<NavigationTreeNode> handler = new NavigationTreeHandlerWithCardLayout<NavigationTreeNode>(this.getPrefix(), context, NavigationHandler.Strategy.PER_UI_TYPE){
            private static final long serialVersionUID = 1L;

            public boolean closeUI(Component component) throws Exception {
                if (component != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Closing UI : " + component.getName()));
                    }
                    AdminContentUI content = (AdminContentUI)component;
                    return content.getHandler().answerToSave(content);
                }
                return true;
            }

            public NavigationModel<NavigationTreeNode> getNavigationTreeModel() {
                return AdminNavigationTreeHelper.this.getSafeModel((JAXXContext)this.getContext());
            }

            protected JPanel getContentContainer() {
                return this.getContext().getContent();
            }

            protected CardLayout2 getContentLayout() {
                return this.getContext().getContentLayout();
            }

            public void treateError(Exception e) {
                ErrorDialogUI.showError((Exception)e);
            }

            public AdminNavUI getContext() {
                return (AdminNavUI)this.context;
            }
        };
        handler.setSelectionMode(1);
        this.setTreeHandler((JAXXContext)context, (NavigationHandler)handler);
        this.setTree((JAXXContext)context, ((AdminNavUI)context).getNav());
        return handler;
    }

    protected class AdminTreeModelBuilder
    extends NavigationTreeModelBuilder {
        public AdminTreeModelBuilder(JAXXContext context) {
            super(null, null, new NavigationTreeModel("/", context));
        }

        protected Decorator<?> getDecorator(Class<?> clazz) {
            return VradiContext.get().getDecoratorProvider().getDecorator(clazz);
        }

        public NavigationTreeNode addClient(JAXXContext context, NavigationTreeNode node, Client client) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Selected node : " + node.getFullPath()));
            }
            if (client == null) {
                client = new ClientImpl();
                client.setName(I18n._((String)NEW_CLIENT_NAME));
                NavigationTreeNode groupNode = this.getParentGroupNode(node);
                if (groupNode != null) {
                    Group group = (Group)groupNode.getBean();
                    group.addClient(client.getWikittyId());
                }
            }
            VradiContext.addIfNecessary(VradiContext.getClientsEntryDef(), client);
            return this.addClient(node, client.getWikittyId());
        }

        public NavigationTreeNode addClient(NavigationTreeNode node, String id) {
            NavigationTreeNode result = (NavigationTreeNode)this.build((NavigationNode)this.getClientCategoryNode(node), this.getDecorator(Client.class), "..[@wikittyId=\"" + id + "\"]", id, AdminClientUI.class, null);
            AdminNavigationTreeHelper.this.sort(result);
            if (!this.isGroupNavigationTree(result)) {
                JAXXContextEntryDef<List<User>> usersEntryDef = VradiContext.getUsersEntryDef();
                this.build((NavigationNode)result, I18n._((String)usersEntryDef.getName()), usersEntryDef, "users", AdminUserUI.class, null);
            }
            return result;
        }

        public NavigationTreeNode addUser(JAXXContext context, NavigationTreeNode node, User user) {
            if (user == null) {
                user = new UserImpl();
                user.setName(I18n._((String)NEW_USER_NAME));
                user.setInscriptionDate(new Date());
                NavigationTreeNode groupNode = this.getParentGroupNode(node);
                if (groupNode == null) {
                    NavigationTreeNode clientNode = this.getParentClientNode(node);
                    Client client = (Client)clientNode.getBean();
                    user.setClient(client.getWikittyId());
                } else {
                    Group group = (Group)groupNode.getBean();
                    group.addUser(user.getWikittyId());
                }
            }
            VradiContext.addIfNecessary(VradiContext.getUsersEntryDef(), user);
            return this.addUser(node, user.getWikittyId());
        }

        public NavigationTreeNode addUser(NavigationTreeNode node, String id) {
            NavigationTreeNode result = (NavigationTreeNode)this.build((NavigationNode)this.getUserCategoryNode(node), this.getDecorator(User.class), "..[@wikittyId=\"" + id + "\"]", id, AdminUserUI.class, null);
            AdminNavigationTreeHelper.this.sort(result);
            return result;
        }

        public NavigationTreeNode addGroup(JAXXContext context, NavigationTreeNode node, Group group) {
            if (group == null) {
                group = new GroupImpl();
                group.setName(I18n._((String)NEW_GROUP_NAME));
            }
            VradiContext.addIfNecessary(VradiContext.getGroupsEntryDef(), group);
            return this.addGroup(node, group);
        }

        public NavigationTreeNode addGroup(NavigationTreeNode node, Group group) {
            NavigationTreeNode result = (NavigationTreeNode)this.build((NavigationNode)this.getGroupCategoryNode(node), this.getDecorator(Group.class), "..[@wikittyId=\"" + group.getWikittyId() + "\"]", group.getWikittyId(), AdminGroupUI.class, null);
            AdminNavigationTreeHelper.this.sort(result);
            this.fillGroupNode(group, result);
            return result;
        }

        public void fillGroupNode(Group g, NavigationTreeNode groupNode) {
            Set clientsId;
            JAXXContextEntryDef<List<User>> usersEntryDef = VradiContext.getUsersEntryDef();
            NavigationTreeNode usersNode = (NavigationTreeNode)this.build((NavigationNode)groupNode, I18n._((String)usersEntryDef.getName()), usersEntryDef, "users", AdminUserUI.class, null);
            JAXXContextEntryDef<List<Client>> clientsEntryDef = VradiContext.getClientsEntryDef();
            NavigationTreeNode clientsNode = (NavigationTreeNode)this.build((NavigationNode)groupNode, I18n._((String)clientsEntryDef.getName()), clientsEntryDef, "clients", AdminClientUI.class, null);
            Set usersId = g.getUser();
            if (usersId != null) {
                for (String userId : usersId) {
                    log.debug((Object)("add user " + userId + " to group " + g.getName()));
                    this.addUser(usersNode, userId);
                }
            }
            if ((clientsId = g.getClient()) != null) {
                for (String clientId : clientsId) {
                    log.debug((Object)("add client " + clientId + " to group " + g.getName()));
                    this.addClient(clientsNode, clientId);
                }
            }
        }

        public NavigationTreeNode addStatus(JAXXContext context, NavigationTreeNode selectedNode, Status status) {
            if (status == null) {
                status = new StatusImpl();
                status.setName(I18n._((String)NEW_STATUS_NAME));
            }
            VradiContext.addIfNecessary(VradiContext.getStatusEntryDef(), status);
            return this.addStatus(selectedNode, status.getWikittyId());
        }

        public NavigationTreeNode addStatus(NavigationTreeNode selectedNode, String id) {
            NavigationTreeNode result = (NavigationTreeNode)this.build((NavigationNode)this.getStatusCategoryNode(selectedNode), this.getDecorator(Status.class), "..[@wikittyId=\"" + id + "\"]", id, AdminStatusUI.class, null);
            AdminNavigationTreeHelper.this.sort(result);
            return result;
        }

        public NavigationTreeNode addForm(JAXXContext context, NavigationTreeNode selectedNode, WikittyExtension form) {
            VradiContext.addIfNecessary(VradiContext.getFormsTypeEntryDef(), form);
            if (form != null) {
                return this.addForm(selectedNode, form.getId());
            }
            return null;
        }

        public NavigationTreeNode addForm(NavigationTreeNode selectedNode, String id) {
            NavigationTreeNode result = (NavigationTreeNode)this.build((NavigationNode)this.getFormCategoryNode(selectedNode), this.getDecorator(WikittyExtension.class), "..[@id=\"" + id + "\"]", id, AdminFormTypeUI.class, null);
            AdminNavigationTreeHelper.this.sort(result);
            return result;
        }

        public NavigationTreeNode addXmlStream(JAXXContext context, NavigationTreeNode selectedNode, XmlStream xml) {
            if (xml == null) {
                xml = new XmlStreamImpl();
                xml.setName(I18n._((String)NEW_XMLSTREAM_NAME));
            }
            VradiContext.addIfNecessary(VradiContext.getXmlStreamEntryDef(), xml);
            return this.addXmlStream(selectedNode, xml.getWikittyId());
        }

        public NavigationTreeNode addXmlStream(NavigationTreeNode selectedNode, String id) {
            NavigationTreeNode result = (NavigationTreeNode)this.build((NavigationNode)this.getXmlStreamCategoryNode(selectedNode), this.getDecorator(XmlStream.class), "..[@wikittyId=\"" + id + "\"]", id, AdminXmlStreamUI.class, null);
            AdminNavigationTreeHelper.this.sort(result);
            return result;
        }

        public NavigationTreeNode getParentClientNode(NavigationTreeNode current) {
            NavigationTreeNode node = (NavigationTreeNode)AdminNavigationTreeHelper.this.getParentNode((NavigationNode)current, Client.class);
            return node;
        }

        public NavigationTreeNode getParentGroupNode(NavigationTreeNode current) {
            NavigationTreeNode node = (NavigationTreeNode)AdminNavigationTreeHelper.this.getParentNode((NavigationNode)current, Group.class);
            return node;
        }

        protected NavigationTreeNode getCategoryNode(NavigationTreeNode current, String categoryName) {
            NavigationTreeNode result = this.getChildCategoryNode(current, categoryName);
            if (result == null) {
                result = this.getParentCategoryNode(current, categoryName);
            }
            if (log.isDebugEnabled()) {
                if (result != null) {
                    log.debug((Object)("Find category [" + categoryName + "] node " + result.getFullPath()));
                } else {
                    log.debug((Object)("Cant find category [" + categoryName + "] node"));
                }
            }
            return result;
        }

        protected NavigationTreeNode getChildCategoryNode(NavigationTreeNode current, String categoryName) {
            if (current.getNodePath().equals(categoryName)) {
                return current;
            }
            Enumeration e = current.children();
            if (e.hasMoreElements()) {
                NavigationTreeNode child = (NavigationTreeNode)e.nextElement();
                return child == null ? null : this.getChildCategoryNode(child, categoryName);
            }
            return null;
        }

        protected NavigationTreeNode getParentCategoryNode(NavigationTreeNode current, String categoryName) {
            if (current.getNodePath().equals(categoryName)) {
                return current;
            }
            return current.getParent() == null ? null : this.getParentCategoryNode(current.getParent(), categoryName);
        }

        protected NavigationTreeNode getClientCategoryNode(NavigationTreeNode current) {
            return this.getCategoryNode(current, "clients");
        }

        protected NavigationTreeNode getUserCategoryNode(NavigationTreeNode current) {
            return this.getCategoryNode(current, "users");
        }

        protected NavigationTreeNode getGroupCategoryNode(NavigationTreeNode current) {
            return this.getCategoryNode(current, "groups");
        }

        protected NavigationTreeNode getStatusCategoryNode(NavigationTreeNode current) {
            return this.getCategoryNode(current, "statuses");
        }

        protected NavigationTreeNode getFormCategoryNode(NavigationTreeNode current) {
            return this.getCategoryNode(current, "forms");
        }

        protected NavigationTreeNode getXmlStreamCategoryNode(NavigationTreeNode current) {
            return this.getCategoryNode(current, "xmlStreams");
        }

        protected boolean isGroupNavigationTree(NavigationTreeNode current) {
            return current.getFullPath().matches("^\\$root\\/groups\\/.*$");
        }
    }
}

