/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.email;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.VradiService;
import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.QueryMaker;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.Session;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.services.MailingService;
import com.jurismarches.vradi.services.ServiceFactory;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.services.dto.VradiClientDTO;
import com.jurismarches.vradi.services.dto.VradiFormDTO;
import com.jurismarches.vradi.services.dto.VradiFormPageDTO;
import com.jurismarches.vradi.services.dto.VradiGroupDTO;
import com.jurismarches.vradi.services.dto.VradiSendingDTO;
import com.jurismarches.vradi.services.dto.VradiSessionDTO;
import com.jurismarches.vradi.services.dto.VradiUserDTO;
import com.jurismarches.vradi.ui.AbstractProgressBarUI;
import com.jurismarches.vradi.ui.OfferListColumnFactory;
import com.jurismarches.vradi.ui.OfferListHandler;
import com.jurismarches.vradi.ui.OfferTable;
import com.jurismarches.vradi.ui.VradiMainUI;
import com.jurismarches.vradi.ui.VradiTask;
import com.jurismarches.vradi.ui.email.EmailPopupUI;
import com.jurismarches.vradi.ui.email.QueryMakerViewUI;
import com.jurismarches.vradi.ui.email.SessionViewUI;
import com.jurismarches.vradi.ui.email.SessionsListUI;
import com.jurismarches.vradi.ui.helpers.EmailNavigationTreeHelper;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.models.OfferListTableModel;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.navigation.tree.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.nuiton.i18n.I18n;
import org.sharengo.wikitty.BusinessEntity;
import org.sharengo.wikitty.WikittyExtension;

public class EmailHandler {
    private static final Log log = LogFactory.getLog(EmailHandler.class);

    public EmailPopupUI init(JAXXContext rootContext, Object ... datas) {
        EmailPopupUI ui = (EmailPopupUI)VradiContext.EMAIL_UI_ENTRY_DEF.getContextValue(rootContext);
        if (ui == null) {
            JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext).add((Object)this);
            VradiMainUI mainUI = (VradiMainUI)VradiContext.MAIN_UI_ENTRY_DEF.getContextValue((JAXXContext)context);
            ui = new EmailPopupUI((JAXXContext)context);
            VradiContext.EMAIL_UI_ENTRY_DEF.setContextValue(rootContext, (Object)ui);
        }
        return ui;
    }

    public EmailPopupUI getUI(JAXXContext context) {
        if (context instanceof EmailPopupUI) {
            return (EmailPopupUI)context;
        }
        EmailPopupUI ui = (EmailPopupUI)VradiContext.EMAIL_UI_ENTRY_DEF.getContextValue(context);
        return ui;
    }

    public SessionsListUI getSessionsListUI(JAXXContext context) {
        if (context instanceof SessionsListUI) {
            return (SessionsListUI)context;
        }
        return (SessionsListUI)context.getContextValue(SessionsListUI.class);
    }

    void close(JAXXContext context) {
        EmailPopupUI ui = this.getUI(context);
        ui.setVisible(false);
        ui.dispose();
    }

    protected VradiStorageService getVradiStorageService() {
        return VradiService.getVradiStorageService();
    }

    protected MailingService getMailingService() {
        return VradiService.getMailingService();
    }

    public List<VradiSessionDTO> getSessions(Date date) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getSessions for date : " + date));
        }
        List sessions = null;
        try {
            sessions = this.getVradiStorageService().getSessions(date);
        }
        catch (VradiException eee) {
            log.error((Object)eee);
            ErrorDialogUI.showError((Exception)((Object)eee));
        }
        VradiContext.addAllSessionEntryDef(sessions);
        List<VradiSessionDTO> result = this.fillSessionsDTO(sessions);
        return result;
    }

    protected List<VradiSessionDTO> fillSessionsDTO(List<Session> sessions) {
        ArrayList<VradiSessionDTO> sessionDTOs = new ArrayList<VradiSessionDTO>();
        for (Session session : sessions) {
            sessionDTOs.add(this.fillSessionDTO(session));
        }
        return sessionDTOs;
    }

    protected VradiSessionDTO fillSessionDTO(Session session) {
        Set sendingList;
        VradiSessionDTO sessionDTO = new VradiSessionDTO();
        sessionDTO.fromWikitty(session);
        if (sessionDTO.getParagraph() == null) {
            String paragraph = ServiceFactory.getServiceConfiguration().getSessionDefaultParagraph();
            sessionDTO.setParagraph(paragraph);
            this.updateSession(sessionDTO);
        }
        if ((sendingList = session.getSending()) != null) {
            List sendings = null;
            try {
                sendings = this.getVradiStorageService().getEntities(new ArrayList(sendingList), Sending.class);
                VradiContext.addAllSendingInEntryDef(sendings);
            }
            catch (VradiException eee) {
                log.error((Object)("Cant restore sendings" + (Object)((Object)eee)));
            }
            for (Sending sending : sendings) {
                VradiSendingDTO sendingDTO = new VradiSendingDTO();
                sendingDTO.fromWikitty(sending);
                sendingDTO.setSessionDTO(sessionDTO);
                sessionDTO.addSending(sendingDTO);
            }
            for (VradiSendingDTO sendingDTO : new ArrayList(sessionDTO.getSendingList())) {
                String groupId;
                String userId;
                this.fillForms(sendingDTO);
                String clientId = sendingDTO.getClient();
                if (clientId != null) {
                    Client client = VradiHelper.findEntityInRef(VradiContext.getClientsEntryDef(), clientId);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Found client " + (client == null ? "none" : client.getName()) + " in ref with id " + sendingDTO.getClient()));
                    }
                    if (client == null) {
                        sessionDTO.removeSending(sendingDTO);
                        log.warn((Object)("User with id " + clientId + " not found !"));
                        break;
                    }
                    VradiClientDTO clientDTO = new VradiClientDTO();
                    clientDTO.fromWikitty(client);
                    clientDTO.setCurrentSending(sendingDTO);
                    this.fillClientDTO(sessionDTO, clientDTO);
                    sendingDTO.setClientDTO(clientDTO);
                }
                if ((userId = sendingDTO.getUser()) != null) {
                    User user = VradiHelper.findEntityInRef(VradiContext.getUsersEntryDef(), userId);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Found user " + (user == null ? "none" : user.getName()) + " in ref with id " + sendingDTO.getUser()));
                    }
                    if (user == null) {
                        sessionDTO.removeSending(sendingDTO);
                        log.warn((Object)("User with id " + userId + " not found !"));
                        break;
                    }
                    VradiUserDTO userDTO = new VradiUserDTO();
                    userDTO.fromWikitty(user);
                    userDTO.setCurrentSending(sendingDTO);
                    Client client = VradiHelper.findEntityInRef(VradiContext.getClientsEntryDef(), user.getClient());
                    if (client != null) {
                        userDTO.setClientName(client.getName());
                    }
                    sendingDTO.setUserDTO(userDTO);
                    sendingDTO.setReceptionProof(!userDTO.getValidEmail());
                    this.updateSending(sendingDTO);
                }
                if ((groupId = sendingDTO.getGroup()) == null) continue;
                Group group = VradiHelper.findEntityInRef(VradiContext.getGroupsEntryDef(), groupId);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found group " + (group == null ? "none" : group.getName()) + " in ref with id " + sendingDTO.getGroup()));
                }
                if (group == null) {
                    sessionDTO.removeSending(sendingDTO);
                    log.warn((Object)("User with id " + groupId + " not found !"));
                    break;
                }
                VradiGroupDTO groupDTO = new VradiGroupDTO();
                groupDTO.fromWikitty(group);
                groupDTO.setCurrentSending(sendingDTO);
                this.fillGroupDTO(sessionDTO, groupDTO);
                sendingDTO.setGroupDTO(groupDTO);
            }
        }
        return sessionDTO;
    }

    protected void fillForms(VradiSendingDTO sending) {
        ArrayList<VradiFormDTO> formsDTO = new ArrayList<VradiFormDTO>();
        for (String formId : sending.getForm()) {
            Form form = null;
            try {
                form = (Form)this.getVradiStorageService().getEntity(formId, Form.class);
            }
            catch (VradiException eee) {
                log.error((Object)("Cant restore forms" + (Object)((Object)eee)));
            }
            VradiFormDTO formDTO = new VradiFormDTO();
            formDTO.fromWikitty(form);
            VradiContext.addFormInEntryDef(form);
            VradiContext.addFormDTOInEntryDef(formDTO);
            formDTO.addSendingDTO(sending);
            formsDTO.add(formDTO);
        }
        sending.setFormDTOs(formsDTO);
    }

    protected void fillGroupDTO(VradiSessionDTO session, VradiGroupDTO group) {
        ArrayList<VradiClientDTO> clientsDTO = new ArrayList<VradiClientDTO>();
        for (String c : group.getClient()) {
            for (VradiSendingDTO sending : session.getSendingList()) {
                if (!c.equals(sending.getClient())) continue;
                Client client = VradiHelper.findEntityInRef(VradiContext.getClientsEntryDef(), c);
                VradiClientDTO clientDTO = new VradiClientDTO();
                clientDTO.fromWikitty(client);
                this.fillForms(sending);
                clientDTO.setCurrentSending(sending);
                clientsDTO.add(clientDTO);
                this.fillClientDTO(session, clientDTO);
            }
        }
        group.setClientsDTO(clientsDTO);
        ArrayList<VradiUserDTO> usersDTO = new ArrayList<VradiUserDTO>();
        for (String u : group.getUser()) {
            for (VradiSendingDTO sending : session.getSendingList()) {
                if (!u.equals(sending.getUser())) continue;
                User user = VradiHelper.findEntityInRef(VradiContext.getUsersEntryDef(), u);
                VradiUserDTO userDTO = new VradiUserDTO();
                userDTO.fromWikitty(user);
                this.fillForms(sending);
                userDTO.setCurrentSending(sending);
                Client client = VradiHelper.findEntityInRef(VradiContext.getClientsEntryDef(), user.getClient());
                if (client != null) {
                    userDTO.setClientName(client.getName());
                }
                usersDTO.add(userDTO);
            }
        }
        group.setUsersDTO(usersDTO);
    }

    protected void fillClientDTO(VradiSessionDTO session, VradiClientDTO client) {
        ArrayList<VradiUserDTO> usersDTO = new ArrayList<VradiUserDTO>();
        List<User> users = this.getUsersForClient(client);
        for (User user : users) {
            for (VradiSendingDTO sending : session.getSendingList()) {
                if (!user.getWikittyId().equals(sending.getUser())) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Client " + client.getName() + " have user : " + user.getName()));
                }
                VradiUserDTO userDTO = new VradiUserDTO();
                userDTO.fromWikitty(user);
                this.fillForms(sending);
                userDTO.setCurrentSending(sending);
                userDTO.setClientName(client.getName());
                usersDTO.add(userDTO);
            }
        }
        client.setUsersDTO(usersDTO);
    }

    public void bindEmailsWithForms(final EmailPopupUI ui) {
        VradiTask<Void> task = new VradiTask<Void>((JAXXContext)ui){

            @Override
            public Void doAction() throws Exception {
                EmailHandler.this.getVradiStorageService().bindForms();
                return null;
            }

            @Override
            public void doWhenDone() throws Exception {
                EmailHandler.this.reloadTree(ui);
            }
        };
        task.execute();
    }

    public List<Form> extractFormsFromSending(VradiSendingDTO sendingDTO) {
        ArrayList<Form> forms = new ArrayList<Form>();
        for (VradiFormDTO formsDTO : sendingDTO.getFormDTOs()) {
            forms.add(VradiContext.findFormsInEntryDef(formsDTO.getWikittyId()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("display " + forms.size() + " forms"));
        }
        return forms;
    }

    public void displaySessions(JAXXContext context, EmailNavigationTreeHelper helper, NavigationTreeNode node) {
        SessionsListUI ui = this.getSessionsListUI(context);
        List<VradiSendingDTO> sendings = helper.getSendingToDisplay(node);
        if (log.isDebugEnabled()) {
            log.debug((Object)(sendings.size() + " sendings to display"));
        }
        ui.getContent().removeAll();
        for (VradiSendingDTO sending : sendings) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sending displayed : " + sending));
            }
            List<Form> forms = this.extractFormsFromSending(sending);
            OfferListTableModel offerListTableModel = new OfferListTableModel(true);
            OfferListColumnFactory offerListColumnFactory = new OfferListColumnFactory();
            JAXXInitialContext initContext = new JAXXInitialContext().add((Object)context).add((Object)this).add((Object)sending).add((Object)offerListTableModel).add((Object)offerListColumnFactory);
            SessionViewUI viewUI = new SessionViewUI((JAXXContext)initContext);
            ui.getContent().add(viewUI);
            OfferListTableModel.OfferListTableCellRenderer renderer = new OfferListTableModel.OfferListTableCellRenderer();
            OfferTable listTable = viewUI.getListTable();
            OfferListTableModel listTableModel = (OfferListTableModel)listTable.getModel();
            VradiFormPageDTO formPageDTO = new VradiFormPageDTO();
            formPageDTO.setFormsToShow(forms);
            listTableModel.setFormPageDTO(formPageDTO);
            listTable.setModel(listTableModel);
            listTable.setDefaultRenderer(Boolean.class, renderer);
            listTable.setDefaultRenderer(Date.class, renderer);
            listTable.setDefaultRenderer(Double.class, renderer);
            listTable.setDefaultRenderer(String.class, renderer);
            Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)HighlighterFactory.NOTEPAD, (Color)HighlighterFactory.GENERIC_GRAY);
            MouseListener offerListTableMouseListener = UIHelper.getHandler(context, OfferListHandler.class).getOfferListTableMouseListener();
            listTable.addMouseListener(offerListTableMouseListener);
            listTable.addHighlighter(highlighter);
        }
    }

    public void displayForm(JAXXContext context, EmailNavigationTreeHelper helper, NavigationTreeNode node) {
        VradiSessionDTO session = (VradiSessionDTO)node.getParent().getBean(context);
        context.setContextValue((Object)session);
        context.setContextValue(node.getBean(context));
    }

    public <E extends QueryMaker> void addQueryMaker(QueryMakerViewUI<E> queryMakerViewUI, Map<E, VradiSendingDTO> beans, VradiSessionDTO sessionDTO, VradiFormDTO form, E selected) {
        int yes = JOptionPane.showConfirmDialog(queryMakerViewUI, I18n._((String)"vradi.email.confirmAdd", (Object[])new Object[]{form.getObjet()}), I18n._((String)"vradi.email.confirmAddTitle"), 0);
        if (yes == 0) {
            ArrayList<VradiFormDTO> formsToBind = new ArrayList<VradiFormDTO>();
            formsToBind.add(form);
            QueryMaker bean = this.getRealQueryMaker(selected);
            List<VradiSessionDTO> sessionsDTO = VradiContext.getSessionsDTOInEntryDef();
            List<Session> sessions = VradiContext.getSessionsInEntryDef();
            sessionsDTO.remove(sessionDTO);
            Session sessionConcerned = VradiContext.findSessionInEntryDef(sessionDTO.getWikittyId());
            sessions.remove(sessionConcerned);
            try {
                List sendings = this.getVradiStorageService().createSending(sessionConcerned, bean, formsToBind);
                VradiContext.addAllSendingInEntryDef(sendings);
                sessionConcerned = (Session)this.getVradiStorageService().getEntity(sessionConcerned.getWikittyId(), Session.class);
            }
            catch (VradiException eee) {
                ErrorDialogUI.showError((Exception)((Object)eee));
                log.error((Object)("Cant add sending : " + (Object)((Object)eee)));
            }
            sessionDTO = this.fillSessionDTO(sessionConcerned);
            sessionsDTO.add(sessionDTO);
            VradiContext.setSessionDTOEntryDef(sessionsDTO);
            sessions.add(sessionConcerned);
            VradiContext.setSessionEntryDef(sessions);
            this.reloadTree(queryMakerViewUI.getParentContainer(EmailPopupUI.class));
        }
    }

    public <E extends QueryMaker> void removeQueryMaker(QueryMakerViewUI<E> queryMakerViewUI, Map<E, VradiSendingDTO> beans, VradiSessionDTO sessionDTO, VradiFormDTO formDTO, VradiSendingDTO selected) {
        int yes = JOptionPane.showConfirmDialog(queryMakerViewUI, I18n._((String)"vradi.email.confirmDelete", (Object[])new Object[]{formDTO.getObjet()}), I18n._((String)"vradi.email.confirmDeleteTitle"), 0);
        if (yes == 0) {
            QueryMaker queryMaker = null;
            for (QueryMaker key : beans.keySet()) {
                if (!beans.get(key).equals(selected)) continue;
                queryMaker = key;
                break;
            }
            Form form = VradiContext.findFormsInEntryDef(formDTO.getWikittyId());
            List<Session> sessions = VradiContext.getSessionsInEntryDef();
            List<VradiSessionDTO> sessionsDTO = VradiContext.getSessionsDTOInEntryDef();
            sessionsDTO.remove(sessionDTO);
            Session session = VradiContext.findSessionInEntryDef(sessionDTO.getWikittyId());
            sessions.remove(session);
            try {
                List sendings = this.getVradiStorageService().removeAllSending(session, form, this.getRealQueryMaker(queryMaker));
                VradiContext.addAllSendingInEntryDef(sendings);
            }
            catch (VradiException eee) {
                ErrorDialogUI.showError((Exception)((Object)eee));
                log.error((Object)("Cant add sending : " + (Object)((Object)eee)));
            }
            sessionDTO = this.fillSessionDTO(session);
            sessionsDTO.add(sessionDTO);
            sessions.add(session);
            VradiContext.setSessionEntryDef(sessions);
            VradiContext.setSessionDTOEntryDef(sessionsDTO);
            this.reloadTree(queryMakerViewUI.getParentContainer(EmailPopupUI.class));
        }
    }

    protected void reloadTree(EmailPopupUI ui) {
        EmailNavigationTreeHelper helper = ui.getHelper();
        String path = helper.getSelectedPath((JAXXContext)ui);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Select path : " + path));
        }
        ui.updateTree();
        if (path != null) {
            helper.selectNode((JAXXContext)ui, path);
        }
    }

    protected <E extends QueryMaker> QueryMaker getRealQueryMaker(E toConvert) {
        String wikittyId = toConvert.getWikittyId();
        QueryMaker converted = (QueryMaker)VradiHelper.findEntityInRef(VradiContext.getClientsEntryDef(), wikittyId);
        if (converted == null) {
            converted = (QueryMaker)VradiHelper.findEntityInRef(VradiContext.getUsersEntryDef(), wikittyId);
        }
        if (converted == null) {
            converted = (QueryMaker)VradiHelper.findEntityInRef(VradiContext.getGroupsEntryDef(), wikittyId);
        }
        return converted;
    }

    public List<VradiClientDTO> getAllClients() {
        ArrayList<VradiClientDTO> result = new ArrayList<VradiClientDTO>();
        List<Client> allClients = VradiContext.getClientsInEntryDef();
        for (Client c : allClients) {
            VradiClientDTO dto = new VradiClientDTO();
            dto.fromWikitty(c);
            result.add(dto);
        }
        return result;
    }

    public List<User> getUsersForClient(VradiClientDTO client) {
        ArrayList<User> result = new ArrayList<User>();
        List<User> allUsers = VradiContext.getUsersInEntryDef();
        for (User user : allUsers) {
            if (!user.getClient().equals(client.getWikittyId())) continue;
            result.add(user);
        }
        return result;
    }

    public List<VradiUserDTO> getAllUsers() {
        ArrayList<VradiUserDTO> result = new ArrayList<VradiUserDTO>();
        List<User> allUsers = VradiContext.getUsersInEntryDef();
        for (User u : allUsers) {
            VradiUserDTO dto = new VradiUserDTO();
            dto.fromWikitty(u);
            Client client = VradiHelper.findEntityInRef(VradiContext.getClientsEntryDef(), u.getClient());
            if (client != null) {
                dto.setClientName(client.getName());
            }
            result.add(dto);
        }
        return result;
    }

    public List<VradiGroupDTO> getAllGroups() {
        ArrayList<VradiGroupDTO> result = new ArrayList<VradiGroupDTO>();
        List<Group> allGroups = VradiContext.getGroupsInEntryDef();
        for (Group g : allGroups) {
            VradiGroupDTO dto = new VradiGroupDTO();
            dto.fromWikitty(g);
            result.add(dto);
        }
        return result;
    }

    public void sendSending(SessionViewUI ui, final VradiSendingDTO sendingDTO) {
        Object[] options = new Object[]{I18n._((String)"vradi.email.confirmSendSending.optionYes"), I18n._((String)"vradi.email.confirmSendSending.optionNo"), I18n._((String)"vradi.email.confirmSendSending.optionOtherMail")};
        int i = JOptionPane.showOptionDialog(ui, I18n._((String)"vradi.email.confirmSendSending", (Object[])new Object[]{this.getQueryMakerName(sendingDTO)}), I18n._((String)"vradi.email.confirmSendSendingTitle"), 1, 3, null, options, options[2]);
        String email = null;
        if (i == 2) {
            email = JOptionPane.showInputDialog(ui, I18n._((String)"vradi.email.confirmSendSending.askMail"), I18n._((String)"vradi.email.confirmSendSending.askMailTitle"), -1);
            i = 0;
        }
        if (i == 0) {
            VradiSessionDTO session = sendingDTO.getSessionDTO();
            final String sessionParagraph = session.getParagraph();
            final String finalEmail = email;
            final EmailPopupUI finalUI = ui.getParentContainer(EmailPopupUI.class);
            VradiTask<Void> sendSendingTask = new VradiTask<Void>((JAXXContext)ui, "vradi.email.sendSending"){

                @Override
                public Void doAction() throws VradiException {
                    Sending sending = VradiContext.findSendingInEntryDef(sendingDTO.getWikittyId());
                    List<Sending> sendings = VradiContext.getSendingInEntryDef();
                    sendings.remove(sending);
                    try {
                        sending = EmailHandler.this.getMailingService().sendMessage(sending, sessionParagraph, finalEmail);
                    }
                    catch (VradiException eee) {
                        JOptionPane.showMessageDialog(finalUI, I18n._((String)"vradi.email.sendSending.sendError", (Object[])new Object[]{eee.getMessage()}), I18n._((String)"vradi.email.sendSession.error"), 0);
                        sendingDTO.setStatus(VradiConstants.SendingStatus.ERROR.getValue());
                        EmailHandler.this.updateSending(sendingDTO);
                        EmailHandler.this.reloadTree(finalUI);
                    }
                    sendings.add(sending);
                    VradiContext.setSendingEntryDef(sendings);
                    return null;
                }

                @Override
                public void doWhenError(Exception eee) {
                    sendingDTO.setStatus(VradiConstants.SendingStatus.ERROR.getValue());
                    EmailHandler.this.updateSending(sendingDTO);
                    EmailHandler.this.reloadTree(finalUI);
                }

                @Override
                public void doWhenDone() throws Exception {
                    EmailHandler.this.reloadTree(finalUI);
                }
            };
            sendSendingTask.execute();
        }
    }

    public boolean send(final EmailPopupUI ui) {
        final VradiSessionDTO sessionDTO = ui.getHelper().getActiveSession();
        int confirm = JOptionPane.showConfirmDialog(ui, I18n._((String)"vradi.email.confirmSendSession"), I18n._((String)"vradi.email.confirmSendSessionTitle"), 0, 3);
        if (confirm != 0) {
            return false;
        }
        if (!this.checkAllSending(ui, sessionDTO)) {
            return false;
        }
        final Session session = VradiContext.findSessionInEntryDef(sessionDTO.getWikittyId());
        AbstractProgressBarUI pb = new AbstractProgressBarUI((JAXXContext)ui){
            private static final long serialVersionUID = 5926558779822425487L;

            @Override
            public void cancel() {
                try {
                    List<Session> sessions = VradiContext.getSessionsInEntryDef();
                    sessions.remove(session);
                    sessions.add(EmailHandler.this.getMailingService().stopSentMail(session));
                    VradiContext.setSessionEntryDef(sessions);
                    this.dispose();
                }
                catch (VradiException eee) {
                    log.info((Object)"Cant stop sending emails : ", (Throwable)eee);
                    ErrorDialogUI.showError((Exception)((Object)eee));
                }
                ui.setCursor(Cursor.getPredefinedCursor(0));
            }
        };
        if (log.isInfoEnabled()) {
            SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy");
            log.info((Object)("Sending session : " + sessionDTO.getNum() + " - " + format.format(sessionDTO.getSessionDate()) + " status : " + VradiConstants.SessionStatus.getStatus((int)sessionDTO.getStatus()).getDescription()));
        }
        final ArrayList<Sending> sendings = new ArrayList<Sending>();
        final ArrayList<Form> forms = new ArrayList<Form>();
        for (VradiSendingDTO sendingDTO : sessionDTO.getSendingList()) {
            Sending sending = VradiContext.findSendingInEntryDef(sendingDTO.getWikittyId());
            sendings.add(sending);
            forms.addAll(VradiContext.findAllFormsInEntryDef(sendingDTO.getFormDTOs()));
        }
        VradiTask<Boolean> pdfGenerationAndSendingTask = new VradiTask<Boolean>((JAXXContext)ui, pb, "vradi.email.generation"){

            @Override
            public Boolean doAction() throws Exception {
                try {
                    VradiHelper.generatePDF(EmailHandler.this.getVradiStorageService(), forms);
                }
                catch (Exception eee) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)this.getErrorMsg(), (Throwable)eee);
                    }
                    this.doWhenError(eee);
                    ErrorDialogUI.showError((Exception)eee);
                    return false;
                }
                return true;
            }

            @Override
            public void doWhenDone() throws Exception {
                Boolean result = (Boolean)this.get();
                if (result != null && result.booleanValue()) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Start sending mails");
                    }
                    VradiTask<Void> sentTask = new VradiTask<Void>((JAXXContext)ui, this.pb, "vradi.email.sendSession"){

                        @Override
                        public Void doAction() throws Exception {
                            List<Session> sessions = VradiContext.getSessionsInEntryDef();
                            sessions.remove(session);
                            try {
                                sessions.add(EmailHandler.this.getMailingService().sendMessages(session, sendings));
                            }
                            catch (VradiException eee) {
                                JOptionPane.showMessageDialog(ui, I18n._((String)"vradi.email.sendSending.sendError", (Object[])new Object[]{eee.getMessage()}), I18n._((String)"vradi.email.sendSession.error"), 0);
                                EmailHandler.this.updateSessionStatus(sessionDTO, VradiConstants.SessionStatus.ERROR);
                                EmailHandler.this.reloadTree(ui);
                            }
                            VradiContext.setSessionEntryDef(sessions);
                            return null;
                        }

                        @Override
                        public void doWhenDone() throws Exception {
                            EmailHandler.this.reloadTree(ui);
                        }

                        @Override
                        public void doWhenError(Exception eee) {
                            EmailHandler.this.updateSessionStatus(sessionDTO, VradiConstants.SessionStatus.ERROR);
                            EmailHandler.this.reloadTree(ui);
                        }
                    };
                    sentTask.execute();
                }
            }

            @Override
            public void doWhenError(Exception eee) {
                EmailHandler.this.updateSessionStatus(sessionDTO, VradiConstants.SessionStatus.ERROR);
                EmailHandler.this.reloadTree(ui);
            }
        };
        pdfGenerationAndSendingTask.execute();
        return true;
    }

    protected boolean checkAllSending(EmailPopupUI ui, VradiSessionDTO sessionDTO) {
        ArrayList<String> alreadyAskFormType = new ArrayList<String>();
        for (VradiSendingDTO sending : sessionDTO.getSendingList()) {
            User user;
            String emailUser;
            VradiUserDTO userDTO = sending.getUserDTO();
            if (userDTO != null && ((emailUser = (user = VradiHelper.findEntityInRef(VradiContext.getUsersEntryDef(), userDTO.getWikittyId())).getEmail()) == null || emailUser.isEmpty())) {
                boolean abord = this.askAbordSending(ui, I18n._((String)"vradi.email.askUserEmailEmpty", (Object[])new Object[]{user.getName(), userDTO.getClientName()}));
                if (abord) {
                    return false;
                }
                sending.setStatus(VradiConstants.SendingStatus.ERROR.getValue());
                this.updateSending(sending);
                break;
            }
            for (VradiFormDTO formDTO : sending.getFormDTOs()) {
                String template;
                File file;
                Form form = VradiContext.findFormsInEntryDef(formDTO.getWikittyId());
                String extensionName = null;
                for (String ext : form.getExtensionNames()) {
                    if (ext.equals("Infogene") || ext.equals("Form")) continue;
                    extensionName = ext;
                    break;
                }
                VradiStorageService storageService = VradiService.getVradiStorageService();
                WikittyExtension extension = null;
                try {
                    extension = storageService.getFormType(extensionName);
                }
                catch (VradiException eee) {
                    log.error((Object)("Cant get formType for form " + formDTO.getObjet() + " with extention : " + extensionName), (Throwable)eee);
                    ErrorDialogUI.showError((Exception)((Object)eee));
                }
                if ((file = storageService.getTemplate(extensionName, template = VradiHelper.getFormTypeTemplate(extension))) != null && file.exists() || alreadyAskFormType.contains(extension.getName())) continue;
                boolean abord = this.askAbordSending(ui, I18n._((String)"vradi.email.askModelEmpty", (Object[])new Object[]{extension.getName()}));
                if (abord) {
                    return false;
                }
                alreadyAskFormType.add(extension.getName());
            }
        }
        return true;
    }

    protected boolean askAbordSending(EmailPopupUI ui, String msg) {
        int i = JOptionPane.showConfirmDialog(ui, msg, I18n._((String)"vradi.email.askAbordSendingTitle"), 0);
        return i != 0;
    }

    public void updateSessionStatus(VradiSessionDTO sessionDTO, VradiConstants.SessionStatus status) {
        sessionDTO.setStatus(status.getValue());
        sessionDTO.setSessionDate(new Date());
        this.updateSession(sessionDTO);
    }

    public void updateSession(VradiSessionDTO sessionDTO) {
        Session session = VradiContext.findSessionInEntryDef(sessionDTO.getWikittyId());
        List<Session> sessions = VradiContext.getSessionsInEntryDef();
        sessions.remove(session);
        sessionDTO.toWikitty(session);
        try {
            session = (Session)this.getVradiStorageService().updateEntity((BusinessEntity)session);
        }
        catch (VradiException eee) {
            log.error((Object)"Cant save session : ", (Throwable)eee);
            ErrorDialogUI.showError((Exception)((Object)eee));
        }
        sessions.add(session);
        VradiContext.setSessionEntryDef(sessions);
    }

    public void updateSending(VradiSendingDTO sendingDTO) {
        Sending sending = VradiContext.findSendingInEntryDef(sendingDTO.getWikittyId());
        List<Sending> sendings = VradiContext.getSendingInEntryDef();
        sendings.remove(sending);
        sendingDTO.toWikitty(sending);
        try {
            sending = (Sending)this.getVradiStorageService().updateEntity((BusinessEntity)sending);
        }
        catch (VradiException eee) {
            log.error((Object)"Cant save session : ", (Throwable)eee);
            ErrorDialogUI.showError((Exception)((Object)eee));
        }
        sendings.add(sending);
        VradiContext.setSendingEntryDef(sendings);
    }

    protected String getQueryMakerName(VradiSendingDTO sendingDTO) {
        if (sendingDTO.getClientDTO() != null) {
            return sendingDTO.getClientDTO().getName();
        }
        if (sendingDTO.getUserDTO() != null) {
            return sendingDTO.getUserDTO().getName();
        }
        if (sendingDTO.getGroupDTO() != null) {
            return sendingDTO.getGroupDTO().getName();
        }
        return "";
    }

    public void closeSession(EmailPopupUI ui) {
        int i;
        VradiSessionDTO session = ui.getHelper().getActiveSession();
        if (session != null && (i = JOptionPane.showConfirmDialog(ui, I18n._((String)"vradi.email.confimCloseSession"), I18n._((String)"vradi.email.confimCloseSession.titles"), 0)) == 0) {
            session.setStatus(VradiConstants.SessionStatus.CLOSE.getValue());
            this.updateSession(session);
            this.reloadTree(ui);
        }
    }

    public void updateReceptionProof(VradiSendingDTO sending, boolean isSelected) {
        VradiGroupDTO group;
        sending.setReceptionProof(isSelected);
        VradiClientDTO client = sending.getClientDTO();
        if (client != null) {
            for (VradiUserDTO user : client.getUsersDTO()) {
                this.updateReceptionProof(user.getCurrentSending(), isSelected);
            }
        }
        if ((group = sending.getGroupDTO()) != null) {
            for (VradiUserDTO user : group.getUsersDTO()) {
                this.updateReceptionProof(user.getCurrentSending(), isSelected);
            }
            for (VradiClientDTO groupClient : group.getClientsDTO()) {
                this.updateReceptionProof(groupClient.getCurrentSending(), isSelected);
            }
        }
        this.updateSending(sending);
    }

    public void updateParagraph(VradiSendingDTO sending, String text) {
        VradiGroupDTO group;
        sending.setParagraph(text);
        VradiClientDTO client = sending.getClientDTO();
        if (client != null) {
            for (VradiUserDTO user : client.getUsersDTO()) {
                VradiSendingDTO userSending = user.getCurrentSending();
                String userParagraph = userSending.getParagraph();
                if (userParagraph != null && !userParagraph.isEmpty()) continue;
                this.updateParagraph(userSending, text);
            }
        }
        if ((group = sending.getGroupDTO()) != null) {
            for (VradiUserDTO user : group.getUsersDTO()) {
                VradiSendingDTO userSending = user.getCurrentSending();
                String userParagraph = userSending.getParagraph();
                if (userParagraph != null && !userParagraph.isEmpty()) continue;
                this.updateParagraph(userSending, text);
            }
            for (VradiClientDTO groupClient : group.getClientsDTO()) {
                VradiSendingDTO clientSending = groupClient.getCurrentSending();
                String clientParagraph = clientSending.getParagraph();
                if (clientParagraph != null && !clientParagraph.isEmpty()) continue;
                this.updateParagraph(clientSending, text);
            }
        }
        this.updateSending(sending);
    }
}

