/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.admin;

import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.entities.XmlStream;
import java.util.Collection;
import javax.swing.tree.TreeModel;
import jaxx.runtime.swing.navigation.NavigationNode;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.widget.tree.TreeFilter;
import org.sharengo.wikitty.WikittyExtension;

public class AdminNavTreeFilter
implements TreeFilter {
    private static final Log log = LogFactory.getLog(AdminNavTreeFilter.class);
    protected String filterString;

    public AdminNavTreeFilter(String filterString) {
        this.filterString = filterString.toLowerCase();
    }

    public boolean include(TreeModel model, Object node) {
        XmlStream xmlStream;
        if (StringUtils.isEmpty((String)this.filterString)) {
            return true;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Todo filter string : " + this.filterString + " on " + node));
        }
        boolean result = true;
        NavigationNode ntNode = (NavigationNode)node;
        Object bean = ntNode.getBean();
        if (bean instanceof Collection) {
            result = false;
            for (int i = 0; i < ntNode.getChildCount() && !result; ++i) {
                NavigationNode child = ntNode.getChildAt(i);
                result = this.include(model, child);
            }
        } else if (bean instanceof Client) {
            Client client = (Client)bean;
            if (!client.getName().toLowerCase().contains(this.filterString)) {
                result = false;
                for (int i = 0; i < ntNode.getChildCount() && !result; ++i) {
                    NavigationNode child = ntNode.getChildAt(i);
                    result = this.include(model, child);
                }
            }
        } else if (bean instanceof User) {
            Group group;
            NavigationNode clientNode;
            User user = (User)bean;
            if (!user.getName().toLowerCase().contains(this.filterString)) {
                result = false;
            }
            if ((clientNode = ntNode.getParent().getParent()) instanceof Client) {
                Client client = (Client)clientNode.getBean();
                if (client.getName().toLowerCase().contains(this.filterString)) {
                    result = true;
                }
            } else if (clientNode instanceof Group && (group = (Group)clientNode.getBean()).getName().toLowerCase().contains(this.filterString)) {
                result = true;
            }
        } else if (bean instanceof Group) {
            Group group = (Group)bean;
            if (!group.getName().toLowerCase().contains(this.filterString)) {
                result = false;
                for (int i = 0; i < ntNode.getChildCount() && !result; ++i) {
                    NavigationNode child = ntNode.getChildAt(i);
                    result = this.include(model, child);
                }
            }
        } else if (bean instanceof WikittyExtension) {
            WikittyExtension form = (WikittyExtension)bean;
            if (!form.getName().toLowerCase().contains(this.filterString)) {
                result = false;
            }
        } else if (bean instanceof XmlStream && !(xmlStream = (XmlStream)bean).getName().toLowerCase().contains(this.filterString)) {
            result = false;
        }
        return result;
    }
}

