/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.admin;

import com.jurismarches.vradi.VradiConfig;
import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.VradiService;
import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.entities.VradiUser;
import com.jurismarches.vradi.entities.XmlFieldBinding;
import com.jurismarches.vradi.entities.XmlFieldBindingImpl;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.services.XmlStreamService;
import com.jurismarches.vradi.services.dto.VradiFormPageDTO;
import com.jurismarches.vradi.services.dto.VradiQueryBean;
import com.jurismarches.vradi.services.dto.VradiThesaurusDTO;
import com.jurismarches.vradi.services.dto.VradiUserDTO;
import com.jurismarches.vradi.services.dto.VradiXmlStreamDTO;
import com.jurismarches.vradi.ui.JListCellRenderer;
import com.jurismarches.vradi.ui.OfferListColumnFactory;
import com.jurismarches.vradi.ui.OfferListHandler;
import com.jurismarches.vradi.ui.OfferListUI;
import com.jurismarches.vradi.ui.OfferTable;
import com.jurismarches.vradi.ui.VradiComparators;
import com.jurismarches.vradi.ui.VradiMainUI;
import com.jurismarches.vradi.ui.VradiTask;
import com.jurismarches.vradi.ui.admin.AdminContentUI;
import com.jurismarches.vradi.ui.admin.AdminNavUI;
import com.jurismarches.vradi.ui.admin.AdminPopupUI;
import com.jurismarches.vradi.ui.admin.AdminRequestUI;
import com.jurismarches.vradi.ui.admin.content.AdminClientUI;
import com.jurismarches.vradi.ui.admin.content.AdminFormTypeUI;
import com.jurismarches.vradi.ui.admin.content.AdminGroupUI;
import com.jurismarches.vradi.ui.admin.content.AdminStatusUI;
import com.jurismarches.vradi.ui.admin.content.AdminUserUI;
import com.jurismarches.vradi.ui.admin.content.AdminXmlStreamUI;
import com.jurismarches.vradi.ui.admin.content.FieldSelectUI;
import com.jurismarches.vradi.ui.admin.content.RequestSelectUI;
import com.jurismarches.vradi.ui.admin.content.StatusEditionUI;
import com.jurismarches.vradi.ui.admin.content.TemplateFieldBindingUI;
import com.jurismarches.vradi.ui.admin.content.XmlStreamConfigUI;
import com.jurismarches.vradi.ui.editors.JListCellEditor;
import com.jurismarches.vradi.ui.helpers.AdminNavigationTreeHelper;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.helpers.XmlStreamHelper;
import com.jurismarches.vradi.ui.models.FieldSelectModel;
import com.jurismarches.vradi.ui.models.FieldTypeModel;
import com.jurismarches.vradi.ui.models.OfferListTableModel;
import com.jurismarches.vradi.ui.models.TemplateFieldTableModel;
import com.jurismarches.vradi.ui.models.XmlStreamFieldTableModel;
import com.jurismarches.vradi.ui.search.SearchHandler;
import com.jurismarches.vradi.ui.search.SearchUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreeModel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.navigation.NavigationNode;
import jaxx.runtime.swing.navigation.tree.NavigationTreeModel;
import jaxx.runtime.swing.navigation.tree.NavigationTreeNode;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.FileUtil;
import org.sharengo.wikitty.BusinessEntity;
import org.sharengo.wikitty.Criteria;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.search.Element;
import org.sharengo.wikitty.search.Search;

public class AdminHandler {
    private static final Log log = LogFactory.getLog(AdminHandler.class);
    public static final int TOOLTIP_LINE_MAX_CHAR_NB = 100;
    public static final int TOOLTIP_ELEMENT_MAX_CHAR_NB = 500;
    private VradiStorageService vradiStorageService = null;
    private XmlStreamService xmlStreamService = null;
    public static final Map<String, org.jdom.Element> XML_STREAM_FIELDS_CACHE = new HashMap<String, org.jdom.Element>();

    public AdminPopupUI init(JAXXContext rootContext, Object ... datas) {
        AdminPopupUI adminPopupUI = (AdminPopupUI)VradiContext.ADMIN_UI_ENTRY_DEF.getContextValue(rootContext);
        if (adminPopupUI == null) {
            JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext).add((Object)this);
            VradiMainUI mainUI = (VradiMainUI)VradiContext.MAIN_UI_ENTRY_DEF.getContextValue((JAXXContext)context);
            adminPopupUI = new AdminPopupUI((JAXXContext)context, mainUI);
            VradiContext.ADMIN_UI_ENTRY_DEF.setContextValue(rootContext, (Object)adminPopupUI);
        }
        return adminPopupUI;
    }

    AdminPopupUI getUI(JAXXContext context) {
        if (context instanceof AdminPopupUI) {
            return (AdminPopupUI)context;
        }
        AdminPopupUI ui = (AdminPopupUI)VradiContext.ADMIN_UI_ENTRY_DEF.getContextValue(context);
        return ui;
    }

    void close(JAXXContext context) {
        AdminPopupUI ui = this.getUI(context);
        ui.setVisible(false);
        ui.dispose();
    }

    protected VradiStorageService getVradiStorageService() {
        if (this.vradiStorageService == null) {
            this.vradiStorageService = VradiService.getVradiStorageService();
        }
        return this.vradiStorageService;
    }

    protected XmlStreamService getXmlStreamService() {
        if (this.xmlStreamService == null) {
            this.xmlStreamService = VradiService.getXmlStreamService();
        }
        return this.xmlStreamService;
    }

    private <B> void repaintAdminUI(AdminContentUI<B> context, AdminNavigationTreeHelper helper, B bean) throws Exception {
        helper.setSelectedBean((JAXXContext)context, bean);
        NavigationTreeNode selectedNode = (NavigationTreeNode)helper.getSelectedNode((JAXXContext)context);
        selectedNode.setBean(bean);
        selectedNode.reload(context);
        helper.repaintNode((JAXXContext)context, (NavigationNode)selectedNode);
        context.openUI(selectedNode);
    }

    private Group saveGroup(Group group) throws VradiException {
        Group newgroup = (Group)this.getVradiStorageService().updateEntity((BusinessEntity)group);
        VradiContext.replace((BusinessEntity)newgroup);
        return newgroup;
    }

    private Collection<Group> saveGroups(Collection<Group> groups) throws VradiException {
        Group[] groupArray = new Group[groups.size()];
        groups.toArray(groupArray);
        for (Group group : groupArray = (Group[])this.getVradiStorageService().updateEntities((BusinessEntity[])groupArray)) {
            VradiContext.replace((BusinessEntity)group);
        }
        List<Group> newgroups = Arrays.asList(groupArray);
        return newgroups;
    }

    private Client saveClient(Client client) throws VradiException {
        Client newclient = (Client)this.getVradiStorageService().updateEntity((BusinessEntity)client);
        VradiContext.replace((BusinessEntity)newclient);
        return newclient;
    }

    private User saveUser(User user) throws VradiException {
        User newuser = (User)this.getVradiStorageService().updateEntity((BusinessEntity)user);
        VradiContext.replace((BusinessEntity)newuser);
        return newuser;
    }

    private XmlStream saveXmlStream(XmlStream xmlStream, List<XmlFieldBinding> bindings) throws VradiException {
        XmlStream newXmlStream = this.getVradiStorageService().updateXmlStream(xmlStream, bindings);
        VradiContext.replace((BusinessEntity)newXmlStream);
        return newXmlStream;
    }

    public void removeFromGroup(AdminContentUI context, AdminNavigationTreeHelper helper) {
        try {
            NavigationTreeNode selectedNode = (NavigationTreeNode)helper.getSelectedNode((JAXXContext)context);
            BusinessEntity bean = (BusinessEntity)selectedNode.getBean();
            NavigationTreeNode parentNode = helper.getParentGroupNode(selectedNode);
            Group group = (Group)parentNode.getBean((JAXXContext)context);
            group.removeClient(bean.getWikittyId());
            group.removeUser(bean.getWikittyId());
            group = this.saveGroup(group);
            helper.reloadGroup((JAXXContext)context, parentNode, group);
            helper.selectNode((JAXXContext)context, parentNode.getFullPath());
        }
        catch (VradiException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            ErrorDialogUI.showError((Exception)((Object)e));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public Group saveGroup(AdminGroupUI context, AdminNavigationTreeHelper helper, Group group) {
        try {
            group = this.saveGroup(group);
            this.repaintAdminUI(context, helper, group);
            helper.reloadGroup((JAXXContext)context, (NavigationTreeNode)helper.getSelectedNode((JAXXContext)context), group);
        }
        catch (VradiException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            ErrorDialogUI.showError((Exception)((Object)e));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return group;
    }

    public Client saveClient(AdminClientUI context, AdminNavigationTreeHelper helper, Client client, Collection<Group> groups) {
        try {
            client = this.saveClient(client);
            if (groups != null && !groups.isEmpty()) {
                this.saveGroups(groups);
            }
            this.repaintAdminUI(context, helper, client);
        }
        catch (VradiException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            ErrorDialogUI.showError((Exception)((Object)e));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return client;
    }

    public User saveUser(AdminUserUI context, AdminNavigationTreeHelper helper, User user, Client client, Collection<Group> groups) {
        try {
            user = this.saveUser(user);
            if (client != null) {
                client = this.saveClient(client);
            }
            if (groups != null && !groups.isEmpty()) {
                this.saveGroups(groups);
            }
            this.repaintAdminUI(context, helper, user);
        }
        catch (VradiException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            ErrorDialogUI.showError((Exception)((Object)e));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return user;
    }

    public void exportClientUsersDBCSV(AdminNavUI adminNavUI) {
        block6: {
            try {
                JFileChooser chooser = new JFileChooser();
                chooser.setDialogTitle(I18n._((String)"vradi.adminClient.exportGroupTitle"));
                chooser.setApproveButtonText(I18n._((String)"vradi.adminClient.exportButtonText"));
                int returnVal = chooser.showOpenDialog(adminNavUI);
                if (returnVal == 0) {
                    File selectedFile = chooser.getSelectedFile();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Exporting groups to : " + selectedFile.getAbsolutePath()));
                    }
                    Search restriction = Search.query().or();
                    restriction.eq(Element.ELT_EXTENSION, "Group");
                    restriction.eq(Element.ELT_EXTENSION, "Client");
                    restriction.eq(Element.ELT_EXTENSION, "User");
                    Criteria criteria = restriction.criteria();
                    VradiStorageService vradiStorageService = this.getVradiStorageService();
                    String vscContent = vradiStorageService.exportAsCSV(criteria);
                    FileUtils.writeStringToFile((File)selectedFile, (String)vscContent);
                }
            }
            catch (VradiException eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't export groups", (Throwable)eee);
                }
                ErrorDialogUI.showError((Exception)((Object)eee));
            }
            catch (Exception eee) {
                if (!log.isErrorEnabled()) break block6;
                log.error((Object)"Can't export groups", (Throwable)eee);
            }
        }
    }

    public void importClientUsersDBCSV(AdminNavUI adminNavUI) {
        block6: {
            try {
                JFileChooser chooser = new JFileChooser();
                chooser.setDialogTitle(I18n._((String)"vradi.adminClient.importTitle"));
                chooser.setApproveButtonText(I18n._((String)"vradi.adminClient.importButtonText"));
                int returnVal = chooser.showOpenDialog(adminNavUI);
                if (returnVal == 0) {
                    File selectedFile = chooser.getSelectedFile();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Importing file : " + selectedFile.getAbsolutePath()));
                    }
                    VradiStorageService vradiStorageService = this.getVradiStorageService();
                    String uri = selectedFile.toURI().toURL().toExternalForm();
                    vradiStorageService.importAsCSV(uri);
                    VradiContext.initEntryDef();
                    AdminNavigationTreeHelper helper = adminNavUI.getHelper();
                    helper.getTree((JAXXContext)adminNavUI).setModel((TreeModel)((NavigationTreeModel)helper.createTreeModel()));
                }
            }
            catch (VradiException eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't import file", (Throwable)eee);
                }
                ErrorDialogUI.showError((Exception)((Object)eee));
            }
            catch (Exception eee) {
                if (!log.isErrorEnabled()) break block6;
                log.error((Object)"Can't import file", (Throwable)eee);
            }
        }
    }

    public boolean answerToSave(AdminContentUI<?> content) {
        if (content != null && content.isModified().booleanValue()) {
            int n = JOptionPane.showConfirmDialog(content, I18n._((String)"vradi.admin.saveAnswer") + VradiHelper.getEntityName(content.getBean()) + " ?", I18n._((String)"vradi.admin.saveTitle"), 1);
            switch (n) {
                case 1: {
                    this.cancel(content, content.getHelper(), false);
                    break;
                }
                case 0: {
                    content.postSave();
                    break;
                }
                case 2: {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean confirmDeletion(AdminContentUI<?> content) {
        int confirm = JOptionPane.showConfirmDialog(content, I18n._((String)"vradi.admin.confirmDelete", (Object[])new Object[]{VradiHelper.getEntityName(content.getBean())}), I18n._((String)"vradi.admin.deleteTitle"), 0);
        return confirm != 1;
    }

    public <B> void delete(AdminContentUI<B> context, AdminNavigationTreeHelper helper, B bean) {
        if (!this.confirmDeletion(context)) {
            return;
        }
        try {
            context.setModified(false);
            NavigationTreeNode selectedNode = (NavigationTreeNode)helper.getSelectedNode((JAXXContext)context);
            NavigationTreeNode parentNode = helper.removeChildNode(selectedNode);
            BusinessEntity entity = (BusinessEntity)bean;
            Object modified = entity.getField("ModificationTag", "lastModified");
            if (modified != null) {
                this.getVradiStorageService().deleteEntity(entity);
            }
            VradiContext.remove(entity);
            helper.selectNode((JAXXContext)context, (NavigationNode)parentNode);
        }
        catch (VradiException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            ErrorDialogUI.showError((Exception)e);
        }
    }

    <B> void cancel(AdminContentUI<B> content, AdminNavigationTreeHelper helper, boolean trigerredByCancelButton) {
        int confirm = -1;
        if (trigerredByCancelButton) {
            confirm = JOptionPane.showConfirmDialog(content, I18n._((String)"vradi.admin.cancel.message"), I18n._((String)"vradi.admin.cancel.title"), 0, 2);
        }
        if (!trigerredByCancelButton || confirm == 0) {
            try {
                NavigationTreeNode selectedNode = (NavigationTreeNode)helper.getSelectedNode((JAXXContext)content);
                content.openUI(selectedNode);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public ComboBoxModel getTypesModel() {
        FieldTypeModel model = new FieldTypeModel();
        return model;
    }

    public void openRequest(JAXXContext rootContext, List<VradiThesaurusDTO> thesaurus) {
        this.openRequest(rootContext, null, thesaurus);
    }

    public void openRequest(JAXXContext rootContext, VradiQueryBean request) {
        this.openRequest(rootContext, request, null);
    }

    public void openRequest(final JAXXContext rootContext, VradiQueryBean request, List<VradiThesaurusDTO> thesaurus) {
        AdminRequestUI requestUI = this.createAdminRequestUI(rootContext, request, thesaurus);
        SearchHandler searchHandler = requestUI.getContextValue(SearchHandler.class);
        SearchUI searchUI = requestUI.getSearchUI();
        OfferListTableModel offerListTableModel = requestUI.getContextValue(OfferListTableModel.class);
        String query = requestUI.getRequest();
        VradiFormPageDTO formPageDTO = new VradiFormPageDTO();
        searchHandler.executeQuery((JAXXContext)searchUI, searchUI.getCriterias(), formPageDTO, null, query);
        offerListTableModel.setFormPageDTO(formPageDTO);
        requestUI.addPropertyChangeListener("request", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String newValue = (String)evt.getNewValue();
                RequestSelectUI ui = (RequestSelectUI)rootContext;
                VradiQueryBean bean = ui.getBean();
                ui.setBean(bean.setQuery(newValue));
            }
        });
        requestUI.setVisible(true);
    }

    public AdminRequestUI createAdminRequestUI(JAXXContext rootContext, VradiQueryBean request, List<VradiThesaurusDTO> thesaurus) {
        JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext);
        SearchHandler searchHandler = new SearchHandler();
        OfferListTableModel offerListTableModel = new OfferListTableModel();
        OfferListColumnFactory offerListColumnFactory = new OfferListColumnFactory();
        context.add((Object)searchHandler);
        context.add((Object)offerListTableModel);
        context.add((Object)offerListColumnFactory);
        AdminRequestUI requestUI = new AdminRequestUI((JAXXContext)context);
        OfferTable listTable = requestUI.getResultTable();
        OfferListUI ui = (OfferListUI)VradiContext.OFFERT_LIST_UI_ENTRY_DEF.getContextValue((JAXXContext)context);
        MouseListener offerListTableMouseListener = UIHelper.getHandler((JAXXContext)context, OfferListHandler.class).getOfferListTableMouseListener();
        listTable.addMouseListener(offerListTableMouseListener);
        TableModelListener offerListTableModelListener = this.getOfferListTableModelListener(listTable);
        offerListTableModel.addTableModelListener(offerListTableModelListener);
        OfferListTableModel.OfferListTableCellRenderer renderer = new OfferListTableModel.OfferListTableCellRenderer();
        listTable.setDefaultRenderer(Boolean.class, renderer);
        listTable.setDefaultRenderer(Date.class, renderer);
        listTable.setDefaultRenderer(Double.class, renderer);
        listTable.setDefaultRenderer(String.class, renderer);
        Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)HighlighterFactory.NOTEPAD, (Color)HighlighterFactory.GENERIC_GRAY);
        listTable.addHighlighter(highlighter);
        SearchUI searchUI = searchHandler.initCloneUI((JAXXContext)context, offerListTableModel, thesaurus);
        String query = null;
        if (request != null) {
            query = request.getQuery();
            searchUI.setRequest(query);
        } else if (thesaurus != null) {
            requestUI.setCanSave(false);
            searchUI.setHidable(false);
        }
        requestUI.getSearchPanel().add((Component)((Object)searchUI), "Center");
        return requestUI;
    }

    private TableModelListener getOfferListTableModelListener(final JXTable listTable) {
        return new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                listTable.packAll();
            }
        };
    }

    public List<Status> getAllStatuses() {
        return VradiContext.getStatusInEntryDef();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveStatuses(AdminStatusUI adminStatusUI) {
        List<Status> existingStatuses = VradiContext.getStatusInEntryDef();
        ArrayList<String> existingStatusIds = new ArrayList<String>();
        for (Status status : existingStatuses) {
            existingStatusIds.add(status.getWikittyId());
        }
        ArrayList<Status> statusesToAdd = new ArrayList<Status>();
        JPanel statusPanel = adminStatusUI.getContent();
        int statusValue = 0;
        for (int i = 0; i < statusPanel.getComponentCount(); ++i) {
            StatusEditionUI editionUI = (StatusEditionUI)((Object)statusPanel.getComponent(i));
            Status status = editionUI.getWikitty();
            editionUI.getBean().toWikitty(status);
            status.setValue(statusValue++);
            statusesToAdd.add(status);
        }
        ArrayList<String> statusesToDelete = new ArrayList<String>();
        JPanel deletedPanel = adminStatusUI.getDeletedContent();
        for (int i = 0; i < deletedPanel.getComponentCount(); ++i) {
            StatusEditionUI editionUI = (StatusEditionUI)((Object)deletedPanel.getComponent(i));
            if (!existingStatusIds.contains(editionUI.getWikitty().getWikittyId())) continue;
            statusesToDelete.add(editionUI.getWikitty().getWikittyId());
        }
        deletedPanel.removeAll();
        try {
            List updateStatuses = this.getVradiStorageService().updateStatuses(statusesToAdd);
            this.getVradiStorageService().deleteStatuses(statusesToDelete);
            VradiContext.setStatusEntryDef(updateStatuses);
        }
        catch (VradiException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            ErrorDialogUI.showError((Exception)((Object)e));
        }
        finally {
            adminStatusUI.createStatuses(false);
        }
    }

    public Map<Client, Set<String>> getAllClients() {
        TreeMap<Client, Set<String>> clientsAndUsers = new TreeMap<Client, Set<String>>(VradiComparators.CLIENT_COMPARATOR);
        TreeMap clientsIdAndUsers = new TreeMap();
        List<Client> clients = VradiContext.getClientsInEntryDef();
        List<User> users = VradiContext.getUsersInEntryDef();
        for (Client client : clients) {
            HashSet ids = new HashSet();
            clientsAndUsers.put(client, ids);
            clientsIdAndUsers.put(client.getWikittyId(), ids);
        }
        for (User user : users) {
            String clientId = user.getClient();
            String userId = user.getWikittyId();
            Set usersIds = (Set)clientsIdAndUsers.get(clientId);
            usersIds.add(userId);
        }
        return clientsAndUsers;
    }

    public List<User> getAllUsers() {
        List<User> values = VradiContext.getUsersInEntryDef();
        ArrayList<User> copy = new ArrayList<User>(values);
        Collections.sort(copy, VradiComparators.USER_COMPARATOR);
        return copy;
    }

    public List<VradiUserDTO> getAllDisplayUsers() {
        ArrayList<VradiUserDTO> result = new ArrayList<VradiUserDTO>();
        List<User> allUsers = this.getAllUsers();
        for (User u : allUsers) {
            VradiUserDTO dto = new VradiUserDTO();
            dto.fromWikitty(u);
            Client client = VradiHelper.findEntityInRef(VradiContext.getClientsEntryDef(), u.getClient());
            if (client != null) {
                dto.setClientName(client.getName());
            }
            result.add(dto);
        }
        return result;
    }

    public void createClient(AdminClientUI context, AdminNavigationTreeHelper helper) {
        this.getUI((JAXXContext)context).getClientAdminNavUI().resetFilter();
        NavigationTreeNode addClient = helper.addClientToSelected((JAXXContext)context, null);
        helper.selectNode((JAXXContext)context, (NavigationNode)addClient);
    }

    public void createUser(JAXXContext context, AdminNavigationTreeHelper helper) {
        this.getUI(context).getClientAdminNavUI().resetFilter();
        NavigationTreeNode addUser = helper.addUserToSelected(context, null);
        helper.selectNode(context, (NavigationNode)addUser);
    }

    public List<Group> getAllGroups() {
        List<Group> values = VradiContext.getGroupsInEntryDef();
        return new ArrayList<Group>(values);
    }

    public void createGroup(AdminGroupUI context, AdminNavigationTreeHelper helper) {
        this.getUI((JAXXContext)context).getGroupAdminNavUI().resetFilter();
        NavigationTreeNode addGroup = helper.addGroupToSelected((JAXXContext)context, null);
        helper.selectNode((JAXXContext)context, (NavigationNode)addGroup);
    }

    public List<WikittyExtension> getAllFormTypes() {
        List<WikittyExtension> values = VradiContext.getFormsTypeInEntryDef();
        return new ArrayList<WikittyExtension>(values);
    }

    public Set<String> getAllFormTypeNames() {
        List<WikittyExtension> extensions = VradiContext.getFormsTypeInEntryDef();
        HashSet<String> names = new HashSet<String>();
        for (WikittyExtension extension : extensions) {
            names.add(extension.getName());
        }
        return names;
    }

    public void createFormType(AdminFormTypeUI context, AdminNavigationTreeHelper helper) {
        String name = JOptionPane.showInputDialog(this.getUI((JAXXContext)context), (Object)I18n._((String)"vradi.adminForm.askName"));
        if (name != null && !name.isEmpty()) {
            WikittyExtension formType = new WikittyExtension(name, "0.0", "Form", new LinkedHashMap());
            this.getUI((JAXXContext)context).getFormAdminNavUI().resetFilter();
            NavigationTreeNode addFormType = helper.addFormTypeToSelected((JAXXContext)context, formType);
            helper.setSelectedNode((JAXXContext)context, (NavigationNode)addFormType);
            helper.selectNode((JAXXContext)context, (NavigationNode)addFormType);
        }
    }

    public void createForms(JAXXContext context) {
        AdminXmlStreamUI xmlStreamUI = this.getXmlStreamUI(context);
        VradiXmlStreamDTO xmlStream = xmlStreamUI.getBean();
        if (xmlStream == null || xmlStream.getFormTypeName() == null) {
            JOptionPane.showMessageDialog(xmlStreamUI, I18n._((String)"vradi.admin.formsCreated.missingFormType"), I18n._((String)"vradi.admin.formsCreated.title"), 2);
            return;
        }
        VradiUser vradiUser = xmlStreamUI.getContextValue(VradiUser.class);
        VradiTask<Object> task = new VradiTask<Object>(context, (XmlStream)xmlStream, vradiUser, xmlStreamUI){
            final /* synthetic */ XmlStream val$xmlStream;
            final /* synthetic */ VradiUser val$vradiUser;
            final /* synthetic */ AdminXmlStreamUI val$xmlStreamUI;
            {
                this.val$xmlStream = xmlStream;
                this.val$vradiUser = vradiUser;
                this.val$xmlStreamUI = adminXmlStreamUI;
                super(x0);
            }

            @Override
            public Object doAction() throws Exception {
                return AdminHandler.this.createForms(this.val$xmlStream, this.val$vradiUser);
            }

            @Override
            public void doWhenDone() throws Exception {
                this.val$xmlStreamUI.getCreateForms().setEnabled(true);
                Object object = this.get();
                AdminHandler.this.showFormCreationResults(this.val$xmlStreamUI, object);
            }
        };
        xmlStreamUI.getCreateForms().setEnabled(false);
        task.execute();
    }

    public Object createForms(XmlStream xmlStream, VradiUser vradiUser) {
        try {
            return this.getVradiStorageService().getFormsFromXmlStream(xmlStream, vradiUser);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return e;
        }
    }

    protected void showFormCreationResults(AdminXmlStreamUI xmlStreamUI, Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof Exception) {
            ErrorDialogUI.showError((Exception)((Exception)object));
            return;
        }
        if (object.getClass().isArray()) {
            int[] formCreationResults = (int[])object;
            int nbFormCreated = formCreationResults[0];
            int alreadyExisting = formCreationResults[1];
            int dateErrorParsing = formCreationResults[2];
            int numberErrorParsing = formCreationResults[3];
            String optionMessage = I18n._((String)"vradi.admin.formsCreated.message.allWarning", (Object[])new Object[]{nbFormCreated, alreadyExisting, dateErrorParsing, numberErrorParsing});
            int messageType = 1;
            if (dateErrorParsing > 0 || numberErrorParsing > 0) {
                messageType = 2;
            }
            JOptionPane.showMessageDialog(xmlStreamUI, I18n._((String)"vradi.admin.formsCreated.message") + optionMessage, I18n._((String)"vradi.admin.formsCreated.title"), messageType);
        }
    }

    public void saveFormType(AdminFormTypeUI context) {
        try {
            ArrayList<FieldSelectModel> fields = new ArrayList<FieldSelectModel>();
            VBox contentPanel = context.getContent();
            for (Component component : contentPanel.getComponents()) {
                fields.add(((FieldSelectUI)((Object)component)).getBean());
            }
            WikittyExtension uiExtension = context.getBean();
            WikittyExtension newFormType = new WikittyExtension(uiExtension.getName(), uiExtension.getVersion(), uiExtension.getRequires(), null);
            for (int i = 0; i < fields.size(); ++i) {
                FieldSelectModel model = (FieldSelectModel)fields.get(i);
                String name = model.getNameValue();
                if (name == null || model.getType() == null) continue;
                FieldType fieldType = model.getType().getFieldType();
                if (model.getDescValue() != null && !model.getDescValue().isEmpty()) {
                    fieldType.addTagValue("description", model.getDescValue());
                }
                fieldType.addTagValue("rank", String.valueOf(i));
                newFormType.addField(name, fieldType);
            }
            Date now = new Date();
            newFormType.addTagValue("lastModifiedDate", String.format("%1$td/%1$tm/%1$ty", now));
            newFormType.addTagValue("lastModifiedTime", String.format("%1$tk:%1$tM:%1$tS", now));
            newFormType.addTagValue("lastModifiedBy", context.getContextValue(VradiUser.class).getName());
            File template = (File)context.getTemplateChoice().getSelectedItem();
            if (template != null) {
                newFormType.addTagValue("template", template.getName());
            }
            newFormType = this.getVradiStorageService().updateFormType(newFormType);
            List<WikittyExtension> forms = VradiContext.getFormsTypeInEntryDef();
            forms.add(newFormType);
            VradiContext.setFormsTypeEntryDef(forms);
            AdminNavigationTreeHelper helper = context.getHelper();
            NavigationTreeNode selectedNode = (NavigationTreeNode)helper.getSelectedNode((JAXXContext)context);
            NavigationTreeNode parentNode = selectedNode.getParent();
            parentNode.setBean(forms);
            NavigationTreeNode newNode = helper.addFormType((JAXXContext)context, parentNode, newFormType);
            helper.setSelectedNode((JAXXContext)context, (NavigationNode)newNode);
            this.repaintAdminUI(context, helper, newFormType);
            helper.removeChildNode(selectedNode);
        }
        catch (VradiException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            ErrorDialogUI.showError((Exception)((Object)e));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public WikittyExtension getExtension(String extensionName) {
        try {
            return this.getVradiStorageService().getFormType(extensionName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void createXmlStream(AdminXmlStreamUI context, AdminNavigationTreeHelper helper) {
        this.getUI((JAXXContext)context).getXmlStreamAdminNavUI().resetFilter();
        NavigationTreeNode addXmlStream = helper.addXmlStreamToSelected((JAXXContext)context, null);
        helper.selectNode((JAXXContext)context, (NavigationNode)addXmlStream);
    }

    public XmlStream saveXmlStream(AdminXmlStreamUI context, AdminNavigationTreeHelper helper, XmlStream xmlStream, List<XmlFieldBinding> bindings) {
        try {
            xmlStream = this.saveXmlStream(xmlStream, bindings);
            this.repaintAdminUI(context, helper, xmlStream);
        }
        catch (VradiException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            ErrorDialogUI.showError((Exception)((Object)e));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return xmlStream;
    }

    public List<XmlFieldBinding> getXmlStreamFields(XmlStream xmlStream) {
        try {
            List result = this.getVradiStorageService().getXmlFieldBindings(xmlStream);
            return result;
        }
        catch (VradiException e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
            return new ArrayList<XmlFieldBinding>();
        }
    }

    private WikittyExtension getFormType(VradiXmlStreamDTO xmlStream) {
        if (xmlStream == null) {
            return null;
        }
        String formTypeName = xmlStream.getFormTypeName();
        if (formTypeName == null) {
            return null;
        }
        WikittyExtension formType = xmlStream.getFormType();
        if (formType != null && formTypeName.equals(formType.getName())) {
            return formType;
        }
        formType = this.getExtension(formTypeName);
        xmlStream.setFormType(formType);
        return formType;
    }

    public void openAdminXmlStreamUI(final AdminXmlStreamUI xmlStreamUI) {
        VradiTask<Void> task = new VradiTask<Void>((JAXXContext)xmlStreamUI, false){

            @Override
            public Void doAction() throws Exception {
                AdminHandler.this.updateXmlStreamFieldModel(xmlStreamUI);
                return null;
            }

            @Override
            public void doWhenDone() throws Exception {
                HBox lastModified = xmlStreamUI.getLastModified();
                lastModified.removeAll();
                VradiXmlStreamDTO bean = xmlStreamUI.getBean();
                if (bean != null && bean.getLastModified() != null && bean.getLastModifier() != null) {
                    String labelText = String.format(I18n._((String)"vradi.entity.lastModified.date.user"), bean.getLastModified(), bean.getLastModifier());
                    lastModified.add((Component)new JLabel(labelText));
                }
                lastModified.validate();
                xmlStreamUI.setModified(false);
                xmlStreamUI.setCursor(null);
                xmlStreamUI.validate();
            }
        };
        task.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateXmlStreamFieldModel(AdminXmlStreamUI xmlStreamUI) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateXmlStreamFieldModel(context)");
        }
        XmlStreamFieldTableModel fieldsModel = xmlStreamUI.getFieldsModel();
        fieldsModel.setValueIsAdjusting(true);
        fieldsModel.clear();
        try {
            VradiXmlStreamDTO bean = xmlStreamUI.getBean();
            String url = bean.getUrl();
            if (url == null || url.trim().isEmpty()) {
                return;
            }
            WikittyExtension formType = this.getFormType(bean);
            if (formType == null) {
                return;
            }
            Set<String> xmlFieldNames = this.getXmlFieldNames(url);
            List<XmlFieldBinding> bindings = this.getXmlStreamFields((XmlStream)bean);
            LinkedHashMap<String, XmlFieldBinding> fieldNames = this.getAllBindingFields(formType);
            if (bindings != null && !bindings.isEmpty()) {
                boolean empty = xmlFieldNames.isEmpty();
                for (XmlFieldBinding binding : bindings) {
                    Set xmlFields;
                    String formField = binding.getFormField();
                    if (!fieldNames.containsKey(formField)) continue;
                    fieldNames.put(formField, binding);
                    if (!empty || (xmlFields = binding.getXmlField()) == null) continue;
                    xmlFieldNames.addAll(xmlFields);
                }
            }
            ArrayList<String> xmlFieldList = new ArrayList<String>(xmlFieldNames);
            xmlStreamUI.getContextValue(JListCellEditor.class).updateUniverse(xmlFieldList);
            xmlStreamUI.getContextValue(JListCellRenderer.class).updateUniverse(xmlFieldList);
            Collection<XmlFieldBinding> bindingCollection = fieldNames.values();
            fieldsModel.setBindings(bindingCollection);
            JXTable fieldsTable = xmlStreamUI.getFieldsTable();
            if (!xmlFieldNames.isEmpty()) {
                fieldsTable.setRowHeight(19 * xmlFieldNames.size());
            } else {
                fieldsTable.setRowHeight(19);
            }
        }
        catch (VradiException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            ErrorDialogUI.showError((Exception)((Object)e));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            fieldsModel.fireTableDataChanged();
            fieldsModel.setValueIsAdjusting(false);
        }
    }

    private LinkedHashMap<String, XmlFieldBinding> getAllBindingFields(WikittyExtension formType) {
        LinkedHashMap<String, XmlFieldBinding> fieldMap = new LinkedHashMap<String, XmlFieldBinding>();
        fieldMap.put("Infogene.objet", (XmlFieldBinding)new XmlFieldBindingImpl());
        fieldMap.put("Infogene.description", (XmlFieldBinding)new XmlFieldBindingImpl());
        fieldMap.put("Form.datePub", (XmlFieldBinding)new XmlFieldBindingImpl());
        fieldMap.put("Form.datePeremption", (XmlFieldBinding)new XmlFieldBindingImpl());
        fieldMap.put("Infogene.entity", (XmlFieldBinding)new XmlFieldBindingImpl());
        fieldMap.put("Infogene.sourceText", (XmlFieldBinding)new XmlFieldBindingImpl());
        fieldMap.put("Infogene.sourceURL", (XmlFieldBinding)new XmlFieldBindingImpl());
        fieldMap.put("Infogene.country", (XmlFieldBinding)new XmlFieldBindingImpl());
        fieldMap.put("Infogene.department", (XmlFieldBinding)new XmlFieldBindingImpl());
        Collection fieldNames = formType.getFieldNames();
        for (String string : fieldNames) {
            fieldMap.put(formType.getName() + "." + string, (XmlFieldBinding)new XmlFieldBindingImpl());
        }
        for (Map.Entry entry : fieldMap.entrySet()) {
            XmlFieldBinding value = (XmlFieldBinding)entry.getValue();
            value.setFormField((String)entry.getKey());
        }
        return fieldMap;
    }

    private Set<String> getXmlFieldNames(String url) throws VradiException {
        Set<Object> xmlFieldNames = new LinkedHashSet();
        Map<String, org.jdom.Element> xmlStreamFields = XML_STREAM_FIELDS_CACHE;
        org.jdom.Element element = xmlStreamFields.get(url);
        if (element == null) {
            try {
                org.jdom.Element firstElement = XmlStreamHelper.getFirstElement(url);
                xmlFieldNames = XmlStreamHelper.getRSSFields(firstElement);
                xmlStreamFields.put(url, firstElement);
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            xmlFieldNames = XmlStreamHelper.getRSSFields(element);
        }
        return xmlFieldNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTemplateFieldTableModel(TemplateFieldBindingUI context, WikittyExtension extension, File template) {
        if (extension == null || template == null) {
            return;
        }
        context.setTemplate(template.getName());
        context.setExtension(extension.getName());
        TemplateFieldTableModel model = context.getFieldsModel();
        model.setValueIsAdjusting(true);
        model.clear();
        LinkedList<String> fieldNames = new LinkedList<String>();
        fieldNames.add("Infogene.id");
        fieldNames.add("Infogene.objet");
        fieldNames.add("Infogene.description");
        fieldNames.add("Infogene.creationDate");
        fieldNames.add("Form.datePub");
        fieldNames.add("Form.datePeremption");
        fieldNames.add("Infogene.entity");
        fieldNames.add("Infogene.sourceText");
        fieldNames.add("Infogene.sourceURL");
        fieldNames.add("Infogene.country");
        fieldNames.add("Infogene.department");
        for (String fieldName : extension.getFieldNames()) {
            fieldNames.add(extension.getName() + "." + fieldName);
        }
        context.getContextValue(JListCellEditor.class).updateUniverse(fieldNames);
        context.getContextValue(JListCellRenderer.class).updateUniverse(fieldNames);
        if (fieldNames.size() > 0) {
            context.getFieldsTable().setRowHeight(19 * fieldNames.size());
        }
        try {
            HashMap<String, Object> fieldMap = this.getVradiStorageService().getAssociatedFields(extension.getName(), template.getName());
            if (fieldMap == null) {
                String[] templateFields;
                fieldMap = new HashMap<String, Object>();
                for (String field : templateFields = VradiService.getMailingService().getDocumentFields(template)) {
                    fieldMap.put(field, null);
                }
            }
            model.setData((Map<String, String>)fieldMap);
        }
        catch (VradiException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            ErrorDialogUI.showError((Exception)((Object)e));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            model.fireTableDataChanged();
            model.setValueIsAdjusting(false);
        }
    }

    public void saveTemplateFieldBinding(TemplateFieldBindingUI context) {
        TemplateFieldTableModel model = context.getFieldsModel();
        Map<String, String> fieldMap = model.getData();
        try {
            String extension = context.getExtension();
            String template = context.getTemplate();
            this.getVradiStorageService().setAssociatedFields(extension, template, fieldMap);
            context.dispose();
        }
        catch (VradiException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            ErrorDialogUI.showError((Exception)((Object)e));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private AdminXmlStreamUI getXmlStreamUI(JAXXContext context) {
        if (context instanceof AdminXmlStreamUI) {
            return (AdminXmlStreamUI)context;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFirstElementPreview(JAXXContext context, String url) {
        if (url == null || url.trim().isEmpty()) {
            return "";
        }
        org.jdom.Element firstElement = null;
        Map<String, org.jdom.Element> xmlStreamFields = XML_STREAM_FIELDS_CACHE;
        if (xmlStreamFields.get(url) == null) {
            AdminXmlStreamUI ui = this.getXmlStreamUI(context);
            try {
                ui.setCursor(Cursor.getPredefinedCursor(3));
                firstElement = XmlStreamHelper.getFirstElement(url);
                xmlStreamFields.put(url, firstElement);
            }
            catch (Exception eee) {
            }
            finally {
                ui.setCursor(null);
            }
        } else {
            firstElement = xmlStreamFields.get(url);
        }
        if (firstElement == null) {
            return "";
        }
        Map<String, String> elementValues = XmlStreamHelper.getFirstElementValues(firstElement);
        StringBuffer result = new StringBuffer();
        result.append("<html>");
        for (Map.Entry<String, String> entry : elementValues.entrySet()) {
            result.append("<strong>").append(entry.getKey()).append("</strong>").append(" : ");
            String value = entry.getValue();
            if (value.length() > 500) {
                value = StringUtils.replace((String)value, (String)"\r", (String)"");
                value = StringUtils.replace((String)value, (String)"\n\n", (String)"\n");
                value = StringUtils.abbreviate((String)value, (int)500);
                value = StringUtils.replace((String)value, (String)"\n", (String)"<br/>");
            }
            result.append(value).append("<br/>");
        }
        result.append("</html>");
        return result.toString();
    }

    public void saveXmlStreamConfig(XmlStreamConfigUI ui) {
        int interval = (Integer)ui.getInterval().getSelectedItem();
        String unit = (String)ui.getUnit().getSelectedItem();
        try {
            if (VradiConstants.XmlStreamConfig.HOURS.toString().equals(unit)) {
                int minute = (Integer)ui.getMinuteHours().getSelectedItem();
                this.getVradiStorageService().autoLoadFormsFromXmlStreams(VradiConstants.XmlStreamConfig.HOURS.toString(), interval, null, Integer.valueOf(minute));
            } else if (VradiConstants.XmlStreamConfig.DAYS.toString().equals(unit)) {
                int hour = (Integer)ui.getHourDays().getSelectedItem();
                int minute = (Integer)ui.getMinuteDays().getSelectedItem();
                this.getVradiStorageService().autoLoadFormsFromXmlStreams(VradiConstants.XmlStreamConfig.DAYS.toString(), interval, Integer.valueOf(hour), Integer.valueOf(minute));
            } else if (VradiConstants.XmlStreamConfig.MINUTES.toString().equals(unit)) {
                this.getVradiStorageService().autoLoadFormsFromXmlStreams(VradiConstants.XmlStreamConfig.MINUTES.toString(), interval, null, Integer.valueOf(5));
            } else {
                this.getVradiStorageService().autoLoadFormsFromXmlStreams(VradiConstants.XmlStreamConfig.DAYS.toString(), 1, Integer.valueOf(0), Integer.valueOf(0));
            }
        }
        catch (VradiException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            ErrorDialogUI.showError((Exception)((Object)e));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public ComboBoxModel getTemplateComboBoxModel(WikittyExtension extension) {
        Object[] files = this.getVradiStorageService().getTemplates(extension);
        if (files != null) {
            return new DefaultComboBoxModel(files){

                @Override
                public void setSelectedItem(Object item) {
                    if (item == null || !String.class.equals(item.getClass())) {
                        super.setSelectedItem(item);
                    } else {
                        for (int i = 0; i < this.getSize(); ++i) {
                            File f = (File)this.getElementAt(i);
                            if (!f.getName().equals(item)) continue;
                            super.setSelectedItem(f);
                            break;
                        }
                    }
                }
            };
        }
        return new DefaultComboBoxModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void showTemplateExample(AdminFormTypeUI context) {
        WikittyExtension extension = context.getBean();
        VradiFormPageDTO formPage = new VradiFormPageDTO();
        if ((formPage = VradiHelper.executeQuery(null, extension, null, null, null, null, null, formPage)).getTotalFoundFormNb() > 0) {
            Form form = (Form)formPage.getFormsToShow().get(0);
            try {
                context.setCursor(new Cursor(3));
                File file = VradiHelper.generatePDF(this.getVradiStorageService(), form);
                if (file == null) return;
                Desktop.getDesktop().open(file);
                return;
            }
            catch (VradiException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                ErrorDialogUI.showError((Exception)((Object)e));
                return;
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                return;
            }
            finally {
                context.setCursor(null);
            }
        } else {
            JOptionPane.showMessageDialog(context, I18n._((String)"vradi.adminFormType.template.showExample.error.message"), I18n._((String)"vradi.adminFormType.template.showExample.error.title"), 0);
        }
    }

    public void uploadNewTemplate(AdminFormTypeUI context) {
        File template = FileUtil.getFile((Component)context, (FileFilter[])new FileFilter[0]);
        try {
            File copy = this.getVradiStorageService().addTemplate(context.getBean(), template);
            JComboBox templates = context.getTemplateChoice();
            templates.addItem(copy);
            templates.setSelectedItem(copy);
        }
        catch (VradiException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            ErrorDialogUI.showError((Exception)((Object)e));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void showHistory(String id) {
        String queryHistory = this.getVradiStorageService().getQueryHistoryFile(id);
        String serviceContext = VradiService.getInstance().getServiceContext();
        if (serviceContext == null) {
            VradiConfig vradiConfig = VradiContext.get().getVradiConfig();
            File vradiUserDirectory = vradiConfig.getVradiUserDirectory();
            File rssFile = new File(vradiUserDirectory, queryHistory);
            if (!rssFile.exists()) {
                rssFile = new File(vradiUserDirectory + "-SNAPSHOT", queryHistory);
            }
            try {
                URL url = rssFile.toURI().toURL();
                UIHelper.browseURI(url);
            }
            catch (MalformedURLException e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            UIHelper.browseURI(serviceContext + "/" + queryHistory);
        }
    }
}

