/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi;

import com.caucho.hessian.server.HessianServlet;
import com.jurismarches.vradi.services.MailingService;
import com.jurismarches.vradi.services.MailingServiceImpl;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.services.VradiStorageServiceImpl;
import com.jurismarches.vradi.services.XmlStreamService;
import com.jurismarches.vradi.services.XmlStreamServiceImpl;
import javax.servlet.Servlet;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;

public class VradiEmbededHessian {
    final Server server;

    public VradiEmbededHessian(int port) throws Exception {
        this.server = new Server(port);
        this.server.setStopAtShutdown(true);
    }

    protected void start() throws Exception {
        HessianServlet storageServlet = new HessianServlet();
        storageServlet.setHomeAPI(VradiStorageService.class);
        storageServlet.setHome((Object)new VradiStorageServiceImpl());
        HessianServlet xmlStreamServlet = new HessianServlet();
        xmlStreamServlet.setHomeAPI(XmlStreamService.class);
        xmlStreamServlet.setHome((Object)new XmlStreamServiceImpl());
        HessianServlet mailingServlet = new HessianServlet();
        mailingServlet.setHomeAPI(MailingService.class);
        mailingServlet.setHome((Object)new MailingServiceImpl());
        Context root = new Context((HandlerContainer)this.server, "/");
        root.addServlet(new ServletHolder((Servlet)storageServlet), "/storage");
        root.addServlet(new ServletHolder((Servlet)xmlStreamServlet), "/xmlstream");
        root.addServlet(new ServletHolder((Servlet)mailingServlet), "/mailing");
        this.server.start();
    }

    protected void stop() throws Exception {
        this.server.stop();
    }

    public static void main(String[] args) throws Exception {
        VradiEmbededHessian server = new VradiEmbededHessian(9000);
        server.start();
        Thread.sleep(300000L);
        server.stop();
        System.exit(0);
    }
}

