/*
 * *##%
 * Vradi :: Swing
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.ui.editors;

import java.awt.Component;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;

import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableCellEditor;

import jaxx.runtime.swing.OneClicListSelectionModel;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.jurismarches.vradi.ui.helpers.UIHelper;


/**
 * Un éditeur de {@link JList} dans une cellule de tableau.
 * <p/>
 * Les objects sélectionnés de la liste sont ceux renvoyés par l'éditeur.
 * <p/>
 * User: chemit
 * Date: 15 nov. 2009
 * Time: 21:15:39
 */
public class JListCellEditor extends AbstractCellEditor implements TableCellEditor {

    private static final long serialVersionUID = 1L;

    /**
     * Logger
     */
    static private final Log log = LogFactory.getLog(JListCellEditor.class);
    /**
     * le composant pour éditer
     */
    protected JList list;
    /**
     * l'editeur de délégation, pour obtenir certaines informations sur le rendu visuel
     */
    protected TableCellEditor delegate;


    public JListCellEditor(TableCellEditor delegate, boolean singleSelection) {
        this.delegate = delegate;
        this.list = new JList(new DefaultListModel());
        OneClicListSelectionModel selectModel = new OneClicListSelectionModel(list.getSelectionModel(), list.getModel());
        if(singleSelection) {
            selectModel.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        }
        list.setSelectionModel(selectModel);
        this.list.setBorder(BorderFactory.createLoweredBevelBorder());
    }

    public JListCellEditor() {
        this(new DefaultCellEditor(new JTextField()), false);
    }

    public JListCellEditor(boolean singleSelection) {
        this(new DefaultCellEditor(new JTextField()), singleSelection);
    }

    /**
     * Pour mettre à jour la liste des valeurs sélectionnables.
     *
     * @param values les valeurs sélectionnables (à placer dans le modèle de la liste)
     */

    public void updateUniverse(List<String> values) {
        UIHelper.fillList(list, values, null);
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        boolean b = super.isCellEditable(e);
        b &= ((Component) e.getSource()).hasFocus();
//        if (e instanceof MouseEvent) {
//            return b && ((MouseEvent) e).getClickCount() > 1;
//        }
        return b;
    }

    @Override
    public Object getCellEditorValue() {
        Object[] values = list.getSelectedValues();
        if (log.isDebugEnabled()) {
            log.debug("selected values = " + Arrays.toString(values));
        }
        return values;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (log.isDebugEnabled()) {
            log.debug("editor value" + value);
        }

        UIHelper.updateListSelection(list, value);

        // obtain visual render from delegate
        list.setFont(table.getFont());

        return list;
    }
}
