package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.BlockingLayerUI;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.SwingUtil.getStringValue;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminStatusUI extends jaxx.runtime.swing.Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_MODIFIED = "modified";
    public static final String PROPERTY_VALIDE = "valide";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_SAVE_ENABLED = "save.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUy24TMRR1QpO06YNH1dLSIkKpWKFJxWtBKugDVbRKARFAFdngzLiNK2c82J50ukF8Ap8AezZI7FghFqxZsEH8AkIs2CKuPUkmU4Y0olHlVNf3nHvuyb1+8x1lpEDnd3EQWMJ3FW0Qa2N5a+tebZfY6jaRtqCe4gKFn1Qapato2OnEpUIXqmUNL7bgxVXe8LhL3C50qYzyUu0zIuuEKIXOxhG2lMVK57oUeL5os3ZEJbG++vkj/dJ58TqNUOCBumFopXAYKupkoIzS1FHoFFRq4iLD7g7IENTdAb2jOrbKsJR3cYM8Q89RroyyHhZAptBc/y0bDoMPPIVGsdOgbkVh5ctH6wpds3nD2vUFlQ0s7DqRVlNgh1o+tUymZXNXAbG13I3zPMOYVWiwwR26TQm0cVIrtnQX1grnjGA3Sss2MaOOaWMsiuaJEFw8xDVGFFqMGWfyMfRhyT0wxKro83E7uEmkxDvEIDe5Q1iXoPmNMq4RtgC+akFBiyCM6qQhBX9UMVIm26oNG7EFwYqEDSo0HoOu+Epx12A7dUbnNyq24Izdxy6BYqdjiOgqjsq17DwoTmcacTOd1DFoiyjirIYIHS3EybI2du0QdiZ+MyBxk3THBZqJ2QsTb0UTH41kqooywoewQlPVv5fkAVyF6zF1YD00obn9PTn+5f23d2vtnchD7YnE1K6Vhln1BPeIUFSXPh4uhK8oK25ir1RFQxLMsMN9n00QVmldgzioF06ihlt3sKwDRSb39cPHyaefj6H0Gsozjp01rPPXYRTqAlzgzAm8W0tG0cjeIJwntDawUpFA/1yL1GXUJQWsYENrviI3A7BhNsGGjpba0Kdf45W3S20rUiBt+p/pkR2ZJygbVjMPRGv3Ex+EYU8S3+HRjidtfUp/T3itHblkzoXEXqkeTzS2CEuGCzXqOjCc0KcGXDUN6P+uG77pQ/l0+LI+rvwvA4w4w/vcN8NfSmY51wdLrkklhaeih5i5vtq50UPI/JEN6Y+hl4aL/ZhBXP1sOkeiOawVzfAHV0UA29wHAAA=";
    protected static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.content.AdminStatusUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminStatusUI adminStatusUI = this;
    protected javax.swing.JButton cancel;
    protected javax.swing.JPanel content;
    protected javax.swing.JButton createStatus;
    protected javax.swing.JPanel deletedContent;
    protected jaxx.runtime.validator.swing.SwingValidatorMessageTableModel errorTable;
    protected java.lang.Boolean modified;
    protected javax.swing.JButton save;
    protected java.lang.Boolean valide;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JLabel $JLabel0;
    private javax.swing.JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    void $afterCompleteSetup() {
        setContextValue(errorTable, "errorTable");
        createStatuses(false);
        //errorTable.registerValidator(validator);
    }
    
    public void createStatuses(boolean triggeredByCancelButton) {
        int confirm = -1;
        if(triggeredByCancelButton) {
            confirm = JOptionPane.showConfirmDialog(this,
                        _("vradi.admin.cancel.message"),
                        _("vradi.admin.cancel.title"),
                        JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE);
        }
        if(!triggeredByCancelButton || confirm == JOptionPane.YES_OPTION) {
            content.setVisible(false);
            content.removeAll();
            java.util.List<Status> statuses = getHandler().getAllStatuses();
            for (Status status : statuses){
                createStatus(status);
            }
            content.setVisible(true);
    
            setModified(false);
        }
    }
    
    protected void createStatus() {
        Status status = new StatusImpl();
        status.setValue(content.getComponentCount());
        status.setModifiable(true);
        createStatus(status);
    }
    
    protected void createStatus(Status status) {
       VradiStatusDTO bean = new VradiStatusDTO();
       bean.fromWikitty(status);
    
       StatusEditionUI result = new StatusEditionUI(this);
       result.setWikitty(status);
       result.setBean(bean);
    
       result.addPropertyChangeListener(StatusEditionUI.PROPERTY_MODIFIED, new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                StatusEditionUI statusUI = (StatusEditionUI) evt.getSource();
                
                log.debug("status " + statusUI.getBean() + " modified value =  " + evt.getNewValue());
                setModified(true);
                
                if(evt.getNewValue() == null) {
                    if(statusUI != null) {
                        statusUI.setVisible(false);
                        content.remove(statusUI);
                    }
                
                    if(statusUI.getBean().isUpOrDown() != null) {
                        if(statusUI.getBean().isUpOrDown() && statusUI.getBean().getValue() == 0) {
                            content.add(statusUI, 0);
                            
                        } else if(!statusUI.getBean().isUpOrDown() && statusUI.getBean().getValue() == content.getComponentCount()) {
                            content.add(statusUI);
                            
                        } else {
                            int statusToMovePosition = statusUI.getBean().isUpOrDown() ?
                                    statusUI.getBean().getValue() - 1 : statusUI.getBean().getValue();
                            int statusToAddPosition = statusUI.getBean().isUpOrDown() ?
                                    statusUI.getBean().getValue() - 1 : statusUI.getBean().getValue() + 1;
                            
                            StatusEditionUI statusToMove = (StatusEditionUI) content.getComponent(statusToMovePosition);
                            log.debug(statusToMove.getBean().getName() + " : " + statusToMove.getBean().getValue());
    
                            content.add(statusUI, statusToAddPosition);
                        }
                        
                        statusUI.getBean().setUpOrDown(null);
                        statusUI.setVisible(true);
                        
                    } else {
                        deletedContent.add(statusUI);
                    }
    
                    for(int i = 0 ; i < content.getComponentCount() ; i++) {
                        StatusEditionUI statusEditionUI = (StatusEditionUI) content.getComponent(i);
                        statusEditionUI.getBean().setValue(i);
                    }
                    
                    validate();
                }
            }
        });
        
        result.setModified(false);
        content.add(result);
        validate();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminStatusUI() {
        $initialize();
    }

    public AdminStatusUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(java.awt.event.ActionEvent event) {
        createStatuses(true);
    }

    public void doActionPerformed__on__createStatus(java.awt.event.ActionEvent event) {
        createStatus(); setModified(true);
    }

    public void doActionPerformed__on__save(java.awt.event.ActionEvent event) {
        getHandler().saveStatuses(this);setModified(false);
    }

    public void doTableChanged__on__errorTable(javax.swing.event.TableModelEvent event) {
        setValide(errorTable.getRowCount()==0);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JButton getCancel() {
        return cancel;
    }

    public javax.swing.JPanel getContent() {
        return content;
    }

    public javax.swing.JButton getCreateStatus() {
        return createStatus;
    }

    public javax.swing.JPanel getDeletedContent() {
        return deletedContent;
    }

    public jaxx.runtime.validator.swing.SwingValidatorMessageTableModel getErrorTable() {
        return errorTable;
    }

    public java.lang.Boolean getModified() {
        return modified;
    }

    public javax.swing.JButton getSave() {
        return save;
    }

    public java.lang.Boolean getValide() {
        return valide;
    }

    public java.lang.Boolean isModified() {
        return modified !=null && modified;
    }

    public java.lang.Boolean isValide() {
        return valide !=null && valide;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setModified(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.modified;
        this.modified = newValue;
        firePropertyChange(PROPERTY_MODIFIED, oldValue, newValue);
    }

    public void setValide(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.valide;
        this.valide = newValue;
        firePropertyChange(PROPERTY_VALIDE, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminStatusUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(createStatus, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.7, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        add(deletedContent, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(cancel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(save, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new javax.swing.JButton());
        cancel.setName("cancel");
        cancel.setText(_("vradi.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createContent() {
        $objectMap.put("content", content = new javax.swing.JPanel());
        content.setName("content");
        content.setLayout(new GridLayout(0,1));
    }

    protected void createCreateStatus() {
        $objectMap.put("createStatus", createStatus = new javax.swing.JButton());
        createStatus.setName("createStatus");
        createStatus.setText(_("vradi.adminStatus.createStatus"));
        createStatus.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createStatus"));
    }

    protected void createDeletedContent() {
        $objectMap.put("deletedContent", deletedContent = new javax.swing.JPanel());
        deletedContent.setName("deletedContent");
        deletedContent.setVisible(false);
    }

    protected void createErrorTable() {
        $objectMap.put("errorTable", errorTable = new jaxx.runtime.validator.swing.SwingValidatorMessageTableModel());
        errorTable.addTableModelListener(JAXXUtil.getEventListener(TableModelListener.class, "tableChanged", this, "doTableChanged__on__errorTable"));
    }

    protected void createModified() {
        $objectMap.put("modified", modified = false);
    }

    protected void createSave() {
        $objectMap.put("save", save = new javax.swing.JButton());
        save.setName("save");
        save.setText(_("vradi.common.save"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createValide() {
        $objectMap.put("valide", valide = true);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToAdminStatusUI();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(content);
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 4 property setters
        createStatus.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("add"));
        cancel.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("cancel"));
        save.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("save"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 1 data bindings
        $registerDefaultBindings();
        $objectMap.put("adminStatusUI", this);
        createModified();
        createValide();
        createErrorTable();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminStatus.title"));
        createCreateStatus();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        $JScrollPane0.setName("$JScrollPane0");
        createContent();
        createDeletedContent();
        createCancel();
        createSave();
        // inline creation of adminStatusUI
        setName("adminStatusUI");
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SAVE_ENABLED, true ,"modified") {
        
            @Override
            public void processDataBinding() {
                save.setEnabled(isModified());
            }
        });
    }

}