package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.text.DateFormat;
import java.util.*;
import java.util.Date;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.HidorButton;
import jaxx.runtime.swing.ListSelectorUI;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.swing.navigation.tree.NavigationTreeNode;
import jaxx.runtime.validator.swing.SwingValidator;
import org.sharengo.wikitty.BusinessEntityWikitty;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.SwingUtil.getStringValue;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminClientUI extends com.jurismarches.vradi.ui.admin.AdminContentUI<Client> implements jaxx.runtime.JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_IN_GROUP = "inGroup";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CLIENT_ADDRESS_TEXT = "clientAddress.text";
    public static final String BINDING_CLIENT_CONTACT_TEXT = "clientContact.text";
    public static final String BINDING_CLIENT_GROUPS_VISIBLE = "clientGroups.visible";
    public static final String BINDING_CLIENT_NAME_TEXT = "clientName.text";
    public static final String BINDING_CLIENT_PHONE_TEXT = "clientPhone.text";
    public static final String BINDING_REQUEST_LIST_UI_BEAN = "requestListUI.bean";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$ADMIN_CONTENT_UI0_ENABLED = "$AdminContentUI0.enabled";
    private static final String BINDING_$JBUTTON0_VISIBLE = "$JButton0.visible";
    private static final String BINDING_$JBUTTON1_ENABLED = "$JButton1.enabled";
    private static final String BINDING_$JBUTTON1_VISIBLE = "$JButton1.visible";
    private static final String BINDING_$JBUTTON2_ENABLED = "$JButton2.enabled";
    private static final String BINDING_$JBUTTON2_VISIBLE = "$JButton2.visible";
    private static final String BINDING_$JBUTTON3_ENABLED = "$JButton3.enabled";
    private static final String BINDING_$JBUTTON3_VISIBLE = "$JButton3.visible";
    private static final String BINDING_$JLABEL0_TEXT = "$JLabel0.text";
    private static final String BINDING_$JLABEL5_VISIBLE = "$JLabel5.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table adminClientForm;
    protected com.jurismarches.vradi.services.dto.VradiClientDTO bean;
    protected javax.swing.JTextField clientAddress;
    protected javax.swing.JTextField clientContact;
    protected jaxx.runtime.swing.ListSelectorUI< Group > clientGroups;
    protected javax.swing.JTextField clientName;
    protected javax.swing.JTextField clientPhone;
    protected java.lang.Boolean inGroup;
    protected jaxx.runtime.swing.HBox lastModified;
    protected com.jurismarches.vradi.ui.admin.content.RequestListUI requestListUI;
    protected jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.services.dto.VradiClientDTO > validator;
    protected java.util.List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private AdminClientUI $AdminContentUI0 = this;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JPanel $JPanel0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JButton $JButton1;
    private javax.swing.JButton $JButton2;
    private javax.swing.JButton $JButton3;
    private jaxx.runtime.swing.HidorButton $HidorButton0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JButton $JButton4;
    private javax.swing.JLabel $JLabel3;
    private javax.swing.JLabel $JLabel4;
    private javax.swing.JLabel $JLabel5;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    void $afterCompleteSetup() {
        if (log.isDebugEnabled()) {
            addPCSLogger();
            addBeanPCSLogger(bean);
        }
        addBeanModifiedPCS(bean);
        clientGroups.addPropertyChangeListener(ListSelectorUI.PROPERTY_MODIFIED, new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean b = (Boolean) evt.getNewValue();
                if (b != null && b) {
                    log.info("modified changed from groups");
                    setModified(true);
                }
            }
        });
        errorTable.registerValidator(validator);
    }
    
    @Override
    public void openUI(NavigationTreeNode node) throws Exception {
        super.openUI(node);
        requestListUI.init();
    
        java.util.List<Group> toCombo = getHandler().getAllGroups();
        java.util.List<Group> toList  = new java.util.ArrayList<Group>(toCombo);
    
        for (java.util.Iterator<Group> it = toList.iterator(); it.hasNext();) {
            Group group = it.next();
            if (group.getClient() == null || !group.getClient().contains(bean.getWikittyId())) {
                it.remove();
                log.debug("client does NOT use group " + group.getName());
            } else {
                toCombo.remove(group);
                log.debug("client use group " + group.getName());
            }
        }
        clientGroups.init(toCombo, toList);
        NavigationTreeNode parentNode = getHelper().getParentGroupNode(getHelper().getSelectedNode(this));
        setInGroup(parentNode != null);
    
        lastModified.removeAll();
        if(bean != null && bean.getLastModified() != null && bean.getLastModifier() != null) {
            String labelText = String.format(_("vradi.entity.lastModified.date.user"), bean.getLastModified(), bean.getLastModifier());
            lastModified.add(new JLabel(labelText));
        }
        lastModified.validate();
    }
    
    @Override
    protected void updateBeanFromEntity(Client bean) {
        this.bean.fromWikitty(bean);
    }
    
    @Override
    public void save() {
        // groups to save
        Map<String, Group> groups = new HashMap<String, Group>();
        
        this.bean.setLastModified(new java.util.Date());
        this.bean.setLastModifier(getContextValue(VradiUser.class).getName());
        
        Client client = (Client) getHelper().getSelectedBean(this);
        if(!client.getExtensionNames().contains(ModificationTag.EXT_MODIFICATION_TAG)) {
            BusinessEntityWikitty entityWikitty = (BusinessEntityWikitty) client;
            entityWikitty.getWikitty().addExtension(ModificationTag.EXTENSION_MODIFICATION_TAG);
        }
        this.bean.toWikitty(client);
    
        String wikittyId = client.getWikittyId();
        for (Group g : clientGroups.getComboDatas()) {
            if (g.getClient() != null && g.getClient().contains(wikittyId)) {
                // group was containing client, but no more
                g.removeClient(wikittyId);
                // mark it for save
                groups.put(g.getWikittyId(), g);
            }
        }
        for (Group g : clientGroups.getListDatas()) {
            if (g.getClient() == null || !g.getClient().contains(wikittyId)) {
                // group was not containing client, but do now
                g.addClient(wikittyId);
                // mark it for save
                groups.put(g.getWikittyId(), g);
            }
        }
        
        client = getHandler().saveClient(this, getHelper(), client, groups.values());
    }
        
    protected void deleteFromGroup() {
        getHandler().removeFromGroup(this, getHelper());
    }
    
    protected String updateTitle(String name) {
       return _("vradi.adminClient.title", getStringValue(name));
    }
    
    protected void openAddressInBrowser() {
        UIHelper.openAddressInBrowser(bean.getAddress());
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminClientUI() {
        super();
        $initialize();
    }

    public AdminClientUI(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidation implementation --------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.services.dto.VradiClientDTO > getValidator() {
        return validator;
    }

    @Override
    public jaxx.runtime.validator.swing.SwingValidator<?> getValidator(String validatorId) {
        return (jaxx.runtime.validator.swing.SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public java.util.List<String> getValidatorIds() {
        return validatorIds;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton4(java.awt.event.ActionEvent event) {
        openAddressInBrowser();
    }

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getHandler().createClient(this, getHelper());                                 setModified(true);
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        getHandler().createUser(this, getHelper());
    }

    public void doActionPerformed__on__$JButton2(java.awt.event.ActionEvent event) {
        getHandler().delete(this, getHelper(), bean);
    }

    public void doActionPerformed__on__$JButton3(java.awt.event.ActionEvent event) {
        deleteFromGroup();
    }

    public void doKeyReleased__on__clientAddress(java.awt.event.KeyEvent event) {
        bean.setAddress(clientAddress.getText());
    }

    public void doKeyReleased__on__clientContact(java.awt.event.KeyEvent event) {
        bean.setContact(clientContact.getText());
    }

    public void doKeyReleased__on__clientName(java.awt.event.KeyEvent event) {
        bean.setName(clientName.getText());
    }

    public void doKeyReleased__on__clientPhone(java.awt.event.KeyEvent event) {
        bean.setPhone(clientPhone.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.swing.Table getAdminClientForm() {
        return adminClientForm;
    }

    public com.jurismarches.vradi.services.dto.VradiClientDTO getBean() {
        return bean;
    }

    public javax.swing.JTextField getClientAddress() {
        return clientAddress;
    }

    public javax.swing.JTextField getClientContact() {
        return clientContact;
    }

    public jaxx.runtime.swing.ListSelectorUI< Group > getClientGroups() {
        return clientGroups;
    }

    public javax.swing.JTextField getClientName() {
        return clientName;
    }

    public javax.swing.JTextField getClientPhone() {
        return clientPhone;
    }

    public java.lang.Boolean getInGroup() {
        return inGroup;
    }

    public jaxx.runtime.swing.HBox getLastModified() {
        return lastModified;
    }

    public com.jurismarches.vradi.ui.admin.content.RequestListUI getRequestListUI() {
        return requestListUI;
    }

    public java.lang.Boolean isInGroup() {
        return inGroup !=null && inGroup;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setInGroup(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.inGroup;
        this.inGroup = newValue;
        firePropertyChange(PROPERTY_IN_GROUP, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    protected javax.swing.JButton get$JButton2() {
        return $JButton2;
    }

    protected javax.swing.JButton get$JButton3() {
        return $JButton3;
    }

    protected jaxx.runtime.swing.HidorButton get$HidorButton0() {
        return $HidorButton0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JButton get$JButton4() {
        return $JButton4;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected javax.swing.JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected javax.swing.JLabel get$JLabel5() {
        return $JLabel5;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminClientForm() {
        if (!allComponentsCreated) {
            return;
        }
        adminClientForm.add($JLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add(SwingUtil.boxComponentWithJxLayer(clientName), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add($JLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add(clientAddress, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add($JButton4, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add($JLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add(clientPhone, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add($JLabel4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add(clientContact, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add($JLabel5, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add(clientGroups, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(adminClientForm, BorderLayout.NORTH);
        body.add(requestListUI, BorderLayout.CENTER);
        body.add(lastModified, BorderLayout.SOUTH);
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        toolbar.add($JPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(jaxx.runtime.validator.swing.ui.ImageValidationUI.class);
        validator.setFieldRepresentation("name", clientName);
    }

    protected void createAdminClientForm() {
        $objectMap.put("adminClientForm", adminClientForm = new jaxx.runtime.swing.Table());
        adminClientForm.setName("adminClientForm");
    }

    protected void createBean() {
        $objectMap.put("bean", bean = new com.jurismarches.vradi.services.dto.VradiClientDTO());
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createClientAddress() {
        $objectMap.put("clientAddress", clientAddress = new javax.swing.JTextField());
        clientAddress.setName("clientAddress");
        clientAddress.setColumns(15);
        clientAddress.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__clientAddress"));
    }

    protected void createClientContact() {
        $objectMap.put("clientContact", clientContact = new javax.swing.JTextField());
        clientContact.setName("clientContact");
        clientContact.setColumns(15);
        clientContact.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__clientContact"));
    }

    protected void createClientGroups() {
        $objectMap.put("clientGroups", clientGroups = new jaxx.runtime.swing.ListSelectorUI< Group >());
        clientGroups.setName("clientGroups");
        clientGroups.setShowHidor(true);
        ((javax.swing.JToolBar) clientGroups.getObjectById("actions")).setOpaque(false);
        ((javax.swing.JToolBar) clientGroups.getObjectById("actions")).setBorderPainted(false);
    }

    protected void createClientName() {
        $objectMap.put("clientName", clientName = new javax.swing.JTextField());
        clientName.setName("clientName");
        clientName.setColumns(15);
        clientName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__clientName"));
    }

    protected void createClientPhone() {
        $objectMap.put("clientPhone", clientPhone = new javax.swing.JTextField());
        clientPhone.setName("clientPhone");
        clientPhone.setColumns(15);
        clientPhone.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__clientPhone"));
    }

    protected void createInGroup() {
        $objectMap.put("inGroup", inGroup = null);
    }

    protected void createLastModified() {
        $objectMap.put("lastModified", lastModified = new jaxx.runtime.swing.HBox());
        lastModified.setName("lastModified");
        lastModified.setHorizontalAlignment(4);
    }

    protected void createRequestListUI() {
        $objectMap.put("requestListUI", requestListUI = new com.jurismarches.vradi.ui.admin.content.RequestListUI(this));
        requestListUI.setName("requestListUI");
    }

    @Override
    protected void createToolbar() {
        $objectMap.put("toolbar", toolbar = new jaxx.runtime.swing.Table());
        toolbar.setName("toolbar");
        ((jaxx.runtime.swing.Table) toolbar).setLayout(new BoxLayout(toolbar, 0));
        ((jaxx.runtime.swing.Table) toolbar).putClientProperty("help", "ui.main.toolbar");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = new jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.services.dto.VradiClientDTO >(com.jurismarches.vradi.services.dto.VradiClientDTO.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToValidator();
        addChildrenToToolbar();
        // inline complete setup of $JPanel0
        $JPanel0.add($JButton0);
        $JPanel0.add($JButton1);
        $JPanel0.add($JButton2);
        $JPanel0.add($JButton3);
        $JPanel0.add($HidorButton0);
        addChildrenToBody();
        addChildrenToAdminClientForm();
        
        // apply 17 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 17 property setters
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("client.add"));
        $JButton2.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("client.delete"));
        $JButton3.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("delete"));
        $HidorButton0.setHideTip(_("vradi.adminClient.hideForm"));
        $HidorButton0.setShowTip(_("vradi.adminClient.showForm"));
        $HidorButton0.setTarget(adminClientForm);
        $HidorButton0.setTargetVisible(true);
        adminClientForm.setMinimumSize(SwingUtil.newMinDimension());
        $JButton4.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("site"));
        clientGroups.setAddToComboTip(_("vradi.adminClient.removeGroups"));
        clientGroups.setAddToListTip(_("vradi.adminClient.addGroup"));
        clientGroups.setMinimumSize(new Dimension(100,250));
        clientGroups.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        $JLabel0.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        $JLabel0.setHorizontalTextPosition(JLabel.LEFT);
        // late initializer
        // register 1 validator(s)
        validatorIds.add("validator");
        getValidator("validator").installUIs();
        getValidator("validator").reloadBean();
        validatorIds = java.util.Collections.unmodifiableList(validatorIds);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 17 data bindings
        $registerDefaultBindings();
        $objectMap.put("$AdminContentUI0", this);
        createBean();
        createInGroup();
        createValidator();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        $JLabel0.setName("$JLabel0");
        if ($JLabel0.getFont() != null) {
            $JLabel0.setFont($JLabel0.getFont().deriveFont((float) 20));
        }
        if ($JLabel0.getFont() != null) {
            $JLabel0.setFont($JLabel0.getFont().deriveFont($JLabel0.getFont().getStyle() | Font.BOLD));
        }
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        $JPanel0.setName("$JPanel0");
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.adminClient.createClient"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("vradi.adminClient.createUser"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of $JButton2
        $objectMap.put("$JButton2", $JButton2 = new javax.swing.JButton());
        $JButton2.setName("$JButton2");
        $JButton2.setToolTipText(_("vradi.adminClient.deleteClient"));
        $JButton2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton2"));
        // inline creation of $JButton3
        $objectMap.put("$JButton3", $JButton3 = new javax.swing.JButton());
        $JButton3.setName("$JButton3");
        $JButton3.setToolTipText(_("vradi.adminClient.deleteClientFromGroup"));
        $JButton3.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton3"));
        // inline creation of $HidorButton0
        $objectMap.put("$HidorButton0", $HidorButton0 = new jaxx.runtime.swing.HidorButton());
        $HidorButton0.setName("$HidorButton0");
        createAdminClientForm();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.adminClient.name"));
        createClientName();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new javax.swing.JLabel());
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("vradi.adminClient.adresse"));
        createClientAddress();
        // inline creation of $JButton4
        $objectMap.put("$JButton4", $JButton4 = new javax.swing.JButton());
        $JButton4.setName("$JButton4");
        $JButton4.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton4"));
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new javax.swing.JLabel());
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("vradi.adminClient.tel"));
        createClientPhone();
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new javax.swing.JLabel());
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("vradi.adminClient.contact"));
        createClientContact();
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new javax.swing.JLabel());
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(_("vradi.adminClient.listGroup"));
        createClientGroups();
        createRequestListUI();
        createLastModified();
        // inline creation of $AdminContentUI0
        setName("$AdminContentUI0");
        ((javax.swing.JPanel) $AdminContentUI0.getObjectById("toolbar")).setLayout(new BoxLayout(toolbar, 0));
        
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 17 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$ADMIN_CONTENT_UI0_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("wikittyId", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    setEnabled(bean.getWikittyId() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("wikittyId", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(isEnabled() ? bean : null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL0_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    $JLabel0.setText(_(updateTitle(bean.getName())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_VISIBLE, true ,"inGroup") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setVisible(!isInGroup());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON1_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                $JButton1.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON1_VISIBLE, true ,"inGroup") {
        
            @Override
            public void processDataBinding() {
                $JButton1.setVisible(!isInGroup());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON2_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                $JButton2.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON2_VISIBLE, true ,"inGroup") {
        
            @Override
            public void processDataBinding() {
                $JButton2.setVisible(!isInGroup());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON3_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                $JButton3.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON3_VISIBLE, true ,"inGroup") {
        
            @Override
            public void processDataBinding() {
                $JButton3.setVisible(isInGroup());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CLIENT_NAME_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    jaxx.runtime.SwingUtil.setText(clientName, bean.getName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CLIENT_ADDRESS_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("address", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    jaxx.runtime.SwingUtil.setText(clientAddress, bean.getAddress());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("address", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CLIENT_PHONE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("phone", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    jaxx.runtime.SwingUtil.setText(clientPhone, bean.getPhone());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("phone", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CLIENT_CONTACT_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("contact", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    jaxx.runtime.SwingUtil.setText(clientContact, bean.getContact());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("contact", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL5_VISIBLE, true ,"inGroup") {
        
            @Override
            public void processDataBinding() {
                $JLabel5.setVisible(!isInGroup());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CLIENT_GROUPS_VISIBLE, true ,"inGroup") {
        
            @Override
            public void processDataBinding() {
                clientGroups.setVisible(!isInGroup());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REQUEST_LIST_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                requestListUI.setBean(getBean());
            }
        });
    }

}