package com.jurismarches.vradi.ui.admin;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.admin.*;
import com.jurismarches.vradi.ui.helpers.ThesaurusTreeHelper;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.renderer.ThesaurusHighlighter;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.JAXXTree;
import jaxx.runtime.swing.JAXXTree.JAXXTreeModel;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.swing.navigation.tree.NavigationTreeNode;
import jaxx.runtime.swing.navigation.treetable.NavigationTreeTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.decorator.*;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class ThesaurusPathChooserUI extends javax.swing.JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_EXPAND = "expand";
    public static final String PROPERTY_SAVED = "saved";
    public static final String PROPERTY_SELECTED = "selected";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_SELECT_ENABLED = "select.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    protected static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.ThesaurusPathChooserUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JButton cancel;
    protected java.lang.Boolean expand;
    protected java.lang.Boolean saved;
    protected javax.swing.JButton select;
    protected java.lang.Boolean selected;
    protected org.jdesktop.swingx.JXTreeTable thesaurus;
    protected ThesaurusPathChooserUI thesaurusPathChooserUI = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected ThesaurusTreeHelper helper;
    
    
    public  ThesaurusPathChooserUI(jaxx.runtime.JAXXContext parentContext, ThesaurusTreeHelper helper) {
        jaxx.runtime.SwingUtil.initContext(this, parentContext);
        this.helper = helper;
        setContextValue(helper);
    $initialize();
    }
    
    public void setHelper(ThesaurusTreeHelper helper){
        this.helper = helper;
    }
    
    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    protected ThesaurusTreeHelper getHelper() {
        return helper;
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
        thesaurus.putClientProperty("JTree.lineStyle", "Angled");
    
        // Adding ridht clic menu
    //    thesaurus.addMouseListener(new MouseAdapter() {
    //
    //        @Override
    //        public void mouseClicked(final MouseEvent mouseEvent) {
    //            JXTreeTable treeTable = (JXTreeTable) mouseEvent.getSource();
    //            TreePath path = treeTable.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
    //
    //            // Clear if no selection
    //            if (path == null){
    //                treeTable.clearSelection();
    //                getHelper().setSelectedNode(ThesaurusPathChooserUI.this, null);
    //                setSelected(false);
    //            } else {
    //                setSelected(true);
    //            }
    //        }
    //    });
    
        thesaurus.addTreeSelectionListener(helper.createTreeHandler(this));
        if (expand){
            SwingUtil.addExpandOnClickListener(thesaurus);
        }
    }
        
    protected void close(){
        setVisible(false);
        dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ThesaurusPathChooserUI() {
        $initialize();
    }

    public ThesaurusPathChooserUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(java.awt.event.ActionEvent event) {
        close();
    }

    public void doActionPerformed__on__select(java.awt.event.ActionEvent event) {
        setSaved(true);close();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JButton getCancel() {
        return cancel;
    }

    public java.lang.Boolean getExpand() {
        return expand;
    }

    public java.lang.Boolean getSaved() {
        return saved;
    }

    public javax.swing.JButton getSelect() {
        return select;
    }

    public java.lang.Boolean getSelected() {
        return selected;
    }

    public org.jdesktop.swingx.JXTreeTable getThesaurus() {
        return thesaurus;
    }

    public java.lang.Boolean isExpand() {
        return expand !=null && expand;
    }

    public java.lang.Boolean isSaved() {
        return saved !=null && saved;
    }

    public java.lang.Boolean isSelected() {
        return selected !=null && selected;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setExpand(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.expand;
        this.expand = newValue;
        firePropertyChange(PROPERTY_EXPAND, oldValue, newValue);
    }

    public void setSaved(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.saved;
        this.saved = newValue;
        firePropertyChange(PROPERTY_SAVED, oldValue, newValue);
    }

    public void setSelected(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.selected;
        this.selected = newValue;
        firePropertyChange(PROPERTY_SELECTED, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToThesaurusPathChooserUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0, BorderLayout.CENTER);
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new javax.swing.JButton());
        cancel.setName("cancel");
        cancel.setText(_("vradi.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createExpand() {
        $objectMap.put("expand", expand = VradiHelper.isExpandSelected());
    }

    protected void createSaved() {
        $objectMap.put("saved", saved = false);
    }

    protected void createSelect() {
        $objectMap.put("select", select = new javax.swing.JButton());
        select.setName("select");
        select.setText(_("vradi.common.select"));
        select.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__select"));
    }

    protected void createSelected() {
        $objectMap.put("selected", selected = true);
    }

    protected void createThesaurus() {
        $objectMap.put("thesaurus", thesaurus = new org.jdesktop.swingx.JXTreeTable());
        thesaurus.setName("thesaurus");
        if (thesaurus.getFont() != null) {
            thesaurus.setFont(thesaurus.getFont().deriveFont((float) 11));
        }
        thesaurus.setRootVisible(false);
        thesaurus.setShowsRootHandles(true);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToThesaurusPathChooserUI();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.7, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(cancel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(select, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(thesaurus);
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 4 property setters
        thesaurus.setTreeTableModel((NavigationTreeTableModel)helper.createTreeModel(this));
        cancel.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("cancel"));
        select.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("select"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 1 data bindings
        $registerDefaultBindings();
        $objectMap.put("thesaurusPathChooserUI", this);
        createSelected();
        createSaved();
        createExpand();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminThesaurus.selectAsk"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        $JScrollPane0.setName("$JScrollPane0");
        createThesaurus();
        createCancel();
        createSelect();
        // inline creation of thesaurusPathChooserUI
        setName("thesaurusPathChooserUI");
        SwingUtil.setComponentHeight(thesaurusPathChooserUI,600);
        thesaurusPathChooserUI.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        setTitle(_("vradi.adminThesaurus.select"));
        SwingUtil.setComponentWidth(thesaurusPathChooserUI,800);
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SELECT_ENABLED, true ,"selected") {
        
            @Override
            public void processDataBinding() {
                select.setEnabled(isSelected());
            }
        });
    }

}