package com.jurismarches.vradi.ui.admin;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.admin.*;
import com.jurismarches.vradi.ui.helpers.AdminNavigationTreeHelper;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.CardLayout2;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.widget.datatips.DataTipManager;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminNavUI extends javax.swing.JSplitPane implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_FILTER_TREE_MODEL = "filterTreeModel";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_NAV_MODEL = "nav.model";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    public static final String PROPERTY$DOCUMENT0 = "$Document0";
    protected static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.AdminNavUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminNavUI adminNavUI = this;
    protected javax.swing.JPanel content;
    protected jaxx.runtime.swing.CardLayout2 contentLayout;
    protected javax.swing.JTextField filterField;
    protected org.nuiton.widget.tree.FilterTreeModel filterTreeModel;
    protected javax.swing.JPanel importExportContent;
    protected javax.swing.JTree nav;
    protected javax.swing.JPanel navPanel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.text.Document $Document0;
    private javax.swing.JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    // FIXME add doc about this code !!!
    protected boolean contextInitialized;
    
    
    public  AdminNavUI(JAXXContext parentContext, AdminNavigationTreeHelper helper) {
        SwingUtil.initContext(this, parentContext);
        setContextValue(helper);
        // FIXME add doc about this code !!!
        contextInitialized = true;
    $initialize();
    }
    
    public AdminContentUI getCurrentContent() {
        return (AdminContentUI) contentLayout.getVisibleComponent(content);
    }
    
    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    protected AdminNavigationTreeHelper getHelper() {
        return getContextValue(AdminNavigationTreeHelper.class);
    }
    
    protected void $afterCompleteSetup() {
         SwingUtil.addExpandOnClickListener(nav);
         // extended tooltip for hidden content
         DataTipManager.get().register(nav);
    }
    
    public void open() {
        SwingUtilities.invokeLater(new Runnable() {
    
            @Override
            public void run() {
                // bug suis les UI autre que nimbus
                // la selection des onglet ne se rafraichit pas tres bien
                repaint();
            }
        });
    }
    
    /**
     * Update tree filter on filter model and expand all tree.
     */
    protected void updateFilter() {
        String filterString = filterField.getText();
        AdminNavTreeFilter treeFilter = new AdminNavTreeFilter(filterString);
        filterTreeModel.setFilter(treeFilter);
        
        // si le filtre n'est pas vide, on etend completemen l'arbre
        if (StringUtils.isNotEmpty(filterString)) {
            expandAll(nav, new TreePath(nav.getModel().getRoot()));
        }
    }
    
    /**
     * Expand all node in tree.
     */
    protected void expandAll(JTree tree, TreePath parent) {
        // Traverse children
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            for (Enumeration e=node.children(); e.hasMoreElements(); ) {
                TreeNode n = (TreeNode)e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                expandAll(tree, path);
            }
        }
        // Expansion or collapse must be done bottom-up
        tree.expandPath(parent);
    }
    
    /**
     * Reset filter (clear filter text).
     */
    public void resetFilter() {
        getFilterField().setText("");
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminNavUI() {
        $initialize();
    }

    public AdminNavUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doInsertUpdate__on__$Document0(javax.swing.event.DocumentEvent event) {
        updateFilter();
    }

    public void doRemoveUpdate__on__$Document0(javax.swing.event.DocumentEvent event) {
        updateFilter();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JPanel getContent() {
        return content;
    }

    public jaxx.runtime.swing.CardLayout2 getContentLayout() {
        return contentLayout;
    }

    public javax.swing.JTextField getFilterField() {
        return filterField;
    }

    public org.nuiton.widget.tree.FilterTreeModel getFilterTreeModel() {
        return filterTreeModel;
    }

    public javax.swing.JPanel getImportExportContent() {
        return importExportContent;
    }

    public javax.swing.JTree getNav() {
        return nav;
    }

    public javax.swing.JPanel getNavPanel() {
        return navPanel;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$Document0(javax.swing.text.Document newValue) {
        javax.swing.text.Document oldValue = this.$Document0;
        this.$Document0 = newValue;
        firePropertyChange(PROPERTY$DOCUMENT0, oldValue, newValue);
    }

    public void setFilterTreeModel(org.nuiton.widget.tree.FilterTreeModel newValue) {
        org.nuiton.widget.tree.FilterTreeModel oldValue = this.filterTreeModel;
        this.filterTreeModel = newValue;
        firePropertyChange(PROPERTY_FILTER_TREE_MODEL, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.text.Document get$Document0() {
        return $Document0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminNavUI() {
        if (!allComponentsCreated) {
            return;
        }
        add(navPanel, JSplitPane.LEFT);
        add(content, JSplitPane.RIGHT);
    }

    protected void addChildrenToNavPanel() {
        if (!allComponentsCreated) {
            return;
        }
        navPanel.add(filterField, BorderLayout.NORTH);
        navPanel.add($JScrollPane0, BorderLayout.CENTER);
        navPanel.add(importExportContent, BorderLayout.SOUTH);
    }

    protected void createContent() {
        $objectMap.put("content", content = new javax.swing.JPanel());
        content.setName("content");
        content.setLayout(contentLayout);
    }

    protected void createContentLayout() {
        $objectMap.put("contentLayout", contentLayout = new jaxx.runtime.swing.CardLayout2());
        contentLayout.setUseOnlyVisibleComponentDimension(true);
    }

    protected void createFilterField() {
        $objectMap.put("filterField", filterField = new javax.swing.JTextField());
        filterField.setName("filterField");
        filterField.setColumns(15);
    }

    protected void createFilterTreeModel() {
        $objectMap.put("filterTreeModel", filterTreeModel = new org.nuiton.widget.tree.FilterTreeModel((TreeModel)getHelper().createTreeModel(this)));
    }

    protected void createImportExportContent() {
        $objectMap.put("importExportContent", importExportContent = new javax.swing.JPanel());
        importExportContent.setName("importExportContent");
        importExportContent.setLayout(new GridLayout(1,2));
    }

    protected void createNav() {
        $objectMap.put("nav", nav = new javax.swing.JTree());
        nav.setName("nav");
        if (nav.getFont() != null) {
            nav.setFont(nav.getFont().deriveFont((float) 11));
        }
        nav.setRootVisible(false);
        nav.setShowsRootHandles(false);
    }

    protected void createNavPanel() {
        $objectMap.put("navPanel", navPanel = new javax.swing.JPanel());
        navPanel.setName("navPanel");
        navPanel.setLayout(new BorderLayout());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToAdminNavUI();
        addChildrenToNavPanel();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(nav);
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 7 property setters
        setDividerLocation(200);
        setResizeWeight(0.1);
        $JScrollPane0.setColumnHeaderView(filterField);
        nav.setSelectionModel(getHelper().createTreeHandler(this));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 1 data bindings
        $registerDefaultBindings();
        $objectMap.put("adminNavUI", this);
        contextInitialized = false;
        createContentLayout();
        createNavPanel();
        createFilterField();
        // inline creation of $Document0
        $objectMap.put("$Document0", $Document0 = getFilterField().getDocument());
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document0"));
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document0"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        $JScrollPane0.setName("$JScrollPane0");
        createFilterTreeModel();
        createNav();
        createImportExportContent();
        createContent();
        // inline creation of adminNavUI
        setName("adminNavUI");
        setOneTouchExpandable(true);
        setContinuousLayout(true);
        setDividerSize(12);
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_NAV_MODEL, true ,"filterTreeModel") {
        
            @Override
            public void processDataBinding() {
                nav.setModel(getFilterTreeModel());
            }
        });
    }

}