/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.scanner.dtd;

import com.sun.msv.scanner.dtd.DTDEventListener;
import com.sun.msv.scanner.dtd.DTDParser;
import com.sun.msv.scanner.dtd.EndOfInputException;
import com.sun.msv.scanner.dtd.XmlChars;
import com.sun.msv.scanner.dtd.XmlReader;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Locale;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class InputEntity {
    private int start;
    private int finish;
    private char[] buf;
    private int lineNumber = 1;
    private boolean returnedFirstHalf = false;
    private boolean maybeInCRLF = false;
    private String name;
    private InputEntity next;
    private InputSource input;
    private Reader reader;
    private boolean isClosed;
    private DTDEventListener errHandler;
    private Locale locale;
    private StringBuffer rememberedText;
    private int startRemember;
    private boolean isPE;
    private static final int BUFSIZ = 8193;
    private static final char[] newline = new char[]{'\n'};

    public static InputEntity getInputEntity(DTDEventListener dTDEventListener, Locale locale) {
        InputEntity inputEntity = new InputEntity();
        inputEntity.errHandler = dTDEventListener;
        inputEntity.locale = locale;
        return inputEntity;
    }

    private InputEntity() {
    }

    public boolean isInternal() {
        return this.reader == null;
    }

    public boolean isDocument() {
        return this.next == null;
    }

    public boolean isParameterEntity() {
        return this.isPE;
    }

    public String getName() {
        return this.name;
    }

    public void init(InputSource inputSource, String string, InputEntity inputEntity, boolean bl) throws IOException, SAXException {
        this.input = inputSource;
        this.isPE = bl;
        this.reader = inputSource.getCharacterStream();
        if (this.reader == null) {
            InputStream inputStream = inputSource.getByteStream();
            this.reader = inputStream == null ? XmlReader.createReader(new URL(inputSource.getSystemId()).openStream()) : (inputSource.getEncoding() != null ? XmlReader.createReader(inputSource.getByteStream(), inputSource.getEncoding()) : XmlReader.createReader(inputSource.getByteStream()));
        }
        this.next = inputEntity;
        this.buf = new char[8193];
        this.name = string;
        this.checkRecursion(inputEntity);
    }

    public void init(char[] cArray, String string, InputEntity inputEntity, boolean bl) throws SAXException {
        this.next = inputEntity;
        this.buf = cArray;
        this.finish = cArray.length;
        this.name = string;
        this.isPE = bl;
        this.checkRecursion(inputEntity);
    }

    private void checkRecursion(InputEntity inputEntity) throws SAXException {
        if (inputEntity == null) {
            return;
        }
        inputEntity = inputEntity.next;
        while (inputEntity != null) {
            if (inputEntity.name != null && inputEntity.name.equals(this.name)) {
                this.fatal("P-069", new Object[]{this.name});
            }
            inputEntity = inputEntity.next;
        }
    }

    public InputEntity pop() throws IOException {
        this.close();
        return this.next;
    }

    public boolean isEOF() throws IOException, SAXException {
        if (this.start >= this.finish) {
            this.fillbuf();
            return this.start >= this.finish;
        }
        return false;
    }

    public String getEncoding() {
        if (this.reader == null) {
            return null;
        }
        if (this.reader instanceof XmlReader) {
            return ((XmlReader)this.reader).getEncoding();
        }
        if (this.reader instanceof InputStreamReader) {
            return ((InputStreamReader)this.reader).getEncoding();
        }
        return null;
    }

    public char getNameChar() throws IOException, SAXException {
        if (this.finish <= this.start) {
            this.fillbuf();
        }
        if (this.finish > this.start) {
            char c;
            if (XmlChars.isNameChar(c = this.buf[this.start++])) {
                return c;
            }
            --this.start;
        }
        return '\u0000';
    }

    public char getc() throws IOException, SAXException {
        if (this.finish <= this.start) {
            this.fillbuf();
        }
        if (this.finish > this.start) {
            char c = this.buf[this.start++];
            if (this.returnedFirstHalf) {
                if (c >= '\udc00' && c <= '\udfff') {
                    this.returnedFirstHalf = false;
                    return c;
                }
                this.fatal("P-070", new Object[]{Integer.toHexString(c)});
            }
            if (c >= ' ' && c <= '\ud7ff' || c == '\t' || c >= '\ue000' && c <= '\ufffd') {
                return c;
            }
            if (c == '\r' && !this.isInternal()) {
                this.maybeInCRLF = true;
                c = this.getc();
                if (c != '\n') {
                    this.ungetc();
                }
                this.maybeInCRLF = false;
                ++this.lineNumber;
                return '\n';
            }
            if (c == '\n' || c == '\r') {
                if (!this.isInternal() && !this.maybeInCRLF) {
                    ++this.lineNumber;
                }
                return c;
            }
            if (c >= '\ud800' && c < '\udc00') {
                this.returnedFirstHalf = true;
                return c;
            }
            this.fatal("P-071", new Object[]{Integer.toHexString(c)});
        }
        throw new EndOfInputException();
    }

    public boolean peekc(char c) throws IOException, SAXException {
        if (this.finish <= this.start) {
            this.fillbuf();
        }
        if (this.finish > this.start) {
            if (this.buf[this.start] == c) {
                ++this.start;
                return true;
            }
            return false;
        }
        return false;
    }

    public void ungetc() {
        if (this.start == 0) {
            throw new InternalError("ungetc");
        }
        --this.start;
        if (this.buf[this.start] == '\n' || this.buf[this.start] == '\r') {
            if (!this.isInternal()) {
                --this.lineNumber;
            }
        } else if (this.returnedFirstHalf) {
            this.returnedFirstHalf = false;
        }
    }

    public boolean maybeWhitespace() throws IOException, SAXException {
        boolean bl = false;
        boolean bl2 = false;
        while (true) {
            char c;
            if (this.finish <= this.start) {
                this.fillbuf();
            }
            if (this.finish <= this.start) {
                return bl;
            }
            if ((c = this.buf[this.start++]) != ' ' && c != '\t' && c != '\n' && c != '\r') break;
            bl = true;
            if (c != '\n' && c != '\r' || this.isInternal()) continue;
            if (c != '\n' || !bl2) {
                ++this.lineNumber;
                bl2 = false;
            }
            if (c != '\r') continue;
            bl2 = true;
        }
        --this.start;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean parsedContent(DTDEventListener dTDEventListener) throws IOException, SAXException {
        int n;
        int n2 = n = this.start;
        boolean bl = false;
        while (true) {
            block21: {
                char c;
                block26: {
                    block25: {
                        block24: {
                            block23: {
                                block22: {
                                    if (n < this.finish) break block22;
                                    if (n > n2) {
                                        dTDEventListener.characters(this.buf, n2, n - n2);
                                        bl = true;
                                        this.start = n;
                                    }
                                    if (this.isEOF()) {
                                        return bl;
                                    }
                                    n2 = this.start;
                                    n = n2 - 1;
                                    break block21;
                                }
                                c = this.buf[n];
                                if (c > ']' && c <= '\ud7ff' || c < '&' && c >= ' ' || c > '<' && c < ']' || c > '&' && c < '<' || c == '\t' || c >= '\ue000' && c <= '\ufffd') break block21;
                                if (c == '<' || c == '&') break;
                                if (c != '\n') break block23;
                                if (!this.isInternal()) {
                                    ++this.lineNumber;
                                }
                                break block21;
                            }
                            if (c != '\r') break block24;
                            if (!this.isInternal()) {
                                dTDEventListener.characters(this.buf, n2, n - n2);
                                dTDEventListener.characters(newline, 0, 1);
                                bl = true;
                                ++this.lineNumber;
                                if (this.finish > n + 1 && this.buf[n + 1] == '\n') {
                                    ++n;
                                }
                                n2 = this.start = n + 1;
                            }
                            break block21;
                        }
                        if (c != ']') break block25;
                        switch (this.finish - n) {
                            case 2: {
                                if (this.buf[n + 1] != ']') break;
                            }
                            case 1: {
                                if (this.reader != null) {
                                    if (this.isClosed) break;
                                    if (n == n2) {
                                        throw new InternalError("fillbuf");
                                    }
                                    if (--n > n2) {
                                        dTDEventListener.characters(this.buf, n2, n - n2);
                                        bl = true;
                                        this.start = n;
                                    }
                                    this.fillbuf();
                                    n2 = n = this.start;
                                    break;
                                }
                                break block21;
                            }
                            default: {
                                if (this.buf[n + 1] == ']' && this.buf[n + 2] == '>') {
                                    this.fatal("P-072", null);
                                    break;
                                }
                                break block21;
                            }
                        }
                        break block21;
                    }
                    if (c < '\ud800' || c > '\udfff') break block26;
                    if (n + 1 >= this.finish) {
                        if (n > n2) {
                            dTDEventListener.characters(this.buf, n2, n - n2);
                            bl = true;
                            this.start = n + 1;
                        }
                        if (this.isEOF()) {
                            this.fatal("P-081", new Object[]{Integer.toHexString(c)});
                        }
                        n = n2 = this.start;
                        break block21;
                    } else if (this.checkSurrogatePair(n)) {
                        ++n;
                        break block21;
                    } else {
                        --n;
                        break;
                    }
                }
                this.fatal("P-071", new Object[]{Integer.toHexString(c)});
            }
            ++n;
        }
        if (n == n2) {
            return bl;
        }
        dTDEventListener.characters(this.buf, n2, n - n2);
        this.start = n;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean unparsedContent(DTDEventListener dTDEventListener, boolean bl, String string) throws IOException, SAXException {
        if (!this.peek("![CDATA[", null)) {
            return false;
        }
        dTDEventListener.startCDATA();
        while (true) {
            boolean bl2 = false;
            boolean bl3 = bl;
            int n = this.start;
            while (n < this.finish) {
                block25: {
                    char c = this.buf[n];
                    if (!XmlChars.isChar(c)) {
                        bl3 = false;
                        if (c >= '\ud800' && c <= '\udfff') {
                            if (this.checkSurrogatePair(n)) {
                                ++n;
                                break block25;
                            } else {
                                --n;
                                break;
                            }
                        }
                        this.fatal("P-071", new Object[]{Integer.toHexString(this.buf[n])});
                    }
                    if (c == '\n') {
                        if (!this.isInternal()) {
                            ++this.lineNumber;
                        }
                    } else if (c == '\r') {
                        if (!this.isInternal()) {
                            if (bl3) {
                                if (string != null) {
                                    this.errHandler.error(new SAXParseException(DTDParser.messages.getMessage(this.locale, string), null));
                                }
                                dTDEventListener.ignorableWhitespace(this.buf, this.start, n - this.start);
                                dTDEventListener.ignorableWhitespace(newline, 0, 1);
                            } else {
                                dTDEventListener.characters(this.buf, this.start, n - this.start);
                                dTDEventListener.characters(newline, 0, 1);
                            }
                            ++this.lineNumber;
                            if (this.finish > n + 1 && this.buf[n + 1] == '\n') {
                                ++n;
                            }
                            this.start = n + 1;
                        }
                    } else if (c != ']') {
                        if (c != ' ' && c != '\t') {
                            bl3 = false;
                        }
                    } else {
                        if (n + 2 >= this.finish) break;
                        if (this.buf[n + 1] == ']' && this.buf[n + 2] == '>') {
                            bl2 = true;
                            break;
                        }
                        bl3 = false;
                    }
                }
                ++n;
            }
            if (bl3) {
                if (string != null) {
                    this.errHandler.error(new SAXParseException(DTDParser.messages.getMessage(this.locale, string), null));
                }
                dTDEventListener.ignorableWhitespace(this.buf, this.start, n - this.start);
            } else {
                dTDEventListener.characters(this.buf, this.start, n - this.start);
            }
            if (bl2) {
                this.start = n + 3;
                dTDEventListener.endCDATA();
                return true;
            }
            this.start = n;
            if (!this.isEOF()) continue;
            this.fatal("P-073", null);
        }
    }

    private boolean checkSurrogatePair(int n) throws SAXException {
        if (n + 1 >= this.finish) {
            return false;
        }
        char c = this.buf[n++];
        char c2 = this.buf[n];
        if (c >= '\ud800' && c < '\udc00' && c2 >= '\udc00' && c2 <= '\udfff') {
            return true;
        }
        this.fatal("P-074", new Object[]{Integer.toHexString(c & 0xFFFF), Integer.toHexString(c2 & 0xFFFF)});
        return false;
    }

    public boolean ignorableWhitespace(DTDEventListener dTDEventListener) throws IOException, SAXException {
        boolean bl = false;
        int n = this.start;
        block5: while (true) {
            if (this.finish <= this.start) {
                if (bl) {
                    dTDEventListener.ignorableWhitespace(this.buf, n, this.start - n);
                }
                this.fillbuf();
                n = this.start;
            }
            if (this.finish <= this.start) {
                return bl;
            }
            char c = this.buf[this.start++];
            switch (c) {
                case '\n': {
                    if (!this.isInternal()) {
                        ++this.lineNumber;
                    }
                }
                case '\t': 
                case ' ': {
                    bl = true;
                    continue block5;
                }
                case '\r': {
                    bl = true;
                    if (!this.isInternal()) {
                        ++this.lineNumber;
                    }
                    dTDEventListener.ignorableWhitespace(this.buf, n, this.start - 1 - n);
                    dTDEventListener.ignorableWhitespace(newline, 0, 1);
                    if (this.start >= this.finish || this.buf[this.start] == '\n') {
                        // empty if block
                    }
                    n = ++this.start;
                    continue block5;
                }
            }
            break;
        }
        this.ungetc();
        if (bl) {
            dTDEventListener.ignorableWhitespace(this.buf, n, this.start - n);
        }
        return bl;
    }

    public boolean peek(String string, char[] cArray) throws IOException, SAXException {
        int n;
        int n2 = cArray != null ? cArray.length : string.length();
        if (this.finish <= this.start || this.finish - this.start < n2) {
            this.fillbuf();
        }
        if (this.finish <= this.start) {
            return false;
        }
        if (cArray != null) {
            n = 0;
            while (n < n2 && this.start + n < this.finish) {
                if (this.buf[this.start + n] != cArray[n]) {
                    return false;
                }
                ++n;
            }
        } else {
            n = 0;
            while (n < n2 && this.start + n < this.finish) {
                if (this.buf[this.start + n] != string.charAt(n)) {
                    return false;
                }
                ++n;
            }
        }
        if (n < n2) {
            if (this.reader == null || this.isClosed) {
                return false;
            }
            if (n2 > this.buf.length) {
                this.fatal("P-077", new Object[]{new Integer(this.buf.length)});
            }
            this.fillbuf();
            return this.peek(string, cArray);
        }
        this.start += n2;
        return true;
    }

    public void startRemembering() {
        if (this.startRemember != 0) {
            throw new InternalError();
        }
        this.startRemember = this.start;
    }

    public String rememberText() {
        String string;
        if (this.rememberedText != null) {
            this.rememberedText.append(this.buf, this.startRemember, this.start - this.startRemember);
            string = this.rememberedText.toString();
        } else {
            string = new String(this.buf, this.startRemember, this.start - this.startRemember);
        }
        this.startRemember = 0;
        this.rememberedText = null;
        return string;
    }

    private InputEntity getTopEntity() {
        InputEntity inputEntity = this;
        while (inputEntity != null && inputEntity.input == null) {
            inputEntity = inputEntity.next;
        }
        return inputEntity == null ? this : inputEntity;
    }

    public String getPublicId() {
        InputEntity inputEntity = this.getTopEntity();
        if (inputEntity == this) {
            return this.input.getPublicId();
        }
        return inputEntity.getPublicId();
    }

    public String getSystemId() {
        InputEntity inputEntity = this.getTopEntity();
        if (inputEntity == this) {
            return this.input.getSystemId();
        }
        return inputEntity.getSystemId();
    }

    public int getLineNumber() {
        InputEntity inputEntity = this.getTopEntity();
        if (inputEntity == this) {
            return this.lineNumber;
        }
        return inputEntity.getLineNumber();
    }

    public int getColumnNumber() {
        return -1;
    }

    private void fillbuf() throws IOException, SAXException {
        boolean bl;
        if (this.reader == null || this.isClosed) {
            return;
        }
        if (this.startRemember != 0) {
            if (this.rememberedText == null) {
                this.rememberedText = new StringBuffer(this.buf.length);
            }
            this.rememberedText.append(this.buf, this.startRemember, this.start - this.startRemember);
        }
        boolean bl2 = bl = this.finish > 0 && this.start > 0;
        if (bl) {
            --this.start;
        }
        int n = this.finish - this.start;
        System.arraycopy(this.buf, this.start, this.buf, 0, n);
        this.start = 0;
        this.finish = n;
        try {
            n = this.buf.length - n;
            n = this.reader.read(this.buf, this.finish, n);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.fatal("P-075", new Object[]{unsupportedEncodingException.getMessage()});
        }
        catch (CharConversionException charConversionException) {
            this.fatal("P-076", new Object[]{charConversionException.getMessage()});
        }
        if (n >= 0) {
            this.finish += n;
        } else {
            this.close();
        }
        if (bl) {
            ++this.start;
        }
        if (this.startRemember != 0) {
            this.startRemember = 1;
        }
    }

    public void close() {
        try {
            if (this.reader != null && !this.isClosed) {
                this.reader.close();
            }
            this.isClosed = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void fatal(String string, Object[] objectArray) throws SAXException {
        SAXParseException sAXParseException = new SAXParseException(DTDParser.messages.getMessage(this.locale, string, objectArray), null);
        this.close();
        this.errHandler.fatalError(sAXParseException);
        throw sAXParseException;
    }
}

