/*
 * Decompiled with CFR 0.152.
 */
package org.sharengo.wikitty.jdbc;

import com.arjuna.ats.jta.TransactionManager;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.enhydra.jdbc.pool.StandardXAPoolDataSource;
import org.enhydra.jdbc.standard.StandardXADataSource;
import org.sharengo.wikitty.WikittyException;

public class WikittyJDBCUtil {
    private static Log log = LogFactory.getLog(WikittyJDBCUtil.class);
    public static final String COL_EXTENSION = "extension_list";
    public static final String COL_VERSION = "version";
    public static final String COL_ID = "id";
    public static final String COL_NAME = "name";
    public static final String COL_REQUIRES = "requires";
    public static final String COL_TAGVALUES = "tagvalues";
    public static final String COL_FIELDNAME = "fieldName";
    public static final String COL_FIELDTYPE = "fieldType";
    public static final String COL_BOOLEAN_VALUE = "booleanValue";
    public static final String COL_NUMBER_VALUE = "numberValue";
    public static final String COL_TEXT_VALUE = "textValue";
    public static final String COL_DATE_VALUE = "dateValue";
    public static final String COL_DELETION_DATE = "deletionDate";
    public static final String QUERY_SELECT = "jdbc.queries.select";
    public static final String QUERY_SELECT_NOTDELETED = "jdbc.queries.select.notdeleted";
    public static final String QUERY_SELECT_WHERE = "jdbc.queries.select.where";
    public static final String QUERY_SELECT_WHERE_NOTDELETED = "jdbc.queries.select.where.notdeleted";
    public static final String QUERY_CREATION_WIKITTY_ADMIN = "jdbc.queries.creation.wikitty.admin";
    public static final String QUERY_CREATION_WIKITTY_DATA = "jdbc.queries.creation.wikitty.data";
    public static final String QUERY_INSERT_WIKITTY_ADMIN = "jdbc.queries.insert.wikitty.admin";
    public static final String QUERY_UPDATE_WIKITTY_ADMIN = "jdbc.queries.update.wikitty.admin";
    public static final String QUERY_INSERT_WIKITTY_DATA = "jdbc.queries.insert.wikitty.data";
    public static final String QUERY_DELETE_WIKITTY_ADMIN = "jdbc.queries.delete.wikitty.admin";
    public static final String QUERY_DELETE_WIKITTY_DATA = "jdbc.queries.delete.wikitty.data";
    public static final String QUERY_CLEAR_EXTENSION = "jdbc.queries.clear.extension";
    public static final String QUERY_CLEAR_WIKITTY = "jdbc.queries.clear.wikitty";
    public static final String QUERY_CREATION_EXTENSION_ADMIN = "jdbc.queries.creation.extension.admin";
    public static final String QUERY_CREATION_EXTENSION_DATA = "jdbc.queries.creation.extension.data";
    public static final String QUERY_INSERT_EXTENSION_ADMIN = "jdbc.queries.insert.extension.admin";
    public static final String QUERY_INSERT_EXTENSION_DATA = "jdbc.queries.insert.extension.data";
    public static final String JDBC_DRIVER = "jdbc.con.driver";
    protected static String JDBC_HOST = "jdbc.con.host";
    protected static String JDBC_USER_NAME = "jdbc.con.userName";
    protected static String JDBC_PASSWORD = "jdbc.con.password";
    protected static String TABLE_WIKITTY_ADMIN = "wikitty_admin";
    protected static String TABLE_WIKITTY_DATA = "wikitty_data";
    protected static String TABLE_EXTENSION_ADMIN = "extension_admin";
    protected static String TABLE_EXTENSION_DATA = "extension_data";
    private static Hashtable<String, StandardXAPoolDataSource> dataSources = new Hashtable();

    public static synchronized Properties loadProperties(Properties properties) {
        Properties queryConfig = new Properties();
        Properties databaseConfig = new Properties(queryConfig);
        try {
            URL url = ClassLoader.getSystemResource("wikitty-jdbc-query.properties");
            if (url == null) {
                ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                url = contextClassLoader.getResource("wikitty-jdbc-query.properties");
            }
            log.info((Object)("Reading resource from: " + url));
            InputStream stream = url.openStream();
            queryConfig.load(stream);
            stream.close();
            url = ClassLoader.getSystemResource("wikitty-jdbc-config.properties");
            if (url == null) {
                ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                url = contextClassLoader.getResource("wikitty-jdbc-config.properties");
            }
            log.info((Object)("Reading resource from: " + url));
            stream = url.openStream();
            databaseConfig.load(stream);
            stream.close();
            if (properties != null) {
                databaseConfig.putAll((Map<?, ?>)properties);
            }
        }
        catch (IOException eee) {
            throw new WikittyException("Unable to load property file", (Exception)eee);
        }
        return databaseConfig;
    }

    public static synchronized Connection getConnection(Properties conf) {
        try {
            javax.transaction.TransactionManager transactionManager = TransactionManager.transactionManager();
            String jdbcUrl = String.format("%s:%s@%s", conf.getProperty(JDBC_USER_NAME), conf.getProperty(JDBC_PASSWORD), conf.getProperty(JDBC_HOST));
            if (!dataSources.containsKey(jdbcUrl)) {
                log.info((Object)("Creating PoolDataSource for: " + jdbcUrl));
                StandardXADataSource dataSource = new StandardXADataSource();
                dataSource.setDriverName(conf.getProperty(JDBC_DRIVER));
                dataSource.setUrl(conf.getProperty(JDBC_HOST));
                dataSource.setUser(conf.getProperty(JDBC_USER_NAME));
                dataSource.setPassword(conf.getProperty(JDBC_PASSWORD));
                dataSource.setTransactionManager(transactionManager);
                StandardXAPoolDataSource poolDataSource = new StandardXAPoolDataSource(dataSource);
                poolDataSource.setUser(conf.getProperty(JDBC_USER_NAME));
                poolDataSource.setPassword(conf.getProperty(JDBC_PASSWORD));
                poolDataSource.setTransactionManager(transactionManager);
                dataSources.put(jdbcUrl, poolDataSource);
            }
            StandardXAPoolDataSource poolDataSource = dataSources.get(jdbcUrl);
            Connection connection = poolDataSource.getConnection();
            return connection;
        }
        catch (SQLException eee) {
            throw new WikittyException((Exception)eee);
        }
    }

    public static synchronized Connection getJDBCConnection(Properties conf) {
        try {
            Connection connection = DriverManager.getConnection(conf.getProperty(JDBC_HOST), conf.getProperty(JDBC_USER_NAME), conf.getProperty(JDBC_PASSWORD));
            connection.setAutoCommit(false);
            return connection;
        }
        catch (SQLException eee) {
            throw new WikittyException((Exception)eee);
        }
    }

    public static void closeQuietly(Connection connection) {
        try {
            connection.close();
        }
        catch (SQLException e) {
            log.error((Object)"SQLException while closing connection", (Throwable)e);
        }
    }

    public static void commitJDBCConnection(Connection connection) {
        try {
            connection.commit();
        }
        catch (SQLException eee) {
            throw new WikittyException((Exception)eee);
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException eee) {
                throw new WikittyException((Exception)eee);
            }
        }
    }

    public static void rollbackJDBCConnection(Connection connection) {
        try {
            connection.rollback();
        }
        catch (SQLException eee) {
            throw new WikittyException((Exception)eee);
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException eee) {
                throw new WikittyException((Exception)eee);
            }
        }
    }

    public static void doQuery(Connection connection, String query, Object ... args) throws SQLException {
        PreparedStatement sta = connection.prepareStatement(query);
        for (int i = 0; i < args.length; ++i) {
            sta.setObject(i + 1, args[i]);
        }
        sta.execute();
    }
}

