/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.search;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.VradiService;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.dto.VradiCartographyDTO;
import com.jurismarches.vradi.services.dto.VradiFormPageDTO;
import com.jurismarches.vradi.services.dto.VradiThesaurusDTO;
import com.jurismarches.vradi.services.search.UnsupportedQueryException;
import com.jurismarches.vradi.ui.OfferListUI;
import com.jurismarches.vradi.ui.ThesaurusCartographyUI;
import com.jurismarches.vradi.ui.ThesaurusHandler;
import com.jurismarches.vradi.ui.VradiTask;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.models.OfferListTableModel;
import com.jurismarches.vradi.ui.models.ThesaurusCartographyModel;
import com.jurismarches.vradi.ui.search.CriteriaField;
import com.jurismarches.vradi.ui.search.CriteriaUI;
import com.jurismarches.vradi.ui.search.SearchUI;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.TreeNodeImpl;
import org.sharengo.wikitty.WikittyExtension;

public class SearchHandler {
    private static final Log log = LogFactory.getLog(SearchHandler.class);
    public static final String CSV_FILE_EXTENSION = ".csv";

    public SearchUI initUI(JAXXContext rootContext, OfferListTableModel resultTableModel) {
        SearchUI ui = this.getUI(rootContext);
        if (ui == null) {
            JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext);
            context.add((Object)this);
            context.add((Object)resultTableModel);
            ui = new SearchUI((JAXXContext)context);
            this.initCriteria((JAXXContext)ui);
            VradiContext.SEARCH_UI_ENTRY_DEF.setContextValue(rootContext, (Object)ui);
        }
        return ui;
    }

    public SearchUI initCloneUI(JAXXContext rootContext, OfferListTableModel resultTableModel) {
        return this.initCloneUI(rootContext, resultTableModel, null);
    }

    public SearchUI initCloneUI(JAXXContext rootContext, OfferListTableModel resultTableModel, List<VradiThesaurusDTO> thesaurus) {
        JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext);
        context.add((Object)this);
        context.add((Object)resultTableModel);
        SearchUI ui = new SearchUI((JAXXContext)context);
        this.initCriteria((JAXXContext)ui, thesaurus);
        return ui;
    }

    SearchUI getUI(JAXXContext context) {
        if (context instanceof SearchUI) {
            return (SearchUI)context;
        }
        SearchUI ui = (SearchUI)((Object)VradiContext.SEARCH_UI_ENTRY_DEF.getContextValue(context));
        return ui;
    }

    public ComboBoxModel getRequestModel() {
        return new DefaultComboBoxModel();
    }

    public void executeQuery(JAXXContext context) {
        final SearchUI searchUI = this.getUI(context);
        if (searchUI != null) {
            final String query = searchUI.getRequest();
            final JComboBox combo = searchUI.isOfferListUI() != false ? searchUI.getRequests() : null;
            final CriteriaUI criterias = searchUI.getCriterias().isVisible() ? searchUI.getCriterias() : null;
            final OfferListTableModel listTableModel = searchUI.getResultTableModel();
            final VradiFormPageDTO formPageDTO = listTableModel.getFormPageDTO();
            VradiTask<VradiFormPageDTO> task = new VradiTask<VradiFormPageDTO>(context, false){

                @Override
                public VradiFormPageDTO doAction() throws Exception {
                    return SearchHandler.this.executeQuery((JAXXContext)searchUI, criterias, formPageDTO, combo, query);
                }

                @Override
                public void doWhenDone() throws Exception {
                    searchUI.getRootPane().setCursor(null);
                    VradiFormPageDTO formPageDTO2 = (VradiFormPageDTO)this.get();
                    listTableModel.setFormPageDTO(formPageDTO2);
                }
            };
            task.execute();
        } else {
            log.warn((Object)"searchUI is null !");
        }
    }

    public void executeQuery(JAXXContext context, int pageToShow) {
        SearchUI searchUI = this.getUI(context);
        if (searchUI != null) {
            OfferListTableModel listTableModel = searchUI.getResultTableModel();
            listTableModel.setPageToShow(pageToShow);
        } else {
            log.warn((Object)"searchUI is null !");
        }
    }

    public List<String> loadRequests() {
        return VradiHelper.loadRequests();
    }

    public JPanel getCriteriaPanel(JAXXContext context) {
        SearchUI ui = this.getUI(context);
        CriteriaUI criterias = ui.getCriterias();
        return criterias.getCriteriaPanel();
    }

    public CriteriaUI getCriterias(JAXXContext context) {
        return this.getUI(context).getCriterias();
    }

    public void initCriteria(JAXXContext context) {
        this.initCriteria(context, null);
    }

    public void initCriteria(JAXXContext context, List<VradiThesaurusDTO> thesaurus) {
        this.getCriteriaPanel(context).removeAll();
        VradiThesaurusDTO root = VradiContext.getThesaurusInEntryDef();
        this.addCriteria(context, root, false, true);
        List<String> vradiListCriteria = VradiHelper.getVradiListCriteria();
        for (String value : vradiListCriteria) {
            this.addCriteria(context, value, true);
        }
        if (thesaurus != null) {
            for (VradiThesaurusDTO t : thesaurus) {
                this.addUnmodifiableCriteria(context, t);
            }
        }
    }

    public void removeCriteria(JAXXContext context, CriteriaField criteriaField) {
        this.getCriteriaPanel(context).remove((Component)((Object)criteriaField));
        this.getUI(context).validate();
    }

    public void removeCriteriaAndPersist(JAXXContext context, TreeNodeImpl bean) {
        CriteriaField criteriaField = (CriteriaField)context;
        VradiHelper.removeVradiListCriteria(bean);
        this.removeCriteria(context, criteriaField);
        this.getUI(context).validate();
    }

    public void addUnmodifiableCriteria(JAXXContext context, VradiThesaurusDTO thesaurusDTO) {
        CriteriaField criteriaField = this.addCriteria(context, thesaurusDTO.getParentThesaurus(), false, false);
        JComboBox combo = criteriaField.getCombo();
        TreeNodeImpl treeNode = VradiContext.findTreeNodeInEntryDef(thesaurusDTO.getWikittyId());
        combo.setSelectedItem(treeNode);
    }

    public void addAndPersistCriteria(JAXXContext context, VradiThesaurusDTO thesaurus) {
        TreeNodeImpl treeNode = VradiContext.findTreeNodeInEntryDef(thesaurus.getWikittyId());
        VradiHelper.addVradiListCriteria(treeNode);
        this.addCriteria(context, thesaurus, true, true);
    }

    protected void addCriteria(JAXXContext context, String wikittyId, boolean deletable) {
        if (wikittyId == null || wikittyId.isEmpty()) {
            return;
        }
        VradiThesaurusDTO criteriaThes = UIHelper.getHandler(context, ThesaurusHandler.class).findThesaurusInRef(wikittyId);
        if (criteriaThes != null) {
            this.addCriteria(context, criteriaThes, deletable, true);
        }
    }

    protected CriteriaField addCriteria(JAXXContext context, VradiThesaurusDTO thesCriteria, boolean deletable, boolean enabled) {
        TreeNodeImpl criteria = VradiContext.findTreeNodeInEntryDef(thesCriteria.getWikittyId());
        CriteriaField criteriaField = new CriteriaField(context);
        criteriaField.setLabelName(criteria.getName());
        criteriaField.setBean(criteria);
        criteriaField.setDeletable(deletable);
        criteriaField.setActif(enabled);
        JComboBox combo = criteriaField.getCombo();
        List children = thesCriteria.getChildren();
        TreeNodeImpl[] thesArray = new TreeNodeImpl[children.size() + 1];
        int i = 0;
        TreeNodeImpl empty = new TreeNodeImpl();
        empty.setName(" ");
        thesArray[i] = empty;
        for (VradiThesaurusDTO child : children) {
            thesArray[++i] = VradiContext.findTreeNodeInEntryDef(child.getWikittyId());
        }
        combo.setModel(new DefaultComboBoxModel<TreeNodeImpl>(thesArray));
        combo.setMaximumRowCount(30);
        combo.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        criteriaField.init();
        JPanel criteriaPanel = this.getCriteriaPanel(context);
        criteriaPanel.add((Component)((Object)criteriaField));
        this.getUI(context).validate();
        return criteriaField;
    }

    protected List<String> getDateFormType(WikittyExtension formType) {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Infogene.creationDate");
        result.add("Form.datePub");
        result.add("Form.datePeremption");
        if (formType != null) {
            for (String name : formType.getFieldNames()) {
                FieldType type = formType.getFieldType(name);
                if (type.getType() != FieldType.TYPE.DATE) continue;
                result.add(formType.getName() + "." + name);
            }
        }
        return result;
    }

    public DefaultComboBoxModel updateDateSelectionModel(WikittyExtension selected) {
        List<String> datas = this.getDateFormType(selected);
        return new DefaultComboBoxModel<String>(datas.toArray(new String[datas.size()]));
    }

    public VradiFormPageDTO executeQuery(JAXXContext context, CriteriaUI criterias, VradiFormPageDTO formPageDTO, JComboBox combo, String request) {
        if (criterias == null) {
            formPageDTO = VradiHelper.executeQuery(request, null, null, null, null, null, null, formPageDTO);
        } else {
            Component[] thesaurusCriteria = this.getCriteriaPanel(context).getComponents();
            ArrayList[] thesaurus = new ArrayList[thesaurusCriteria.length];
            for (int i = 0; i < thesaurus.length; ++i) {
                TreeNodeImpl tn = (TreeNodeImpl)((CriteriaField)((Object)thesaurusCriteria[i])).getCombo().getSelectedItem();
                if (tn == null || tn.getName().trim().isEmpty()) continue;
                thesaurus[i] = new ArrayList();
                String wikittyId = tn.getWikittyId();
                thesaurus[i].add(wikittyId);
                VradiThesaurusDTO parent = UIHelper.getHandler(context, ThesaurusHandler.class).findThesaurusInRef(wikittyId);
                thesaurus[i].addAll(parent.getChildrenRecursif());
            }
            GregorianCalendar beginDate = new GregorianCalendar();
            beginDate.setTime(criterias.getFromDate().getDate());
            beginDate.set(11, (Integer)criterias.getFromHour().getSelectedItem());
            beginDate.set(12, (Integer)criterias.getFromMinute().getSelectedItem());
            GregorianCalendar endDate = new GregorianCalendar();
            endDate.setTime(criterias.getToDate().getDate());
            endDate.set(11, (Integer)criterias.getToHour().getSelectedItem());
            endDate.set(12, (Integer)criterias.getToMinute().getSelectedItem());
            WikittyExtension extension = (WikittyExtension)criterias.getFormTypeSelection().getSelectedItem();
            String dateType = (String)criterias.getDateTypeSelection().getSelectedItem();
            XmlStream xmlStream = (XmlStream)criterias.getXmlStreamSelection().getSelectedItem();
            String realRequest = request;
            if (xmlStream != null) {
                String xmlStreamURL = xmlStream.getUrl();
                realRequest = realRequest == null || realRequest.isEmpty() ? "xmlStreamURL:(\"" + xmlStreamURL + "\")" : realRequest + " AND xmlStreamURL:(\"" + xmlStreamURL + "\")";
            }
            Object[] statuses = criterias.getStatusSelection().getSelectedValues();
            String[] statusIds = new String[statuses.length];
            for (int i = 0; i < statuses.length; ++i) {
                statusIds[i] = ((Status)statuses[i]).getWikittyId();
            }
            formPageDTO = VradiHelper.executeQuery(realRequest, extension, dateType, beginDate.getTime(), endDate.getTime(), thesaurus, statusIds, formPageDTO);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Total forms found        : " + formPageDTO.getTotalFoundFormNb()));
            log.info((Object)("Number of forms per page : " + formPageDTO.getNbFormsToShow()));
            log.info((Object)("Actual page              : " + formPageDTO.getPageToShow()));
        }
        if (context instanceof OfferListUI) {
            VradiHelper.addRequestToProperties(request);
        }
        if (combo != null) {
            ((DefaultComboBoxModel)combo.getModel()).removeElement(request);
            combo.insertItemAt(request, 0);
            combo.setSelectedIndex(0);
        }
        return formPageDTO;
    }

    public void executeCartography(final SearchUI searchUI) {
        final String query = searchUI.getRequest();
        final JComboBox combo = searchUI.isOfferListUI() != false ? searchUI.getRequests() : null;
        final CriteriaUI criterias = searchUI.getCriterias().isVisible() ? searchUI.getCriterias() : null;
        VradiTask<VradiCartographyDTO> task = new VradiTask<VradiCartographyDTO>((JAXXContext)searchUI){

            @Override
            public VradiCartographyDTO doAction() throws Exception {
                return SearchHandler.this.executeCartography(searchUI, criterias, combo, query);
            }

            @Override
            public void doWhenDone() throws Exception {
                searchUI.getRootPane().setCursor(null);
                VradiCartographyDTO cartographyDTO = (VradiCartographyDTO)this.get();
                if (cartographyDTO != null) {
                    ThesaurusCartographyModel cartographyModel = new ThesaurusCartographyModel(cartographyDTO);
                    DefaultJAXXContext context = new DefaultJAXXContext();
                    context.setContextValue((Object)cartographyModel);
                    ThesaurusCartographyUI cartographyUI = new ThesaurusCartographyUI((JAXXContext)context);
                    cartographyUI.setVisible(true);
                }
            }
        };
        task.execute();
    }

    VradiCartographyDTO executeCartography(SearchUI searchUI, CriteriaUI criterias, JComboBox combo, String request) throws VradiException, UnsupportedQueryException {
        VradiCartographyDTO cartography = null;
        if (criterias == null) {
            cartography = VradiService.getVradiStorageService().getThesaurusCartography(request, null, null, null, null, null, null);
        } else {
            Component[] thesaurusCriteria = this.getCriteriaPanel((JAXXContext)searchUI).getComponents();
            List[] thesaurus = new ArrayList[thesaurusCriteria.length];
            for (int i = 0; i < thesaurus.length; ++i) {
                TreeNodeImpl tn = (TreeNodeImpl)((CriteriaField)((Object)thesaurusCriteria[i])).getCombo().getSelectedItem();
                if (tn == null || tn.getName().trim().isEmpty()) continue;
                thesaurus[i] = new ArrayList();
                String wikittyId = tn.getWikittyId();
                thesaurus[i].add(wikittyId);
                VradiThesaurusDTO parent = UIHelper.getHandler((JAXXContext)searchUI, ThesaurusHandler.class).findThesaurusInRef(wikittyId);
                thesaurus[i].addAll(parent.getChildrenRecursif());
            }
            GregorianCalendar beginDate = new GregorianCalendar();
            beginDate.setTime(criterias.getFromDate().getDate());
            beginDate.set(11, (Integer)criterias.getFromHour().getSelectedItem());
            beginDate.set(12, (Integer)criterias.getFromMinute().getSelectedItem());
            GregorianCalendar endDate = new GregorianCalendar();
            endDate.setTime(criterias.getToDate().getDate());
            endDate.set(11, (Integer)criterias.getToHour().getSelectedItem());
            endDate.set(12, (Integer)criterias.getToMinute().getSelectedItem());
            WikittyExtension extension = (WikittyExtension)criterias.getFormTypeSelection().getSelectedItem();
            String dateType = (String)criterias.getDateTypeSelection().getSelectedItem();
            XmlStream xmlStream = (XmlStream)criterias.getXmlStreamSelection().getSelectedItem();
            String realRequest = request;
            if (xmlStream != null) {
                String xmlStreamURL = xmlStream.getUrl();
                realRequest = realRequest == null || realRequest.isEmpty() ? "xmlStreamURL:(\"" + xmlStreamURL + "\")" : realRequest + " AND xmlStreamURL:(\"" + xmlStreamURL + "\")";
            }
            Object[] statuses = criterias.getStatusSelection().getSelectedValues();
            String[] statusIds = new String[statuses.length];
            for (int i = 0; i < statuses.length; ++i) {
                statusIds[i] = ((Status)statuses[i]).getWikittyId();
            }
            cartography = VradiService.getVradiStorageService().getThesaurusCartography(realRequest, extension, dateType, beginDate.getTime(), endDate.getTime(), thesaurus, statusIds);
        }
        return cartography;
    }

    public ListCellRenderer getDateTypeComboBoxRenderer() {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String stringValue = null;
                if (value != null) {
                    int dot;
                    stringValue = value.toString();
                    String extName = stringValue.substring(0, dot = stringValue.lastIndexOf("."));
                    stringValue = "Infogene".equals(extName) || "Form".equals(extName) ? I18n._((String)stringValue) : stringValue.substring(dot + 1);
                }
                return super.getListCellRendererComponent((JList<?>)list, stringValue, index, isSelected, cellHasFocus);
            }
        };
    }

    public void exportToCSV(JAXXContext context) {
        SearchUI searchUI = this.getUI(context);
        File file = UIHelper.openFileChooser(CSV_FILE_EXTENSION, "vradi.export.filter.csv", (Component)((Object)searchUI), "vradi.export.validate.label");
        if (file != null) {
            VradiFormPageDTO formPageDTO = new VradiFormPageDTO();
            formPageDTO.setNbFormsToShow(1000000);
            formPageDTO.setPageToShow(1);
            OfferListTableModel tableModel = new OfferListTableModel(formPageDTO);
            if (searchUI != null) {
                CriteriaUI criterias = searchUI.getCriterias();
                String request = searchUI.getRequest();
                this.executeQuery(context, criterias, formPageDTO, null, request);
            } else {
                this.executeQuery(context, null, formPageDTO, null, null);
            }
            UIHelper.exportToCSV(file, tableModel);
        }
    }
}

