/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.reflect.impl.asm;

import gnu.trove.TIntArrayList;
import gnu.trove.TIntObjectHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.aspectwerkz.annotation.instrumentation.asm.AsmAnnotationHelper;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.org.objectweb.asm.Attribute;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassReader;
import org.codehaus.aspectwerkz.org.objectweb.asm.CodeVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.Label;
import org.codehaus.aspectwerkz.org.objectweb.asm.Type;
import org.codehaus.aspectwerkz.org.objectweb.asm.attrs.Attributes;
import org.codehaus.aspectwerkz.proxy.ProxyCompiler;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.reflect.ConstructorInfo;
import org.codehaus.aspectwerkz.reflect.FieldInfo;
import org.codehaus.aspectwerkz.reflect.MethodInfo;
import org.codehaus.aspectwerkz.reflect.StaticInitializationInfo;
import org.codehaus.aspectwerkz.reflect.StaticInitializationInfoImpl;
import org.codehaus.aspectwerkz.reflect.impl.asm.AsmClassInfoRepository;
import org.codehaus.aspectwerkz.reflect.impl.asm.AsmConstructorInfo;
import org.codehaus.aspectwerkz.reflect.impl.asm.AsmFieldInfo;
import org.codehaus.aspectwerkz.reflect.impl.asm.AsmMemberInfo;
import org.codehaus.aspectwerkz.reflect.impl.asm.AsmMethodInfo;
import org.codehaus.aspectwerkz.reflect.impl.asm.FieldStruct;
import org.codehaus.aspectwerkz.reflect.impl.asm.MethodStruct;
import org.codehaus.aspectwerkz.reflect.impl.java.JavaClassInfo;
import org.codehaus.aspectwerkz.transform.inlining.AsmHelper;

public class AsmClassInfo
implements ClassInfo {
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected static final List EMPTY_LIST = new ArrayList();
    private static final Attribute[] NO_ATTRIBUTES = new Attribute[0];
    private final WeakReference m_loaderRef;
    private String m_name;
    private String m_signature;
    private int m_modifiers;
    private boolean m_isInterface = false;
    private boolean m_isPrimitive = false;
    private boolean m_isArray = false;
    private boolean m_hasStaticInitializer = false;
    private StaticInitializationInfo m_staticInitializer = null;
    private final TIntObjectHashMap m_constructors = new TIntObjectHashMap();
    private TIntArrayList m_sortedConstructorHashes = new TIntArrayList();
    private ConstructorInfo[] m_constructorsLazy = null;
    private final TIntObjectHashMap m_methods = new TIntObjectHashMap();
    private TIntArrayList m_sortedMethodHashes = new TIntArrayList();
    private MethodInfo[] m_methodsLazy = null;
    private final TIntObjectHashMap m_fields = new TIntObjectHashMap();
    private TIntArrayList m_sortedFieldHashes = new TIntArrayList();
    private FieldInfo[] m_fieldsLazy = null;
    private String[] m_interfaceClassNames = null;
    private ClassInfo[] m_interfaces = null;
    private String m_superClassName = null;
    private ClassInfo m_superClass = null;
    private List m_annotations = null;
    private String m_componentTypeName = null;
    private ClassInfo m_componentType = null;
    private final AsmClassInfoRepository m_classInfoRepository;
    static /* synthetic */ Class class$java$lang$Object;

    AsmClassInfo(byte[] bytecode, ClassLoader loader, boolean lazyAttributes) {
        if (bytecode == null) {
            throw new IllegalArgumentException("bytecode can not be null");
        }
        this.m_loaderRef = new WeakReference<ClassLoader>(loader);
        this.m_classInfoRepository = AsmClassInfoRepository.getRepository(loader);
        try {
            ClassReader cr = new ClassReader(bytecode);
            ClassInfoClassAdapter visitor = new ClassInfoClassAdapter(lazyAttributes);
            cr.accept(visitor, lazyAttributes ? NO_ATTRIBUTES : Attributes.getDefaultAttributes(), false);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.m_classInfoRepository.addClassInfo(this);
    }

    AsmClassInfo(InputStream resourceStream, ClassLoader loader) {
        if (resourceStream == null) {
            throw new IllegalArgumentException("resource stream can not be null");
        }
        this.m_loaderRef = new WeakReference<ClassLoader>(loader);
        this.m_classInfoRepository = AsmClassInfoRepository.getRepository(loader);
        try {
            ClassReader cr = new ClassReader(resourceStream);
            ClassInfoClassAdapter visitor = new ClassInfoClassAdapter(true);
            cr.accept(visitor, NO_ATTRIBUTES, false);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.m_classInfoRepository.addClassInfo(this);
    }

    AsmClassInfo(String className, ClassLoader loader, ClassInfo componentInfo) {
        this.m_loaderRef = new WeakReference<ClassLoader>(loader);
        this.m_name = className.replace('/', '.');
        this.m_classInfoRepository = AsmClassInfoRepository.getRepository(loader);
        this.m_isArray = true;
        this.m_componentType = componentInfo;
        this.m_componentTypeName = componentInfo.getName();
        this.m_modifiers = componentInfo.getModifiers() | 0x400 | 0x10;
        this.m_isInterface = false;
        this.m_superClass = JavaClassInfo.getClassInfo(class$java$lang$Object == null ? (class$java$lang$Object = AsmClassInfo.class$("java.lang.Object")) : class$java$lang$Object);
        this.m_superClassName = this.m_superClass.getName();
        this.m_interfaceClassNames = new String[0];
        this.m_interfaces = new ClassInfo[0];
        this.m_signature = AsmHelper.getClassDescriptor(this);
        this.m_classInfoRepository.addClassInfo(this);
    }

    public static ClassInfo newClassInfo(byte[] bytecode, ClassLoader loader) {
        String className = AsmClassInfo.retrieveClassNameFromBytecode(bytecode);
        AsmClassInfoRepository repository = AsmClassInfoRepository.getRepository(loader);
        repository.removeClassInfo(className);
        return new AsmClassInfo(bytecode, loader, true);
    }

    public static ClassInfo getClassInfo(String className, ClassLoader loader) {
        String javaClassName = AsmClassInfo.getJavaClassName(className);
        AsmClassInfoRepository repository = AsmClassInfoRepository.getRepository(loader);
        ClassInfo classInfo = repository.getClassInfo(javaClassName);
        if (classInfo == null) {
            classInfo = AsmClassInfo.createClassInfoFromStream(javaClassName, loader, true);
        }
        return classInfo;
    }

    public static ClassInfo getClassInfo(byte[] bytecode, ClassLoader loader) {
        String className = AsmClassInfo.retrieveClassNameFromBytecode(bytecode);
        AsmClassInfoRepository repository = AsmClassInfoRepository.getRepository(loader);
        ClassInfo classInfo = repository.getClassInfo(className);
        if (classInfo == null) {
            classInfo = new AsmClassInfo(bytecode, loader, true);
        }
        return classInfo;
    }

    public static ClassInfo getClassInfo(InputStream stream, ClassLoader loader) {
        try {
            ClassReader cr = new ClassReader(stream);
            byte[] bytes = cr.b;
            ClassNameRetrievalClassAdapter visitor = new ClassNameRetrievalClassAdapter();
            cr.accept(visitor, NO_ATTRIBUTES, true);
            String className = visitor.getClassName();
            AsmClassInfoRepository repository = AsmClassInfoRepository.getRepository(loader);
            ClassInfo classInfo = repository.getClassInfo(className);
            if (classInfo == null) {
                classInfo = new AsmClassInfo(bytes, loader, true);
            }
            return classInfo;
        }
        catch (IOException e) {
            throw new WrappedRuntimeException(e);
        }
    }

    public static ClassInfo getClassInfo(InputStream stream, ClassLoader loader, boolean lazyAttributes) {
        if (lazyAttributes) {
            return AsmClassInfo.getClassInfo(stream, loader);
        }
        try {
            ClassReader cr = new ClassReader(stream);
            byte[] bytes = cr.b;
            ClassNameRetrievalClassAdapter visitor = new ClassNameRetrievalClassAdapter();
            cr.accept(visitor, NO_ATTRIBUTES, true);
            String className = visitor.getClassName();
            AsmClassInfoRepository repository = AsmClassInfoRepository.getRepository(loader);
            ClassInfo classInfo = repository.getClassInfo(className);
            if (classInfo == null) {
                classInfo = new AsmClassInfo(bytes, loader, lazyAttributes);
            }
            return classInfo;
        }
        catch (IOException e) {
            throw new WrappedRuntimeException(e);
        }
    }

    public static void markDirty(String className, ClassLoader loader) {
        AsmClassInfoRepository.getRepository(loader).removeClassInfo(className);
    }

    public static String retrieveClassNameFromBytecode(byte[] bytecode) {
        ClassReader cr = new ClassReader(bytecode);
        ClassNameRetrievalClassAdapter visitor = new ClassNameRetrievalClassAdapter();
        cr.accept(visitor, NO_ATTRIBUTES, true);
        return visitor.getClassName();
    }

    public static Class getPrimitiveClass(String className) {
        if (className.equals("void")) {
            return Void.TYPE;
        }
        if (className.equals("long")) {
            return Long.TYPE;
        }
        if (className.equals("int")) {
            return Integer.TYPE;
        }
        if (className.equals("short")) {
            return Short.TYPE;
        }
        if (className.equals("double")) {
            return Double.TYPE;
        }
        if (className.equals("float")) {
            return Float.TYPE;
        }
        if (className.equals("byte")) {
            return Byte.TYPE;
        }
        if (className.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (className.equals("char")) {
            return Character.TYPE;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAnnotations() {
        if (this.m_annotations == null) {
            if (this.isPrimitive() || this.isArray()) {
                this.m_annotations = EMPTY_LIST;
            } else {
                try {
                    InputStream in = null;
                    ClassReader cr = null;
                    try {
                        in = (ClassLoader)this.m_loaderRef.get() != null ? ((ClassLoader)this.m_loaderRef.get()).getResourceAsStream(this.m_name.replace('.', '/') + ".class") : ClassLoader.getSystemClassLoader().getResourceAsStream(this.m_name.replace('.', '/') + ".class");
                        if (in == null) {
                            in = ProxyCompiler.getProxyResourceAsStream((ClassLoader)this.m_loaderRef.get(), this.m_name);
                        }
                        cr = new ClassReader(in);
                    }
                    finally {
                        try {
                            in.close();
                        }
                        catch (Exception e) {}
                    }
                    ArrayList annotations = new ArrayList();
                    cr.accept(new AsmAnnotationHelper.ClassAnnotationExtractor(annotations, (ClassLoader)this.m_loaderRef.get()), Attributes.getDefaultAttributes(), true);
                    this.m_annotations = annotations;
                }
                catch (IOException e) {
                    System.err.println("AW::WARNING  could not load " + this.m_name + " as a resource to retrieve annotations");
                    this.m_annotations = EMPTY_LIST;
                }
            }
        }
        return this.m_annotations;
    }

    public String getName() {
        return this.m_name;
    }

    public String getSignature() {
        return this.m_signature;
    }

    public int getModifiers() {
        return this.m_modifiers;
    }

    public ClassLoader getClassLoader() {
        return (ClassLoader)this.m_loaderRef.get();
    }

    public boolean hasStaticInitializer() {
        return this.m_hasStaticInitializer;
    }

    public StaticInitializationInfo staticInitializer() {
        if (this.hasStaticInitializer() && this.m_staticInitializer == null) {
            this.m_staticInitializer = new StaticInitializationInfoImpl(this);
        }
        return this.m_staticInitializer;
    }

    public ConstructorInfo getConstructor(int hash) {
        ConstructorInfo constructor = (ConstructorInfo)this.m_constructors.get(hash);
        if (constructor == null && this.getSuperclass() != null) {
            constructor = this.getSuperclass().getConstructor(hash);
        }
        return constructor;
    }

    public ConstructorInfo[] getConstructors() {
        if (this.m_constructorsLazy == null) {
            ConstructorInfo[] constructorInfos = new ConstructorInfo[this.m_sortedConstructorHashes.size()];
            for (int i = 0; i < this.m_sortedConstructorHashes.size(); ++i) {
                constructorInfos[i] = (ConstructorInfo)this.m_constructors.get(this.m_sortedConstructorHashes.get(i));
            }
            this.m_constructorsLazy = constructorInfos;
        }
        return this.m_constructorsLazy;
    }

    public MethodInfo getMethod(int hash) {
        MethodInfo method = (MethodInfo)this.m_methods.get(hash);
        if (method == null) {
            for (int i = 0; i < this.getInterfaces().length && (method = this.getInterfaces()[i].getMethod(hash)) == null; ++i) {
            }
        }
        if (method == null && this.getSuperclass() != null) {
            method = this.getSuperclass().getMethod(hash);
        }
        return method;
    }

    public MethodInfo[] getMethods() {
        if (this.m_methodsLazy == null) {
            MethodInfo[] methodInfos = new MethodInfo[this.m_sortedMethodHashes.size()];
            for (int i = 0; i < this.m_sortedMethodHashes.size(); ++i) {
                methodInfos[i] = (MethodInfo)this.m_methods.get(this.m_sortedMethodHashes.get(i));
            }
            this.m_methodsLazy = methodInfos;
        }
        return this.m_methodsLazy;
    }

    public FieldInfo getField(int hash) {
        FieldInfo field = (FieldInfo)this.m_fields.get(hash);
        if (field == null && this.getSuperclass() != null) {
            field = this.getSuperclass().getField(hash);
        }
        return field;
    }

    public FieldInfo[] getFields() {
        if (this.m_fieldsLazy == null) {
            FieldInfo[] fieldInfos = new FieldInfo[this.m_sortedFieldHashes.size()];
            for (int i = 0; i < this.m_sortedFieldHashes.size(); ++i) {
                fieldInfos[i] = (FieldInfo)this.m_fields.get(this.m_sortedFieldHashes.get(i));
            }
            this.m_fieldsLazy = fieldInfos;
        }
        return this.m_fieldsLazy;
    }

    public ClassInfo[] getInterfaces() {
        if (this.m_interfaces == null) {
            this.m_interfaces = new ClassInfo[this.m_interfaceClassNames.length];
            for (int i = 0; i < this.m_interfaceClassNames.length; ++i) {
                this.m_interfaces[i] = AsmClassInfo.getClassInfo(this.m_interfaceClassNames[i], (ClassLoader)this.m_loaderRef.get());
            }
        }
        return this.m_interfaces;
    }

    public ClassInfo getSuperclass() {
        if (this.m_superClass == null && this.m_superClassName != null) {
            this.m_superClass = AsmClassInfo.getClassInfo(this.m_superClassName, (ClassLoader)this.m_loaderRef.get());
        }
        return this.m_superClass;
    }

    public ClassInfo getComponentType() {
        if (this.isArray() && this.m_componentTypeName == null) {
            this.m_componentType = AsmClassInfo.getClassInfo(this.m_componentTypeName, (ClassLoader)this.m_loaderRef.get());
        }
        return this.m_componentType;
    }

    public boolean isInterface() {
        return this.m_isInterface;
    }

    public boolean isPrimitive() {
        return this.m_isPrimitive;
    }

    public boolean isArray() {
        return this.m_isArray;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClassInfo)) {
            return false;
        }
        ClassInfo classInfo = (ClassInfo)o;
        return this.m_name.equals(classInfo.getName());
    }

    public int hashCode() {
        return this.m_name.hashCode();
    }

    public String toString() {
        return this.m_name;
    }

    public static ClassInfo getArrayClassInfo(String className, ClassLoader loader, ClassInfo componentClassInfo) {
        return new AsmClassInfo(className, loader, componentClassInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassInfo createClassInfoFromStream(String name, ClassLoader loader, boolean lazyAttributes) {
        String className = name.replace('.', '/');
        if (name.indexOf(47) < 0) {
            Class primitiveClass;
            int dimension = 0;
            int i = className.indexOf(91);
            while (i > 0) {
                ++dimension;
                i = className.indexOf(91, i + 1);
            }
            String unidimComponentName = className;
            if (dimension > 0) {
                int unidimComponentTypeIndex = className.indexOf(91);
                unidimComponentName = className.substring(0, unidimComponentTypeIndex);
            }
            if ((primitiveClass = AsmClassInfo.getPrimitiveClass(unidimComponentName)) != null && primitiveClass.isPrimitive()) {
                if (dimension == 0) {
                    return JavaClassInfo.getClassInfo(primitiveClass);
                }
                Class<?> arrayClass = Array.newInstance(primitiveClass, new int[dimension]).getClass();
                return JavaClassInfo.getClassInfo(arrayClass);
            }
        }
        int componentTypeIndex = className.lastIndexOf(91);
        String componentName = className;
        boolean isArray = false;
        if (componentTypeIndex > 0) {
            componentName = className.substring(0, componentTypeIndex);
            isArray = true;
        }
        ClassInfo componentInfo = null;
        if (componentName.indexOf(91) > 0) {
            componentInfo = AsmClassInfo.getClassInfo(componentName, loader);
        } else {
            InputStream componentClassAsStream = null;
            componentClassAsStream = loader != null ? loader.getResourceAsStream(componentName + ".class") : ClassLoader.getSystemClassLoader().getResourceAsStream(componentName + ".class");
            if (componentClassAsStream == null) {
                if (componentName.indexOf(91) > 0) {
                    return AsmClassInfo.getClassInfo(componentName, loader);
                }
                System.out.println("AW::WARNING - could not load class [" + componentName + "] as a resource in loader [" + loader + "]");
                componentInfo = new ClassInfo.NullClassInfo();
            }
            try {
                componentInfo = AsmClassInfo.getClassInfo(componentClassAsStream, loader, lazyAttributes);
            }
            finally {
                try {
                    componentClassAsStream.close();
                }
                catch (Exception e) {}
            }
        }
        if (!isArray) {
            return componentInfo;
        }
        return AsmClassInfo.getArrayClassInfo(className, loader, componentInfo);
    }

    private static String getJavaClassName(String className) {
        String javaClassName = className.startsWith("[") ? Type.getType(className).getClassName() : className.replace('/', '.');
        return javaClassName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ String[] access$402(AsmClassInfo x0, String[] x1) {
        x0.m_interfaceClassNames = x1;
        return x1;
    }

    static class MethodParameterNamesCodeAdapter
    extends AsmAnnotationHelper.NullCodeAdapter {
        private final boolean m_isStatic;
        private final int m_parameterCount;
        private AsmMethodInfo m_methodInfo;
        private int m_signatureParameterRegisterDepth = 0;

        public MethodParameterNamesCodeAdapter(boolean isStatic, int parameterCount, AsmMethodInfo methodInfo) {
            this.m_isStatic = isStatic;
            this.m_parameterCount = parameterCount;
            this.m_methodInfo = methodInfo;
            this.m_methodInfo.m_parameterNames = new String[this.m_parameterCount];
            if (!this.m_isStatic) {
                ++this.m_signatureParameterRegisterDepth;
            }
            this.m_signatureParameterRegisterDepth += AsmHelper.getRegisterDepth(Type.getArgumentTypes(this.m_methodInfo.m_member.desc));
        }

        public void visitLocalVariable(String name, String desc, Label start, Label end, int index) {
            if (index < this.m_signatureParameterRegisterDepth) {
                if (index == 0) {
                    if (this.m_isStatic) {
                        this.m_methodInfo.pushParameterNameFromRegister(index, name);
                    }
                } else {
                    this.m_methodInfo.pushParameterNameFromRegister(index, name);
                }
            }
        }
    }

    private class ClassInfoClassAdapter
    extends AsmAnnotationHelper.NullClassAdapter {
        public boolean m_lazyAttributes = true;

        public ClassInfoClassAdapter(boolean lazyAttributes) {
            this.m_lazyAttributes = lazyAttributes;
        }

        public void visit(int version, int access, String name, String superName, String[] interfaces, String sourceFile) {
            AsmClassInfo.this.m_name = name.replace('/', '.');
            AsmClassInfo.this.m_modifiers = access;
            AsmClassInfo.this.m_isInterface = Modifier.isInterface(AsmClassInfo.this.m_modifiers);
            AsmClassInfo.this.m_superClassName = superName == null ? null : superName.replace('/', '.');
            AsmClassInfo.access$402(AsmClassInfo.this, new String[interfaces.length]);
            for (int i = 0; i < interfaces.length; ++i) {
                ((AsmClassInfo)AsmClassInfo.this).m_interfaceClassNames[i] = interfaces[i].replace('/', '.');
            }
            if (AsmClassInfo.this.m_name.endsWith("[]")) {
                AsmClassInfo.this.m_isArray = true;
                int index = AsmClassInfo.this.m_name.indexOf(91);
                AsmClassInfo.this.m_componentTypeName = AsmClassInfo.this.m_name.substring(0, index);
            } else if (AsmClassInfo.this.m_name.equals("long") || AsmClassInfo.this.m_name.equals("int") || AsmClassInfo.this.m_name.equals("short") || AsmClassInfo.this.m_name.equals("double") || AsmClassInfo.this.m_name.equals("float") || AsmClassInfo.this.m_name.equals("byte") || AsmClassInfo.this.m_name.equals("boolean") || AsmClassInfo.this.m_name.equals("char")) {
                AsmClassInfo.this.m_isPrimitive = true;
            }
        }

        public void visitAttribute(Attribute attribute) {
            if (!this.m_lazyAttributes) {
                List annotations = new ArrayList();
                annotations = AsmAnnotationHelper.extractAnnotations(annotations, attribute, (ClassLoader)AsmClassInfo.this.m_loaderRef.get());
                AsmClassInfo.this.m_annotations = annotations;
            }
        }

        public void visitField(int access, String name, String desc, Object value, Attribute attrs) {
            FieldStruct struct = new FieldStruct();
            struct.modifiers = access;
            struct.name = name;
            struct.desc = desc;
            struct.value = value;
            AsmFieldInfo fieldInfo = new AsmFieldInfo(struct, AsmClassInfo.this.m_name, (ClassLoader)AsmClassInfo.this.m_loaderRef.get());
            if (!this.m_lazyAttributes) {
                List annotations = new ArrayList();
                fieldInfo.m_annotations = annotations = AsmAnnotationHelper.extractAnnotations(annotations, attrs, (ClassLoader)AsmClassInfo.this.m_loaderRef.get());
            }
            int hash = AsmHelper.calculateFieldHash(name, desc);
            AsmClassInfo.this.m_fields.put(hash, (Object)fieldInfo);
            AsmClassInfo.this.m_sortedFieldHashes.add(hash);
        }

        public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
            MethodStruct struct = new MethodStruct();
            struct.modifiers = access;
            struct.name = name;
            struct.desc = desc;
            struct.exceptions = exceptions;
            int hash = AsmHelper.calculateMethodHash(name, desc);
            AsmMethodInfo methodInfo = null;
            if (name.equals("<clinit>")) {
                AsmClassInfo.this.m_hasStaticInitializer = true;
            } else {
                AsmMemberInfo memberInfo = null;
                if (name.equals("<init>")) {
                    memberInfo = new AsmConstructorInfo(struct, AsmClassInfo.this.m_name, (ClassLoader)AsmClassInfo.this.m_loaderRef.get());
                    AsmClassInfo.this.m_constructors.put(hash, (Object)memberInfo);
                    AsmClassInfo.this.m_sortedConstructorHashes.add(hash);
                } else {
                    memberInfo = new AsmMethodInfo(struct, AsmClassInfo.this.m_name, (ClassLoader)AsmClassInfo.this.m_loaderRef.get());
                    AsmClassInfo.this.m_methods.put(hash, (Object)memberInfo);
                    AsmClassInfo.this.m_sortedMethodHashes.add(hash);
                    methodInfo = (AsmMethodInfo)memberInfo;
                }
                if (!this.m_lazyAttributes) {
                    List annotations = new ArrayList();
                    memberInfo.m_annotations = annotations = AsmAnnotationHelper.extractAnnotations(annotations, attrs, (ClassLoader)AsmClassInfo.this.m_loaderRef.get());
                }
            }
            if (methodInfo != null) {
                Type[] parameterTypes = Type.getArgumentTypes(desc);
                if (parameterTypes.length > 0) {
                    MethodParameterNamesCodeAdapter methodParameterNamesVisitor = new MethodParameterNamesCodeAdapter(Modifier.isStatic(access), parameterTypes.length, methodInfo);
                    return methodParameterNamesVisitor;
                }
                methodInfo.m_parameterNames = EMPTY_STRING_ARRAY;
            }
            return AsmAnnotationHelper.NullCodeAdapter.NULL_CODE_ADAPTER;
        }

        public void visitEnd() {
            AsmClassInfo.this.m_signature = AsmHelper.getClassDescriptor(AsmClassInfo.this);
        }
    }

    public static class ClassNameRetrievalClassAdapter
    extends AsmAnnotationHelper.NullClassAdapter {
        private String m_className;

        public void visit(int version, int access, String name, String superName, String[] interfaces, String sourceFile) {
            this.m_className = name.replace('/', '.');
        }

        public String getClassName() {
            return this.m_className;
        }
    }
}

