/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.expression;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.aspectwerkz.annotation.AnnotationInfo;
import org.codehaus.aspectwerkz.expression.ExpressionContext;
import org.codehaus.aspectwerkz.expression.ExpressionInfo;
import org.codehaus.aspectwerkz.expression.ExpressionNamespace;
import org.codehaus.aspectwerkz.expression.PointcutType;
import org.codehaus.aspectwerkz.expression.SubtypePatternType;
import org.codehaus.aspectwerkz.expression.Undeterministic;
import org.codehaus.aspectwerkz.expression.ast.ASTAnd;
import org.codehaus.aspectwerkz.expression.ast.ASTArgParameter;
import org.codehaus.aspectwerkz.expression.ast.ASTArgs;
import org.codehaus.aspectwerkz.expression.ast.ASTAttribute;
import org.codehaus.aspectwerkz.expression.ast.ASTCall;
import org.codehaus.aspectwerkz.expression.ast.ASTCflow;
import org.codehaus.aspectwerkz.expression.ast.ASTCflowBelow;
import org.codehaus.aspectwerkz.expression.ast.ASTClassPattern;
import org.codehaus.aspectwerkz.expression.ast.ASTConstructorPattern;
import org.codehaus.aspectwerkz.expression.ast.ASTExecution;
import org.codehaus.aspectwerkz.expression.ast.ASTExpression;
import org.codehaus.aspectwerkz.expression.ast.ASTFieldPattern;
import org.codehaus.aspectwerkz.expression.ast.ASTGet;
import org.codehaus.aspectwerkz.expression.ast.ASTHandler;
import org.codehaus.aspectwerkz.expression.ast.ASTHasField;
import org.codehaus.aspectwerkz.expression.ast.ASTHasMethod;
import org.codehaus.aspectwerkz.expression.ast.ASTMethodPattern;
import org.codehaus.aspectwerkz.expression.ast.ASTModifier;
import org.codehaus.aspectwerkz.expression.ast.ASTNot;
import org.codehaus.aspectwerkz.expression.ast.ASTOr;
import org.codehaus.aspectwerkz.expression.ast.ASTParameter;
import org.codehaus.aspectwerkz.expression.ast.ASTPointcutReference;
import org.codehaus.aspectwerkz.expression.ast.ASTRoot;
import org.codehaus.aspectwerkz.expression.ast.ASTSet;
import org.codehaus.aspectwerkz.expression.ast.ASTStaticInitialization;
import org.codehaus.aspectwerkz.expression.ast.ASTTarget;
import org.codehaus.aspectwerkz.expression.ast.ASTThis;
import org.codehaus.aspectwerkz.expression.ast.ASTWithin;
import org.codehaus.aspectwerkz.expression.ast.ASTWithinCode;
import org.codehaus.aspectwerkz.expression.ast.ExpressionParserVisitor;
import org.codehaus.aspectwerkz.expression.ast.Node;
import org.codehaus.aspectwerkz.expression.ast.SimpleNode;
import org.codehaus.aspectwerkz.expression.regexp.TypePattern;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.reflect.ClassInfoHelper;
import org.codehaus.aspectwerkz.reflect.ConstructorInfo;
import org.codehaus.aspectwerkz.reflect.FieldInfo;
import org.codehaus.aspectwerkz.reflect.MemberInfo;
import org.codehaus.aspectwerkz.reflect.MethodInfo;
import org.codehaus.aspectwerkz.reflect.ReflectionInfo;
import org.codehaus.aspectwerkz.reflect.StaticInitializationInfo;
import org.codehaus.aspectwerkz.util.Util;

public class ExpressionVisitor
implements ExpressionParserVisitor {
    protected Node m_root;
    protected String m_expression;
    protected String m_namespace;
    protected ExpressionInfo m_expressionInfo;

    public ExpressionVisitor(ExpressionInfo expressionInfo, String expression, String namespace, Node root) {
        this.m_expressionInfo = expressionInfo;
        this.m_expression = expression;
        this.m_namespace = namespace;
        this.m_root = root;
    }

    public boolean match(ExpressionContext context) {
        Boolean match = (Boolean)this.visit(this.m_root, (Object)context);
        return match != null ? match : true;
    }

    protected Boolean matchUndeterministic(ExpressionContext context) {
        Boolean match = (Boolean)this.visit(this.m_root, (Object)context);
        return match;
    }

    public Object visit(Node node, Object data) {
        return node.jjtGetChild(0).jjtAccept(this, data);
    }

    public Object visit(SimpleNode node, Object data) {
        return node.jjtGetChild(0).jjtAccept(this, data);
    }

    public Object visit(ASTRoot node, Object data) {
        return node.jjtGetChild(0).jjtAccept(this, data);
    }

    public Object visit(ASTExpression node, Object data) {
        return node.jjtGetChild(0).jjtAccept(this, data);
    }

    public Object visit(ASTOr node, Object data) {
        Boolean matchL = (Boolean)node.jjtGetChild(0).jjtAccept(this, data);
        Boolean matchR = (Boolean)node.jjtGetChild(1).jjtAccept(this, data);
        Boolean intermediate = Undeterministic.or(matchL, matchR);
        for (int i = 2; i < node.jjtGetNumChildren(); ++i) {
            Boolean matchNext = (Boolean)node.jjtGetChild(i).jjtAccept(this, data);
            intermediate = Undeterministic.or(intermediate, matchNext);
        }
        return intermediate;
    }

    public Object visit(ASTAnd node, Object data) {
        Boolean matchL = (Boolean)node.jjtGetChild(0).jjtAccept(this, data);
        Boolean matchR = (Boolean)node.jjtGetChild(1).jjtAccept(this, data);
        Boolean intermediate = Undeterministic.and(matchL, matchR);
        for (int i = 2; i < node.jjtGetNumChildren(); ++i) {
            Boolean matchNext = (Boolean)node.jjtGetChild(i).jjtAccept(this, data);
            intermediate = Undeterministic.and(intermediate, matchNext);
        }
        return intermediate;
    }

    public Object visit(ASTNot node, Object data) {
        Boolean match = (Boolean)node.jjtGetChild(0).jjtAccept(this, data);
        return Undeterministic.not(match);
    }

    public Object visit(ASTPointcutReference node, Object data) {
        ExpressionContext context = (ExpressionContext)data;
        ExpressionNamespace namespace = ExpressionNamespace.getNamespace(this.m_namespace);
        ExpressionVisitor expression = namespace.getExpression(node.getName());
        return expression.matchUndeterministic(context);
    }

    public Object visit(ASTExecution node, Object data) {
        ExpressionContext context = (ExpressionContext)data;
        if (context.hasExecutionPointcut() && (context.hasMethodInfo() || context.hasConstructorInfo())) {
            return this.visitAnnotatedNode(node, context.getReflectionInfo());
        }
        return Boolean.FALSE;
    }

    public Object visit(ASTCall node, Object data) {
        ExpressionContext context = (ExpressionContext)data;
        if (context.hasCallPointcut() && (context.hasMethodInfo() || context.hasConstructorInfo())) {
            return this.visitAnnotatedNode(node, context.getReflectionInfo());
        }
        return Boolean.FALSE;
    }

    public Object visit(ASTSet node, Object data) {
        ExpressionContext context = (ExpressionContext)data;
        if (context.hasSetPointcut() && context.hasFieldInfo()) {
            return this.visitAnnotatedNode(node, context.getReflectionInfo());
        }
        return Boolean.FALSE;
    }

    public Object visit(ASTGet node, Object data) {
        ExpressionContext context = (ExpressionContext)data;
        if (context.hasGetPointcut() && context.hasFieldInfo()) {
            return this.visitAnnotatedNode(node, context.getReflectionInfo());
        }
        return Boolean.FALSE;
    }

    public Object visit(ASTHandler node, Object data) {
        ExpressionContext context = (ExpressionContext)data;
        if (context.hasHandlerPointcut() && context.hasClassInfo()) {
            return node.jjtGetChild(0).jjtAccept(this, context.getReflectionInfo());
        }
        return Boolean.FALSE;
    }

    public Object visit(ASTStaticInitialization node, Object data) {
        ExpressionContext context = (ExpressionContext)data;
        if (context.hasStaticInitializationPointcut() && context.hasReflectionInfo()) {
            ReflectionInfo reflectInfo = context.getReflectionInfo();
            if (reflectInfo instanceof StaticInitializationInfo) {
                Boolean matchPattern;
                ClassInfo declaringClassInfo = ((StaticInitializationInfo)reflectInfo).getDeclaringType();
                Node patternNode = node.jjtGetChild(node.jjtGetNumChildren() - 1);
                if (!(patternNode instanceof ASTAttribute) && Boolean.FALSE.equals(matchPattern = (Boolean)patternNode.jjtAccept(this, reflectInfo))) {
                    return Boolean.FALSE;
                }
                boolean matchedAnnotations = this.visitAttributes(node, declaringClassInfo);
                if (!matchedAnnotations) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    public Object visit(ASTWithin node, Object data) {
        ExpressionContext context = (ExpressionContext)data;
        if (context.hasWithinReflectionInfo()) {
            ReflectionInfo reflectInfo = context.getWithinReflectionInfo();
            ReflectionInfo withinInfo = null;
            if (reflectInfo instanceof MemberInfo) {
                withinInfo = ((MemberInfo)reflectInfo).getDeclaringType();
            } else if (reflectInfo instanceof ClassInfo) {
                withinInfo = reflectInfo;
            } else {
                return Boolean.FALSE;
            }
            return this.visitAnnotatedNode(node, withinInfo);
        }
        return null;
    }

    public Object visit(ASTWithinCode node, Object data) {
        ExpressionContext context = (ExpressionContext)data;
        if (!context.hasWithinReflectionInfo()) {
            return null;
        }
        ReflectionInfo reflectInfo = context.getWithinReflectionInfo();
        if (node.isStaticInitializer()) {
            if (reflectInfo instanceof StaticInitializationInfo) {
                ClassInfo declaringClassInfo;
                SimpleNode staticClinitNode = (SimpleNode)node.jjtGetChild(0);
                boolean matchedAnnotations = this.visitAttributes(staticClinitNode, declaringClassInfo = ((StaticInitializationInfo)reflectInfo).getDeclaringType());
                if (!matchedAnnotations) {
                    return Boolean.FALSE;
                }
                Node lastNode = staticClinitNode.jjtGetChild(staticClinitNode.jjtGetNumChildren() - 1);
                if (lastNode instanceof ASTAttribute) {
                    return Boolean.TRUE;
                }
                return lastNode.jjtAccept(this, reflectInfo);
            }
            return Boolean.FALSE;
        }
        return this.visitAnnotatedNode(node, reflectInfo);
    }

    public Object visit(ASTHasMethod node, Object data) {
        ExpressionContext context = (ExpressionContext)data;
        ReflectionInfo info = context.getWithinReflectionInfo();
        ClassInfo classInfo = info instanceof MemberInfo ? ((MemberInfo)info).getDeclaringType() : (ClassInfo)info;
        Node patternNode = node.jjtGetChild(node.jjtGetNumChildren() - 1);
        boolean hasPatternNode = !(patternNode instanceof ASTAttribute);
        MethodInfo[] methodInfos = classInfo.getMethods();
        for (int i = 0; i < methodInfos.length; ++i) {
            boolean matchAnnotations;
            if (hasPatternNode && Boolean.FALSE.equals(patternNode.jjtAccept(this, methodInfos[i])) || !(matchAnnotations = this.visitAttributes(node, methodInfos[i]))) continue;
            return Boolean.TRUE;
        }
        ConstructorInfo[] constructorInfos = classInfo.getConstructors();
        for (int i = 0; i < constructorInfos.length; ++i) {
            boolean matchAnnotations;
            if (hasPatternNode && Boolean.FALSE.equals(patternNode.jjtAccept(this, constructorInfos[i])) || !(matchAnnotations = this.visitAttributes(node, constructorInfos[i]))) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Object visit(ASTHasField node, Object data) {
        ExpressionContext context = (ExpressionContext)data;
        ReflectionInfo info = context.getWithinReflectionInfo();
        ClassInfo classInfo = info instanceof MemberInfo ? ((MemberInfo)info).getDeclaringType() : (ClassInfo)info;
        Node patternNode = node.jjtGetChild(node.jjtGetNumChildren() - 1);
        boolean hasPatternNode = !(patternNode instanceof ASTAttribute);
        FieldInfo[] fieldInfos = classInfo.getFields();
        for (int i = 0; i < fieldInfos.length; ++i) {
            boolean matchAnnotations;
            if (hasPatternNode && Boolean.FALSE.equals(patternNode.jjtAccept(this, fieldInfos[i])) || !(matchAnnotations = this.visitAttributes(node, fieldInfos[i]))) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Object visit(ASTTarget node, Object data) {
        ExpressionContext context = (ExpressionContext)data;
        ReflectionInfo info = context.getReflectionInfo();
        ClassInfo declaringType = null;
        if (info instanceof MemberInfo) {
            if (Modifier.isStatic(((MemberInfo)info).getModifiers())) {
                return Boolean.FALSE;
            }
            declaringType = ((MemberInfo)info).getDeclaringType();
        } else if (info instanceof ClassInfo) {
            declaringType = (ClassInfo)info;
        } else {
            return Boolean.FALSE;
        }
        String boundedTypeName = node.getBoundedType(this.m_expressionInfo);
        if (declaringType.isInterface()) {
            if (ClassInfoHelper.instanceOf(declaringType, boundedTypeName)) {
                return Boolean.TRUE;
            }
            return null;
        }
        return Util.booleanValueOf(ClassInfoHelper.instanceOf(declaringType, boundedTypeName));
    }

    public Object visit(ASTThis node, Object data) {
        ExpressionContext context = (ExpressionContext)data;
        if (context.hasWithinReflectionInfo()) {
            ReflectionInfo withinInfo = context.getWithinReflectionInfo();
            if (withinInfo instanceof MemberInfo) {
                if (Modifier.isStatic(((MemberInfo)withinInfo).getModifiers())) {
                    return Boolean.FALSE;
                }
                return Util.booleanValueOf(ClassInfoHelper.instanceOf(((MemberInfo)withinInfo).getDeclaringType(), node.getBoundedType(this.m_expressionInfo)));
            }
            if (withinInfo instanceof ClassInfo) {
                return Util.booleanValueOf(ClassInfoHelper.instanceOf((ClassInfo)withinInfo, node.getBoundedType(this.m_expressionInfo)));
            }
        }
        return Boolean.FALSE;
    }

    public Object visit(ASTCflow node, Object data) {
        return null;
    }

    public Object visit(ASTCflowBelow node, Object data) {
        return null;
    }

    public Object visit(ASTClassPattern node, Object data) {
        if (data instanceof ClassInfo) {
            ClassInfo classInfo = (ClassInfo)data;
            TypePattern typePattern = node.getTypePattern();
            if (typePattern.matchType(classInfo) && this.visitModifiers(node, classInfo)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (data instanceof StaticInitializationInfo) {
            ClassInfo classInfo = ((StaticInitializationInfo)data).getDeclaringType();
            if (node.getTypePattern().matchType(classInfo)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    public Object visit(ASTMethodPattern node, Object data) {
        if (data instanceof MethodInfo) {
            MethodInfo methodInfo = (MethodInfo)data;
            if (node.getMethodNamePattern().matches(methodInfo.getName()) && node.getDeclaringTypePattern().matchType(methodInfo.getDeclaringType()) && node.getReturnTypePattern().matchType(methodInfo.getReturnType()) && this.visitModifiers(node, methodInfo) && this.visitParameters(node, methodInfo.getParameterTypes())) {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public Object visit(ASTConstructorPattern node, Object data) {
        if (data instanceof ConstructorInfo) {
            ConstructorInfo constructorMetaData = (ConstructorInfo)data;
            if (node.getDeclaringTypePattern().matchType(constructorMetaData.getDeclaringType()) && this.visitModifiers(node, constructorMetaData) && this.visitParameters(node, constructorMetaData.getParameterTypes())) {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public Object visit(ASTFieldPattern node, Object data) {
        if (data instanceof FieldInfo) {
            FieldInfo fieldInfo = (FieldInfo)data;
            if (node.getFieldNamePattern().matches(fieldInfo.getName()) && node.getDeclaringTypePattern().matchType(fieldInfo.getDeclaringType()) && node.getFieldTypePattern().matchType(fieldInfo.getType()) && this.visitModifiers(node, fieldInfo)) {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public Object visit(ASTParameter node, Object data) {
        ClassInfo parameterType = (ClassInfo)data;
        if (node.getDeclaringClassPattern().matchType(parameterType)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Object visit(ASTArgs node, Object data) {
        ExpressionContext ctx = (ExpressionContext)data;
        if (node.jjtGetNumChildren() <= 0) {
            return this.getParametersCount(ctx) == 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        int expressionParameterCount = node.jjtGetNumChildren();
        boolean isFirstArgEager = ((ASTArgParameter)node.jjtGetChild(0)).getTypePattern().isEagerWildCard();
        boolean isLastArgEager = ((ASTArgParameter)node.jjtGetChild(node.jjtGetNumChildren() - 1)).getTypePattern().isEagerWildCard();
        if (isFirstArgEager && expressionParameterCount == 1) {
            return Boolean.TRUE;
        }
        int contextParametersCount = this.getParametersCount(ctx);
        if (isFirstArgEager && isLastArgEager) {
            if ((expressionParameterCount -= 2) == 0) {
                return Boolean.TRUE;
            }
            int matchCount = 0;
            int ictx = 0;
            for (int iexp = 0; iexp < expressionParameterCount; ++iexp) {
                if (ictx >= contextParametersCount) {
                    matchCount = -1;
                    break;
                }
                ctx.setCurrentTargetArgsIndex(ictx);
                boolean isEager = ((ASTArgParameter)node.jjtGetChild(iexp + 1)).getTypePattern().isEagerWildCard();
                if (isEager) {
                    // empty if block
                }
                if (Boolean.TRUE.equals((Boolean)node.jjtGetChild(iexp + 1).jjtAccept(this, ctx))) {
                    ++matchCount;
                    ++ictx;
                    continue;
                }
                matchCount = 0;
                ++ictx;
                iexp = -1;
            }
            if (matchCount == expressionParameterCount) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (isFirstArgEager) {
            if (contextParametersCount >= --expressionParameterCount) {
                for (int i = 0; i < contextParametersCount && expressionParameterCount - i >= 0; ++i) {
                    ctx.setCurrentTargetArgsIndex(contextParametersCount - 1 - i);
                    if (Boolean.TRUE.equals((Boolean)node.jjtGetChild(expressionParameterCount - i).jjtAccept(this, ctx))) continue;
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (isLastArgEager) {
            if (contextParametersCount >= --expressionParameterCount) {
                for (int i = 0; i < contextParametersCount && i < expressionParameterCount; ++i) {
                    ctx.setCurrentTargetArgsIndex(i);
                    if (Boolean.TRUE.equals((Boolean)node.jjtGetChild(i).jjtAccept(this, ctx))) continue;
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (expressionParameterCount == contextParametersCount) {
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                ctx.setCurrentTargetArgsIndex(i);
                if (Boolean.TRUE.equals((Boolean)node.jjtGetChild(i).jjtAccept(this, ctx))) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Object visit(ASTArgParameter node, Object data) {
        String boundedType;
        TypePattern typePattern;
        TypePattern realPattern = typePattern = node.getTypePattern();
        int pointcutArgIndex = -1;
        if (typePattern.getPattern().indexOf(".") < 0 && (boundedType = this.m_expressionInfo.getArgumentType(typePattern.getPattern())) != null) {
            pointcutArgIndex = this.m_expressionInfo.getArgumentIndex(typePattern.getPattern());
            realPattern = TypePattern.compileTypePattern(boundedType, SubtypePatternType.NOT_HIERARCHICAL);
        }
        ExpressionContext ctx = (ExpressionContext)data;
        ClassInfo argInfo = null;
        try {
            if (ctx.getReflectionInfo() instanceof MethodInfo) {
                argInfo = ((MethodInfo)ctx.getReflectionInfo()).getParameterTypes()[ctx.getCurrentTargetArgsIndex()];
            } else if (ctx.getReflectionInfo() instanceof ConstructorInfo) {
                argInfo = ((ConstructorInfo)ctx.getReflectionInfo()).getParameterTypes()[ctx.getCurrentTargetArgsIndex()];
            } else if (ctx.getReflectionInfo() instanceof FieldInfo) {
                argInfo = ((FieldInfo)ctx.getReflectionInfo()).getType();
            } else if (ctx.getPointcutType().equals(PointcutType.HANDLER) && ctx.getReflectionInfo() instanceof ClassInfo) {
                argInfo = (ClassInfo)ctx.getReflectionInfo();
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return Boolean.FALSE;
        }
        if (realPattern.matchType(argInfo)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Object visit(ASTAttribute node, Object data) {
        boolean matchAnnotation = false;
        List annotations = (List)data;
        Iterator it = annotations.iterator();
        while (it.hasNext()) {
            AnnotationInfo annotation = (AnnotationInfo)it.next();
            if (!annotation.getName().equals(node.getName())) continue;
            matchAnnotation = true;
        }
        if (node.isNot()) {
            return Util.booleanValueOf(!matchAnnotation);
        }
        return Util.booleanValueOf(matchAnnotation);
    }

    public Object visit(ASTModifier node, Object data) {
        ReflectionInfo refInfo = (ReflectionInfo)data;
        int modifiersToMatch = refInfo.getModifiers();
        int modifierPattern = node.getModifier();
        if (node.isNot()) {
            if ((modifierPattern & 1) != 0) {
                if ((modifiersToMatch & 1) == 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if ((modifierPattern & 4) != 0) {
                if ((modifiersToMatch & 4) == 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if ((modifierPattern & 2) != 0) {
                if ((modifiersToMatch & 2) == 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if ((modifierPattern & 8) != 0) {
                if ((modifiersToMatch & 8) == 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if ((modifierPattern & 0x20) != 0) {
                if ((modifiersToMatch & 0x20) == 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if ((modifierPattern & 0x10) != 0) {
                if ((modifiersToMatch & 0x10) == 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if ((modifierPattern & 0x80) != 0) {
                if ((modifiersToMatch & 0x80) == 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if ((modifierPattern & 0x40) != 0) {
                if ((modifiersToMatch & 0x40) == 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if ((modifierPattern & 0x800) != 0) {
                if ((modifiersToMatch & 0x800) == 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            return Boolean.FALSE;
        }
        if ((modifierPattern & 1) != 0) {
            if ((modifiersToMatch & 1) == 0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if ((modifierPattern & 4) != 0) {
            if ((modifiersToMatch & 4) == 0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if ((modifierPattern & 2) != 0) {
            if ((modifiersToMatch & 2) == 0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if ((modifierPattern & 8) != 0) {
            if ((modifiersToMatch & 8) == 0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if ((modifierPattern & 0x20) != 0) {
            if ((modifiersToMatch & 0x20) == 0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if ((modifierPattern & 0x10) != 0) {
            if ((modifiersToMatch & 0x10) == 0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if ((modifierPattern & 0x80) != 0) {
            if ((modifiersToMatch & 0x80) == 0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if ((modifierPattern & 0x40) != 0) {
            if ((modifiersToMatch & 0x40) == 0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if ((modifierPattern & 0x800) != 0) {
            if ((modifiersToMatch & 0x800) == 0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        return Boolean.TRUE;
    }

    protected boolean visitAttributes(SimpleNode node, ReflectionInfo refInfo) {
        int nrChildren = node.jjtGetNumChildren();
        if (nrChildren != 0) {
            for (int i = 0; i < nrChildren; ++i) {
                List annotations;
                Node child = node.jjtGetChild(i);
                if (!(child instanceof ASTAttribute) || Boolean.TRUE.equals(child.jjtAccept(this, annotations = refInfo.getAnnotations()))) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean visitModifiers(SimpleNode node, ReflectionInfo refInfo) {
        int nrChildren = node.jjtGetNumChildren();
        if (nrChildren != 0) {
            for (int i = 0; i < nrChildren; ++i) {
                Node child = node.jjtGetChild(i);
                if (!(child instanceof ASTModifier) || Boolean.TRUE.equals(child.jjtAccept(this, refInfo))) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean visitParameters(SimpleNode node, ClassInfo[] parameterTypes) {
        int nrChildren = node.jjtGetNumChildren();
        if (nrChildren <= 0) {
            return parameterTypes.length == 0;
        }
        ArrayList<Node> parameterNodes = new ArrayList<Node>();
        for (int i = 0; i < nrChildren; ++i) {
            Node child = node.jjtGetChild(i);
            if (!(child instanceof ASTParameter)) continue;
            parameterNodes.add(child);
        }
        if (parameterNodes.size() <= 0) {
            return parameterTypes.length == 0;
        }
        int expressionParameterCount = parameterNodes.size();
        boolean isFirstArgEager = ((ASTParameter)parameterNodes.get(0)).getDeclaringClassPattern().isEagerWildCard();
        boolean isLastArgEager = ((ASTParameter)parameterNodes.get(expressionParameterCount - 1)).getDeclaringClassPattern().isEagerWildCard();
        if (isFirstArgEager && expressionParameterCount == 1) {
            return true;
        }
        int contextParametersCount = parameterTypes.length;
        if (isFirstArgEager && isLastArgEager) {
            if ((expressionParameterCount -= 2) == 0) {
                return true;
            }
            int matchCount = 0;
            int ictx = 0;
            for (int iexp = 0; iexp < expressionParameterCount; ++iexp) {
                if (ictx >= contextParametersCount) {
                    matchCount = -1;
                    break;
                }
                ASTParameter parameterNode = (ASTParameter)parameterNodes.get(iexp + 1);
                boolean isEager = parameterNode.getDeclaringClassPattern().isEagerWildCard();
                if (isEager) {
                    // empty if block
                }
                if (Boolean.TRUE.equals((Boolean)parameterNode.jjtAccept(this, parameterTypes[ictx]))) {
                    ++matchCount;
                    ++ictx;
                    continue;
                }
                matchCount = 0;
                ++ictx;
                iexp = -1;
            }
            return matchCount == expressionParameterCount;
        }
        if (isFirstArgEager) {
            if (contextParametersCount >= --expressionParameterCount) {
                for (int i = 0; i < contextParametersCount && expressionParameterCount - i >= 0; ++i) {
                    ASTParameter parameterNode = (ASTParameter)parameterNodes.get(expressionParameterCount - i);
                    if (Boolean.TRUE.equals((Boolean)parameterNode.jjtAccept(this, parameterTypes[contextParametersCount - 1 - i]))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (isLastArgEager) {
            if (contextParametersCount >= --expressionParameterCount) {
                for (int i = 0; i < contextParametersCount && i < expressionParameterCount; ++i) {
                    ASTParameter parameterNode = (ASTParameter)parameterNodes.get(i);
                    if (Boolean.TRUE.equals((Boolean)parameterNode.jjtAccept(this, parameterTypes[i]))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (expressionParameterCount == contextParametersCount) {
            for (int i = 0; i < parameterNodes.size(); ++i) {
                ASTParameter parameterNode = (ASTParameter)parameterNodes.get(i);
                if (Boolean.TRUE.equals((Boolean)parameterNode.jjtAccept(this, parameterTypes[i]))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return this.m_expression;
    }

    private int getParametersCount(ExpressionContext ctx) {
        ReflectionInfo reflectionInfo = ctx.getReflectionInfo();
        if (reflectionInfo instanceof MethodInfo) {
            return ((MethodInfo)reflectionInfo).getParameterTypes().length;
        }
        if (reflectionInfo instanceof ConstructorInfo) {
            return ((ConstructorInfo)reflectionInfo).getParameterTypes().length;
        }
        if (reflectionInfo instanceof FieldInfo) {
            return 1;
        }
        if (ctx.getPointcutType().equals(PointcutType.HANDLER) && reflectionInfo instanceof ClassInfo) {
            return 1;
        }
        return -1;
    }

    protected Object visitAnnotatedNode(SimpleNode node, ReflectionInfo reflectInfo) {
        Node patternNode = node.jjtGetChild(node.jjtGetNumChildren() - 1);
        if (!(patternNode instanceof ASTAttribute) && Boolean.FALSE.equals((Boolean)patternNode.jjtAccept(this, reflectInfo))) {
            return Boolean.FALSE;
        }
        boolean matchedAnnotations = this.visitAttributes(node, reflectInfo);
        if (!matchedAnnotations) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Node getASTRoot() {
        return this.m_root;
    }

    public ExpressionInfo getExpressionInfo() {
        return this.m_expressionInfo;
    }
}

