/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.expression;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.codehaus.aspectwerkz.exception.DefinitionException;
import org.codehaus.aspectwerkz.expression.AdvisedClassFilterExpressionVisitor;
import org.codehaus.aspectwerkz.expression.ExpressionInfo;
import org.codehaus.aspectwerkz.expression.ExpressionVisitor;

public final class ExpressionNamespace {
    private static final Map s_namespaces = new WeakHashMap();
    private final Map m_expressions = new HashMap();
    private final String m_namespace;

    private ExpressionNamespace(String namespace) {
        this.m_namespace = namespace;
    }

    public static synchronized ExpressionNamespace getNamespace(String namespace) {
        if (!s_namespaces.containsKey(namespace)) {
            s_namespaces.put(namespace, new ExpressionNamespace(namespace));
        }
        return (ExpressionNamespace)s_namespaces.get(namespace);
    }

    public void addExpressionInfo(String name, ExpressionInfo expressionInfo) {
        this.m_expressions.put(name, expressionInfo);
    }

    public ExpressionInfo getExpressionInfoOrNull(String name) {
        int index = name.lastIndexOf(46);
        if (index != -1) {
            return ExpressionNamespace.getNamespace(name.substring(0, index)).getExpressionInfoOrNull(name.substring(index + 1, name.length()));
        }
        ExpressionInfo expressionInfo = (ExpressionInfo)this.m_expressions.get(name);
        return expressionInfo;
    }

    public ExpressionInfo getExpressionInfo(String name) {
        int index = name.lastIndexOf(46);
        if (index != -1) {
            return ExpressionNamespace.getNamespace(name.substring(0, index)).getExpressionInfo(name.substring(index + 1, name.length()));
        }
        ExpressionInfo expressionInfo = (ExpressionInfo)this.m_expressions.get(name);
        if (expressionInfo == null) {
            throw new DefinitionException("could not resolve reference to pointcut [" + name + "] in namespace [" + this.m_namespace + "]");
        }
        return expressionInfo;
    }

    public ExpressionVisitor getExpression(String name) {
        return this.getExpressionInfo(name).getExpression();
    }

    public AdvisedClassFilterExpressionVisitor getAdvisedClassExpression(String name) {
        return this.getExpressionInfo(name).getAdvisedClassFilterExpression();
    }

    public String getName() {
        return this.m_namespace;
    }
}

