/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.dto;

import au.com.bytecode.opencsv.CSVParser;
import au.com.bytecode.opencsv.CSVWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;

public final class VradiQueryBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String queryLine;
    private final String[] queryArray;
    private final String id;

    public VradiQueryBean() {
        this.id = null;
        this.queryLine = "";
        this.queryArray = new String[3];
    }

    public VradiQueryBean(String queryLine) throws IOException {
        this(queryLine, null);
    }

    public VradiQueryBean(String queryLine, String id) throws IOException {
        this.id = id;
        this.queryLine = queryLine;
        this.queryArray = VradiQueryBean.decode(queryLine, 3);
    }

    private VradiQueryBean(String[] queryArray, String id) {
        if (queryArray.length < 3) {
            throw new IllegalArgumentException("queryArray length is less than 3");
        }
        this.id = id;
        this.queryArray = (String[])queryArray.clone();
        this.queryLine = VradiQueryBean.encode(queryArray);
    }

    public String getQuery() {
        return this.queryArray[0];
    }

    public String getName() {
        return this.queryArray[1];
    }

    public String getDescription() {
        return this.queryArray[2];
    }

    public String toString() {
        return this.queryLine;
    }

    public String[] toArray() {
        return this.queryArray;
    }

    public VradiQueryBean setQuery(String value) {
        return this.create(value, 0);
    }

    public VradiQueryBean setName(String value) {
        return this.create(value, 1);
    }

    public VradiQueryBean setDescription(String value) {
        return this.create(value, 2);
    }

    private VradiQueryBean create(String value, int pos) {
        String[] newArray = (String[])this.queryArray.clone();
        newArray[pos] = value;
        return new VradiQueryBean(newArray, this.id);
    }

    static String[] decode(String line, int size) throws IOException {
        CSVParser csvParser = new CSVParser();
        String[] parseLine = csvParser.parseLine(line);
        String[] result = new String[size];
        for (int i = 0; i < parseLine.length; ++i) {
            result[i] = parseLine[i];
        }
        return result;
    }

    static String encode(String[] columns) {
        StringWriter writer = new StringWriter();
        CSVWriter csvwriter = new CSVWriter((Writer)writer, ',', '\"', '\"', "");
        csvwriter.writeNext(columns);
        return writer.toString();
    }

    public String getId() {
        return this.id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.queryLine == null ? 0 : this.queryLine.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VradiQueryBean other = (VradiQueryBean)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.queryLine == null ? other.queryLine != null : !this.queryLine.equals(other.queryLine));
    }
}

