/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.admin;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.entities.VradiUser;
import com.jurismarches.vradi.entities.XmlFieldBinding;
import com.jurismarches.vradi.entities.XmlFieldBindingImpl;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.models.FieldSelectModel;
import com.jurismarches.vradi.models.FieldTypeModel;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.services.XmlStreamService;
import com.jurismarches.vradi.services.dto.VradiFormPageDTO;
import com.jurismarches.vradi.services.dto.VradiThesaurusDTO;
import com.jurismarches.vradi.services.dto.VradiXmlStreamDTO;
import com.jurismarches.vradi.ui.JListCellRenderer;
import com.jurismarches.vradi.ui.OfferEditHandler;
import com.jurismarches.vradi.ui.OfferEditUI;
import com.jurismarches.vradi.ui.OfferListTableModel;
import com.jurismarches.vradi.ui.ThesaurusTreeHelper;
import com.jurismarches.vradi.ui.UIHelper;
import com.jurismarches.vradi.ui.VradiMainUI;
import com.jurismarches.vradi.ui.admin.AdminContentUI;
import com.jurismarches.vradi.ui.admin.AdminPopupUI;
import com.jurismarches.vradi.ui.admin.AdminRequestUI;
import com.jurismarches.vradi.ui.admin.AdminThesaurusUI;
import com.jurismarches.vradi.ui.admin.ThesaurusEditUI;
import com.jurismarches.vradi.ui.admin.ThesaurusPathChooserUI;
import com.jurismarches.vradi.ui.admin.VradiNavigationTreeHelper;
import com.jurismarches.vradi.ui.admin.content.AdminXmlStreamUI;
import com.jurismarches.vradi.ui.admin.content.FormNavigationTreeHelper;
import com.jurismarches.vradi.ui.admin.content.RequestSelectUI;
import com.jurismarches.vradi.ui.admin.content.XmlStreamFieldTableModel;
import com.jurismarches.vradi.ui.editors.JListCellEditor;
import com.jurismarches.vradi.ui.search.SearchHandler;
import java.awt.Component;
import java.awt.Cursor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JOptionPane;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Element;
import org.nuiton.i18n.I18n;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.BusinessEntity;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.TreeNode;
import org.sharengo.wikitty.TreeNodeImpl;
import org.sharengo.wikitty.WikittyExtension;

public class AdminHandler {
    private static final Log log = LogFactory.getLog(AdminHandler.class);
    public static final int TOOLTIP_LINE_MAX_CHAR_NB = 100;
    public static final int TOOLTIP_ELEMENT_MAX_CHAR_NB = 500;
    public static final Map<String, Element> XML_STREAM_FIELDS_CACHE = new HashMap<String, Element>();
    protected static final Comparator<Client> CLIENT_COMPARATOR = new Comparator<Client>(){

        @Override
        public int compare(Client o1, Client o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    protected static final Comparator<User> USER_COMPARATOR = new Comparator<User>(){

        @Override
        public int compare(User o1, User o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    protected static final Comparator<Group> GROUP_COMPARATOR = new Comparator<Group>(){

        @Override
        public int compare(Group o1, Group o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    protected static final Comparator<WikittyExtension> FORM_COMPARATOR = new Comparator<WikittyExtension>(){

        @Override
        public int compare(WikittyExtension o1, WikittyExtension o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    protected static final Comparator<XmlStream> XML_STREAM_COMPARATOR = new Comparator<XmlStream>(){

        @Override
        public int compare(XmlStream o1, XmlStream o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };

    public AdminPopupUI init(JAXXContext rootContext, Object ... datas) {
        AdminPopupUI ui = (AdminPopupUI)VradiContext.ADMIN_UI_ENTRY_DEF.getContextValue(rootContext);
        if (ui == null) {
            JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext).add((Object)this);
            VradiMainUI mainUI = (VradiMainUI)VradiContext.MAIN_UI_ENTRY_DEF.getContextValue((JAXXContext)context);
            ui = new AdminPopupUI((JAXXContext)context, mainUI);
            VradiContext.ADMIN_UI_ENTRY_DEF.setContextValue(rootContext, (Object)ui);
        } else {
            log.info((Object)"Reinit thesaurus");
            ui.getAdminThesaurus().reinit(new ThesaurusTreeHelper((JAXXContext)ui, this.getRootThesaurus()));
        }
        return ui;
    }

    AdminPopupUI getUI(JAXXContext context) {
        if (context instanceof AdminPopupUI) {
            return (AdminPopupUI)context;
        }
        AdminPopupUI ui = (AdminPopupUI)VradiContext.ADMIN_UI_ENTRY_DEF.getContextValue(context);
        return ui;
    }

    void close(JAXXContext context) {
        AdminPopupUI ui = this.getUI(context);
        ui.setVisible(false);
        ui.dispose();
    }

    protected VradiStorageService getVradiStorageService() {
        return ServiceHelper.getVradiStorageService();
    }

    protected XmlStreamService getXmlStreamService() {
        return ServiceHelper.getXmlStreamService();
    }

    protected boolean answerToDelete(JAXXContext context, String name) {
        AdminPopupUI ui = this.getUI(context);
        int n = JOptionPane.showConfirmDialog(ui, I18n._((String)"vradi.admin.deleteAnswer") + name + " ?", I18n._((String)"vradi.admin.deleteTitle"), 0);
        return n == 0;
    }

    protected void repaintSelectedNode(JAXXContext context, VradiNavigationTreeHelper helper) {
        helper.repaintNode(context, this.getSelectedNode(context, helper));
    }

    protected NavigationTreeNode getSelectedNode(JAXXContext context, VradiNavigationTreeHelper helper) {
        return helper.getSelectedNode(context);
    }

    public void save(Object bean) {
        BusinessEntity entity = (BusinessEntity)bean;
        try {
            this.getVradiStorageService().updateEntity(entity);
        }
        catch (TechnicalException ex) {
            log.error((Object)("Cant saving bean : " + entity + " id : " + entity.getWikittyId() + " caused by : " + (Object)((Object)ex)));
            ErrorDialogUI.showError((Exception)((Object)ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(JAXXContext context, VradiNavigationTreeHelper helper, Object ... beans) {
        try {
            for (Object bean : beans) {
                log.info((Object)("will save bean " + bean));
                this.save(bean);
            }
        }
        finally {
            this.repaintSelectedNode(context, helper);
        }
    }

    public boolean answerToSave(AdminThesaurusUI content) {
        if (content != null) {
            log.info((Object)("current content  to close " + ((Object)((Object)content)).getClass().getSimpleName() + " : " + content.isModified()));
            if (content.isModified().booleanValue()) {
                int n = JOptionPane.showConfirmDialog((Component)((Object)content), I18n._((String)"vradi.admin.saveThesaurusAnswer") + " ?", I18n._((String)"vradi.admin.saveTitle"), 1);
                switch (n) {
                    case 1: {
                        this.cancelThesaurus((JAXXContext)content, content.getHelper());
                        break;
                    }
                    case 0: {
                        this.saveThesaurus((JAXXContext)content, content.getHelper());
                        break;
                    }
                    case 2: {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public boolean answerToSave(AdminContentUI<?> content) {
        if (content != null) {
            log.info((Object)("current content  to close " + content.getClass().getSimpleName() + " : " + content.isModified()));
            if (content.isModified().booleanValue()) {
                int n = JOptionPane.showConfirmDialog(content, I18n._((String)"vradi.admin.saveAnswer") + VradiHelper.getEntityName(content.getBean()) + " ?", I18n._((String)"vradi.admin.saveTitle"), 1);
                switch (n) {
                    case 1: {
                        this.cancel(content, content.getHelper());
                        break;
                    }
                    case 0: {
                        content.postSave();
                        break;
                    }
                    case 2: {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(JAXXContext context, VradiNavigationTreeHelper helper, Object bean) {
        BusinessEntity entity = (BusinessEntity)bean;
        try {
            this.getVradiStorageService().deleteEntity(entity);
        }
        catch (TechnicalException ex) {
            log.error((Object)("Cant delete bean : " + entity + " id : " + entity.getWikittyId() + " caused by : " + (Object)((Object)ex)));
            ErrorDialogUI.showError((Exception)((Object)ex));
        }
        finally {
            NavigationTreeNode parent = helper.removeChildNode(helper.getSelectedNode(context));
            helper.selectNode(context, parent);
        }
    }

    protected <B> void cancel(AdminContentUI<B> content, VradiNavigationTreeHelper helper) {
        B selectedBean = content.getSelectedEntity();
        try {
            content.openUI(helper.getSelectedNode((JAXXContext)content));
        }
        catch (Exception e) {
            log.error((Object)("Cant cancel bean : " + selectedBean + " caused by : " + e), (Throwable)e);
            ErrorDialogUI.showError((Exception)e);
        }
    }

    public OfferListTableModel getResultTableModel(VradiFormPageDTO forms) {
        OfferListTableModel model = new OfferListTableModel(forms);
        return model;
    }

    public ComboBoxModel getTypesModel() {
        FieldTypeModel model = new FieldTypeModel();
        return model;
    }

    public void refreshAllThesaurus(JAXXContext context) {
        List editUIs = (List)VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.getContextValue((JAXXContext)VradiContext.get());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Refresh ui : " + (editUIs == null ? "is null" : Integer.valueOf(editUIs.size()))));
        }
        if (editUIs != null) {
            for (OfferEditUI editUI : editUIs) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Refresh ui : " + editUI.getData().getName()));
                }
                OfferEditHandler offerEditHandler = UIHelper.getHandler(context, OfferEditHandler.class);
                offerEditHandler.initThesaurus(context, editUI);
            }
        }
    }

    public VradiThesaurusDTO getRootThesaurus() {
        try {
            TreeNode rootThesaurus = this.getVradiStorageService().getRootThesaurus();
            VradiThesaurusDTO vradiThesaurusDTO = new VradiThesaurusDTO();
            vradiThesaurusDTO.fromWikitty(rootThesaurus);
            return vradiThesaurusDTO;
        }
        catch (TechnicalException e) {
            log.error((Object)"Cant get root thesaurus : ", (Throwable)e);
            ErrorDialogUI.showError((Exception)((Object)e));
            return null;
        }
    }

    protected NavigationTreeNode getSelectedNode(JAXXContext context, ThesaurusTreeHelper helper) {
        NavigationTreeNode selectedNode = helper.getSelectedNode(context);
        if (selectedNode == null) {
            selectedNode = helper.getRootNode();
        }
        return selectedNode;
    }

    public boolean addChildThesaurusToSelected(JAXXContext context, ThesaurusTreeHelper helper) {
        NavigationTreeNode parentNode = this.getSelectedNode(context, helper);
        if (parentNode == null) {
            parentNode = helper.getRootNode();
        }
        return this.addChildThesaurus(context, helper, parentNode);
    }

    protected boolean addChildThesaurus(JAXXContext context, ThesaurusTreeHelper helper, NavigationTreeNode parentNode) {
        String name;
        VradiThesaurusDTO thesaurusParent = (VradiThesaurusDTO)parentNode.getBean(context);
        TreeNodeImpl newTreeNode = new TreeNodeImpl();
        VradiThesaurusDTO newThesaurus = new VradiThesaurusDTO();
        newThesaurus.fromWikitty((TreeNode)newTreeNode);
        newThesaurus.setParentThesaurus(thesaurusParent);
        ThesaurusEditUI edit = new ThesaurusEditUI(context);
        edit.setBean(newThesaurus);
        this.attachListener(edit, newThesaurus);
        edit.setHelper(helper);
        edit.setTitleThesaurus(I18n._((String)"vradi.adminThesaurus.creationTitle"));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating thesaurus " + newThesaurus.getName()));
        }
        edit.setVisible(true);
        if (edit.isSave().booleanValue() && (name = edit.getName()) != null && !name.isEmpty()) {
            newThesaurus.setParentThesaurus(thesaurusParent);
            thesaurusParent.addChild(newThesaurus);
            newThesaurus.setToCreate(true);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding thesaurus " + newThesaurus.getName() + " to parent " + parentNode));
            }
            NavigationTreeNode newNode = helper.getBuilder().addThesaurus(context, parentNode, newThesaurus);
            helper.expendNode(context, parentNode);
            return true;
        }
        return false;
    }

    public boolean editThesaurusSelected(JAXXContext context, ThesaurusTreeHelper helper) {
        NavigationTreeNode selectedNode = this.getSelectedNode(context, helper);
        VradiThesaurusDTO selected = (VradiThesaurusDTO)selectedNode.getBean(context);
        ThesaurusEditUI edit = new ThesaurusEditUI(context);
        this.attachListener(edit, selected);
        edit.setBean(selected);
        edit.setHelper(helper);
        edit.setTitleThesaurus(I18n._((String)"vradi.adminThesaurus.editTitle", (Object[])new Object[]{selected.getName()}));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Editing thesaurus " + (selected == null ? " null " : selected.getName())));
        }
        edit.setVisible(true);
        if (edit.isSave().booleanValue()) {
            selected.setToSave(true);
            selectedNode = this.getSelectedNode((JAXXContext)edit, helper);
            helper.repaintNode(context, selectedNode);
            helper.expendNode(context, selectedNode);
            return true;
        }
        return false;
    }

    public boolean deleteThesaurusSelected(JAXXContext context, ThesaurusTreeHelper helper) {
        return this.deleteThesaurusSelected(context, helper, true);
    }

    public boolean deleteThesaurusSelected(JAXXContext context, ThesaurusTreeHelper helper, boolean ask) {
        NavigationTreeNode selectedNode = this.getSelectedNode(context, helper);
        return this.deleteThesaurus(context, helper, selectedNode, ask);
    }

    public boolean deleteThesaurus(JAXXContext context, ThesaurusTreeHelper helper, NavigationTreeNode selectedNode, boolean ask) {
        VradiThesaurusDTO selected = (VradiThesaurusDTO)selectedNode.getBean(context);
        int result = 2;
        result = ask ? JOptionPane.showConfirmDialog(this.getUI(context), I18n._((String)"vradi.thesaurus.askdeleteThesaurus") + selected.getRecursifName()) : 0;
        if (result == 0) {
            selected.setToDelete(true);
            helper.getBuilder().removeNodeFromParent(context, selectedNode);
            return true;
        }
        return false;
    }

    protected void deleteTreeNode(VradiThesaurusDTO toDelete) {
        try {
            ServiceHelper.getVradiStorageService().deleteEntity((BusinessEntity)toDelete.getBean());
        }
        catch (TechnicalException e) {
            log.error((Object)("Cant delete thesaurus : " + toDelete.getName() + " id : " + toDelete.getWikittyId()), (Throwable)e);
            ErrorDialogUI.showError((Exception)((Object)e));
        }
    }

    protected void attachListener(final ThesaurusEditUI ui, VradiThesaurusDTO thesaurus) {
        thesaurus.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ui.setModified(true);
            }
        });
    }

    public void cancelThesaurus(JAXXContext context, ThesaurusTreeHelper helper) {
        NavigationTreeNode node = helper.getRootNode();
        this.cancelThesaurus(context, helper, node);
    }

    public void cancelThesaurus(JAXXContext context, ThesaurusTreeHelper helper, NavigationTreeNode node) {
        VradiThesaurusDTO bean = (VradiThesaurusDTO)node.getBean();
        if (bean.isToCreate()) {
            bean.setToCreate(false);
            helper.getBuilder().removeNodeFromParent(context, node);
        } else if (bean.isToDelete()) {
            bean.setToDelete(false);
            helper.getBuilder().addThesaurus(context, node.getParent(), bean);
        } else if (bean.isToSave()) {
            bean.setToSave(false);
            bean.revertFromWikitty();
        } else {
            Enumeration children = node.children();
            while (children.hasMoreElements()) {
                NavigationTreeNode child = (NavigationTreeNode)children.nextElement();
                this.cancelThesaurus(context, helper, child);
            }
        }
        ((AdminThesaurusUI)context).setModified(false);
    }

    public void saveThesaurus(JAXXContext context, ThesaurusTreeHelper helper) {
        this.saveThesaurus(helper.getRootThesaurus());
        ((AdminThesaurusUI)context).setModified(false);
        UIHelper.getHandler(context, SearchHandler.class).initCriteria(context);
        this.refreshAllThesaurus(context);
    }

    protected void saveThesaurus(VradiThesaurusDTO toSave) {
        TreeNode bean = toSave.getBean();
        VradiStorageService service = ServiceHelper.getVradiStorageService();
        if (toSave.isToSave() || toSave.isToCreate()) {
            try {
                VradiThesaurusDTO parentThesaurus = toSave.getParentThesaurus();
                if (parentThesaurus != null) {
                    TreeNode parent = parentThesaurus.getBean();
                    bean.setParent(parent.getWikittyId());
                }
                bean = (TreeNode)service.updateEntity((BusinessEntity)bean);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Saving thesaurus : " + bean.getName()));
                }
            }
            catch (TechnicalException ex) {
                log.error((Object)("Cant save thesaurus : " + bean.getName() + " id : " + bean.getWikittyId() + " caused by : "), (Throwable)ex);
                ErrorDialogUI.showError((Exception)((Object)ex));
            }
            toSave.setToSave(false);
            toSave.setToCreate(false);
            toSave.setToDelete(false);
        } else if (toSave.isToDelete()) {
            this.deleteTreeNode(toSave);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Saving thesaurus : " + bean.getName()));
            }
        }
        Collection children = toSave.getChildren();
        if (children != null) {
            for (VradiThesaurusDTO child : children) {
                if (child == null) continue;
                this.saveThesaurus(child);
            }
        }
    }

    public void moveThesaurus(JAXXContext context, ThesaurusTreeHelper helperFrom, VradiThesaurusDTO beanToMove) {
        NavigationTreeNode nodeToMove = this.getSelectedNode(context, helperFrom);
        VradiThesaurusDTO rootThesaurus = helperFrom.getRootThesaurus().clone();
        boolean isDeleted = rootThesaurus.removeThesaurusRecursivly(beanToMove);
        if (log.isDebugEnabled()) {
            if (isDeleted) {
                log.debug((Object)("Thesaurus " + beanToMove.getName() + " is deleted"));
            } else {
                log.debug((Object)("Thesaurus " + beanToMove.getName() + " is not deleted (not found)"));
            }
        }
        ThesaurusTreeHelper selectHelper = new ThesaurusTreeHelper(context, rootThesaurus, rootThesaurus.getWikittyId());
        ThesaurusPathChooserUI selectUI = new ThesaurusPathChooserUI(context, selectHelper);
        selectUI.setVisible(true);
        if (selectUI.isSaved().booleanValue()) {
            NavigationTreeNode nodeParentSelected = this.getSelectedNode((JAXXContext)selectUI, selectHelper);
            NavigationTreeNode nodeParentSelectedFrom = helperFrom.findNode(context, nodeParentSelected.getFullPath());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Selected node : " + nodeParentSelected.getFullPath() + " finded node : " + nodeParentSelectedFrom.getFullPath()));
            }
            this.deleteThesaurus(context, helperFrom, nodeToMove, false);
            VradiThesaurusDTO oldParent = beanToMove.getParentThesaurus();
            oldParent.removeChild(beanToMove);
            VradiThesaurusDTO thesaurusParentFrom = (VradiThesaurusDTO)nodeParentSelectedFrom.getBean(context);
            thesaurusParentFrom.addChild(beanToMove);
            beanToMove.setParentThesaurus(thesaurusParentFrom);
            beanToMove.setToSave(true);
            NavigationTreeNode newNode = helperFrom.getBuilder().addThesaurusRecursivly(nodeParentSelectedFrom, beanToMove);
            helperFrom.selectNode(context, nodeParentSelectedFrom);
        }
        ((ThesaurusEditUI)context).getPathField().setText(beanToMove.getParentPath());
    }

    public void openRequest(JAXXContext rootContext, String request) {
        JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext);
        OfferListTableModel offerListTableModel = this.getResultTableModel(this.query(request));
        context.add((Object)offerListTableModel);
        AdminRequestUI requestUI = new AdminRequestUI((JAXXContext)context);
        requestUI.show(request);
        RequestSelectUI ui = (RequestSelectUI)rootContext;
        ui.setBean(requestUI.getSearchUI().getRequest());
    }

    public List<Client> getAllClients(JAXXContext context) {
        List values = (List)VradiNavigationTreeHelper.CLIENTS.getContextValue(context);
        return new ArrayList<Client>(values);
    }

    public List<User> getAllUsers(JAXXContext context) {
        List values = (List)VradiNavigationTreeHelper.USERS.getContextValue(context);
        return new ArrayList<User>(values);
    }

    public void createClient(JAXXContext context, VradiNavigationTreeHelper helper) {
        NavigationTreeNode addClient = helper.addClientToSelected(context, null);
        helper.selectNode(context, addClient);
    }

    public void createUser(JAXXContext context, VradiNavigationTreeHelper helper) {
        NavigationTreeNode addUser = helper.addUserToSelected(context, null);
        helper.selectNode(context, addUser);
    }

    public List<Group> getAllGroups(JAXXContext context) {
        List values = (List)VradiNavigationTreeHelper.GROUPS.getContextValue(context);
        return new ArrayList<Group>(values);
    }

    public void createGroup(JAXXContext context, VradiNavigationTreeHelper helper) {
        NavigationTreeNode addGroup = helper.addGroupToSelected(context, null);
        helper.selectNode(context, addGroup);
    }

    public List<WikittyExtension> getAllForms(JAXXContext context) {
        List values = (List)VradiNavigationTreeHelper.FORMS.getContextValue(context);
        return new ArrayList<WikittyExtension>(values);
    }

    public void createFormType(JAXXContext context, VradiNavigationTreeHelper helper) {
        String name = JOptionPane.showInputDialog(this.getUI(context), (Object)I18n._((String)"vradi.adminForm.askName"));
        if (name != null && !name.isEmpty()) {
            WikittyExtension formType = new WikittyExtension(name, "0.0", "Form", new LinkedHashMap());
            NavigationTreeNode addFormType = helper.addFormTypeToSelected(context, formType);
            helper.selectNode(context, addFormType);
        }
    }

    public void createForms(JAXXContext context) {
        AdminXmlStreamUI ui = this.getXmlStreamUI(context);
        VradiXmlStreamDTO xmlStream = ui.getBean();
        VradiUser vradiUser = ui.getContextValue(VradiUser.class);
        if (xmlStream != null) {
            try {
                String lastItem = this.getVradiStorageService().getFormsFromXmlStream((XmlStream)xmlStream, VradiHelper.getLastItemOfXmlStream(xmlStream.getName()), vradiUser);
                VradiHelper.setLastItemOfXmlStream(xmlStream.getName(), lastItem);
            }
            catch (TechnicalException ex) {
                log.error((Object)("Cant create form : " + (Object)((Object)ex)));
                ErrorDialogUI.showError((Exception)((Object)ex));
            }
        }
    }

    public void saveFormType(JAXXContext context, VradiNavigationTreeHelper helper, List<FieldSelectModel> fields, WikittyExtension formType) {
        WikittyExtension newFormType = new WikittyExtension(formType.getName(), formType.getVersion(), formType.getRequires(), null);
        FieldSelectModel[] models = new FieldSelectModel[fields.size()];
        Iterator<FieldSelectModel> i$ = fields.iterator();
        while (i$.hasNext()) {
            FieldSelectModel field;
            models[field.getPosition().intValue()] = field = i$.next();
        }
        for (int i = 0; i < models.length; ++i) {
            FieldSelectModel model = models[i];
            String name = model.getNameValue();
            if (name == null || model.getType() == null) continue;
            FieldType fieldType = model.getType().getFieldType();
            if (model.getDescValue() != null && !model.getDescValue().isEmpty()) {
                fieldType.addTagValue("description", model.getDescValue());
            }
            newFormType.addField(name, fieldType);
        }
        Date now = new Date();
        newFormType.addTagValue("lastModifiedDate", String.format("%1$td/%1$tm/%1$ty", now));
        newFormType.addTagValue("lastModifiedTime", String.format("%1$tk:%1$tM:%1$tS", now));
        newFormType.addTagValue("lastModifiedBy", ((VradiUser)context.getContextValue(VradiUser.class)).getName());
        try {
            this.getVradiStorageService().updateFormType(newFormType);
            NavigationTreeNode selectedNode = helper.getSelectedNode(context);
            List forms = (List)FormNavigationTreeHelper.FORMS.getContextValue(context);
            forms.remove(selectedNode.getBean());
            forms.add(newFormType);
            selectedNode.setBean((Object)newFormType);
            selectedNode.reload(context);
            UIHelper.getHandler(context, SearchHandler.class).getCriterias(context).getFormTypeSelection().setModel(new DefaultComboBoxModel<Object>(VradiHelper.getFormTypes()));
            ((VradiMainUI)VradiContext.MAIN_UI_ENTRY_DEF.getContextValue(context)).updateFormMenu();
        }
        catch (TechnicalException ex) {
            log.error((Object)("Cant adding formType : " + formType.getName() + " id : " + formType.getId() + " caused by : " + (Object)((Object)ex)));
            ErrorDialogUI.showError((Exception)((Object)ex));
        }
    }

    public VradiFormPageDTO query(String query) {
        try {
            VradiFormPageDTO result = new VradiFormPageDTO();
            this.getVradiStorageService().findForms(query, result);
            return result;
        }
        catch (TechnicalException eee) {
            log.error((Object)("Cant execute query : " + (Object)((Object)eee)));
            ErrorDialogUI.showError((Exception)((Object)eee));
            return null;
        }
    }

    public WikittyExtension getExtension(String extensionName) {
        try {
            return this.getVradiStorageService().getFormType(extensionName);
        }
        catch (TechnicalException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)e);
                ErrorDialogUI.showError((Exception)((Object)e));
            }
            return null;
        }
    }

    public void createXmlStream(JAXXContext context, VradiNavigationTreeHelper helper) {
        NavigationTreeNode addXmlStream = helper.addXmlStreamToSelected(context, null);
        helper.selectNode(context, addXmlStream);
    }

    public XmlStream saveXmlStream(JAXXContext context, VradiNavigationTreeHelper helper, XmlStream xmlStream, List<XmlFieldBinding> bindings) {
        XmlStream result = null;
        try {
            bindings = this.getVradiStorageService().updateXmlFieldBindings(bindings);
            xmlStream.clearXmlFieldBinding();
            for (XmlFieldBinding binding : bindings) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(binding.getFormField() + " : " + (binding.getXmlField() != null ? Integer.valueOf(binding.getXmlField().size()) : "null")));
                }
                xmlStream.addXmlFieldBinding(binding.getWikittyId());
            }
            result = (XmlStream)this.getVradiStorageService().updateEntity((BusinessEntity)xmlStream);
            if (log.isDebugEnabled() && result != null) {
                for (String s : result.getXmlFieldBinding()) {
                    log.debug((Object)this.getVradiStorageService().getXmlFieldBinding(s).getXmlField());
                }
            }
            this.repaintSelectedNode(context, helper);
        }
        catch (TechnicalException ex) {
            log.error((Object)("Cant adding client : " + xmlStream.getUrl() + " id : " + xmlStream.getWikittyId() + " caused by : " + (Object)((Object)ex)));
            ErrorDialogUI.showError((Exception)((Object)ex));
        }
        return result;
    }

    public List<XmlFieldBinding> getXmlStreamFields(XmlStream xmlStream) {
        ArrayList result;
        try {
            result = this.getVradiStorageService().getXmlFieldBindings(xmlStream);
            if (log.isDebugEnabled()) {
                for (XmlFieldBinding xmlFieldBinding : result) {
                    log.debug((Object)(xmlFieldBinding.getFormField() + " : " + xmlFieldBinding.getXmlField()));
                }
            }
        }
        catch (TechnicalException eee) {
            log.error((Object)"Cant get xml stream : ", (Throwable)eee);
            ErrorDialogUI.showError((Exception)((Object)eee));
            result = new ArrayList();
        }
        return result;
    }

    public WikittyExtension getFormType(XmlStream xmlStream) {
        List<XmlFieldBinding> bindings = this.getXmlStreamFields(xmlStream);
        WikittyExtension result = null;
        for (XmlFieldBinding binding : bindings) {
            WikittyExtension formType;
            String formField = binding.getFormField();
            if (formField == null || (formType = this.getExtension(formField.substring(0, formField.lastIndexOf(46)))) == null || formType.getName().equals("Form")) continue;
            result = formType;
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFieldsModel(JAXXContext context) {
        AdminXmlStreamUI ui = this.getXmlStreamUI(context);
        XmlStreamFieldTableModel fieldsModel = this.getXmlStreamUI(context).getFieldsModel();
        fieldsModel.setValueIsAdjusting(true);
        try {
            fieldsModel.clear();
            VradiXmlStreamDTO bean = ui.getBean();
            List<XmlFieldBinding> bindings = this.getXmlStreamFields((XmlStream)bean);
            WikittyExtension formType = bean.getFormType();
            if (formType == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No form type, stop update");
                }
                return;
            }
            String url = bean.getUrl();
            if (url == null || url.trim().isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No url, stop update");
                }
                return;
            }
            ArrayList<String> xmlFieldNames = new ArrayList();
            Map<String, Element> xmlStreamFields = XML_STREAM_FIELDS_CACHE;
            if (xmlStreamFields.get(url) == null) {
                try {
                    Element firstElement = this.getXmlStreamService().getFirstElement(url);
                    xmlFieldNames = this.getXmlStreamService().getRSSFields(firstElement);
                    xmlStreamFields.put(url, firstElement);
                }
                catch (Exception eee) {
                    log.error((Object)("Can't bind xml stream : " + eee));
                    JOptionPane.showMessageDialog(ui, I18n._((String)"vradi.adminXmlStream.badURL.message"), I18n._((String)"vradi.adminXmlStream.badURL.title"), 0);
                    fieldsModel.fireTableDataChanged();
                    fieldsModel.setValueIsAdjusting(false);
                    return;
                }
            } else {
                xmlFieldNames = this.getXmlStreamService().getRSSFields(xmlStreamFields.get(url));
            }
            ui.getContextValue(JListCellEditor.class).updateUniverse(xmlFieldNames);
            ui.getContextValue(JListCellRenderer.class).updateUniverse(xmlFieldNames);
            if (xmlFieldNames.size() > 0) {
                ui.getFieldsTable().setRowHeight(19 * xmlFieldNames.size());
            }
            LinkedHashMap<String, Object> fieldNames = new LinkedHashMap<String, Object>();
            fieldNames.put("Form.id", new XmlFieldBindingImpl());
            fieldNames.put("Form.name", new XmlFieldBindingImpl());
            fieldNames.put("Form.datePub", new XmlFieldBindingImpl());
            fieldNames.put("Form.datePeremption", new XmlFieldBindingImpl());
            for (String fieldName : formType.getFieldNames()) {
                fieldNames.put(formType.getName() + "." + fieldName, new XmlFieldBindingImpl());
            }
            for (XmlFieldBinding binding : bindings) {
                String formField = binding.getFormField();
                if (log.isDebugEnabled()) {
                    log.debug((Object)formField);
                }
                if (fieldNames.get(formField) == null) continue;
                fieldNames.put(formField, binding);
            }
            for (String fieldName : fieldNames.keySet()) {
                XmlFieldBinding binding = (XmlFieldBinding)fieldNames.get(fieldName);
                if (binding == null) continue;
                binding.setFormField(fieldName);
                fieldsModel.addEntry(binding);
            }
        }
        catch (TechnicalException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)e);
                ErrorDialogUI.showError((Exception)((Object)e));
            }
        }
        finally {
            fieldsModel.fireTableDataChanged();
            fieldsModel.setValueIsAdjusting(false);
        }
    }

    private AdminXmlStreamUI getXmlStreamUI(JAXXContext context) {
        if (context instanceof AdminXmlStreamUI) {
            return (AdminXmlStreamUI)context;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFirstElementPreview(JAXXContext context, String url) {
        AdminXmlStreamUI ui = this.getXmlStreamUI(context);
        StringBuffer result = new StringBuffer();
        if (url == null || url.trim().isEmpty()) {
            if (log.isErrorEnabled()) {
                log.debug((Object)"No url, stop update");
            }
            return "";
        }
        Element firstElement = null;
        Map<String, Element> xmlStreamFields = XML_STREAM_FIELDS_CACHE;
        if (xmlStreamFields.get(url) == null) {
            try {
                ui.setCursor(Cursor.getPredefinedCursor(3));
                firstElement = this.getXmlStreamService().getFirstElement(url);
                xmlStreamFields.put(url, firstElement);
            }
            catch (Exception eee) {
                String string = "";
                return string;
            }
            finally {
                ui.setCursor(null);
            }
        } else {
            firstElement = xmlStreamFields.get(url);
        }
        if (firstElement == null) {
            return "";
        }
        try {
            Map elementValues = this.getXmlStreamService().getFirstElementValues(firstElement);
            result.append("<html>");
            for (Map.Entry entry : elementValues.entrySet()) {
                result.append("<strong>").append(entry.getKey()).append("</strong>").append(" : ");
                String value = (String)entry.getValue();
                if (value.length() > 500) {
                    value = value.substring(0, value.lastIndexOf(32, 500)) + "...";
                }
                while (value.length() > 100) {
                    result.append(value.substring(0, value.lastIndexOf(32, 100))).append("<br/>&nbsp;");
                    value = value.substring(value.lastIndexOf(32, 100));
                }
                result.append(value).append("<br/>");
            }
            result.append("</html>");
            return result.toString();
        }
        catch (TechnicalException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)e);
            }
            return "";
        }
    }

    public void createModel(JAXXContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"createModel");
        }
        try {
            List allForms = this.getVradiStorageService().getAllFormTypes();
            Collections.sort(allForms, FORM_COMPARATOR);
            VradiNavigationTreeHelper.FORMS.setContextValue(context, (Object)allForms);
            List allGroups = this.getVradiStorageService().getAllGroups();
            Collections.sort(allGroups, GROUP_COMPARATOR);
            VradiNavigationTreeHelper.GROUPS.setContextValue(context, (Object)allGroups);
            List clients = this.getVradiStorageService().getAllClients();
            Collections.sort(clients, CLIENT_COMPARATOR);
            VradiNavigationTreeHelper.CLIENTS.setContextValue(context, (Object)clients);
            List xmlStreams = this.getVradiStorageService().getAllXmlStreams();
            Collections.sort(xmlStreams, XML_STREAM_COMPARATOR);
            VradiNavigationTreeHelper.XMLSTREAMS.setContextValue(context, (Object)xmlStreams);
            ArrayList<User> users = new ArrayList<User>();
            for (Client c : clients) {
                Set usersId = c.getUser();
                if (usersId == null) continue;
                for (String userId : usersId) {
                    User user = this.getVradiStorageService().getUser(userId);
                    users.add(user);
                }
            }
            Collections.sort(users, USER_COMPARATOR);
            VradiNavigationTreeHelper.USERS.setContextValue(context, users);
        }
        catch (TechnicalException ex) {
            log.error((Object)ex);
            ErrorDialogUI.showError((Exception)((Object)ex));
        }
    }
}

