package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.JListCellRenderer;
import com.jurismarches.vradi.ui.ProgressBarUI;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.editors.JListCellEditor;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.text.DateFormat;
import java.util.*;
import java.util.Date;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.Util;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.HidorButton;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import jaxx.runtime.validator.swing.SwingValidator;
import org.sharengo.wikitty.WikittyExtension;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.SwingUtil.getStringValue;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminXmlStreamUI extends com.jurismarches.vradi.ui.admin.AdminContentUI<XmlStream> implements jaxx.runtime.JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADMIN_XML_STREAM_ENABLED = "adminXmlStream.enabled";
    public static final String BINDING_FORM_TYPE_COMBO_SELECTED_ITEM = "formTypeCombo.selectedItem";
    public static final String BINDING_TITLE_TEXT = "title.text";
    public static final String BINDING_VALIDATE_URL_ENABLED = "validateUrl.enabled";
    public static final String BINDING_XML_STREAM_NAME_TEXT = "xmlStreamName.text";
    public static final String BINDING_XML_STREAM_PREVIEW_TOOL_TIP_TEXT = "xmlStreamPreview.toolTipText";
    public static final String BINDING_XML_STREAM_URL_TEXT = "xmlStreamUrl.text";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1aSW/cyBmlZO2LtVnSWPbIkuwkMkam7Bl4MoEHM5bkbi1p24rUMowIgVLdrFaXzWbRxaLUGiFB7rnkJyT3XALkllOQQ8455BLkLwRBDrkG+arYXIoi2VS3DZhuVn3fq/cea2PRv/+X1u8wbfkdajZ15lqcNLC+t/H27evKO1zlL7BTZcTmlGnen55erfdYGzWCcodr949LIn29lb6+RRs2tbAVyX5W0kYcfmFip44x59qnakbVcdYPg+pnTdtlPmpAKgn1t//5d+9vjF/9rlfTmjawWwApS+2yQiV9Ja2XGFybhpbO0LqJrFOgwYh1CnzHRdmWiRznFWrgD9ovtcGSNmAjBmBcW8kvWWLI/KbNtZvIaBDrbcOEhjBqcO2rKm3o71xGnAZi1Tp29DOGDKK7RJehepVaHJD1DSXxaNe2JeoA1/oqGFlce5qC5GB2Rqpwa3CqvxFFAcqL8usQZrRGsGk4L6mBTa49z8srACuK9DKqmFhChMDDZ8gkBgJTuPaZ8niCCt05B9v1Q3F94xeGCIOcUrOCIP8TJd/Lkm2Gwf2ccBPDYxVPsNmK2SuhCjZFxCwQkhElXON+ztCDvX1kYfNxPE2WyrQAf6IKajmOPMMZJWXT5ZxaIvhu6K2XU6SsIYuW1erhB62sxwmV4w92iEFZK4BriwkWRCLU5L4KNS7E78XQoGm1DwpSomZeXB7aEUukZ5LSgrh8FlJq+slicHBtTjGgjJtcdgY1yQd8kgA4FgAeMWn3E7V+MqjfZ/iM4PMEDB//8yTCNRBZvrAxjNQK5dqsQlgWbtKmmjPa6p24RWn5SnOyc0imi8nefRFQ+TbyOPcOq4yapsiGxzmvUAmr1KzW4JRdPd5HZaGI2wr9hEmHwzAkkGbINq52mZZgYM20O0oAzMd6OB+HE2bPsdbPXCiGcXh8dQo/gCpv8v4kNnkLQFn7v7mZv//pn38s+jP2C2h7NjE0suDATGozamPGiWh6wpuuXU7M9ZfIfnasDTvYhNVKrkZ3E4gdtqqBHLQ3JdJ1ka7vIKcOEP2D//jzX+Z+/rcbWm9RGzEpMopIxO/CTFFn4AI1jab97XPJaOx8CK6T8PcGDNwaRHPvofTXkOnAvwPURh/cSMF4hTIDs31EYMY0/PIm+HQ3waeAbGX4r/+dOfzDc9+rHuB+OzU89Kv/p9oAsUxiYbm+tZauxPVs1Hawa9BwiUpatDRYtob2yjADbyJ/Tv6JvB4lWTIpFgZiudR1SuiCwpyk9XEm/JiGJbJM3Wq90LSRZXiutepGDXJGwKRD8h3c9XzZdEUDP5Oyxa8TwWJk79A2CRejoz2PmTpl5DvggswNk5xaDblw37+MDh253mxRy+GwgDr6VuFVuXDwCyBVo3KVv7Tw+VIRfq+uHGJGaitr8k7ffF16sbb0+ZcPIXYubEdMfPvUIZzArTZx6U0CPmyipAEvxvaXrc5ULWepKhWK5Y+ladzXJEHbKIots9dWtZKl6mB3e+ejybrpy/JQ2+gakboOyGk9W1hvuBeZ8TZP8k4/xyZsrqB01sA15Jp8y6QOfg0THPLozBj0xKK8DoJPqHVSFdVXOYHBDZhSigzGs91mPPQAlZO6ZD95uQJ7OJGpg83uSoJacFVUtQO9IUYv+Ahd3ZMnkvQaEYKHGhZuUItUYTAXw8Zn1cZlcDKDIVFfJGZbaf0BiwWPBUzd4KLYn9bIqet7GiW0Bc/Qi9oVk5U24MXCLCT2mWVilyXeYjoePEk7VHU/QZUan6xx1te4FY3NL3guZrtu0iqKux8XO8wZshwT9jVxvalwvs67STq9oGSBk77AErxbueg0z8McxJZYGWCdfHK5jKpVbPOSbGL1FHPPqNWHOvxulT5cW1qpsZPiwYoY4qozrUfnUdRrLGbFIHnylfVIFKtGLCRnqw/9XroZEJvsx3Tcj+JBO0cGOnMEWyfbm20dcd+rfeUo0SARlcMg931+g9z3OQ06+nEOg1oS5xVWNdc04WUcY6HjjDjE2zlfLhPnyDJwlcJow8aqsChqwX7MgpEojurCnZT2VBuWkmwIg9v4UAwC8/twW+FlwZsPSnBi6jLbiFcxIyZNjM7wo3Q7Pk1tVjXk+4n9IgaebMst35ZXEfT88+WUwhA3CVclv41J7vNCVJmzV0BUeQtJ8kRYsqQxX1IBQjpcccEMVcjLjBUXgrNWXKjOz2I6wsIzxFGJbIRE5mNEvPhkKqMiYsMDzM9mMspGHHGkcsm/DRmWTARYfh5TER5Vk8i9bGxF7sSUiYDKlgTtzJhTRl1b5bPdGZ+bAZ9tgZmfzkys74pzmdQd43UYjQeMrteNb0UINcNjvdjU0Amj6YBRcNzWGS1exw5ymRsbX+VuaZV93M56E4b2TJVSoeNhVhBg+XnMx3l8zME2FRDavLjucJu9QuzqDN1hD5+I0LpeH4+6RRo2ZbzQFFeV1m4nD0/u8ncjmPlZLaawggXzKrlCZ56NSM8+FjHvJtW1axPzfMtP7F4aMYYJ7OaaKrODLtbfAw+wsz2J12aUCk7vWqI0Y0+yIz4mdbjJS+ShbvK8kKxNnojI3uTJiHQZY76MbqQ4hMeWSScuxQvJkiIickgRYW2kHEJIfinTCgtUkefCsd2ZoqW/FZN4RBGFUdXcSVIj4zK2DELOhojJ8Y41XKNV11FP/BXiQ/K4rowqce7qa9kHl/CdoF9NiK8+9Ayzgv+qn/3xIBS8GAoWn/o8wT6FlEHlV7eT28u1AbN1hn9HHrBu0qZ3qL/a+iK7tvRYvDj6bGZCNq2AZAr+B90c55bh6cfNrw3E0VIFpiVinX5zBbdHXEdyQMo+CbW9s8kYt/NgkKr81pqGsdQWQyQvwMj42vtYs4Q4Z6TicpyiLCeiuDxIRrifC+Fehqrv5UK41RWCOm4y5OSBGqwTAwNUBqMf5IFx6vS8e5gBjtgpzup6eVDGPZQ33klOl2Cj8BJAGm5DfHjLgFrruvPp+RFSODzumsMXXXN42vUQ+mEuhKddI2T58KM834sa4n/xZNB4lgNkiGHYQzLMusQZ877wY2OX40ZXWO3mp2+6Nrc9QrCsZvB4ngMl6bNpBrHNrqW1R5AbJIs/clrTSQrQdi4qNMOf9gjgD6Pn3v+PgB3XBmywzrHRNalfZyDsAcL/ATsnYMBTKQAA";
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminXmlStreamUI adminXmlStream = this;
    protected jaxx.runtime.swing.Table adminXmlStreamForm;
    protected com.jurismarches.vradi.services.dto.VradiXmlStreamDTO bean;
    protected javax.swing.JButton createForms;
    protected javax.swing.JButton createXmlStream;
    protected com.jurismarches.vradi.ui.admin.content.XmlStreamFieldTableModel fieldsModel;
    protected javax.swing.JTable fieldsTable;
    protected javax.swing.JComboBox formTypeCombo;
    protected jaxx.runtime.swing.HBox lastModified;
    protected javax.swing.JLabel title;
    protected javax.swing.JButton validateUrl;
    protected jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.services.dto.VradiXmlStreamDTO > validator;
    protected java.util.List<String> validatorIds = new ArrayList<String>();
    protected javax.swing.JTextField xmlStreamName;
    protected javax.swing.JLabel xmlStreamPreview;
    protected javax.swing.JTextField xmlStreamUrl;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JPanel $JPanel0;
    private javax.swing.JButton $JButton0;
    private jaxx.runtime.swing.HidorButton $HidorButton0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JPanel $JPanel1;
    private javax.swing.JLabel $JLabel3;
    private javax.swing.JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    void $afterCompleteSetup() {
        addPCSLogger();
        addBeanPCSLogger(bean);
        addBeanModifiedPCS(bean);
        SwingUtil.setI18nTableHeaderRenderer(fieldsTable,
                n_("vradi.table.field.name"),
                n_("vradi.table.field.name.tip"),
                n_("vradi.table.field.values"),
                n_("vradi.table.field.values.tip"));
    
        JListCellRenderer render= new JListCellRenderer(fieldsTable.getDefaultRenderer(String.class));
        setContextValue(render);
        SwingUtil.setTableColumnRenderer(fieldsTable, 0, fieldsTable.getDefaultRenderer(String.class));
        SwingUtil.setTableColumnRenderer(fieldsTable, 1, render);
    
        JListCellEditor editor = new JListCellEditor();
        setContextValue(editor);
        SwingUtil.setTableColumnEditor(fieldsTable, 1, editor);
        errorTable.registerValidator(validator);
    }
    
    protected void validateFormTypeChoice() {
        stopEditing();
        boolean m = isModified();
        getHandler().updateFieldsModel(this);    
        setModified(m);
        validate();
    }
    
    protected void superOpenUI(NavigationTreeNode node) throws Exception {
        super.openUI(node);
    }
    
    @Override
    public void openUI(final NavigationTreeNode node) throws Exception {
        final ProgressBarUI pb = new ProgressBarUI(this);
        setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
        SwingWorker task = new SwingWorker<Void, Void>(){
            /*
             * Main task. Executed in background thread.
             */
            @Override
            public Void doInBackground() throws Exception {
                superOpenUI(node);
                java.util.List<WikittyExtension> forms = getHandler().getAllForms(adminXmlStream);
                SwingUtil.fillComboBox(formTypeCombo, forms, null);
                WikittyExtension formType = getHandler().getFormType(bean);
                if (log.isDebugEnabled()) {
                    log.debug("form type = " + formType);
                }
                bean.setFormType(formType);
                getHandler().updateFieldsModel(adminXmlStream);
                lastModified.removeAll();
                if(bean != null && bean.getLastModified() != null && bean.getLastModifier() != null) {
                    String labelText = String.format(_("vradi.entity.lastModified.date.user"), bean.getLastModified(), bean.getLastModifier());
                    lastModified.add(new JLabel(labelText));
                }
                setModified(false);
                return null;
            }
    
            /*
             * Executed in event dispatching thread
             */
            @Override
            public void done() {
                adminXmlStream.validate();
                setCursor(null); //turn off the wait cursor
                pb.dispose();
            }
        };
        task.execute();
        pb.setVisible(true);
    }
    
    @Override
    public void save(){
        this.bean.setLastModified(new java.util.Date());
        this.bean.setLastModifier(getContextValue(VradiUser.class).getName());
        XmlStream bean = (XmlStream) getHelper().getSelectedBean(this);
        if(!bean.getExtensions().contains(ModificationTag.MODIFICATION_TAG)) {
            bean.addExtension(ModificationTag.MODIFICATION_TAG);
        }
        this.bean.toWikitty(bean);
        XmlStream savedStream = getHandler().saveXmlStream(this, getHelper(), bean, fieldsModel.getData());
        if(savedStream != null) {
            this.bean.fromWikitty(savedStream);
        }
        //bean = getHandler().saveXmlStream(this, getHelper(), bean, fieldsModel.getData());
        //updateBeanFromEntity(bean);
    }
    
    protected void updateBeanFromEntity(XmlStream bean) {
        this.bean.fromWikitty(bean);
    }
    
    protected void stopEditing() {
        //FIXME-TC20091116 il faut pouvoir annuler l'édition si on sort du tableau
        if (fieldsTable.getCellEditor()!=null) {
            fieldsTable.getCellEditor().stopCellEditing();
        }
    }
    
    protected void createForms() {
        createForms.setEnabled(false);
        setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
        final ProgressBarUI pb = new ProgressBarUI(this);
        SwingWorker task = new SwingWorker<Void, Void>(){
            /*
             * Main task. Executed in background thread.
             */
            @Override
            public Void doInBackground() {
                getHandler().createForms(adminXmlStream);
                return null;
            }
    
            /*
             * Executed in event dispatching thread
             */
            @Override
            public void done() {
                createForms.setEnabled(true);
                setCursor(null); //turn off the wait cursor
                pb.dispose();
            }
        };
        task.execute();
        pb.setVisible(true);
    }
    
    protected String updateTitle(String name) {         
       return _("vradi.adminXmlStream.title", getStringValue(name));
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminXmlStreamUI() {
        super();
        $initialize();
    }

    public AdminXmlStreamUI(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidation implementation --------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.services.dto.VradiXmlStreamDTO > getValidator() {
        return validator;
    }

    @Override
    public jaxx.runtime.validator.swing.SwingValidator<?> getValidator(String validatorId) {
        return (jaxx.runtime.validator.swing.SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public java.util.List<String> getValidatorIds() {
        return validatorIds;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getHandler().delete(this, getHelper(), bean);
    }

    public void doActionPerformed__on__createForms(java.awt.event.ActionEvent event) {
        createForms();
    }

    public void doActionPerformed__on__createXmlStream(java.awt.event.ActionEvent event) {
        getHandler().createXmlStream(this, getHelper());
    }

    public void doActionPerformed__on__formTypeCombo(java.awt.event.ActionEvent event) {
        bean.setFormType((WikittyExtension) formTypeCombo.getSelectedItem());
    }

    public void doActionPerformed__on__validateUrl(java.awt.event.ActionEvent event) {
        validateFormTypeChoice();
    }

    public void doKeyReleased__on__xmlStreamName(java.awt.event.KeyEvent event) {
        bean.setName(xmlStreamName.getText());
    }

    public void doKeyReleased__on__xmlStreamUrl(java.awt.event.KeyEvent event) {
        bean.setUrl(xmlStreamUrl.getText());
    }

    public void doTableChanged__on__fieldsModel(javax.swing.event.TableModelEvent event) {
        setModified(true);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.swing.Table getAdminXmlStreamForm() {
        return adminXmlStreamForm;
    }

    public com.jurismarches.vradi.services.dto.VradiXmlStreamDTO getBean() {
        return bean;
    }

    public javax.swing.JButton getCreateForms() {
        return createForms;
    }

    public javax.swing.JButton getCreateXmlStream() {
        return createXmlStream;
    }

    public com.jurismarches.vradi.ui.admin.content.XmlStreamFieldTableModel getFieldsModel() {
        return fieldsModel;
    }

    public javax.swing.JTable getFieldsTable() {
        return fieldsTable;
    }

    public javax.swing.JComboBox getFormTypeCombo() {
        return formTypeCombo;
    }

    public jaxx.runtime.swing.HBox getLastModified() {
        return lastModified;
    }

    public javax.swing.JLabel getTitle() {
        return title;
    }

    public javax.swing.JButton getValidateUrl() {
        return validateUrl;
    }

    public javax.swing.JTextField getXmlStreamName() {
        return xmlStreamName;
    }

    public javax.swing.JLabel getXmlStreamPreview() {
        return xmlStreamPreview;
    }

    public javax.swing.JTextField getXmlStreamUrl() {
        return xmlStreamUrl;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected jaxx.runtime.swing.HidorButton get$HidorButton0() {
        return $HidorButton0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminXmlStreamForm() {
        if (!allComponentsCreated) {
            return;
        }
        adminXmlStreamForm.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminXmlStreamForm.add(SwingUtil.boxComponentWithJxLayer(xmlStreamName), new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminXmlStreamForm.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminXmlStreamForm.add(SwingUtil.boxComponentWithJxLayer(xmlStreamUrl), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminXmlStreamForm.add(xmlStreamPreview, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        adminXmlStreamForm.add($JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminXmlStreamForm.add(SwingUtil.boxComponentWithJxLayer(formTypeCombo), new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminXmlStreamForm.add(validateUrl, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(adminXmlStreamForm, BorderLayout.NORTH);
        body.add($JPanel1, BorderLayout.CENTER);
        body.add(lastModified, BorderLayout.SOUTH);
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add(title, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        toolbar.add($JPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(jaxx.runtime.validator.swing.ui.ImageValidationUI.class);
        validator.setBean(bean);
        validator.setFieldRepresentation("formType", formTypeCombo);
        validator.setFieldRepresentation("name", xmlStreamName);
        validator.setFieldRepresentation("url", xmlStreamUrl);
    }

    protected void createAdminXmlStreamForm() {
        $objectMap.put("adminXmlStreamForm", adminXmlStreamForm = new jaxx.runtime.swing.Table());
        adminXmlStreamForm.setName("adminXmlStreamForm");
    }

    protected void createBean() {
        $objectMap.put("bean", bean = new com.jurismarches.vradi.services.dto.VradiXmlStreamDTO());
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCreateForms() {
        $objectMap.put("createForms", createForms = new javax.swing.JButton());
        createForms.setName("createForms");
        createForms.setText(_("vradi.adminXmlStream.createForms"));
        createForms.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createForms"));
    }

    protected void createCreateXmlStream() {
        $objectMap.put("createXmlStream", createXmlStream = new javax.swing.JButton());
        createXmlStream.setName("createXmlStream");
        createXmlStream.setText(_("vradi.adminXmlStream.createXmlStream"));
        createXmlStream.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createXmlStream"));
    }

    protected void createFieldsModel() {
        $objectMap.put("fieldsModel", fieldsModel = new com.jurismarches.vradi.ui.admin.content.XmlStreamFieldTableModel());
        fieldsModel.addTableModelListener(Util.getEventListener(TableModelListener.class, "tableChanged", this, "doTableChanged__on__fieldsModel"));
    }

    protected void createFieldsTable() {
        $objectMap.put("fieldsTable", fieldsTable = new javax.swing.JTable());
        fieldsTable.setName("fieldsTable");
        if (fieldsTable.getFont() != null) {
            fieldsTable.setFont(fieldsTable.getFont().deriveFont((float) 11));
        }
        fieldsTable.setRowSelectionAllowed(false);
    }

    protected void createFormTypeCombo() {
        $objectMap.put("formTypeCombo", formTypeCombo = new javax.swing.JComboBox());
        formTypeCombo.setName("formTypeCombo");
        formTypeCombo.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__formTypeCombo"));
    }

    protected void createLastModified() {
        $objectMap.put("lastModified", lastModified = new jaxx.runtime.swing.HBox());
        lastModified.setName("lastModified");
        lastModified.setHorizontalAlignment(4);
    }

    protected void createTitle() {
        $objectMap.put("title", title = new javax.swing.JLabel());
        title.setName("title");
    }

    @Override
    protected void createToolbar() {
        $objectMap.put("toolbar", toolbar = new jaxx.runtime.swing.Table());
        toolbar.setName("toolbar");
        ((jaxx.runtime.swing.Table) toolbar).setLayout(new BoxLayout(toolbar, 0));
        ((jaxx.runtime.swing.Table) toolbar).putClientProperty("help", "ui.main.toolbar");
    }

    protected void createValidateUrl() {
        $objectMap.put("validateUrl", validateUrl = new javax.swing.JButton());
        validateUrl.setName("validateUrl");
        validateUrl.setText(_("vradi.adminXmlStream.validateUrl"));
        validateUrl.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__validateUrl"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = new jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.services.dto.VradiXmlStreamDTO >(com.jurismarches.vradi.services.dto.VradiXmlStreamDTO.class, null));
    }

    protected void createXmlStreamName() {
        $objectMap.put("xmlStreamName", xmlStreamName = new javax.swing.JTextField());
        xmlStreamName.setName("xmlStreamName");
        xmlStreamName.setColumns(15);
        xmlStreamName.addKeyListener(Util.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__xmlStreamName"));
    }

    protected void createXmlStreamPreview() {
        $objectMap.put("xmlStreamPreview", xmlStreamPreview = new javax.swing.JLabel());
        xmlStreamPreview.setName("xmlStreamPreview");
    }

    protected void createXmlStreamUrl() {
        $objectMap.put("xmlStreamUrl", xmlStreamUrl = new javax.swing.JTextField());
        xmlStreamUrl.setName("xmlStreamUrl");
        xmlStreamUrl.setColumns(15);
        xmlStreamUrl.addKeyListener(Util.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__xmlStreamUrl"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToValidator();
        addChildrenToToolbar();
        // inline complete setup of $JPanel0
        $JPanel0.add(createXmlStream);
        $JPanel0.add(createForms);
        $JPanel0.add($JButton0);
        $JPanel0.add($HidorButton0);
        addChildrenToBody();
        addChildrenToAdminXmlStreamForm();
        // inline complete setup of $JPanel1
        $JPanel1.add($JLabel3, BorderLayout.NORTH);
        $JPanel1.add($JScrollPane0, BorderLayout.CENTER);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(fieldsTable);
        
        // apply 8 data bindings
        Util.applyDataBinding(this, $bindings.keySet());
        
        // apply 17 property setters
        createXmlStream.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("feed.add"));
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("feed.delete"));
        $HidorButton0.setHideTip(_("vradi.adminXmlStream.hideForm"));
        $HidorButton0.setShowTip(_("vradi.adminXmlStream.showForm"));
        $HidorButton0.setTarget(adminXmlStreamForm);
        $HidorButton0.setTargetVisible(true);
        adminXmlStreamForm.setMinimumSize(SwingUtil.newMinDimension());
        xmlStreamPreview.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("feed.magnify"));
        formTypeCombo.setModel(new DefaultComboBoxModel());
        formTypeCombo.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        fieldsTable.setModel(fieldsModel);
        title.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        title.setFont(new Font("Serif", Font.BOLD, 26));
        title.setHorizontalTextPosition(JLabel.LEFT);
        // late initializer
        // register 1 validator(s)
        validatorIds.add("validator");
        getValidator("validator").installUIs();
        getValidator("validator").reloadBean();
        validatorIds = java.util.Collections.unmodifiableList(validatorIds);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 8 data bindings
        $registerDefaultBindings();
        $objectMap.put("adminXmlStream", this);
        createBean();
        createFieldsModel();
        createValidator();
        createTitle();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        $JPanel0.setName("$JPanel0");
        createCreateXmlStream();
        createCreateForms();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        $JButton0.setName("$JButton0");
        $JButton0.setToolTipText(_("vradi.adminXmlStream.deleteXmlStream"));
        $JButton0.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $HidorButton0
        $objectMap.put("$HidorButton0", $HidorButton0 = new jaxx.runtime.swing.HidorButton());
        $HidorButton0.setName("$HidorButton0");
        createAdminXmlStreamForm();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminXmlStream.name"));
        createXmlStreamName();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.adminXmlStream.url"));
        createXmlStreamUrl();
        createXmlStreamPreview();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new javax.swing.JLabel());
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("vradi.adminXmlStream.formType"));
        createFormTypeCombo();
        createValidateUrl();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new javax.swing.JPanel());
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new BorderLayout());
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new javax.swing.JLabel());
        $JLabel3.setName("$JLabel3");
        $JLabel3.setHorizontalAlignment(2);
        $JLabel3.setText(_("vradi.adminField.title"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        $JScrollPane0.setName("$JScrollPane0");
        createFieldsTable();
        createLastModified();
        // inline creation of adminXmlStream
        setName("adminXmlStream");
        ((javax.swing.JPanel) adminXmlStream.getObjectById("toolbar")).setLayout(new BoxLayout(toolbar, 0));
        
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 8 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADMIN_XML_STREAM_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("wikittyId", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    setEnabled(bean.getWikittyId() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("wikittyId", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TITLE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    title.setText(_(updateTitle(bean.getName())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_XML_STREAM_NAME_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    jaxx.runtime.SwingUtil.setText(xmlStreamName, bean.getName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_XML_STREAM_URL_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("url", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    jaxx.runtime.SwingUtil.setText(xmlStreamUrl, bean.getUrl());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("url", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_XML_STREAM_PREVIEW_TOOL_TIP_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("url", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    xmlStreamPreview.setToolTipText(_(getHandler().getFirstElementPreview(AdminXmlStreamUI.this, bean.getUrl())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("url", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FORM_TYPE_COMBO_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("formType", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    formTypeCombo.setSelectedItem(bean.getFormType());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("formType", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATE_URL_ENABLED, true ,"valide") {
        
            @Override
            public void processDataBinding() {
                validateUrl.setEnabled(isValide());
            }
        });
    }

}